/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusText
 * LegalDocumentStatusText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.field.LegalDocumentStatusTextField
 * LegalDocumentStatusTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.link.LegalDocumentStatusTextLink
 * LegalDocumentStatusTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusText#INTERNAL_DOCUMENT_STATUS
 * INTERNAL_DOCUMENT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusText#LGL_CNTNT_M_DOC_STATUS_NAME
 * LGL_CNTNT_M_DOC_STATUS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatusText#TO_LGL_CNTNT_M_DOC_STATUS
 * TO_LGL_CNTNT_M_DOC_STATUS}</li>
 * </ul>
 *
 */
public interface LegalDocumentStatusTextSelectable extends EntitySelectable<LegalDocumentStatusText>
{

}
