/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.field.LegalTransactionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.link.LegalTransactionLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable.LegalTransactionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Legal Transactions
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LegalTransactionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LegalTransaction extends VdmEntity<LegalTransaction>
{

    /**
     * Selector for all available fields of LegalTransaction.
     *
     */
    public final static LegalTransactionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @Key
    @SerializedName( "LegalTransactionUUID" )
    @JsonProperty( "LegalTransactionUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionUUID" )
    private UUID legalTransactionUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionUUID</b> field to query operations.
     *
     */
    public final static LegalTransactionField<UUID> LEGAL_TRANSACTION_UUID =
        new LegalTransactionField<UUID>("LegalTransactionUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransaction</b>
     * </p>
     *
     * @return Legal Transaction ID
     */
    @SerializedName( "LegalTransaction" )
    @JsonProperty( "LegalTransaction" )
    @Nullable
    @ODataField( odataName = "LegalTransaction" )
    private String legalTransaction;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransaction</b> field to query operations.
     *
     */
    public final static LegalTransactionField<String> LEGAL_TRANSACTION =
        new LegalTransactionField<String>("LegalTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionTitle</b>
     * </p>
     *
     * @return Legal Transaction Name
     */
    @SerializedName( "LegalTransactionTitle" )
    @JsonProperty( "LegalTransactionTitle" )
    @Nullable
    @ODataField( odataName = "LegalTransactionTitle" )
    private String legalTransactionTitle;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionTitle</b> field to query operations.
     *
     */
    public final static LegalTransactionField<String> LEGAL_TRANSACTION_TITLE =
        new LegalTransactionField<String>("LegalTransactionTitle");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMContext</b>
     * </p>
     *
     * @return Context ID
     */
    @SerializedName( "LglCntntMContext" )
    @JsonProperty( "LglCntntMContext" )
    @Nullable
    @ODataField( odataName = "LglCntntMContext" )
    private String lglCntntMContext;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMContext</b> field to query operations.
     *
     */
    public final static LegalTransactionField<String> LGL_CNTNT_M_CONTEXT =
        new LegalTransactionField<String>("LglCntntMContext");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMContextUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @SerializedName( "LglCntntMContextUUID" )
    @JsonProperty( "LglCntntMContextUUID" )
    @Nullable
    @ODataField( odataName = "LglCntntMContextUUID" )
    private UUID lglCntntMContextUUID;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMContextUUID</b> field to query operations.
     *
     */
    public final static LegalTransactionField<UUID> LGL_CNTNT_M_CONTEXT_UUID =
        new LegalTransactionField<UUID>("LglCntntMContextUUID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMLanguage</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "LglCntntMLanguage" )
    @JsonProperty( "LglCntntMLanguage" )
    @Nullable
    @ODataField( odataName = "LglCntntMLanguage" )
    private String lglCntntMLanguage;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMLanguage</b> field to query operations.
     *
     */
    public final static LegalTransactionField<String> LGL_CNTNT_M_LANGUAGE =
        new LegalTransactionField<String>("LglCntntMLanguage");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMChangedByUser</b>
     * </p>
     *
     * @return Changed By User
     */
    @SerializedName( "LglCntntMChangedByUser" )
    @JsonProperty( "LglCntntMChangedByUser" )
    @Nullable
    @ODataField( odataName = "LglCntntMChangedByUser" )
    private String lglCntntMChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMChangedByUser</b> field to query operations.
     *
     */
    public final static LegalTransactionField<String> LGL_CNTNT_M_CHANGED_BY_USER =
        new LegalTransactionField<String>("LglCntntMChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMChangedUTCDateTime</b>
     * </p>
     *
     * @return Changed UTC Date Time
     */
    @SerializedName( "LglCntntMChangedUTCDateTime" )
    @JsonProperty( "LglCntntMChangedUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LglCntntMChangedUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lglCntntMChangedUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMChangedUTCDateTime</b> field to query operations.
     *
     */
    public final static LegalTransactionField<ZonedDateTime> LGL_CNTNT_M_CHANGED_UTC_DATE_TIME =
        new LegalTransactionField<ZonedDateTime>("LglCntntMChangedUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "LglCntntMCreatedByUser" )
    @JsonProperty( "LglCntntMCreatedByUser" )
    @Nullable
    @ODataField( odataName = "LglCntntMCreatedByUser" )
    private String lglCntntMCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCreatedByUser</b> field to query operations.
     *
     */
    public final static LegalTransactionField<String> LGL_CNTNT_M_CREATED_BY_USER =
        new LegalTransactionField<String>("LglCntntMCreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCreatedUTCDateTime</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "LglCntntMCreatedUTCDateTime" )
    @JsonProperty( "LglCntntMCreatedUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LglCntntMCreatedUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lglCntntMCreatedUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCreatedUTCDateTime</b> field to query operations.
     *
     */
    public final static LegalTransactionField<ZonedDateTime> LGL_CNTNT_M_CREATED_UTC_DATE_TIME =
        new LegalTransactionField<ZonedDateTime>("LglCntntMCreatedUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionHealth</b>
     * </p>
     *
     * @return Legal Transaction Status
     */
    @SerializedName( "LegalTransactionHealth" )
    @JsonProperty( "LegalTransactionHealth" )
    @Nullable
    @ODataField( odataName = "LegalTransactionHealth" )
    private String legalTransactionHealth;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionHealth</b> field to query operations.
     *
     */
    public final static LegalTransactionField<String> LEGAL_TRANSACTION_HEALTH =
        new LegalTransactionField<String>("LegalTransactionHealth");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMProfile</b>
     * </p>
     *
     * @return Profile
     */
    @SerializedName( "LglCntntMProfile" )
    @JsonProperty( "LglCntntMProfile" )
    @Nullable
    @ODataField( odataName = "LglCntntMProfile" )
    private String lglCntntMProfile;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMProfile</b> field to query operations.
     *
     */
    public final static LegalTransactionField<String> LGL_CNTNT_M_PROFILE =
        new LegalTransactionField<String>("LglCntntMProfile");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionSource</b>
     * </p>
     *
     * @return LT Integration source
     */
    @SerializedName( "LegalTransactionSource" )
    @JsonProperty( "LegalTransactionSource" )
    @Nullable
    @ODataField( odataName = "LegalTransactionSource" )
    private String legalTransactionSource;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionSource</b> field to query operations.
     *
     */
    public final static LegalTransactionField<String> LEGAL_TRANSACTION_SOURCE =
        new LegalTransactionField<String>("LegalTransactionSource");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsEndOfPurposeBlocked</b>
     * </p>
     *
     * @return Business Purpose Completed
     */
    @SerializedName( "IsEndOfPurposeBlocked" )
    @JsonProperty( "IsEndOfPurposeBlocked" )
    @Nullable
    @ODataField( odataName = "IsEndOfPurposeBlocked" )
    private String isEndOfPurposeBlocked;
    /**
     * Use with available fluent helpers to apply the <b>IsEndOfPurposeBlocked</b> field to query operations.
     *
     */
    public final static LegalTransactionField<String> IS_END_OF_PURPOSE_BLOCKED =
        new LegalTransactionField<String>("IsEndOfPurposeBlocked");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMGovLaw</b>
     * </p>
     *
     * @return Governing Law
     */
    @SerializedName( "LglCntntMGovLaw" )
    @JsonProperty( "LglCntntMGovLaw" )
    @Nullable
    @ODataField( odataName = "LglCntntMGovLaw" )
    private String lglCntntMGovLaw;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMGovLaw</b> field to query operations.
     *
     */
    public final static LegalTransactionField<String> LGL_CNTNT_M_GOV_LAW =
        new LegalTransactionField<String>("LglCntntMGovLaw");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglTransAccessLvl</b>
     * </p>
     *
     * @return Access Level
     */
    @SerializedName( "LglTransAccessLvl" )
    @JsonProperty( "LglTransAccessLvl" )
    @Nullable
    @ODataField( odataName = "LglTransAccessLvl" )
    private String lglTransAccessLvl;
    /**
     * Use with available fluent helpers to apply the <b>LglTransAccessLvl</b> field to query operations.
     *
     */
    public final static LegalTransactionField<String> LGL_TRANS_ACCESS_LVL =
        new LegalTransactionField<String>("LglTransAccessLvl");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMMainOrgCoCode</b>
     * </p>
     *
     * @return Entity ID
     */
    @SerializedName( "LglCntntMMainOrgCoCode" )
    @JsonProperty( "LglCntntMMainOrgCoCode" )
    @Nullable
    @ODataField( odataName = "LglCntntMMainOrgCoCode" )
    private String lglCntntMMainOrgCoCode;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMMainOrgCoCode</b> field to query operations.
     *
     */
    public final static LegalTransactionField<String> LGL_CNTNT_M_MAIN_ORG_CO_CODE =
        new LegalTransactionField<String>("LglCntntMMainOrgCoCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMMainOrgSalesOrg</b>
     * </p>
     *
     * @return Entity ID
     */
    @SerializedName( "LglCntntMMainOrgSalesOrg" )
    @JsonProperty( "LglCntntMMainOrgSalesOrg" )
    @Nullable
    @ODataField( odataName = "LglCntntMMainOrgSalesOrg" )
    private String lglCntntMMainOrgSalesOrg;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMMainOrgSalesOrg</b> field to query operations.
     *
     */
    public final static LegalTransactionField<String> LGL_CNTNT_M_MAIN_ORG_SALES_ORG =
        new LegalTransactionField<String>("LglCntntMMainOrgSalesOrg");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMMainOrgPurOrg</b>
     * </p>
     *
     * @return Entity ID
     */
    @SerializedName( "LglCntntMMainOrgPurOrg" )
    @JsonProperty( "LglCntntMMainOrgPurOrg" )
    @Nullable
    @ODataField( odataName = "LglCntntMMainOrgPurOrg" )
    private String lglCntntMMainOrgPurOrg;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMMainOrgPurOrg</b> field to query operations.
     *
     */
    public final static LegalTransactionField<String> LGL_CNTNT_M_MAIN_ORG_PUR_ORG =
        new LegalTransactionField<String>("LglCntntMMainOrgPurOrg");
    /**
     * Navigation property <b>to_LglTransCategoryGroup</b> for <b>LegalTransaction</b> to multiple
     * <b>LglTransCategoryGroup</b>.
     *
     */
    @SerializedName( "to_LglTransCategoryGroup" )
    @JsonProperty( "to_LglTransCategoryGroup" )
    @ODataField( odataName = "to_LglTransCategoryGroup" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LglTransCategoryGroup> toLglTransCategoryGroup;
    /**
     * Navigation property <b>to_LglTransDate</b> for <b>LegalTransaction</b> to multiple <b>LglTransDate</b>.
     *
     */
    @SerializedName( "to_LglTransDate" )
    @JsonProperty( "to_LglTransDate" )
    @ODataField( odataName = "to_LglTransDate" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LglTransDate> toLglTransDate;
    /**
     * Navigation property <b>to_LglTransEntity</b> for <b>LegalTransaction</b> to multiple <b>LglTransEntity</b>.
     *
     */
    @SerializedName( "to_LglTransEntity" )
    @JsonProperty( "to_LglTransEntity" )
    @ODataField( odataName = "to_LglTransEntity" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LglTransEntity> toLglTransEntity;
    /**
     * Navigation property <b>to_LglTransExternalContact</b> for <b>LegalTransaction</b> to multiple
     * <b>LglTransExternalContact</b>.
     *
     */
    @SerializedName( "to_LglTransExternalContact" )
    @JsonProperty( "to_LglTransExternalContact" )
    @ODataField( odataName = "to_LglTransExternalContact" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LglTransExternalContact> toLglTransExternalContact;
    /**
     * Navigation property <b>to_LglTransInternalContact</b> for <b>LegalTransaction</b> to multiple
     * <b>LglTransInternalContact</b>.
     *
     */
    @SerializedName( "to_LglTransInternalContact" )
    @JsonProperty( "to_LglTransInternalContact" )
    @ODataField( odataName = "to_LglTransInternalContact" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LglTransInternalContact> toLglTransInternalContact;
    /**
     * Navigation property <b>to_LglTransLinkedObjects</b> for <b>LegalTransaction</b> to multiple
     * <b>LglTransLinkedObjects</b>.
     *
     */
    @SerializedName( "to_LglTransLinkedObjects" )
    @JsonProperty( "to_LglTransLinkedObjects" )
    @ODataField( odataName = "to_LglTransLinkedObjects" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LglTransLinkedObjects> toLglTransLinkedObjects;
    /**
     * Navigation property <b>to_LglTransRelationship</b> for <b>LegalTransaction</b> to multiple
     * <b>LglTransRelationship</b>.
     *
     */
    @SerializedName( "to_LglTransRelationship" )
    @JsonProperty( "to_LglTransRelationship" )
    @ODataField( odataName = "to_LglTransRelationship" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LglTransRelationship> toLglTransRelationship;
    /**
     * Use with available fluent helpers to apply the <b>to_LglTransCategoryGroup</b> navigation property to query
     * operations.
     *
     */
    public final static LegalTransactionLink<LglTransCategoryGroup> TO_LGL_TRANS_CATEGORY_GROUP =
        new LegalTransactionLink<LglTransCategoryGroup>("to_LglTransCategoryGroup");
    /**
     * Use with available fluent helpers to apply the <b>to_LglTransDate</b> navigation property to query operations.
     *
     */
    public final static LegalTransactionLink<LglTransDate> TO_LGL_TRANS_DATE =
        new LegalTransactionLink<LglTransDate>("to_LglTransDate");
    /**
     * Use with available fluent helpers to apply the <b>to_LglTransEntity</b> navigation property to query operations.
     *
     */
    public final static LegalTransactionLink<LglTransEntity> TO_LGL_TRANS_ENTITY =
        new LegalTransactionLink<LglTransEntity>("to_LglTransEntity");
    /**
     * Use with available fluent helpers to apply the <b>to_LglTransExternalContact</b> navigation property to query
     * operations.
     *
     */
    public final static LegalTransactionLink<LglTransExternalContact> TO_LGL_TRANS_EXTERNAL_CONTACT =
        new LegalTransactionLink<LglTransExternalContact>("to_LglTransExternalContact");
    /**
     * Use with available fluent helpers to apply the <b>to_LglTransInternalContact</b> navigation property to query
     * operations.
     *
     */
    public final static LegalTransactionLink<LglTransInternalContact> TO_LGL_TRANS_INTERNAL_CONTACT =
        new LegalTransactionLink<LglTransInternalContact>("to_LglTransInternalContact");
    /**
     * Use with available fluent helpers to apply the <b>to_LglTransLinkedObjects</b> navigation property to query
     * operations.
     *
     */
    public final static LegalTransactionLink<LglTransLinkedObjects> TO_LGL_TRANS_LINKED_OBJECTS =
        new LegalTransactionLink<LglTransLinkedObjects>("to_LglTransLinkedObjects");
    /**
     * Use with available fluent helpers to apply the <b>to_LglTransRelationship</b> navigation property to query
     * operations.
     *
     */
    public final static LegalTransactionLink<LglTransRelationship> TO_LGL_TRANS_RELATIONSHIP =
        new LegalTransactionLink<LglTransRelationship>("to_LglTransRelationship");

    @Nonnull
    @Override
    public Class<LegalTransaction> getType()
    {
        return LegalTransaction.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @param legalTransactionUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionUUID( @Nullable final UUID legalTransactionUUID )
    {
        rememberChangedField("LegalTransactionUUID", this.legalTransactionUUID);
        this.legalTransactionUUID = legalTransactionUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransaction</b>
     * </p>
     *
     * @param legalTransaction
     *            Legal Transaction ID
     */
    public void setLegalTransaction( @Nullable final String legalTransaction )
    {
        rememberChangedField("LegalTransaction", this.legalTransaction);
        this.legalTransaction = legalTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionTitle</b>
     * </p>
     *
     * @param legalTransactionTitle
     *            Legal Transaction Name
     */
    public void setLegalTransactionTitle( @Nullable final String legalTransactionTitle )
    {
        rememberChangedField("LegalTransactionTitle", this.legalTransactionTitle);
        this.legalTransactionTitle = legalTransactionTitle;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMContext</b>
     * </p>
     *
     * @param lglCntntMContext
     *            Context ID
     */
    public void setLglCntntMContext( @Nullable final String lglCntntMContext )
    {
        rememberChangedField("LglCntntMContext", this.lglCntntMContext);
        this.lglCntntMContext = lglCntntMContext;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMContextUUID</b>
     * </p>
     *
     * @param lglCntntMContextUUID
     *            Universal Unique Identifier
     */
    public void setLglCntntMContextUUID( @Nullable final UUID lglCntntMContextUUID )
    {
        rememberChangedField("LglCntntMContextUUID", this.lglCntntMContextUUID);
        this.lglCntntMContextUUID = lglCntntMContextUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMLanguage</b>
     * </p>
     *
     * @param lglCntntMLanguage
     *            Language Key
     */
    public void setLglCntntMLanguage( @Nullable final String lglCntntMLanguage )
    {
        rememberChangedField("LglCntntMLanguage", this.lglCntntMLanguage);
        this.lglCntntMLanguage = lglCntntMLanguage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMChangedByUser</b>
     * </p>
     *
     * @param lglCntntMChangedByUser
     *            Changed By User
     */
    public void setLglCntntMChangedByUser( @Nullable final String lglCntntMChangedByUser )
    {
        rememberChangedField("LglCntntMChangedByUser", this.lglCntntMChangedByUser);
        this.lglCntntMChangedByUser = lglCntntMChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMChangedUTCDateTime</b>
     * </p>
     *
     * @param lglCntntMChangedUTCDateTime
     *            Changed UTC Date Time
     */
    public void setLglCntntMChangedUTCDateTime( @Nullable final ZonedDateTime lglCntntMChangedUTCDateTime )
    {
        rememberChangedField("LglCntntMChangedUTCDateTime", this.lglCntntMChangedUTCDateTime);
        this.lglCntntMChangedUTCDateTime = lglCntntMChangedUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCreatedByUser</b>
     * </p>
     *
     * @param lglCntntMCreatedByUser
     *            Created By
     */
    public void setLglCntntMCreatedByUser( @Nullable final String lglCntntMCreatedByUser )
    {
        rememberChangedField("LglCntntMCreatedByUser", this.lglCntntMCreatedByUser);
        this.lglCntntMCreatedByUser = lglCntntMCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCreatedUTCDateTime</b>
     * </p>
     *
     * @param lglCntntMCreatedUTCDateTime
     *            Created On
     */
    public void setLglCntntMCreatedUTCDateTime( @Nullable final ZonedDateTime lglCntntMCreatedUTCDateTime )
    {
        rememberChangedField("LglCntntMCreatedUTCDateTime", this.lglCntntMCreatedUTCDateTime);
        this.lglCntntMCreatedUTCDateTime = lglCntntMCreatedUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionHealth</b>
     * </p>
     *
     * @param legalTransactionHealth
     *            Legal Transaction Status
     */
    public void setLegalTransactionHealth( @Nullable final String legalTransactionHealth )
    {
        rememberChangedField("LegalTransactionHealth", this.legalTransactionHealth);
        this.legalTransactionHealth = legalTransactionHealth;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMProfile</b>
     * </p>
     *
     * @param lglCntntMProfile
     *            Profile
     */
    public void setLglCntntMProfile( @Nullable final String lglCntntMProfile )
    {
        rememberChangedField("LglCntntMProfile", this.lglCntntMProfile);
        this.lglCntntMProfile = lglCntntMProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionSource</b>
     * </p>
     *
     * @param legalTransactionSource
     *            LT Integration source
     */
    public void setLegalTransactionSource( @Nullable final String legalTransactionSource )
    {
        rememberChangedField("LegalTransactionSource", this.legalTransactionSource);
        this.legalTransactionSource = legalTransactionSource;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsEndOfPurposeBlocked</b>
     * </p>
     *
     * @param isEndOfPurposeBlocked
     *            Business Purpose Completed
     */
    public void setIsEndOfPurposeBlocked( @Nullable final String isEndOfPurposeBlocked )
    {
        rememberChangedField("IsEndOfPurposeBlocked", this.isEndOfPurposeBlocked);
        this.isEndOfPurposeBlocked = isEndOfPurposeBlocked;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMGovLaw</b>
     * </p>
     *
     * @param lglCntntMGovLaw
     *            Governing Law
     */
    public void setLglCntntMGovLaw( @Nullable final String lglCntntMGovLaw )
    {
        rememberChangedField("LglCntntMGovLaw", this.lglCntntMGovLaw);
        this.lglCntntMGovLaw = lglCntntMGovLaw;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglTransAccessLvl</b>
     * </p>
     *
     * @param lglTransAccessLvl
     *            Access Level
     */
    public void setLglTransAccessLvl( @Nullable final String lglTransAccessLvl )
    {
        rememberChangedField("LglTransAccessLvl", this.lglTransAccessLvl);
        this.lglTransAccessLvl = lglTransAccessLvl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMMainOrgCoCode</b>
     * </p>
     *
     * @param lglCntntMMainOrgCoCode
     *            Entity ID
     */
    public void setLglCntntMMainOrgCoCode( @Nullable final String lglCntntMMainOrgCoCode )
    {
        rememberChangedField("LglCntntMMainOrgCoCode", this.lglCntntMMainOrgCoCode);
        this.lglCntntMMainOrgCoCode = lglCntntMMainOrgCoCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMMainOrgSalesOrg</b>
     * </p>
     *
     * @param lglCntntMMainOrgSalesOrg
     *            Entity ID
     */
    public void setLglCntntMMainOrgSalesOrg( @Nullable final String lglCntntMMainOrgSalesOrg )
    {
        rememberChangedField("LglCntntMMainOrgSalesOrg", this.lglCntntMMainOrgSalesOrg);
        this.lglCntntMMainOrgSalesOrg = lglCntntMMainOrgSalesOrg;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMMainOrgPurOrg</b>
     * </p>
     *
     * @param lglCntntMMainOrgPurOrg
     *            Entity ID
     */
    public void setLglCntntMMainOrgPurOrg( @Nullable final String lglCntntMMainOrgPurOrg )
    {
        rememberChangedField("LglCntntMMainOrgPurOrg", this.lglCntntMMainOrgPurOrg);
        this.lglCntntMMainOrgPurOrg = lglCntntMMainOrgPurOrg;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LegalTransaction";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LegalTransactionUUID", getLegalTransactionUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LegalTransactionUUID", getLegalTransactionUUID());
        values.put("LegalTransaction", getLegalTransaction());
        values.put("LegalTransactionTitle", getLegalTransactionTitle());
        values.put("LglCntntMContext", getLglCntntMContext());
        values.put("LglCntntMContextUUID", getLglCntntMContextUUID());
        values.put("LglCntntMLanguage", getLglCntntMLanguage());
        values.put("LglCntntMChangedByUser", getLglCntntMChangedByUser());
        values.put("LglCntntMChangedUTCDateTime", getLglCntntMChangedUTCDateTime());
        values.put("LglCntntMCreatedByUser", getLglCntntMCreatedByUser());
        values.put("LglCntntMCreatedUTCDateTime", getLglCntntMCreatedUTCDateTime());
        values.put("LegalTransactionHealth", getLegalTransactionHealth());
        values.put("LglCntntMProfile", getLglCntntMProfile());
        values.put("LegalTransactionSource", getLegalTransactionSource());
        values.put("IsEndOfPurposeBlocked", getIsEndOfPurposeBlocked());
        values.put("LglCntntMGovLaw", getLglCntntMGovLaw());
        values.put("LglTransAccessLvl", getLglTransAccessLvl());
        values.put("LglCntntMMainOrgCoCode", getLglCntntMMainOrgCoCode());
        values.put("LglCntntMMainOrgSalesOrg", getLglCntntMMainOrgSalesOrg());
        values.put("LglCntntMMainOrgPurOrg", getLglCntntMMainOrgPurOrg());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LegalTransactionUUID") ) {
                final Object value = values.remove("LegalTransactionUUID");
                if( (value == null) || (!value.equals(getLegalTransactionUUID())) ) {
                    setLegalTransactionUUID(((UUID) value));
                }
            }
            if( values.containsKey("LegalTransaction") ) {
                final Object value = values.remove("LegalTransaction");
                if( (value == null) || (!value.equals(getLegalTransaction())) ) {
                    setLegalTransaction(((String) value));
                }
            }
            if( values.containsKey("LegalTransactionTitle") ) {
                final Object value = values.remove("LegalTransactionTitle");
                if( (value == null) || (!value.equals(getLegalTransactionTitle())) ) {
                    setLegalTransactionTitle(((String) value));
                }
            }
            if( values.containsKey("LglCntntMContext") ) {
                final Object value = values.remove("LglCntntMContext");
                if( (value == null) || (!value.equals(getLglCntntMContext())) ) {
                    setLglCntntMContext(((String) value));
                }
            }
            if( values.containsKey("LglCntntMContextUUID") ) {
                final Object value = values.remove("LglCntntMContextUUID");
                if( (value == null) || (!value.equals(getLglCntntMContextUUID())) ) {
                    setLglCntntMContextUUID(((UUID) value));
                }
            }
            if( values.containsKey("LglCntntMLanguage") ) {
                final Object value = values.remove("LglCntntMLanguage");
                if( (value == null) || (!value.equals(getLglCntntMLanguage())) ) {
                    setLglCntntMLanguage(((String) value));
                }
            }
            if( values.containsKey("LglCntntMChangedByUser") ) {
                final Object value = values.remove("LglCntntMChangedByUser");
                if( (value == null) || (!value.equals(getLglCntntMChangedByUser())) ) {
                    setLglCntntMChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LglCntntMChangedUTCDateTime") ) {
                final Object value = values.remove("LglCntntMChangedUTCDateTime");
                if( (value == null) || (!value.equals(getLglCntntMChangedUTCDateTime())) ) {
                    setLglCntntMChangedUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LglCntntMCreatedByUser") ) {
                final Object value = values.remove("LglCntntMCreatedByUser");
                if( (value == null) || (!value.equals(getLglCntntMCreatedByUser())) ) {
                    setLglCntntMCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LglCntntMCreatedUTCDateTime") ) {
                final Object value = values.remove("LglCntntMCreatedUTCDateTime");
                if( (value == null) || (!value.equals(getLglCntntMCreatedUTCDateTime())) ) {
                    setLglCntntMCreatedUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LegalTransactionHealth") ) {
                final Object value = values.remove("LegalTransactionHealth");
                if( (value == null) || (!value.equals(getLegalTransactionHealth())) ) {
                    setLegalTransactionHealth(((String) value));
                }
            }
            if( values.containsKey("LglCntntMProfile") ) {
                final Object value = values.remove("LglCntntMProfile");
                if( (value == null) || (!value.equals(getLglCntntMProfile())) ) {
                    setLglCntntMProfile(((String) value));
                }
            }
            if( values.containsKey("LegalTransactionSource") ) {
                final Object value = values.remove("LegalTransactionSource");
                if( (value == null) || (!value.equals(getLegalTransactionSource())) ) {
                    setLegalTransactionSource(((String) value));
                }
            }
            if( values.containsKey("IsEndOfPurposeBlocked") ) {
                final Object value = values.remove("IsEndOfPurposeBlocked");
                if( (value == null) || (!value.equals(getIsEndOfPurposeBlocked())) ) {
                    setIsEndOfPurposeBlocked(((String) value));
                }
            }
            if( values.containsKey("LglCntntMGovLaw") ) {
                final Object value = values.remove("LglCntntMGovLaw");
                if( (value == null) || (!value.equals(getLglCntntMGovLaw())) ) {
                    setLglCntntMGovLaw(((String) value));
                }
            }
            if( values.containsKey("LglTransAccessLvl") ) {
                final Object value = values.remove("LglTransAccessLvl");
                if( (value == null) || (!value.equals(getLglTransAccessLvl())) ) {
                    setLglTransAccessLvl(((String) value));
                }
            }
            if( values.containsKey("LglCntntMMainOrgCoCode") ) {
                final Object value = values.remove("LglCntntMMainOrgCoCode");
                if( (value == null) || (!value.equals(getLglCntntMMainOrgCoCode())) ) {
                    setLglCntntMMainOrgCoCode(((String) value));
                }
            }
            if( values.containsKey("LglCntntMMainOrgSalesOrg") ) {
                final Object value = values.remove("LglCntntMMainOrgSalesOrg");
                if( (value == null) || (!value.equals(getLglCntntMMainOrgSalesOrg())) ) {
                    setLglCntntMMainOrgSalesOrg(((String) value));
                }
            }
            if( values.containsKey("LglCntntMMainOrgPurOrg") ) {
                final Object value = values.remove("LglCntntMMainOrgPurOrg");
                if( (value == null) || (!value.equals(getLglCntntMMainOrgPurOrg())) ) {
                    setLglCntntMMainOrgPurOrg(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_LglTransCategoryGroup") ) {
                final Object value = (values).remove("to_LglTransCategoryGroup");
                if( value instanceof Iterable ) {
                    if( toLglTransCategoryGroup == null ) {
                        toLglTransCategoryGroup = Lists.newArrayList();
                    } else {
                        toLglTransCategoryGroup = Lists.newArrayList(toLglTransCategoryGroup);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LglTransCategoryGroup entity;
                        if( toLglTransCategoryGroup.size() > i ) {
                            entity = toLglTransCategoryGroup.get(i);
                        } else {
                            entity = new LglTransCategoryGroup();
                            toLglTransCategoryGroup.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_LglTransDate") ) {
                final Object value = (values).remove("to_LglTransDate");
                if( value instanceof Iterable ) {
                    if( toLglTransDate == null ) {
                        toLglTransDate = Lists.newArrayList();
                    } else {
                        toLglTransDate = Lists.newArrayList(toLglTransDate);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LglTransDate entity;
                        if( toLglTransDate.size() > i ) {
                            entity = toLglTransDate.get(i);
                        } else {
                            entity = new LglTransDate();
                            toLglTransDate.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_LglTransEntity") ) {
                final Object value = (values).remove("to_LglTransEntity");
                if( value instanceof Iterable ) {
                    if( toLglTransEntity == null ) {
                        toLglTransEntity = Lists.newArrayList();
                    } else {
                        toLglTransEntity = Lists.newArrayList(toLglTransEntity);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LglTransEntity entity;
                        if( toLglTransEntity.size() > i ) {
                            entity = toLglTransEntity.get(i);
                        } else {
                            entity = new LglTransEntity();
                            toLglTransEntity.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_LglTransExternalContact") ) {
                final Object value = (values).remove("to_LglTransExternalContact");
                if( value instanceof Iterable ) {
                    if( toLglTransExternalContact == null ) {
                        toLglTransExternalContact = Lists.newArrayList();
                    } else {
                        toLglTransExternalContact = Lists.newArrayList(toLglTransExternalContact);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LglTransExternalContact entity;
                        if( toLglTransExternalContact.size() > i ) {
                            entity = toLglTransExternalContact.get(i);
                        } else {
                            entity = new LglTransExternalContact();
                            toLglTransExternalContact.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_LglTransInternalContact") ) {
                final Object value = (values).remove("to_LglTransInternalContact");
                if( value instanceof Iterable ) {
                    if( toLglTransInternalContact == null ) {
                        toLglTransInternalContact = Lists.newArrayList();
                    } else {
                        toLglTransInternalContact = Lists.newArrayList(toLglTransInternalContact);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LglTransInternalContact entity;
                        if( toLglTransInternalContact.size() > i ) {
                            entity = toLglTransInternalContact.get(i);
                        } else {
                            entity = new LglTransInternalContact();
                            toLglTransInternalContact.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_LglTransLinkedObjects") ) {
                final Object value = (values).remove("to_LglTransLinkedObjects");
                if( value instanceof Iterable ) {
                    if( toLglTransLinkedObjects == null ) {
                        toLglTransLinkedObjects = Lists.newArrayList();
                    } else {
                        toLglTransLinkedObjects = Lists.newArrayList(toLglTransLinkedObjects);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LglTransLinkedObjects entity;
                        if( toLglTransLinkedObjects.size() > i ) {
                            entity = toLglTransLinkedObjects.get(i);
                        } else {
                            entity = new LglTransLinkedObjects();
                            toLglTransLinkedObjects.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_LglTransRelationship") ) {
                final Object value = (values).remove("to_LglTransRelationship");
                if( value instanceof Iterable ) {
                    if( toLglTransRelationship == null ) {
                        toLglTransRelationship = Lists.newArrayList();
                    } else {
                        toLglTransRelationship = Lists.newArrayList(toLglTransRelationship);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LglTransRelationship entity;
                        if( toLglTransRelationship.size() > i ) {
                            entity = toLglTransRelationship.get(i);
                        } else {
                            entity = new LglTransRelationship();
                            toLglTransRelationship.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LegalTransactionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LegalTransactionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LegalTransactionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LegalTransactionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toLglTransCategoryGroup != null ) {
            (values).put("to_LglTransCategoryGroup", toLglTransCategoryGroup);
        }
        if( toLglTransDate != null ) {
            (values).put("to_LglTransDate", toLglTransDate);
        }
        if( toLglTransEntity != null ) {
            (values).put("to_LglTransEntity", toLglTransEntity);
        }
        if( toLglTransExternalContact != null ) {
            (values).put("to_LglTransExternalContact", toLglTransExternalContact);
        }
        if( toLglTransInternalContact != null ) {
            (values).put("to_LglTransInternalContact", toLglTransInternalContact);
        }
        if( toLglTransLinkedObjects != null ) {
            (values).put("to_LglTransLinkedObjects", toLglTransLinkedObjects);
        }
        if( toLglTransRelationship != null ) {
            (values).put("to_LglTransRelationship", toLglTransRelationship);
        }
        return values;
    }

    /**
     * Fetches the <b>LglTransCategoryGroup</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_LglTransCategoryGroup</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LglTransCategoryGroup</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglTransCategoryGroup> fetchLglTransCategoryGroup()
    {
        return fetchFieldAsList("to_LglTransCategoryGroup", LglTransCategoryGroup.class);
    }

    /**
     * Retrieval of associated <b>LglTransCategoryGroup</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglTransCategoryGroup</b>.
     * <p>
     * If the navigation property <b>to_LglTransCategoryGroup</b> of a queried <b>LegalTransaction</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LglTransCategoryGroup</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglTransCategoryGroup> getLglTransCategoryGroupOrFetch()
    {
        if( toLglTransCategoryGroup == null ) {
            toLglTransCategoryGroup = fetchLglTransCategoryGroup();
        }
        return toLglTransCategoryGroup;
    }

    /**
     * Retrieval of associated <b>LglTransCategoryGroup</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglTransCategoryGroup</b>.
     * <p>
     * If the navigation property for an entity <b>LegalTransaction</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LglTransCategoryGroup</b> is already loaded, the result
     *         will contain the <b>LglTransCategoryGroup</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<LglTransCategoryGroup>> getLglTransCategoryGroupIfPresent()
    {
        return Option.of(toLglTransCategoryGroup);
    }

    /**
     * Overwrites the list of associated <b>LglTransCategoryGroup</b> entities for the loaded navigation property
     * <b>to_LglTransCategoryGroup</b>.
     * <p>
     * If the navigation property <b>to_LglTransCategoryGroup</b> of a queried <b>LegalTransaction</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LglTransCategoryGroup</b> entities.
     */
    public void setLglTransCategoryGroup( @Nonnull final List<LglTransCategoryGroup> value )
    {
        if( toLglTransCategoryGroup == null ) {
            toLglTransCategoryGroup = Lists.newArrayList();
        }
        toLglTransCategoryGroup.clear();
        toLglTransCategoryGroup.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LglTransCategoryGroup</b> entities. This corresponds to the OData
     * navigation property <b>to_LglTransCategoryGroup</b>.
     * <p>
     * If the navigation property <b>to_LglTransCategoryGroup</b> of a queried <b>LegalTransaction</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LglTransCategoryGroup</b> entities.
     */
    public void addLglTransCategoryGroup( LglTransCategoryGroup... entity )
    {
        if( toLglTransCategoryGroup == null ) {
            toLglTransCategoryGroup = Lists.newArrayList();
        }
        toLglTransCategoryGroup.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>LglTransDate</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_LglTransDate</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LglTransDate</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglTransDate> fetchLglTransDate()
    {
        return fetchFieldAsList("to_LglTransDate", LglTransDate.class);
    }

    /**
     * Retrieval of associated <b>LglTransDate</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_LglTransDate</b>.
     * <p>
     * If the navigation property <b>to_LglTransDate</b> of a queried <b>LegalTransaction</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LglTransDate</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglTransDate> getLglTransDateOrFetch()
    {
        if( toLglTransDate == null ) {
            toLglTransDate = fetchLglTransDate();
        }
        return toLglTransDate;
    }

    /**
     * Retrieval of associated <b>LglTransDate</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_LglTransDate</b>.
     * <p>
     * If the navigation property for an entity <b>LegalTransaction</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LglTransDate</b> is already loaded, the result will
     *         contain the <b>LglTransDate</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<LglTransDate>> getLglTransDateIfPresent()
    {
        return Option.of(toLglTransDate);
    }

    /**
     * Overwrites the list of associated <b>LglTransDate</b> entities for the loaded navigation property
     * <b>to_LglTransDate</b>.
     * <p>
     * If the navigation property <b>to_LglTransDate</b> of a queried <b>LegalTransaction</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LglTransDate</b> entities.
     */
    public void setLglTransDate( @Nonnull final List<LglTransDate> value )
    {
        if( toLglTransDate == null ) {
            toLglTransDate = Lists.newArrayList();
        }
        toLglTransDate.clear();
        toLglTransDate.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LglTransDate</b> entities. This corresponds to the OData navigation
     * property <b>to_LglTransDate</b>.
     * <p>
     * If the navigation property <b>to_LglTransDate</b> of a queried <b>LegalTransaction</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LglTransDate</b> entities.
     */
    public void addLglTransDate( LglTransDate... entity )
    {
        if( toLglTransDate == null ) {
            toLglTransDate = Lists.newArrayList();
        }
        toLglTransDate.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>LglTransEntity</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_LglTransEntity</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LglTransEntity</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglTransEntity> fetchLglTransEntity()
    {
        return fetchFieldAsList("to_LglTransEntity", LglTransEntity.class);
    }

    /**
     * Retrieval of associated <b>LglTransEntity</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_LglTransEntity</b>.
     * <p>
     * If the navigation property <b>to_LglTransEntity</b> of a queried <b>LegalTransaction</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LglTransEntity</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglTransEntity> getLglTransEntityOrFetch()
    {
        if( toLglTransEntity == null ) {
            toLglTransEntity = fetchLglTransEntity();
        }
        return toLglTransEntity;
    }

    /**
     * Retrieval of associated <b>LglTransEntity</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_LglTransEntity</b>.
     * <p>
     * If the navigation property for an entity <b>LegalTransaction</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LglTransEntity</b> is already loaded, the result will
     *         contain the <b>LglTransEntity</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<LglTransEntity>> getLglTransEntityIfPresent()
    {
        return Option.of(toLglTransEntity);
    }

    /**
     * Overwrites the list of associated <b>LglTransEntity</b> entities for the loaded navigation property
     * <b>to_LglTransEntity</b>.
     * <p>
     * If the navigation property <b>to_LglTransEntity</b> of a queried <b>LegalTransaction</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LglTransEntity</b> entities.
     */
    public void setLglTransEntity( @Nonnull final List<LglTransEntity> value )
    {
        if( toLglTransEntity == null ) {
            toLglTransEntity = Lists.newArrayList();
        }
        toLglTransEntity.clear();
        toLglTransEntity.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LglTransEntity</b> entities. This corresponds to the OData navigation
     * property <b>to_LglTransEntity</b>.
     * <p>
     * If the navigation property <b>to_LglTransEntity</b> of a queried <b>LegalTransaction</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LglTransEntity</b> entities.
     */
    public void addLglTransEntity( LglTransEntity... entity )
    {
        if( toLglTransEntity == null ) {
            toLglTransEntity = Lists.newArrayList();
        }
        toLglTransEntity.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>LglTransExternalContact</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_LglTransExternalContact</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LglTransExternalContact</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglTransExternalContact> fetchLglTransExternalContact()
    {
        return fetchFieldAsList("to_LglTransExternalContact", LglTransExternalContact.class);
    }

    /**
     * Retrieval of associated <b>LglTransExternalContact</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglTransExternalContact</b>.
     * <p>
     * If the navigation property <b>to_LglTransExternalContact</b> of a queried <b>LegalTransaction</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LglTransExternalContact</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglTransExternalContact> getLglTransExternalContactOrFetch()
    {
        if( toLglTransExternalContact == null ) {
            toLglTransExternalContact = fetchLglTransExternalContact();
        }
        return toLglTransExternalContact;
    }

    /**
     * Retrieval of associated <b>LglTransExternalContact</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglTransExternalContact</b>.
     * <p>
     * If the navigation property for an entity <b>LegalTransaction</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LglTransExternalContact</b> is already loaded, the
     *         result will contain the <b>LglTransExternalContact</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<LglTransExternalContact>> getLglTransExternalContactIfPresent()
    {
        return Option.of(toLglTransExternalContact);
    }

    /**
     * Overwrites the list of associated <b>LglTransExternalContact</b> entities for the loaded navigation property
     * <b>to_LglTransExternalContact</b>.
     * <p>
     * If the navigation property <b>to_LglTransExternalContact</b> of a queried <b>LegalTransaction</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LglTransExternalContact</b> entities.
     */
    public void setLglTransExternalContact( @Nonnull final List<LglTransExternalContact> value )
    {
        if( toLglTransExternalContact == null ) {
            toLglTransExternalContact = Lists.newArrayList();
        }
        toLglTransExternalContact.clear();
        toLglTransExternalContact.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LglTransExternalContact</b> entities. This corresponds to the OData
     * navigation property <b>to_LglTransExternalContact</b>.
     * <p>
     * If the navigation property <b>to_LglTransExternalContact</b> of a queried <b>LegalTransaction</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LglTransExternalContact</b> entities.
     */
    public void addLglTransExternalContact( LglTransExternalContact... entity )
    {
        if( toLglTransExternalContact == null ) {
            toLglTransExternalContact = Lists.newArrayList();
        }
        toLglTransExternalContact.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>LglTransInternalContact</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_LglTransInternalContact</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LglTransInternalContact</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglTransInternalContact> fetchLglTransInternalContact()
    {
        return fetchFieldAsList("to_LglTransInternalContact", LglTransInternalContact.class);
    }

    /**
     * Retrieval of associated <b>LglTransInternalContact</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglTransInternalContact</b>.
     * <p>
     * If the navigation property <b>to_LglTransInternalContact</b> of a queried <b>LegalTransaction</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LglTransInternalContact</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglTransInternalContact> getLglTransInternalContactOrFetch()
    {
        if( toLglTransInternalContact == null ) {
            toLglTransInternalContact = fetchLglTransInternalContact();
        }
        return toLglTransInternalContact;
    }

    /**
     * Retrieval of associated <b>LglTransInternalContact</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglTransInternalContact</b>.
     * <p>
     * If the navigation property for an entity <b>LegalTransaction</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LglTransInternalContact</b> is already loaded, the
     *         result will contain the <b>LglTransInternalContact</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<LglTransInternalContact>> getLglTransInternalContactIfPresent()
    {
        return Option.of(toLglTransInternalContact);
    }

    /**
     * Overwrites the list of associated <b>LglTransInternalContact</b> entities for the loaded navigation property
     * <b>to_LglTransInternalContact</b>.
     * <p>
     * If the navigation property <b>to_LglTransInternalContact</b> of a queried <b>LegalTransaction</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LglTransInternalContact</b> entities.
     */
    public void setLglTransInternalContact( @Nonnull final List<LglTransInternalContact> value )
    {
        if( toLglTransInternalContact == null ) {
            toLglTransInternalContact = Lists.newArrayList();
        }
        toLglTransInternalContact.clear();
        toLglTransInternalContact.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LglTransInternalContact</b> entities. This corresponds to the OData
     * navigation property <b>to_LglTransInternalContact</b>.
     * <p>
     * If the navigation property <b>to_LglTransInternalContact</b> of a queried <b>LegalTransaction</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LglTransInternalContact</b> entities.
     */
    public void addLglTransInternalContact( LglTransInternalContact... entity )
    {
        if( toLglTransInternalContact == null ) {
            toLglTransInternalContact = Lists.newArrayList();
        }
        toLglTransInternalContact.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>LglTransLinkedObjects</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_LglTransLinkedObjects</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LglTransLinkedObjects</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglTransLinkedObjects> fetchLglTransLinkedObjects()
    {
        return fetchFieldAsList("to_LglTransLinkedObjects", LglTransLinkedObjects.class);
    }

    /**
     * Retrieval of associated <b>LglTransLinkedObjects</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglTransLinkedObjects</b>.
     * <p>
     * If the navigation property <b>to_LglTransLinkedObjects</b> of a queried <b>LegalTransaction</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LglTransLinkedObjects</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglTransLinkedObjects> getLglTransLinkedObjectsOrFetch()
    {
        if( toLglTransLinkedObjects == null ) {
            toLglTransLinkedObjects = fetchLglTransLinkedObjects();
        }
        return toLglTransLinkedObjects;
    }

    /**
     * Retrieval of associated <b>LglTransLinkedObjects</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglTransLinkedObjects</b>.
     * <p>
     * If the navigation property for an entity <b>LegalTransaction</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LglTransLinkedObjects</b> is already loaded, the result
     *         will contain the <b>LglTransLinkedObjects</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<LglTransLinkedObjects>> getLglTransLinkedObjectsIfPresent()
    {
        return Option.of(toLglTransLinkedObjects);
    }

    /**
     * Overwrites the list of associated <b>LglTransLinkedObjects</b> entities for the loaded navigation property
     * <b>to_LglTransLinkedObjects</b>.
     * <p>
     * If the navigation property <b>to_LglTransLinkedObjects</b> of a queried <b>LegalTransaction</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LglTransLinkedObjects</b> entities.
     */
    public void setLglTransLinkedObjects( @Nonnull final List<LglTransLinkedObjects> value )
    {
        if( toLglTransLinkedObjects == null ) {
            toLglTransLinkedObjects = Lists.newArrayList();
        }
        toLglTransLinkedObjects.clear();
        toLglTransLinkedObjects.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LglTransLinkedObjects</b> entities. This corresponds to the OData
     * navigation property <b>to_LglTransLinkedObjects</b>.
     * <p>
     * If the navigation property <b>to_LglTransLinkedObjects</b> of a queried <b>LegalTransaction</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LglTransLinkedObjects</b> entities.
     */
    public void addLglTransLinkedObjects( LglTransLinkedObjects... entity )
    {
        if( toLglTransLinkedObjects == null ) {
            toLglTransLinkedObjects = Lists.newArrayList();
        }
        toLglTransLinkedObjects.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>LglTransRelationship</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_LglTransRelationship</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LglTransRelationship</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglTransRelationship> fetchLglTransRelationship()
    {
        return fetchFieldAsList("to_LglTransRelationship", LglTransRelationship.class);
    }

    /**
     * Retrieval of associated <b>LglTransRelationship</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglTransRelationship</b>.
     * <p>
     * If the navigation property <b>to_LglTransRelationship</b> of a queried <b>LegalTransaction</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LglTransRelationship</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglTransRelationship> getLglTransRelationshipOrFetch()
    {
        if( toLglTransRelationship == null ) {
            toLglTransRelationship = fetchLglTransRelationship();
        }
        return toLglTransRelationship;
    }

    /**
     * Retrieval of associated <b>LglTransRelationship</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglTransRelationship</b>.
     * <p>
     * If the navigation property for an entity <b>LegalTransaction</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LglTransRelationship</b> is already loaded, the result
     *         will contain the <b>LglTransRelationship</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<LglTransRelationship>> getLglTransRelationshipIfPresent()
    {
        return Option.of(toLglTransRelationship);
    }

    /**
     * Overwrites the list of associated <b>LglTransRelationship</b> entities for the loaded navigation property
     * <b>to_LglTransRelationship</b>.
     * <p>
     * If the navigation property <b>to_LglTransRelationship</b> of a queried <b>LegalTransaction</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LglTransRelationship</b> entities.
     */
    public void setLglTransRelationship( @Nonnull final List<LglTransRelationship> value )
    {
        if( toLglTransRelationship == null ) {
            toLglTransRelationship = Lists.newArrayList();
        }
        toLglTransRelationship.clear();
        toLglTransRelationship.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LglTransRelationship</b> entities. This corresponds to the OData
     * navigation property <b>to_LglTransRelationship</b>.
     * <p>
     * If the navigation property <b>to_LglTransRelationship</b> of a queried <b>LegalTransaction</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LglTransRelationship</b> entities.
     */
    public void addLglTransRelationship( LglTransRelationship... entity )
    {
        if( toLglTransRelationship == null ) {
            toLglTransRelationship = Lists.newArrayList();
        }
        toLglTransRelationship.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of LegalTransaction instances.
     *
     */
    public final static class LegalTransactionBuilder
    {

        private List<LglTransCategoryGroup> toLglTransCategoryGroup = Lists.newArrayList();
        private List<LglTransDate> toLglTransDate = Lists.newArrayList();
        private List<LglTransEntity> toLglTransEntity = Lists.newArrayList();
        private List<LglTransExternalContact> toLglTransExternalContact = Lists.newArrayList();
        private List<LglTransInternalContact> toLglTransInternalContact = Lists.newArrayList();
        private List<LglTransLinkedObjects> toLglTransLinkedObjects = Lists.newArrayList();
        private List<LglTransRelationship> toLglTransRelationship = Lists.newArrayList();

        private LegalTransaction.LegalTransactionBuilder toLglTransCategoryGroup(
            final List<LglTransCategoryGroup> value )
        {
            toLglTransCategoryGroup.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LglTransCategoryGroup</b> for <b>LegalTransaction</b> to multiple
         * <b>LglTransCategoryGroup</b>.
         *
         * @param value
         *            The LglTransCategoryGroups to build this LegalTransaction with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LegalTransaction.LegalTransactionBuilder lglTransCategoryGroup( LglTransCategoryGroup... value )
        {
            return toLglTransCategoryGroup(Lists.newArrayList(value));
        }

        private LegalTransaction.LegalTransactionBuilder toLglTransDate( final List<LglTransDate> value )
        {
            toLglTransDate.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LglTransDate</b> for <b>LegalTransaction</b> to multiple <b>LglTransDate</b>.
         *
         * @param value
         *            The LglTransDates to build this LegalTransaction with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LegalTransaction.LegalTransactionBuilder lglTransDate( LglTransDate... value )
        {
            return toLglTransDate(Lists.newArrayList(value));
        }

        private LegalTransaction.LegalTransactionBuilder toLglTransEntity( final List<LglTransEntity> value )
        {
            toLglTransEntity.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LglTransEntity</b> for <b>LegalTransaction</b> to multiple <b>LglTransEntity</b>.
         *
         * @param value
         *            The LglTransEntitys to build this LegalTransaction with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LegalTransaction.LegalTransactionBuilder lglTransEntity( LglTransEntity... value )
        {
            return toLglTransEntity(Lists.newArrayList(value));
        }

        private LegalTransaction.LegalTransactionBuilder toLglTransExternalContact(
            final List<LglTransExternalContact> value )
        {
            toLglTransExternalContact.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LglTransExternalContact</b> for <b>LegalTransaction</b> to multiple
         * <b>LglTransExternalContact</b>.
         *
         * @param value
         *            The LglTransExternalContacts to build this LegalTransaction with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LegalTransaction.LegalTransactionBuilder lglTransExternalContact( LglTransExternalContact... value )
        {
            return toLglTransExternalContact(Lists.newArrayList(value));
        }

        private LegalTransaction.LegalTransactionBuilder toLglTransInternalContact(
            final List<LglTransInternalContact> value )
        {
            toLglTransInternalContact.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LglTransInternalContact</b> for <b>LegalTransaction</b> to multiple
         * <b>LglTransInternalContact</b>.
         *
         * @param value
         *            The LglTransInternalContacts to build this LegalTransaction with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LegalTransaction.LegalTransactionBuilder lglTransInternalContact( LglTransInternalContact... value )
        {
            return toLglTransInternalContact(Lists.newArrayList(value));
        }

        private LegalTransaction.LegalTransactionBuilder toLglTransLinkedObjects(
            final List<LglTransLinkedObjects> value )
        {
            toLglTransLinkedObjects.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LglTransLinkedObjects</b> for <b>LegalTransaction</b> to multiple
         * <b>LglTransLinkedObjects</b>.
         *
         * @param value
         *            The LglTransLinkedObjectss to build this LegalTransaction with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LegalTransaction.LegalTransactionBuilder lglTransLinkedObjects( LglTransLinkedObjects... value )
        {
            return toLglTransLinkedObjects(Lists.newArrayList(value));
        }

        private LegalTransaction.LegalTransactionBuilder toLglTransRelationship(
            final List<LglTransRelationship> value )
        {
            toLglTransRelationship.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LglTransRelationship</b> for <b>LegalTransaction</b> to multiple
         * <b>LglTransRelationship</b>.
         *
         * @param value
         *            The LglTransRelationships to build this LegalTransaction with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LegalTransaction.LegalTransactionBuilder lglTransRelationship( LglTransRelationship... value )
        {
            return toLglTransRelationship(Lists.newArrayList(value));
        }

    }

}
