/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.field.LglTransCategoryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable.LglTransCategorySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Categories
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LglTransCategoryType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LglTransCategory extends VdmEntity<LglTransCategory>
{

    /**
     * Selector for all available fields of LglTransCategory.
     *
     */
    public final static LglTransCategorySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionCategoryUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @Key
    @SerializedName( "LegalTransactionCategoryUUID" )
    @JsonProperty( "LegalTransactionCategoryUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionCategoryUUID" )
    private UUID legalTransactionCategoryUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionCategoryUUID</b> field to query operations.
     *
     */
    public final static LglTransCategoryField<UUID> LEGAL_TRANSACTION_CATEGORY_UUID =
        new LglTransCategoryField<UUID>("LegalTransactionCategoryUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionParCatUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @SerializedName( "LegalTransactionParCatUUID" )
    @JsonProperty( "LegalTransactionParCatUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionParCatUUID" )
    private UUID legalTransactionParCatUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionParCatUUID</b> field to query operations.
     *
     */
    public final static LglTransCategoryField<UUID> LEGAL_TRANSACTION_PAR_CAT_UUID =
        new LglTransCategoryField<UUID>("LegalTransactionParCatUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @SerializedName( "LegalTransactionUUID" )
    @JsonProperty( "LegalTransactionUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionUUID" )
    private UUID legalTransactionUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionUUID</b> field to query operations.
     *
     */
    public final static LglTransCategoryField<UUID> LEGAL_TRANSACTION_UUID =
        new LglTransCategoryField<UUID>("LegalTransactionUUID");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCategory</b>
     * </p>
     *
     * @return Category ID
     */
    @SerializedName( "LglCntntMCategory" )
    @JsonProperty( "LglCntntMCategory" )
    @Nullable
    @ODataField( odataName = "LglCntntMCategory" )
    private String lglCntntMCategory;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCategory</b> field to query operations.
     *
     */
    public final static LglTransCategoryField<String> LGL_CNTNT_M_CATEGORY =
        new LglTransCategoryField<String>("LglCntntMCategory");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIsMandatory</b>
     * </p>
     *
     * @return Mandatory
     */
    @SerializedName( "LglCntntMIsMandatory" )
    @JsonProperty( "LglCntntMIsMandatory" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "LglCntntMIsMandatory" )
    private Boolean lglCntntMIsMandatory;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMIsMandatory</b> field to query operations.
     *
     */
    public final static LglTransCategoryField<Boolean> LGL_CNTNT_M_IS_MANDATORY =
        new LglTransCategoryField<Boolean>("LglCntntMIsMandatory");

    @Nonnull
    @Override
    public Class<LglTransCategory> getType()
    {
        return LglTransCategory.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionCategoryUUID</b>
     * </p>
     *
     * @param legalTransactionCategoryUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionCategoryUUID( @Nullable final UUID legalTransactionCategoryUUID )
    {
        rememberChangedField("LegalTransactionCategoryUUID", this.legalTransactionCategoryUUID);
        this.legalTransactionCategoryUUID = legalTransactionCategoryUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionParCatUUID</b>
     * </p>
     *
     * @param legalTransactionParCatUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionParCatUUID( @Nullable final UUID legalTransactionParCatUUID )
    {
        rememberChangedField("LegalTransactionParCatUUID", this.legalTransactionParCatUUID);
        this.legalTransactionParCatUUID = legalTransactionParCatUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @param legalTransactionUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionUUID( @Nullable final UUID legalTransactionUUID )
    {
        rememberChangedField("LegalTransactionUUID", this.legalTransactionUUID);
        this.legalTransactionUUID = legalTransactionUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCategory</b>
     * </p>
     *
     * @param lglCntntMCategory
     *            Category ID
     */
    public void setLglCntntMCategory( @Nullable final String lglCntntMCategory )
    {
        rememberChangedField("LglCntntMCategory", this.lglCntntMCategory);
        this.lglCntntMCategory = lglCntntMCategory;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIsMandatory</b>
     * </p>
     *
     * @param lglCntntMIsMandatory
     *            Mandatory
     */
    public void setLglCntntMIsMandatory( @Nullable final Boolean lglCntntMIsMandatory )
    {
        rememberChangedField("LglCntntMIsMandatory", this.lglCntntMIsMandatory);
        this.lglCntntMIsMandatory = lglCntntMIsMandatory;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LglTransCategory";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LegalTransactionCategoryUUID", getLegalTransactionCategoryUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LegalTransactionCategoryUUID", getLegalTransactionCategoryUUID());
        values.put("LegalTransactionParCatUUID", getLegalTransactionParCatUUID());
        values.put("LegalTransactionUUID", getLegalTransactionUUID());
        values.put("LglCntntMCategory", getLglCntntMCategory());
        values.put("LglCntntMIsMandatory", getLglCntntMIsMandatory());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LegalTransactionCategoryUUID") ) {
                final Object value = values.remove("LegalTransactionCategoryUUID");
                if( (value == null) || (!value.equals(getLegalTransactionCategoryUUID())) ) {
                    setLegalTransactionCategoryUUID(((UUID) value));
                }
            }
            if( values.containsKey("LegalTransactionParCatUUID") ) {
                final Object value = values.remove("LegalTransactionParCatUUID");
                if( (value == null) || (!value.equals(getLegalTransactionParCatUUID())) ) {
                    setLegalTransactionParCatUUID(((UUID) value));
                }
            }
            if( values.containsKey("LegalTransactionUUID") ) {
                final Object value = values.remove("LegalTransactionUUID");
                if( (value == null) || (!value.equals(getLegalTransactionUUID())) ) {
                    setLegalTransactionUUID(((UUID) value));
                }
            }
            if( values.containsKey("LglCntntMCategory") ) {
                final Object value = values.remove("LglCntntMCategory");
                if( (value == null) || (!value.equals(getLglCntntMCategory())) ) {
                    setLglCntntMCategory(((String) value));
                }
            }
            if( values.containsKey("LglCntntMIsMandatory") ) {
                final Object value = values.remove("LglCntntMIsMandatory");
                if( (value == null) || (!value.equals(getLglCntntMIsMandatory())) ) {
                    setLglCntntMIsMandatory(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LglTransCategoryField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LglTransCategoryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LglTransCategoryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LglTransCategoryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService.DEFAULT_SERVICE_PATH);
    }

}
