/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.field.LglTransCategoryGroupField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.link.LglTransCategoryGroupLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable.LglTransCategoryGroupSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Category Groups
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LglTransCategoryGroupType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LglTransCategoryGroup extends VdmEntity<LglTransCategoryGroup>
{

    /**
     * Selector for all available fields of LglTransCategoryGroup.
     *
     */
    public final static LglTransCategoryGroupSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionCatGroupUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @Key
    @SerializedName( "LegalTransactionCatGroupUUID" )
    @JsonProperty( "LegalTransactionCatGroupUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionCatGroupUUID" )
    private UUID legalTransactionCatGroupUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionCatGroupUUID</b> field to query operations.
     *
     */
    public final static LglTransCategoryGroupField<UUID> LEGAL_TRANSACTION_CAT_GROUP_UUID =
        new LglTransCategoryGroupField<UUID>("LegalTransactionCatGroupUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @SerializedName( "LegalTransactionUUID" )
    @JsonProperty( "LegalTransactionUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionUUID" )
    private UUID legalTransactionUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionUUID</b> field to query operations.
     *
     */
    public final static LglTransCategoryGroupField<UUID> LEGAL_TRANSACTION_UUID =
        new LglTransCategoryGroupField<UUID>("LegalTransactionUUID");
    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatGroupTitle</b>
     * </p>
     *
     * @return Legal Transaction Name
     */
    @SerializedName( "LglCntntMCatGroupTitle" )
    @JsonProperty( "LglCntntMCatGroupTitle" )
    @Nullable
    @ODataField( odataName = "LglCntntMCatGroupTitle" )
    private String lglCntntMCatGroupTitle;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCatGroupTitle</b> field to query operations.
     *
     */
    public final static LglTransCategoryGroupField<String> LGL_CNTNT_M_CAT_GROUP_TITLE =
        new LglTransCategoryGroupField<String>("LglCntntMCatGroupTitle");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIndex</b>
     * </p>
     *
     * @return Index
     */
    @SerializedName( "LglCntntMIndex" )
    @JsonProperty( "LglCntntMIndex" )
    @Nullable
    @ODataField( odataName = "LglCntntMIndex" )
    private Short lglCntntMIndex;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMIndex</b> field to query operations.
     *
     */
    public final static LglTransCategoryGroupField<Short> LGL_CNTNT_M_INDEX =
        new LglTransCategoryGroupField<Short>("LglCntntMIndex");
    /**
     * Navigation property <b>to_LglTransParentCategory</b> for <b>LglTransCategoryGroup</b> to multiple
     * <b>LglTransParentCategory</b>.
     *
     */
    @SerializedName( "to_LglTransParentCategory" )
    @JsonProperty( "to_LglTransParentCategory" )
    @ODataField( odataName = "to_LglTransParentCategory" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LglTransParentCategory> toLglTransParentCategory;
    /**
     * Use with available fluent helpers to apply the <b>to_LglTransParentCategory</b> navigation property to query
     * operations.
     *
     */
    public final static LglTransCategoryGroupLink<LglTransParentCategory> TO_LGL_TRANS_PARENT_CATEGORY =
        new LglTransCategoryGroupLink<LglTransParentCategory>("to_LglTransParentCategory");

    @Nonnull
    @Override
    public Class<LglTransCategoryGroup> getType()
    {
        return LglTransCategoryGroup.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionCatGroupUUID</b>
     * </p>
     *
     * @param legalTransactionCatGroupUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionCatGroupUUID( @Nullable final UUID legalTransactionCatGroupUUID )
    {
        rememberChangedField("LegalTransactionCatGroupUUID", this.legalTransactionCatGroupUUID);
        this.legalTransactionCatGroupUUID = legalTransactionCatGroupUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @param legalTransactionUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionUUID( @Nullable final UUID legalTransactionUUID )
    {
        rememberChangedField("LegalTransactionUUID", this.legalTransactionUUID);
        this.legalTransactionUUID = legalTransactionUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatGroupTitle</b>
     * </p>
     *
     * @param lglCntntMCatGroupTitle
     *            Legal Transaction Name
     */
    public void setLglCntntMCatGroupTitle( @Nullable final String lglCntntMCatGroupTitle )
    {
        rememberChangedField("LglCntntMCatGroupTitle", this.lglCntntMCatGroupTitle);
        this.lglCntntMCatGroupTitle = lglCntntMCatGroupTitle;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIndex</b>
     * </p>
     *
     * @param lglCntntMIndex
     *            Index
     */
    public void setLglCntntMIndex( @Nullable final Short lglCntntMIndex )
    {
        rememberChangedField("LglCntntMIndex", this.lglCntntMIndex);
        this.lglCntntMIndex = lglCntntMIndex;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LglTransCategoryGroup";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LegalTransactionCatGroupUUID", getLegalTransactionCatGroupUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LegalTransactionCatGroupUUID", getLegalTransactionCatGroupUUID());
        values.put("LegalTransactionUUID", getLegalTransactionUUID());
        values.put("LglCntntMCatGroupTitle", getLglCntntMCatGroupTitle());
        values.put("LglCntntMIndex", getLglCntntMIndex());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LegalTransactionCatGroupUUID") ) {
                final Object value = values.remove("LegalTransactionCatGroupUUID");
                if( (value == null) || (!value.equals(getLegalTransactionCatGroupUUID())) ) {
                    setLegalTransactionCatGroupUUID(((UUID) value));
                }
            }
            if( values.containsKey("LegalTransactionUUID") ) {
                final Object value = values.remove("LegalTransactionUUID");
                if( (value == null) || (!value.equals(getLegalTransactionUUID())) ) {
                    setLegalTransactionUUID(((UUID) value));
                }
            }
            if( values.containsKey("LglCntntMCatGroupTitle") ) {
                final Object value = values.remove("LglCntntMCatGroupTitle");
                if( (value == null) || (!value.equals(getLglCntntMCatGroupTitle())) ) {
                    setLglCntntMCatGroupTitle(((String) value));
                }
            }
            if( values.containsKey("LglCntntMIndex") ) {
                final Object value = values.remove("LglCntntMIndex");
                if( (value == null) || (!value.equals(getLglCntntMIndex())) ) {
                    setLglCntntMIndex(((Short) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_LglTransParentCategory") ) {
                final Object value = (values).remove("to_LglTransParentCategory");
                if( value instanceof Iterable ) {
                    if( toLglTransParentCategory == null ) {
                        toLglTransParentCategory = Lists.newArrayList();
                    } else {
                        toLglTransParentCategory = Lists.newArrayList(toLglTransParentCategory);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LglTransParentCategory entity;
                        if( toLglTransParentCategory.size() > i ) {
                            entity = toLglTransParentCategory.get(i);
                        } else {
                            entity = new LglTransParentCategory();
                            toLglTransParentCategory.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LglTransCategoryGroupField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LglTransCategoryGroupField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LglTransCategoryGroupField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LglTransCategoryGroupField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toLglTransParentCategory != null ) {
            (values).put("to_LglTransParentCategory", toLglTransParentCategory);
        }
        return values;
    }

    /**
     * Fetches the <b>LglTransParentCategory</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_LglTransParentCategory</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LglTransParentCategory</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglTransParentCategory> fetchLglTransParentCategory()
    {
        return fetchFieldAsList("to_LglTransParentCategory", LglTransParentCategory.class);
    }

    /**
     * Retrieval of associated <b>LglTransParentCategory</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglTransParentCategory</b>.
     * <p>
     * If the navigation property <b>to_LglTransParentCategory</b> of a queried <b>LglTransCategoryGroup</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LglTransParentCategory</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglTransParentCategory> getLglTransParentCategoryOrFetch()
    {
        if( toLglTransParentCategory == null ) {
            toLglTransParentCategory = fetchLglTransParentCategory();
        }
        return toLglTransParentCategory;
    }

    /**
     * Retrieval of associated <b>LglTransParentCategory</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglTransParentCategory</b>.
     * <p>
     * If the navigation property for an entity <b>LglTransCategoryGroup</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LglTransParentCategory</b> is already loaded, the result
     *         will contain the <b>LglTransParentCategory</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<LglTransParentCategory>> getLglTransParentCategoryIfPresent()
    {
        return Option.of(toLglTransParentCategory);
    }

    /**
     * Overwrites the list of associated <b>LglTransParentCategory</b> entities for the loaded navigation property
     * <b>to_LglTransParentCategory</b>.
     * <p>
     * If the navigation property <b>to_LglTransParentCategory</b> of a queried <b>LglTransCategoryGroup</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LglTransParentCategory</b> entities.
     */
    public void setLglTransParentCategory( @Nonnull final List<LglTransParentCategory> value )
    {
        if( toLglTransParentCategory == null ) {
            toLglTransParentCategory = Lists.newArrayList();
        }
        toLglTransParentCategory.clear();
        toLglTransParentCategory.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LglTransParentCategory</b> entities. This corresponds to the OData
     * navigation property <b>to_LglTransParentCategory</b>.
     * <p>
     * If the navigation property <b>to_LglTransParentCategory</b> of a queried <b>LglTransCategoryGroup</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LglTransParentCategory</b> entities.
     */
    public void addLglTransParentCategory( LglTransParentCategory... entity )
    {
        if( toLglTransParentCategory == null ) {
            toLglTransParentCategory = Lists.newArrayList();
        }
        toLglTransParentCategory.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of LglTransCategoryGroup instances.
     *
     */
    public final static class LglTransCategoryGroupBuilder
    {

        private List<LglTransParentCategory> toLglTransParentCategory = Lists.newArrayList();

        private LglTransCategoryGroup.LglTransCategoryGroupBuilder toLglTransParentCategory(
            final List<LglTransParentCategory> value )
        {
            toLglTransParentCategory.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LglTransParentCategory</b> for <b>LglTransCategoryGroup</b> to multiple
         * <b>LglTransParentCategory</b>.
         *
         * @param value
         *            The LglTransParentCategorys to build this LglTransCategoryGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LglTransCategoryGroup.LglTransCategoryGroupBuilder lglTransParentCategory(
            LglTransParentCategory... value )
        {
            return toLglTransParentCategory(Lists.newArrayList(value));
        }

    }

}
