/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable.LglTransCategoryGroupSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroup
 * LglTransCategoryGroup} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class LglTransCategoryGroupByKeyFluentHelper
    extends
    FluentHelperByKey<LglTransCategoryGroupByKeyFluentHelper, LglTransCategoryGroup, LglTransCategoryGroupSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroup
     * LglTransCategoryGroup} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code LglTransCategoryGroup}
     * @param legalTransactionCatGroupUUID
     *            Universal Unique Identifier
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code LglTransCategoryGroup}
     */
    public LglTransCategoryGroupByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID legalTransactionCatGroupUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("LegalTransactionCatGroupUUID", legalTransactionCatGroupUUID);
    }

    @Override
    @Nonnull
    protected Class<LglTransCategoryGroup> getEntityClass()
    {
        return LglTransCategoryGroup.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
