/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction;

import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.field.LglTransDateField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable.LglTransDateSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Dates
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LglTransDateType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LglTransDate extends VdmEntity<LglTransDate>
{

    /**
     * Selector for all available fields of LglTransDate.
     *
     */
    public final static LglTransDateSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionDateUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @Key
    @SerializedName( "LegalTransactionDateUUID" )
    @JsonProperty( "LegalTransactionDateUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionDateUUID" )
    private UUID legalTransactionDateUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionDateUUID</b> field to query operations.
     *
     */
    public final static LglTransDateField<UUID> LEGAL_TRANSACTION_DATE_UUID =
        new LglTransDateField<UUID>("LegalTransactionDateUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDateType</b>
     * </p>
     *
     * @return Date Type
     */
    @SerializedName( "LglCntntMDateType" )
    @JsonProperty( "LglCntntMDateType" )
    @Nullable
    @ODataField( odataName = "LglCntntMDateType" )
    private String lglCntntMDateType;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDateType</b> field to query operations.
     *
     */
    public final static LglTransDateField<String> LGL_CNTNT_M_DATE_TYPE =
        new LglTransDateField<String>("LglCntntMDateType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMFromDate</b>
     * </p>
     *
     * @return Valid From
     */
    @SerializedName( "LglCntntMFromDate" )
    @JsonProperty( "LglCntntMFromDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LglCntntMFromDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lglCntntMFromDate;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMFromDate</b> field to query operations.
     *
     */
    public final static LglTransDateField<LocalDateTime> LGL_CNTNT_M_FROM_DATE =
        new LglTransDateField<LocalDateTime>("LglCntntMFromDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMToDate</b>
     * </p>
     *
     * @return Valid To
     */
    @SerializedName( "LglCntntMToDate" )
    @JsonProperty( "LglCntntMToDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LglCntntMToDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lglCntntMToDate;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMToDate</b> field to query operations.
     *
     */
    public final static LglTransDateField<LocalDateTime> LGL_CNTNT_M_TO_DATE =
        new LglTransDateField<LocalDateTime>("LglCntntMToDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransDateChangeReason</b>
     * </p>
     *
     * @return Reason of Change
     */
    @SerializedName( "LegalTransDateChangeReason" )
    @JsonProperty( "LegalTransDateChangeReason" )
    @Nullable
    @ODataField( odataName = "LegalTransDateChangeReason" )
    private String legalTransDateChangeReason;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransDateChangeReason</b> field to query operations.
     *
     */
    public final static LglTransDateField<String> LEGAL_TRANS_DATE_CHANGE_REASON =
        new LglTransDateField<String>("LegalTransDateChangeReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionMandatoryFlag</b>
     * </p>
     *
     * @return Control Parameter Legal Transaction Mandatory State
     */
    @SerializedName( "LegalTransactionMandatoryFlag" )
    @JsonProperty( "LegalTransactionMandatoryFlag" )
    @Nullable
    @ODataField( odataName = "LegalTransactionMandatoryFlag" )
    private String legalTransactionMandatoryFlag;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionMandatoryFlag</b> field to query operations.
     *
     */
    public final static LglTransDateField<String> LEGAL_TRANSACTION_MANDATORY_FLAG =
        new LglTransDateField<String>("LegalTransactionMandatoryFlag");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @SerializedName( "LegalTransactionUUID" )
    @JsonProperty( "LegalTransactionUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionUUID" )
    private UUID legalTransactionUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionUUID</b> field to query operations.
     *
     */
    public final static LglTransDateField<UUID> LEGAL_TRANSACTION_UUID =
        new LglTransDateField<UUID>("LegalTransactionUUID");

    @Nonnull
    @Override
    public Class<LglTransDate> getType()
    {
        return LglTransDate.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionDateUUID</b>
     * </p>
     *
     * @param legalTransactionDateUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionDateUUID( @Nullable final UUID legalTransactionDateUUID )
    {
        rememberChangedField("LegalTransactionDateUUID", this.legalTransactionDateUUID);
        this.legalTransactionDateUUID = legalTransactionDateUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDateType</b>
     * </p>
     *
     * @param lglCntntMDateType
     *            Date Type
     */
    public void setLglCntntMDateType( @Nullable final String lglCntntMDateType )
    {
        rememberChangedField("LglCntntMDateType", this.lglCntntMDateType);
        this.lglCntntMDateType = lglCntntMDateType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMFromDate</b>
     * </p>
     *
     * @param lglCntntMFromDate
     *            Valid From
     */
    public void setLglCntntMFromDate( @Nullable final LocalDateTime lglCntntMFromDate )
    {
        rememberChangedField("LglCntntMFromDate", this.lglCntntMFromDate);
        this.lglCntntMFromDate = lglCntntMFromDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMToDate</b>
     * </p>
     *
     * @param lglCntntMToDate
     *            Valid To
     */
    public void setLglCntntMToDate( @Nullable final LocalDateTime lglCntntMToDate )
    {
        rememberChangedField("LglCntntMToDate", this.lglCntntMToDate);
        this.lglCntntMToDate = lglCntntMToDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransDateChangeReason</b>
     * </p>
     *
     * @param legalTransDateChangeReason
     *            Reason of Change
     */
    public void setLegalTransDateChangeReason( @Nullable final String legalTransDateChangeReason )
    {
        rememberChangedField("LegalTransDateChangeReason", this.legalTransDateChangeReason);
        this.legalTransDateChangeReason = legalTransDateChangeReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionMandatoryFlag</b>
     * </p>
     *
     * @param legalTransactionMandatoryFlag
     *            Control Parameter Legal Transaction Mandatory State
     */
    public void setLegalTransactionMandatoryFlag( @Nullable final String legalTransactionMandatoryFlag )
    {
        rememberChangedField("LegalTransactionMandatoryFlag", this.legalTransactionMandatoryFlag);
        this.legalTransactionMandatoryFlag = legalTransactionMandatoryFlag;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @param legalTransactionUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionUUID( @Nullable final UUID legalTransactionUUID )
    {
        rememberChangedField("LegalTransactionUUID", this.legalTransactionUUID);
        this.legalTransactionUUID = legalTransactionUUID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LglTransDate";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LegalTransactionDateUUID", getLegalTransactionDateUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LegalTransactionDateUUID", getLegalTransactionDateUUID());
        values.put("LglCntntMDateType", getLglCntntMDateType());
        values.put("LglCntntMFromDate", getLglCntntMFromDate());
        values.put("LglCntntMToDate", getLglCntntMToDate());
        values.put("LegalTransDateChangeReason", getLegalTransDateChangeReason());
        values.put("LegalTransactionMandatoryFlag", getLegalTransactionMandatoryFlag());
        values.put("LegalTransactionUUID", getLegalTransactionUUID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LegalTransactionDateUUID") ) {
                final Object value = values.remove("LegalTransactionDateUUID");
                if( (value == null) || (!value.equals(getLegalTransactionDateUUID())) ) {
                    setLegalTransactionDateUUID(((UUID) value));
                }
            }
            if( values.containsKey("LglCntntMDateType") ) {
                final Object value = values.remove("LglCntntMDateType");
                if( (value == null) || (!value.equals(getLglCntntMDateType())) ) {
                    setLglCntntMDateType(((String) value));
                }
            }
            if( values.containsKey("LglCntntMFromDate") ) {
                final Object value = values.remove("LglCntntMFromDate");
                if( (value == null) || (!value.equals(getLglCntntMFromDate())) ) {
                    setLglCntntMFromDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LglCntntMToDate") ) {
                final Object value = values.remove("LglCntntMToDate");
                if( (value == null) || (!value.equals(getLglCntntMToDate())) ) {
                    setLglCntntMToDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LegalTransDateChangeReason") ) {
                final Object value = values.remove("LegalTransDateChangeReason");
                if( (value == null) || (!value.equals(getLegalTransDateChangeReason())) ) {
                    setLegalTransDateChangeReason(((String) value));
                }
            }
            if( values.containsKey("LegalTransactionMandatoryFlag") ) {
                final Object value = values.remove("LegalTransactionMandatoryFlag");
                if( (value == null) || (!value.equals(getLegalTransactionMandatoryFlag())) ) {
                    setLegalTransactionMandatoryFlag(((String) value));
                }
            }
            if( values.containsKey("LegalTransactionUUID") ) {
                final Object value = values.remove("LegalTransactionUUID");
                if( (value == null) || (!value.equals(getLegalTransactionUUID())) ) {
                    setLegalTransactionUUID(((UUID) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> LglTransDateField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LglTransDateField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LglTransDateField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LglTransDateField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService.DEFAULT_SERVICE_PATH);
    }

}
