/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable.LglTransDateSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate LglTransDate} entity using
 * key fields. This fluent helper allows methods which modify the underlying query to be called before executing the
 * query itself.
 *
 */
public class LglTransDateByKeyFluentHelper
    extends
    FluentHelperByKey<LglTransDateByKeyFluentHelper, LglTransDate, LglTransDateSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate LglTransDate} entity
     * with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code LglTransDate}
     * @param servicePath
     *            Service path to be used to fetch a single {@code LglTransDate}
     * @param legalTransactionDateUUID
     *            Universal Unique Identifier
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public LglTransDateByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID legalTransactionDateUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("LegalTransactionDateUUID", legalTransactionDateUUID);
    }

    @Override
    @Nonnull
    protected Class<LglTransDate> getEntityClass()
    {
        return LglTransDate.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
