/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.field.LglTransEntityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable.LglTransEntitySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Entities
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LglTransEntityType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LglTransEntity extends VdmEntity<LglTransEntity>
{

    /**
     * Selector for all available fields of LglTransEntity.
     *
     */
    public final static LglTransEntitySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionEntityUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @Key
    @SerializedName( "LegalTransactionEntityUUID" )
    @JsonProperty( "LegalTransactionEntityUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionEntityUUID" )
    private UUID legalTransactionEntityUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionEntityUUID</b> field to query operations.
     *
     */
    public final static LglTransEntityField<UUID> LEGAL_TRANSACTION_ENTITY_UUID =
        new LglTransEntityField<UUID>("LegalTransactionEntityUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMRank</b>
     * </p>
     *
     * @return Sequence Number
     */
    @SerializedName( "LglCntntMRank" )
    @JsonProperty( "LglCntntMRank" )
    @Nullable
    @ODataField( odataName = "LglCntntMRank" )
    private Short lglCntntMRank;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMRank</b> field to query operations.
     *
     */
    public final static LglTransEntityField<Short> LGL_CNTNT_M_RANK = new LglTransEntityField<Short>("LglCntntMRank");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMEntityType</b>
     * </p>
     *
     * @return Entity Type
     */
    @SerializedName( "LglCntntMEntityType" )
    @JsonProperty( "LglCntntMEntityType" )
    @Nullable
    @ODataField( odataName = "LglCntntMEntityType" )
    private String lglCntntMEntityType;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMEntityType</b> field to query operations.
     *
     */
    public final static LglTransEntityField<String> LGL_CNTNT_M_ENTITY_TYPE =
        new LglTransEntityField<String>("LglCntntMEntityType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMEntity</b>
     * </p>
     *
     * @return Entity ID
     */
    @SerializedName( "LglCntntMEntity" )
    @JsonProperty( "LglCntntMEntity" )
    @Nullable
    @ODataField( odataName = "LglCntntMEntity" )
    private String lglCntntMEntity;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMEntity</b> field to query operations.
     *
     */
    public final static LglTransEntityField<String> LGL_CNTNT_M_ENTITY =
        new LglTransEntityField<String>("LglCntntMEntity");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @SerializedName( "LegalTransactionUUID" )
    @JsonProperty( "LegalTransactionUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionUUID" )
    private UUID legalTransactionUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionUUID</b> field to query operations.
     *
     */
    public final static LglTransEntityField<UUID> LEGAL_TRANSACTION_UUID =
        new LglTransEntityField<UUID>("LegalTransactionUUID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionMandatoryFlag</b>
     * </p>
     *
     * @return Control Parameter Legal Transaction Mandatory State
     */
    @SerializedName( "LegalTransactionMandatoryFlag" )
    @JsonProperty( "LegalTransactionMandatoryFlag" )
    @Nullable
    @ODataField( odataName = "LegalTransactionMandatoryFlag" )
    private String legalTransactionMandatoryFlag;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionMandatoryFlag</b> field to query operations.
     *
     */
    public final static LglTransEntityField<String> LEGAL_TRANSACTION_MANDATORY_FLAG =
        new LglTransEntityField<String>("LegalTransactionMandatoryFlag");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIsMainEntity</b>
     * </p>
     *
     * @return Entity is Main Entity of Legal Transaction
     */
    @SerializedName( "LglCntntMIsMainEntity" )
    @JsonProperty( "LglCntntMIsMainEntity" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "LglCntntMIsMainEntity" )
    private Boolean lglCntntMIsMainEntity;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMIsMainEntity</b> field to query operations.
     *
     */
    public final static LglTransEntityField<Boolean> LGL_CNTNT_M_IS_MAIN_ENTITY =
        new LglTransEntityField<Boolean>("LglCntntMIsMainEntity");

    @Nonnull
    @Override
    public Class<LglTransEntity> getType()
    {
        return LglTransEntity.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionEntityUUID</b>
     * </p>
     *
     * @param legalTransactionEntityUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionEntityUUID( @Nullable final UUID legalTransactionEntityUUID )
    {
        rememberChangedField("LegalTransactionEntityUUID", this.legalTransactionEntityUUID);
        this.legalTransactionEntityUUID = legalTransactionEntityUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMRank</b>
     * </p>
     *
     * @param lglCntntMRank
     *            Sequence Number
     */
    public void setLglCntntMRank( @Nullable final Short lglCntntMRank )
    {
        rememberChangedField("LglCntntMRank", this.lglCntntMRank);
        this.lglCntntMRank = lglCntntMRank;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMEntityType</b>
     * </p>
     *
     * @param lglCntntMEntityType
     *            Entity Type
     */
    public void setLglCntntMEntityType( @Nullable final String lglCntntMEntityType )
    {
        rememberChangedField("LglCntntMEntityType", this.lglCntntMEntityType);
        this.lglCntntMEntityType = lglCntntMEntityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMEntity</b>
     * </p>
     *
     * @param lglCntntMEntity
     *            Entity ID
     */
    public void setLglCntntMEntity( @Nullable final String lglCntntMEntity )
    {
        rememberChangedField("LglCntntMEntity", this.lglCntntMEntity);
        this.lglCntntMEntity = lglCntntMEntity;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @param legalTransactionUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionUUID( @Nullable final UUID legalTransactionUUID )
    {
        rememberChangedField("LegalTransactionUUID", this.legalTransactionUUID);
        this.legalTransactionUUID = legalTransactionUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionMandatoryFlag</b>
     * </p>
     *
     * @param legalTransactionMandatoryFlag
     *            Control Parameter Legal Transaction Mandatory State
     */
    public void setLegalTransactionMandatoryFlag( @Nullable final String legalTransactionMandatoryFlag )
    {
        rememberChangedField("LegalTransactionMandatoryFlag", this.legalTransactionMandatoryFlag);
        this.legalTransactionMandatoryFlag = legalTransactionMandatoryFlag;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIsMainEntity</b>
     * </p>
     *
     * @param lglCntntMIsMainEntity
     *            Entity is Main Entity of Legal Transaction
     */
    public void setLglCntntMIsMainEntity( @Nullable final Boolean lglCntntMIsMainEntity )
    {
        rememberChangedField("LglCntntMIsMainEntity", this.lglCntntMIsMainEntity);
        this.lglCntntMIsMainEntity = lglCntntMIsMainEntity;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LglTransEntity";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LegalTransactionEntityUUID", getLegalTransactionEntityUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LegalTransactionEntityUUID", getLegalTransactionEntityUUID());
        values.put("LglCntntMRank", getLglCntntMRank());
        values.put("LglCntntMEntityType", getLglCntntMEntityType());
        values.put("LglCntntMEntity", getLglCntntMEntity());
        values.put("LegalTransactionUUID", getLegalTransactionUUID());
        values.put("LegalTransactionMandatoryFlag", getLegalTransactionMandatoryFlag());
        values.put("LglCntntMIsMainEntity", getLglCntntMIsMainEntity());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LegalTransactionEntityUUID") ) {
                final Object value = values.remove("LegalTransactionEntityUUID");
                if( (value == null) || (!value.equals(getLegalTransactionEntityUUID())) ) {
                    setLegalTransactionEntityUUID(((UUID) value));
                }
            }
            if( values.containsKey("LglCntntMRank") ) {
                final Object value = values.remove("LglCntntMRank");
                if( (value == null) || (!value.equals(getLglCntntMRank())) ) {
                    setLglCntntMRank(((Short) value));
                }
            }
            if( values.containsKey("LglCntntMEntityType") ) {
                final Object value = values.remove("LglCntntMEntityType");
                if( (value == null) || (!value.equals(getLglCntntMEntityType())) ) {
                    setLglCntntMEntityType(((String) value));
                }
            }
            if( values.containsKey("LglCntntMEntity") ) {
                final Object value = values.remove("LglCntntMEntity");
                if( (value == null) || (!value.equals(getLglCntntMEntity())) ) {
                    setLglCntntMEntity(((String) value));
                }
            }
            if( values.containsKey("LegalTransactionUUID") ) {
                final Object value = values.remove("LegalTransactionUUID");
                if( (value == null) || (!value.equals(getLegalTransactionUUID())) ) {
                    setLegalTransactionUUID(((UUID) value));
                }
            }
            if( values.containsKey("LegalTransactionMandatoryFlag") ) {
                final Object value = values.remove("LegalTransactionMandatoryFlag");
                if( (value == null) || (!value.equals(getLegalTransactionMandatoryFlag())) ) {
                    setLegalTransactionMandatoryFlag(((String) value));
                }
            }
            if( values.containsKey("LglCntntMIsMainEntity") ) {
                final Object value = values.remove("LglCntntMIsMainEntity");
                if( (value == null) || (!value.equals(getLglCntntMIsMainEntity())) ) {
                    setLglCntntMIsMainEntity(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> LglTransEntityField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LglTransEntityField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LglTransEntityField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LglTransEntityField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService.DEFAULT_SERVICE_PATH);
    }

}
