/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.field.LglTransExternalContactField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable.LglTransExternalContactSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * External Contacts
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LglTransExternalContactType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LglTransExternalContact extends VdmEntity<LglTransExternalContact>
{

    /**
     * Selector for all available fields of LglTransExternalContact.
     *
     */
    public final static LglTransExternalContactSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionExtCntctUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @Key
    @SerializedName( "LegalTransactionExtCntctUUID" )
    @JsonProperty( "LegalTransactionExtCntctUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionExtCntctUUID" )
    private UUID legalTransactionExtCntctUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionExtCntctUUID</b> field to query operations.
     *
     */
    public final static LglTransExternalContactField<UUID> LEGAL_TRANSACTION_EXT_CNTCT_UUID =
        new LglTransExternalContactField<UUID>("LegalTransactionExtCntctUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMRank</b>
     * </p>
     *
     * @return Sequence Number
     */
    @SerializedName( "LglCntntMRank" )
    @JsonProperty( "LglCntntMRank" )
    @Nullable
    @ODataField( odataName = "LglCntntMRank" )
    private Short lglCntntMRank;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMRank</b> field to query operations.
     *
     */
    public final static LglTransExternalContactField<Short> LGL_CNTNT_M_RANK =
        new LglTransExternalContactField<Short>("LglCntntMRank");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMExtCntctType</b>
     * </p>
     *
     * @return External context type
     */
    @SerializedName( "LglCntntMExtCntctType" )
    @JsonProperty( "LglCntntMExtCntctType" )
    @Nullable
    @ODataField( odataName = "LglCntntMExtCntctType" )
    private String lglCntntMExtCntctType;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMExtCntctType</b> field to query operations.
     *
     */
    public final static LglTransExternalContactField<String> LGL_CNTNT_M_EXT_CNTCT_TYPE =
        new LglTransExternalContactField<String>("LglCntntMExtCntctType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMExtCntctBP</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "LglCntntMExtCntctBP" )
    @JsonProperty( "LglCntntMExtCntctBP" )
    @Nullable
    @ODataField( odataName = "LglCntntMExtCntctBP" )
    private String lglCntntMExtCntctBP;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMExtCntctBP</b> field to query operations.
     *
     */
    public final static LglTransExternalContactField<String> LGL_CNTNT_M_EXT_CNTCT_BP =
        new LglTransExternalContactField<String>("LglCntntMExtCntctBP");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionMandatoryFlag</b>
     * </p>
     *
     * @return Control Parameter Legal Transaction Mandatory State
     */
    @SerializedName( "LegalTransactionMandatoryFlag" )
    @JsonProperty( "LegalTransactionMandatoryFlag" )
    @Nullable
    @ODataField( odataName = "LegalTransactionMandatoryFlag" )
    private String legalTransactionMandatoryFlag;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionMandatoryFlag</b> field to query operations.
     *
     */
    public final static LglTransExternalContactField<String> LEGAL_TRANSACTION_MANDATORY_FLAG =
        new LglTransExternalContactField<String>("LegalTransactionMandatoryFlag");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @SerializedName( "LegalTransactionUUID" )
    @JsonProperty( "LegalTransactionUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionUUID" )
    private UUID legalTransactionUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionUUID</b> field to query operations.
     *
     */
    public final static LglTransExternalContactField<UUID> LEGAL_TRANSACTION_UUID =
        new LglTransExternalContactField<UUID>("LegalTransactionUUID");

    @Nonnull
    @Override
    public Class<LglTransExternalContact> getType()
    {
        return LglTransExternalContact.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionExtCntctUUID</b>
     * </p>
     *
     * @param legalTransactionExtCntctUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionExtCntctUUID( @Nullable final UUID legalTransactionExtCntctUUID )
    {
        rememberChangedField("LegalTransactionExtCntctUUID", this.legalTransactionExtCntctUUID);
        this.legalTransactionExtCntctUUID = legalTransactionExtCntctUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMRank</b>
     * </p>
     *
     * @param lglCntntMRank
     *            Sequence Number
     */
    public void setLglCntntMRank( @Nullable final Short lglCntntMRank )
    {
        rememberChangedField("LglCntntMRank", this.lglCntntMRank);
        this.lglCntntMRank = lglCntntMRank;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMExtCntctType</b>
     * </p>
     *
     * @param lglCntntMExtCntctType
     *            External context type
     */
    public void setLglCntntMExtCntctType( @Nullable final String lglCntntMExtCntctType )
    {
        rememberChangedField("LglCntntMExtCntctType", this.lglCntntMExtCntctType);
        this.lglCntntMExtCntctType = lglCntntMExtCntctType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMExtCntctBP</b>
     * </p>
     *
     * @param lglCntntMExtCntctBP
     *            Business Partner Number
     */
    public void setLglCntntMExtCntctBP( @Nullable final String lglCntntMExtCntctBP )
    {
        rememberChangedField("LglCntntMExtCntctBP", this.lglCntntMExtCntctBP);
        this.lglCntntMExtCntctBP = lglCntntMExtCntctBP;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionMandatoryFlag</b>
     * </p>
     *
     * @param legalTransactionMandatoryFlag
     *            Control Parameter Legal Transaction Mandatory State
     */
    public void setLegalTransactionMandatoryFlag( @Nullable final String legalTransactionMandatoryFlag )
    {
        rememberChangedField("LegalTransactionMandatoryFlag", this.legalTransactionMandatoryFlag);
        this.legalTransactionMandatoryFlag = legalTransactionMandatoryFlag;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @param legalTransactionUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionUUID( @Nullable final UUID legalTransactionUUID )
    {
        rememberChangedField("LegalTransactionUUID", this.legalTransactionUUID);
        this.legalTransactionUUID = legalTransactionUUID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LglTransExternalContact";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LegalTransactionExtCntctUUID", getLegalTransactionExtCntctUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LegalTransactionExtCntctUUID", getLegalTransactionExtCntctUUID());
        values.put("LglCntntMRank", getLglCntntMRank());
        values.put("LglCntntMExtCntctType", getLglCntntMExtCntctType());
        values.put("LglCntntMExtCntctBP", getLglCntntMExtCntctBP());
        values.put("LegalTransactionMandatoryFlag", getLegalTransactionMandatoryFlag());
        values.put("LegalTransactionUUID", getLegalTransactionUUID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LegalTransactionExtCntctUUID") ) {
                final Object value = values.remove("LegalTransactionExtCntctUUID");
                if( (value == null) || (!value.equals(getLegalTransactionExtCntctUUID())) ) {
                    setLegalTransactionExtCntctUUID(((UUID) value));
                }
            }
            if( values.containsKey("LglCntntMRank") ) {
                final Object value = values.remove("LglCntntMRank");
                if( (value == null) || (!value.equals(getLglCntntMRank())) ) {
                    setLglCntntMRank(((Short) value));
                }
            }
            if( values.containsKey("LglCntntMExtCntctType") ) {
                final Object value = values.remove("LglCntntMExtCntctType");
                if( (value == null) || (!value.equals(getLglCntntMExtCntctType())) ) {
                    setLglCntntMExtCntctType(((String) value));
                }
            }
            if( values.containsKey("LglCntntMExtCntctBP") ) {
                final Object value = values.remove("LglCntntMExtCntctBP");
                if( (value == null) || (!value.equals(getLglCntntMExtCntctBP())) ) {
                    setLglCntntMExtCntctBP(((String) value));
                }
            }
            if( values.containsKey("LegalTransactionMandatoryFlag") ) {
                final Object value = values.remove("LegalTransactionMandatoryFlag");
                if( (value == null) || (!value.equals(getLegalTransactionMandatoryFlag())) ) {
                    setLegalTransactionMandatoryFlag(((String) value));
                }
            }
            if( values.containsKey("LegalTransactionUUID") ) {
                final Object value = values.remove("LegalTransactionUUID");
                if( (value == null) || (!value.equals(getLegalTransactionUUID())) ) {
                    setLegalTransactionUUID(((UUID) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LglTransExternalContactField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LglTransExternalContactField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LglTransExternalContactField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LglTransExternalContactField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService.DEFAULT_SERVICE_PATH);
    }

}
