/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable.LglTransExternalContactSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
 * LglTransExternalContact} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class LglTransExternalContactByKeyFluentHelper
    extends
    FluentHelperByKey<LglTransExternalContactByKeyFluentHelper, LglTransExternalContact, LglTransExternalContactSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     * LglTransExternalContact} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code LglTransExternalContact}
     * @param servicePath
     *            Service path to be used to fetch a single {@code LglTransExternalContact}
     * @param legalTransactionExtCntctUUID
     *            Universal Unique Identifier
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public LglTransExternalContactByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID legalTransactionExtCntctUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("LegalTransactionExtCntctUUID", legalTransactionExtCntctUUID);
    }

    @Override
    @Nonnull
    protected Class<LglTransExternalContact> getEntityClass()
    {
        return LglTransExternalContact.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
