/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.field.LglTransInternalContactField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable.LglTransInternalContactSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Internal Contacts
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LglTransInternalContactType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LglTransInternalContact extends VdmEntity<LglTransInternalContact>
{

    /**
     * Selector for all available fields of LglTransInternalContact.
     *
     */
    public final static LglTransInternalContactSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionIntCntctUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @Key
    @SerializedName( "LegalTransactionIntCntctUUID" )
    @JsonProperty( "LegalTransactionIntCntctUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionIntCntctUUID" )
    private UUID legalTransactionIntCntctUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionIntCntctUUID</b> field to query operations.
     *
     */
    public final static LglTransInternalContactField<UUID> LEGAL_TRANSACTION_INT_CNTCT_UUID =
        new LglTransInternalContactField<UUID>("LegalTransactionIntCntctUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMRank</b>
     * </p>
     *
     * @return Sequence Number
     */
    @SerializedName( "LglCntntMRank" )
    @JsonProperty( "LglCntntMRank" )
    @Nullable
    @ODataField( odataName = "LglCntntMRank" )
    private Short lglCntntMRank;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMRank</b> field to query operations.
     *
     */
    public final static LglTransInternalContactField<Short> LGL_CNTNT_M_RANK =
        new LglTransInternalContactField<Short>("LglCntntMRank");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIntCntctType</b>
     * </p>
     *
     * @return Contact Type
     */
    @SerializedName( "LglCntntMIntCntctType" )
    @JsonProperty( "LglCntntMIntCntctType" )
    @Nullable
    @ODataField( odataName = "LglCntntMIntCntctType" )
    private String lglCntntMIntCntctType;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMIntCntctType</b> field to query operations.
     *
     */
    public final static LglTransInternalContactField<String> LGL_CNTNT_M_INT_CNTCT_TYPE =
        new LglTransInternalContactField<String>("LglCntntMIntCntctType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIntContactUserType</b>
     * </p>
     *
     * @return Assignment Type
     */
    @SerializedName( "LglCntntMIntContactUserType" )
    @JsonProperty( "LglCntntMIntContactUserType" )
    @Nullable
    @ODataField( odataName = "LglCntntMIntContactUserType" )
    private String lglCntntMIntContactUserType;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMIntContactUserType</b> field to query operations.
     *
     */
    public final static LglTransInternalContactField<String> LGL_CNTNT_M_INT_CONTACT_USER_TYPE =
        new LglTransInternalContactField<String>("LglCntntMIntContactUserType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIntCntctUser</b>
     * </p>
     *
     * @return User Name
     */
    @SerializedName( "LglCntntMIntCntctUser" )
    @JsonProperty( "LglCntntMIntCntctUser" )
    @Nullable
    @ODataField( odataName = "LglCntntMIntCntctUser" )
    private String lglCntntMIntCntctUser;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMIntCntctUser</b> field to query operations.
     *
     */
    public final static LglTransInternalContactField<String> LGL_CNTNT_M_INT_CNTCT_USER =
        new LglTransInternalContactField<String>("LglCntntMIntCntctUser");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIntContactTeam</b>
     * </p>
     *
     * @return Team
     */
    @SerializedName( "LglCntntMIntContactTeam" )
    @JsonProperty( "LglCntntMIntContactTeam" )
    @Nullable
    @ODataField( odataName = "LglCntntMIntContactTeam" )
    private String lglCntntMIntContactTeam;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMIntContactTeam</b> field to query operations.
     *
     */
    public final static LglTransInternalContactField<String> LGL_CNTNT_M_INT_CONTACT_TEAM =
        new LglTransInternalContactField<String>("LglCntntMIntContactTeam");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionMandatoryFlag</b>
     * </p>
     *
     * @return Control Parameter Legal Transaction Mandatory State
     */
    @SerializedName( "LegalTransactionMandatoryFlag" )
    @JsonProperty( "LegalTransactionMandatoryFlag" )
    @Nullable
    @ODataField( odataName = "LegalTransactionMandatoryFlag" )
    private String legalTransactionMandatoryFlag;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionMandatoryFlag</b> field to query operations.
     *
     */
    public final static LglTransInternalContactField<String> LEGAL_TRANSACTION_MANDATORY_FLAG =
        new LglTransInternalContactField<String>("LegalTransactionMandatoryFlag");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @SerializedName( "LegalTransactionUUID" )
    @JsonProperty( "LegalTransactionUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionUUID" )
    private UUID legalTransactionUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionUUID</b> field to query operations.
     *
     */
    public final static LglTransInternalContactField<UUID> LEGAL_TRANSACTION_UUID =
        new LglTransInternalContactField<UUID>("LegalTransactionUUID");

    @Nonnull
    @Override
    public Class<LglTransInternalContact> getType()
    {
        return LglTransInternalContact.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionIntCntctUUID</b>
     * </p>
     *
     * @param legalTransactionIntCntctUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionIntCntctUUID( @Nullable final UUID legalTransactionIntCntctUUID )
    {
        rememberChangedField("LegalTransactionIntCntctUUID", this.legalTransactionIntCntctUUID);
        this.legalTransactionIntCntctUUID = legalTransactionIntCntctUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMRank</b>
     * </p>
     *
     * @param lglCntntMRank
     *            Sequence Number
     */
    public void setLglCntntMRank( @Nullable final Short lglCntntMRank )
    {
        rememberChangedField("LglCntntMRank", this.lglCntntMRank);
        this.lglCntntMRank = lglCntntMRank;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIntCntctType</b>
     * </p>
     *
     * @param lglCntntMIntCntctType
     *            Contact Type
     */
    public void setLglCntntMIntCntctType( @Nullable final String lglCntntMIntCntctType )
    {
        rememberChangedField("LglCntntMIntCntctType", this.lglCntntMIntCntctType);
        this.lglCntntMIntCntctType = lglCntntMIntCntctType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIntContactUserType</b>
     * </p>
     *
     * @param lglCntntMIntContactUserType
     *            Assignment Type
     */
    public void setLglCntntMIntContactUserType( @Nullable final String lglCntntMIntContactUserType )
    {
        rememberChangedField("LglCntntMIntContactUserType", this.lglCntntMIntContactUserType);
        this.lglCntntMIntContactUserType = lglCntntMIntContactUserType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIntCntctUser</b>
     * </p>
     *
     * @param lglCntntMIntCntctUser
     *            User Name
     */
    public void setLglCntntMIntCntctUser( @Nullable final String lglCntntMIntCntctUser )
    {
        rememberChangedField("LglCntntMIntCntctUser", this.lglCntntMIntCntctUser);
        this.lglCntntMIntCntctUser = lglCntntMIntCntctUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIntContactTeam</b>
     * </p>
     *
     * @param lglCntntMIntContactTeam
     *            Team
     */
    public void setLglCntntMIntContactTeam( @Nullable final String lglCntntMIntContactTeam )
    {
        rememberChangedField("LglCntntMIntContactTeam", this.lglCntntMIntContactTeam);
        this.lglCntntMIntContactTeam = lglCntntMIntContactTeam;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionMandatoryFlag</b>
     * </p>
     *
     * @param legalTransactionMandatoryFlag
     *            Control Parameter Legal Transaction Mandatory State
     */
    public void setLegalTransactionMandatoryFlag( @Nullable final String legalTransactionMandatoryFlag )
    {
        rememberChangedField("LegalTransactionMandatoryFlag", this.legalTransactionMandatoryFlag);
        this.legalTransactionMandatoryFlag = legalTransactionMandatoryFlag;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @param legalTransactionUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionUUID( @Nullable final UUID legalTransactionUUID )
    {
        rememberChangedField("LegalTransactionUUID", this.legalTransactionUUID);
        this.legalTransactionUUID = legalTransactionUUID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LglTransInternalContact";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LegalTransactionIntCntctUUID", getLegalTransactionIntCntctUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LegalTransactionIntCntctUUID", getLegalTransactionIntCntctUUID());
        values.put("LglCntntMRank", getLglCntntMRank());
        values.put("LglCntntMIntCntctType", getLglCntntMIntCntctType());
        values.put("LglCntntMIntContactUserType", getLglCntntMIntContactUserType());
        values.put("LglCntntMIntCntctUser", getLglCntntMIntCntctUser());
        values.put("LglCntntMIntContactTeam", getLglCntntMIntContactTeam());
        values.put("LegalTransactionMandatoryFlag", getLegalTransactionMandatoryFlag());
        values.put("LegalTransactionUUID", getLegalTransactionUUID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LegalTransactionIntCntctUUID") ) {
                final Object value = values.remove("LegalTransactionIntCntctUUID");
                if( (value == null) || (!value.equals(getLegalTransactionIntCntctUUID())) ) {
                    setLegalTransactionIntCntctUUID(((UUID) value));
                }
            }
            if( values.containsKey("LglCntntMRank") ) {
                final Object value = values.remove("LglCntntMRank");
                if( (value == null) || (!value.equals(getLglCntntMRank())) ) {
                    setLglCntntMRank(((Short) value));
                }
            }
            if( values.containsKey("LglCntntMIntCntctType") ) {
                final Object value = values.remove("LglCntntMIntCntctType");
                if( (value == null) || (!value.equals(getLglCntntMIntCntctType())) ) {
                    setLglCntntMIntCntctType(((String) value));
                }
            }
            if( values.containsKey("LglCntntMIntContactUserType") ) {
                final Object value = values.remove("LglCntntMIntContactUserType");
                if( (value == null) || (!value.equals(getLglCntntMIntContactUserType())) ) {
                    setLglCntntMIntContactUserType(((String) value));
                }
            }
            if( values.containsKey("LglCntntMIntCntctUser") ) {
                final Object value = values.remove("LglCntntMIntCntctUser");
                if( (value == null) || (!value.equals(getLglCntntMIntCntctUser())) ) {
                    setLglCntntMIntCntctUser(((String) value));
                }
            }
            if( values.containsKey("LglCntntMIntContactTeam") ) {
                final Object value = values.remove("LglCntntMIntContactTeam");
                if( (value == null) || (!value.equals(getLglCntntMIntContactTeam())) ) {
                    setLglCntntMIntContactTeam(((String) value));
                }
            }
            if( values.containsKey("LegalTransactionMandatoryFlag") ) {
                final Object value = values.remove("LegalTransactionMandatoryFlag");
                if( (value == null) || (!value.equals(getLegalTransactionMandatoryFlag())) ) {
                    setLegalTransactionMandatoryFlag(((String) value));
                }
            }
            if( values.containsKey("LegalTransactionUUID") ) {
                final Object value = values.remove("LegalTransactionUUID");
                if( (value == null) || (!value.equals(getLegalTransactionUUID())) ) {
                    setLegalTransactionUUID(((UUID) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LglTransInternalContactField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LglTransInternalContactField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LglTransInternalContactField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LglTransInternalContactField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService.DEFAULT_SERVICE_PATH);
    }

}
