/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.field.LglTransLinkedObjectsField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable.LglTransLinkedObjectsSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Linked Objects
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LglTransLinkedObjectsType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LglTransLinkedObjects extends VdmEntity<LglTransLinkedObjects>
{

    /**
     * Selector for all available fields of LglTransLinkedObjects.
     *
     */
    public final static LglTransLinkedObjectsSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionLinkdObjUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @Key
    @SerializedName( "LegalTransactionLinkdObjUUID" )
    @JsonProperty( "LegalTransactionLinkdObjUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionLinkdObjUUID" )
    private UUID legalTransactionLinkdObjUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionLinkdObjUUID</b> field to query operations.
     *
     */
    public final static LglTransLinkedObjectsField<UUID> LEGAL_TRANSACTION_LINKD_OBJ_UUID =
        new LglTransLinkedObjectsField<UUID>("LegalTransactionLinkdObjUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMLinkdObjType</b>
     * </p>
     *
     * @return Linked Object Type
     */
    @SerializedName( "LglCntntMLinkdObjType" )
    @JsonProperty( "LglCntntMLinkdObjType" )
    @Nullable
    @ODataField( odataName = "LglCntntMLinkdObjType" )
    private String lglCntntMLinkdObjType;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMLinkdObjType</b> field to query operations.
     *
     */
    public final static LglTransLinkedObjectsField<String> LGL_CNTNT_M_LINKD_OBJ_TYPE =
        new LglTransLinkedObjectsField<String>("LglCntntMLinkdObjType");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMLinkdObj</b>
     * </p>
     *
     * @return Linked Object ID
     */
    @SerializedName( "LglCntntMLinkdObj" )
    @JsonProperty( "LglCntntMLinkdObj" )
    @Nullable
    @ODataField( odataName = "LglCntntMLinkdObj" )
    private String lglCntntMLinkdObj;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMLinkdObj</b> field to query operations.
     *
     */
    public final static LglTransLinkedObjectsField<String> LGL_CNTNT_M_LINKD_OBJ =
        new LglTransLinkedObjectsField<String>("LglCntntMLinkdObj");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionMandatoryFlag</b>
     * </p>
     *
     * @return Control Parameter Legal Transaction Mandatory State
     */
    @SerializedName( "LegalTransactionMandatoryFlag" )
    @JsonProperty( "LegalTransactionMandatoryFlag" )
    @Nullable
    @ODataField( odataName = "LegalTransactionMandatoryFlag" )
    private String legalTransactionMandatoryFlag;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionMandatoryFlag</b> field to query operations.
     *
     */
    public final static LglTransLinkedObjectsField<String> LEGAL_TRANSACTION_MANDATORY_FLAG =
        new LglTransLinkedObjectsField<String>("LegalTransactionMandatoryFlag");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @SerializedName( "LegalTransactionUUID" )
    @JsonProperty( "LegalTransactionUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionUUID" )
    private UUID legalTransactionUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionUUID</b> field to query operations.
     *
     */
    public final static LglTransLinkedObjectsField<UUID> LEGAL_TRANSACTION_UUID =
        new LglTransLinkedObjectsField<UUID>("LegalTransactionUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionIsTriggerObj</b>
     * </p>
     *
     * @return Denotes if linked object is trigger object
     */
    @SerializedName( "LegalTransactionIsTriggerObj" )
    @JsonProperty( "LegalTransactionIsTriggerObj" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "LegalTransactionIsTriggerObj" )
    private Boolean legalTransactionIsTriggerObj;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionIsTriggerObj</b> field to query operations.
     *
     */
    public final static LglTransLinkedObjectsField<Boolean> LEGAL_TRANSACTION_IS_TRIGGER_OBJ =
        new LglTransLinkedObjectsField<Boolean>("LegalTransactionIsTriggerObj");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIntegrationLink</b>
     * </p>
     *
     * @return Integration Link
     */
    @SerializedName( "LglCntntMIntegrationLink" )
    @JsonProperty( "LglCntntMIntegrationLink" )
    @Nullable
    @ODataField( odataName = "LglCntntMIntegrationLink" )
    private String lglCntntMIntegrationLink;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMIntegrationLink</b> field to query operations.
     *
     */
    public final static LglTransLinkedObjectsField<String> LGL_CNTNT_M_INTEGRATION_LINK =
        new LglTransLinkedObjectsField<String>("LglCntntMIntegrationLink");

    @Nonnull
    @Override
    public Class<LglTransLinkedObjects> getType()
    {
        return LglTransLinkedObjects.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionLinkdObjUUID</b>
     * </p>
     *
     * @param legalTransactionLinkdObjUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionLinkdObjUUID( @Nullable final UUID legalTransactionLinkdObjUUID )
    {
        rememberChangedField("LegalTransactionLinkdObjUUID", this.legalTransactionLinkdObjUUID);
        this.legalTransactionLinkdObjUUID = legalTransactionLinkdObjUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMLinkdObjType</b>
     * </p>
     *
     * @param lglCntntMLinkdObjType
     *            Linked Object Type
     */
    public void setLglCntntMLinkdObjType( @Nullable final String lglCntntMLinkdObjType )
    {
        rememberChangedField("LglCntntMLinkdObjType", this.lglCntntMLinkdObjType);
        this.lglCntntMLinkdObjType = lglCntntMLinkdObjType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMLinkdObj</b>
     * </p>
     *
     * @param lglCntntMLinkdObj
     *            Linked Object ID
     */
    public void setLglCntntMLinkdObj( @Nullable final String lglCntntMLinkdObj )
    {
        rememberChangedField("LglCntntMLinkdObj", this.lglCntntMLinkdObj);
        this.lglCntntMLinkdObj = lglCntntMLinkdObj;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionMandatoryFlag</b>
     * </p>
     *
     * @param legalTransactionMandatoryFlag
     *            Control Parameter Legal Transaction Mandatory State
     */
    public void setLegalTransactionMandatoryFlag( @Nullable final String legalTransactionMandatoryFlag )
    {
        rememberChangedField("LegalTransactionMandatoryFlag", this.legalTransactionMandatoryFlag);
        this.legalTransactionMandatoryFlag = legalTransactionMandatoryFlag;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @param legalTransactionUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionUUID( @Nullable final UUID legalTransactionUUID )
    {
        rememberChangedField("LegalTransactionUUID", this.legalTransactionUUID);
        this.legalTransactionUUID = legalTransactionUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionIsTriggerObj</b>
     * </p>
     *
     * @param legalTransactionIsTriggerObj
     *            Denotes if linked object is trigger object
     */
    public void setLegalTransactionIsTriggerObj( @Nullable final Boolean legalTransactionIsTriggerObj )
    {
        rememberChangedField("LegalTransactionIsTriggerObj", this.legalTransactionIsTriggerObj);
        this.legalTransactionIsTriggerObj = legalTransactionIsTriggerObj;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIntegrationLink</b>
     * </p>
     *
     * @param lglCntntMIntegrationLink
     *            Integration Link
     */
    public void setLglCntntMIntegrationLink( @Nullable final String lglCntntMIntegrationLink )
    {
        rememberChangedField("LglCntntMIntegrationLink", this.lglCntntMIntegrationLink);
        this.lglCntntMIntegrationLink = lglCntntMIntegrationLink;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LglTransLinkedObjects";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LegalTransactionLinkdObjUUID", getLegalTransactionLinkdObjUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LegalTransactionLinkdObjUUID", getLegalTransactionLinkdObjUUID());
        values.put("LglCntntMLinkdObjType", getLglCntntMLinkdObjType());
        values.put("LglCntntMLinkdObj", getLglCntntMLinkdObj());
        values.put("LegalTransactionMandatoryFlag", getLegalTransactionMandatoryFlag());
        values.put("LegalTransactionUUID", getLegalTransactionUUID());
        values.put("LegalTransactionIsTriggerObj", getLegalTransactionIsTriggerObj());
        values.put("LglCntntMIntegrationLink", getLglCntntMIntegrationLink());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LegalTransactionLinkdObjUUID") ) {
                final Object value = values.remove("LegalTransactionLinkdObjUUID");
                if( (value == null) || (!value.equals(getLegalTransactionLinkdObjUUID())) ) {
                    setLegalTransactionLinkdObjUUID(((UUID) value));
                }
            }
            if( values.containsKey("LglCntntMLinkdObjType") ) {
                final Object value = values.remove("LglCntntMLinkdObjType");
                if( (value == null) || (!value.equals(getLglCntntMLinkdObjType())) ) {
                    setLglCntntMLinkdObjType(((String) value));
                }
            }
            if( values.containsKey("LglCntntMLinkdObj") ) {
                final Object value = values.remove("LglCntntMLinkdObj");
                if( (value == null) || (!value.equals(getLglCntntMLinkdObj())) ) {
                    setLglCntntMLinkdObj(((String) value));
                }
            }
            if( values.containsKey("LegalTransactionMandatoryFlag") ) {
                final Object value = values.remove("LegalTransactionMandatoryFlag");
                if( (value == null) || (!value.equals(getLegalTransactionMandatoryFlag())) ) {
                    setLegalTransactionMandatoryFlag(((String) value));
                }
            }
            if( values.containsKey("LegalTransactionUUID") ) {
                final Object value = values.remove("LegalTransactionUUID");
                if( (value == null) || (!value.equals(getLegalTransactionUUID())) ) {
                    setLegalTransactionUUID(((UUID) value));
                }
            }
            if( values.containsKey("LegalTransactionIsTriggerObj") ) {
                final Object value = values.remove("LegalTransactionIsTriggerObj");
                if( (value == null) || (!value.equals(getLegalTransactionIsTriggerObj())) ) {
                    setLegalTransactionIsTriggerObj(((Boolean) value));
                }
            }
            if( values.containsKey("LglCntntMIntegrationLink") ) {
                final Object value = values.remove("LglCntntMIntegrationLink");
                if( (value == null) || (!value.equals(getLglCntntMIntegrationLink())) ) {
                    setLglCntntMIntegrationLink(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LglTransLinkedObjectsField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LglTransLinkedObjectsField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LglTransLinkedObjectsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LglTransLinkedObjectsField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService.DEFAULT_SERVICE_PATH);
    }

}
