/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.field.LglTransParentCategoryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.link.LglTransParentCategoryLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.link.LglTransParentCategoryOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable.LglTransParentCategorySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Parent Categories
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LglTransParentCategoryType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LglTransParentCategory extends VdmEntity<LglTransParentCategory>
{

    /**
     * Selector for all available fields of LglTransParentCategory.
     *
     */
    public final static LglTransParentCategorySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionParCatUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @Key
    @SerializedName( "LegalTransactionParCatUUID" )
    @JsonProperty( "LegalTransactionParCatUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionParCatUUID" )
    private UUID legalTransactionParCatUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionParCatUUID</b> field to query operations.
     *
     */
    public final static LglTransParentCategoryField<UUID> LEGAL_TRANSACTION_PAR_CAT_UUID =
        new LglTransParentCategoryField<UUID>("LegalTransactionParCatUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionCatGroupUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @SerializedName( "LegalTransactionCatGroupUUID" )
    @JsonProperty( "LegalTransactionCatGroupUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionCatGroupUUID" )
    private UUID legalTransactionCatGroupUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionCatGroupUUID</b> field to query operations.
     *
     */
    public final static LglTransParentCategoryField<UUID> LEGAL_TRANSACTION_CAT_GROUP_UUID =
        new LglTransParentCategoryField<UUID>("LegalTransactionCatGroupUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @SerializedName( "LegalTransactionUUID" )
    @JsonProperty( "LegalTransactionUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionUUID" )
    private UUID legalTransactionUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionUUID</b> field to query operations.
     *
     */
    public final static LglTransParentCategoryField<UUID> LEGAL_TRANSACTION_UUID =
        new LglTransParentCategoryField<UUID>("LegalTransactionUUID");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMParentCategory</b>
     * </p>
     *
     * @return Parent Category ID
     */
    @SerializedName( "LglCntntMParentCategory" )
    @JsonProperty( "LglCntntMParentCategory" )
    @Nullable
    @ODataField( odataName = "LglCntntMParentCategory" )
    private String lglCntntMParentCategory;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMParentCategory</b> field to query operations.
     *
     */
    public final static LglTransParentCategoryField<String> LGL_CNTNT_M_PARENT_CATEGORY =
        new LglTransParentCategoryField<String>("LglCntntMParentCategory");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIsMandatory</b>
     * </p>
     *
     * @return Mandatory
     */
    @SerializedName( "LglCntntMIsMandatory" )
    @JsonProperty( "LglCntntMIsMandatory" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "LglCntntMIsMandatory" )
    private Boolean lglCntntMIsMandatory;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMIsMandatory</b> field to query operations.
     *
     */
    public final static LglTransParentCategoryField<Boolean> LGL_CNTNT_M_IS_MANDATORY =
        new LglTransParentCategoryField<Boolean>("LglCntntMIsMandatory");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIndex</b>
     * </p>
     *
     * @return Index
     */
    @SerializedName( "LglCntntMIndex" )
    @JsonProperty( "LglCntntMIndex" )
    @Nullable
    @ODataField( odataName = "LglCntntMIndex" )
    private Short lglCntntMIndex;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMIndex</b> field to query operations.
     *
     */
    public final static LglTransParentCategoryField<Short> LGL_CNTNT_M_INDEX =
        new LglTransParentCategoryField<Short>("LglCntntMIndex");
    /**
     * Navigation property <b>to_LglTransCategoryGroup</b> for <b>LglTransParentCategory</b> to single
     * <b>LglTransCategoryGroup</b>.
     *
     */
    @SerializedName( "to_LglTransCategoryGroup" )
    @JsonProperty( "to_LglTransCategoryGroup" )
    @ODataField( odataName = "to_LglTransCategoryGroup" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private LglTransCategoryGroup toLglTransCategoryGroup;
    /**
     * Navigation property <b>to_LglTransCategory</b> for <b>LglTransParentCategory</b> to multiple
     * <b>LglTransCategory</b>.
     *
     */
    @SerializedName( "to_LglTransCategory" )
    @JsonProperty( "to_LglTransCategory" )
    @ODataField( odataName = "to_LglTransCategory" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LglTransCategory> toLglTransCategory;
    /**
     * Use with available fluent helpers to apply the <b>to_LglTransCategoryGroup</b> navigation property to query
     * operations.
     *
     */
    public final static LglTransParentCategoryOneToOneLink<LglTransCategoryGroup> TO_LGL_TRANS_CATEGORY_GROUP =
        new LglTransParentCategoryOneToOneLink<LglTransCategoryGroup>("to_LglTransCategoryGroup");
    /**
     * Use with available fluent helpers to apply the <b>to_LglTransCategory</b> navigation property to query
     * operations.
     *
     */
    public final static LglTransParentCategoryLink<LglTransCategory> TO_LGL_TRANS_CATEGORY =
        new LglTransParentCategoryLink<LglTransCategory>("to_LglTransCategory");

    @Nonnull
    @Override
    public Class<LglTransParentCategory> getType()
    {
        return LglTransParentCategory.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionParCatUUID</b>
     * </p>
     *
     * @param legalTransactionParCatUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionParCatUUID( @Nullable final UUID legalTransactionParCatUUID )
    {
        rememberChangedField("LegalTransactionParCatUUID", this.legalTransactionParCatUUID);
        this.legalTransactionParCatUUID = legalTransactionParCatUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionCatGroupUUID</b>
     * </p>
     *
     * @param legalTransactionCatGroupUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionCatGroupUUID( @Nullable final UUID legalTransactionCatGroupUUID )
    {
        rememberChangedField("LegalTransactionCatGroupUUID", this.legalTransactionCatGroupUUID);
        this.legalTransactionCatGroupUUID = legalTransactionCatGroupUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @param legalTransactionUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionUUID( @Nullable final UUID legalTransactionUUID )
    {
        rememberChangedField("LegalTransactionUUID", this.legalTransactionUUID);
        this.legalTransactionUUID = legalTransactionUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMParentCategory</b>
     * </p>
     *
     * @param lglCntntMParentCategory
     *            Parent Category ID
     */
    public void setLglCntntMParentCategory( @Nullable final String lglCntntMParentCategory )
    {
        rememberChangedField("LglCntntMParentCategory", this.lglCntntMParentCategory);
        this.lglCntntMParentCategory = lglCntntMParentCategory;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIsMandatory</b>
     * </p>
     *
     * @param lglCntntMIsMandatory
     *            Mandatory
     */
    public void setLglCntntMIsMandatory( @Nullable final Boolean lglCntntMIsMandatory )
    {
        rememberChangedField("LglCntntMIsMandatory", this.lglCntntMIsMandatory);
        this.lglCntntMIsMandatory = lglCntntMIsMandatory;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMIndex</b>
     * </p>
     *
     * @param lglCntntMIndex
     *            Index
     */
    public void setLglCntntMIndex( @Nullable final Short lglCntntMIndex )
    {
        rememberChangedField("LglCntntMIndex", this.lglCntntMIndex);
        this.lglCntntMIndex = lglCntntMIndex;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LglTransParentCategory";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LegalTransactionParCatUUID", getLegalTransactionParCatUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LegalTransactionParCatUUID", getLegalTransactionParCatUUID());
        values.put("LegalTransactionCatGroupUUID", getLegalTransactionCatGroupUUID());
        values.put("LegalTransactionUUID", getLegalTransactionUUID());
        values.put("LglCntntMParentCategory", getLglCntntMParentCategory());
        values.put("LglCntntMIsMandatory", getLglCntntMIsMandatory());
        values.put("LglCntntMIndex", getLglCntntMIndex());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LegalTransactionParCatUUID") ) {
                final Object value = values.remove("LegalTransactionParCatUUID");
                if( (value == null) || (!value.equals(getLegalTransactionParCatUUID())) ) {
                    setLegalTransactionParCatUUID(((UUID) value));
                }
            }
            if( values.containsKey("LegalTransactionCatGroupUUID") ) {
                final Object value = values.remove("LegalTransactionCatGroupUUID");
                if( (value == null) || (!value.equals(getLegalTransactionCatGroupUUID())) ) {
                    setLegalTransactionCatGroupUUID(((UUID) value));
                }
            }
            if( values.containsKey("LegalTransactionUUID") ) {
                final Object value = values.remove("LegalTransactionUUID");
                if( (value == null) || (!value.equals(getLegalTransactionUUID())) ) {
                    setLegalTransactionUUID(((UUID) value));
                }
            }
            if( values.containsKey("LglCntntMParentCategory") ) {
                final Object value = values.remove("LglCntntMParentCategory");
                if( (value == null) || (!value.equals(getLglCntntMParentCategory())) ) {
                    setLglCntntMParentCategory(((String) value));
                }
            }
            if( values.containsKey("LglCntntMIsMandatory") ) {
                final Object value = values.remove("LglCntntMIsMandatory");
                if( (value == null) || (!value.equals(getLglCntntMIsMandatory())) ) {
                    setLglCntntMIsMandatory(((Boolean) value));
                }
            }
            if( values.containsKey("LglCntntMIndex") ) {
                final Object value = values.remove("LglCntntMIndex");
                if( (value == null) || (!value.equals(getLglCntntMIndex())) ) {
                    setLglCntntMIndex(((Short) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_LglTransCategoryGroup") ) {
                final Object value = (values).remove("to_LglTransCategoryGroup");
                if( value instanceof Map ) {
                    if( toLglTransCategoryGroup == null ) {
                        toLglTransCategoryGroup = new LglTransCategoryGroup();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toLglTransCategoryGroup.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_LglTransCategory") ) {
                final Object value = (values).remove("to_LglTransCategory");
                if( value instanceof Iterable ) {
                    if( toLglTransCategory == null ) {
                        toLglTransCategory = Lists.newArrayList();
                    } else {
                        toLglTransCategory = Lists.newArrayList(toLglTransCategory);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LglTransCategory entity;
                        if( toLglTransCategory.size() > i ) {
                            entity = toLglTransCategory.get(i);
                        } else {
                            entity = new LglTransCategory();
                            toLglTransCategory.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LglTransParentCategoryField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LglTransParentCategoryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LglTransParentCategoryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LglTransParentCategoryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toLglTransCategoryGroup != null ) {
            (values).put("to_LglTransCategoryGroup", toLglTransCategoryGroup);
        }
        if( toLglTransCategory != null ) {
            (values).put("to_LglTransCategory", toLglTransCategory);
        }
        return values;
    }

    /**
     * Fetches the <b>LglTransCategoryGroup</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_LglTransCategoryGroup</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>LglTransCategoryGroup</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public LglTransCategoryGroup fetchLglTransCategoryGroup()
    {
        return fetchFieldAsSingle("to_LglTransCategoryGroup", LglTransCategoryGroup.class);
    }

    /**
     * Retrieval of associated <b>LglTransCategoryGroup</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_LglTransCategoryGroup</b>.
     * <p>
     * If the navigation property <b>to_LglTransCategoryGroup</b> of a queried <b>LglTransParentCategory</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LglTransCategoryGroup</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public LglTransCategoryGroup getLglTransCategoryGroupOrFetch()
    {
        if( toLglTransCategoryGroup == null ) {
            toLglTransCategoryGroup = fetchLglTransCategoryGroup();
        }
        return toLglTransCategoryGroup;
    }

    /**
     * Retrieval of associated <b>LglTransCategoryGroup</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_LglTransCategoryGroup</b>.
     * <p>
     * If the navigation property for an entity <b>LglTransParentCategory</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LglTransCategoryGroup</b> is already loaded, the result
     *         will contain the <b>LglTransCategoryGroup</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<LglTransCategoryGroup> getLglTransCategoryGroupIfPresent()
    {
        return Option.of(toLglTransCategoryGroup);
    }

    /**
     * Overwrites the associated <b>LglTransCategoryGroup</b> entity for the loaded navigation property
     * <b>to_LglTransCategoryGroup</b>.
     *
     * @param value
     *            New <b>LglTransCategoryGroup</b> entity.
     */
    public void setLglTransCategoryGroup( final LglTransCategoryGroup value )
    {
        toLglTransCategoryGroup = value;
    }

    /**
     * Fetches the <b>LglTransCategory</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_LglTransCategory</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LglTransCategory</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglTransCategory> fetchLglTransCategory()
    {
        return fetchFieldAsList("to_LglTransCategory", LglTransCategory.class);
    }

    /**
     * Retrieval of associated <b>LglTransCategory</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_LglTransCategory</b>.
     * <p>
     * If the navigation property <b>to_LglTransCategory</b> of a queried <b>LglTransParentCategory</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LglTransCategory</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglTransCategory> getLglTransCategoryOrFetch()
    {
        if( toLglTransCategory == null ) {
            toLglTransCategory = fetchLglTransCategory();
        }
        return toLglTransCategory;
    }

    /**
     * Retrieval of associated <b>LglTransCategory</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_LglTransCategory</b>.
     * <p>
     * If the navigation property for an entity <b>LglTransParentCategory</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LglTransCategory</b> is already loaded, the result will
     *         contain the <b>LglTransCategory</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<LglTransCategory>> getLglTransCategoryIfPresent()
    {
        return Option.of(toLglTransCategory);
    }

    /**
     * Overwrites the list of associated <b>LglTransCategory</b> entities for the loaded navigation property
     * <b>to_LglTransCategory</b>.
     * <p>
     * If the navigation property <b>to_LglTransCategory</b> of a queried <b>LglTransParentCategory</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LglTransCategory</b> entities.
     */
    public void setLglTransCategory( @Nonnull final List<LglTransCategory> value )
    {
        if( toLglTransCategory == null ) {
            toLglTransCategory = Lists.newArrayList();
        }
        toLglTransCategory.clear();
        toLglTransCategory.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LglTransCategory</b> entities. This corresponds to the OData
     * navigation property <b>to_LglTransCategory</b>.
     * <p>
     * If the navigation property <b>to_LglTransCategory</b> of a queried <b>LglTransParentCategory</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LglTransCategory</b> entities.
     */
    public void addLglTransCategory( LglTransCategory... entity )
    {
        if( toLglTransCategory == null ) {
            toLglTransCategory = Lists.newArrayList();
        }
        toLglTransCategory.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of LglTransParentCategory instances.
     *
     */
    public final static class LglTransParentCategoryBuilder
    {

        private LglTransCategoryGroup toLglTransCategoryGroup;
        private List<LglTransCategory> toLglTransCategory = Lists.newArrayList();

        private LglTransParentCategory.LglTransParentCategoryBuilder toLglTransCategoryGroup(
            final LglTransCategoryGroup value )
        {
            toLglTransCategoryGroup = value;
            return this;
        }

        /**
         * Navigation property <b>to_LglTransCategoryGroup</b> for <b>LglTransParentCategory</b> to single
         * <b>LglTransCategoryGroup</b>.
         *
         * @param value
         *            The LglTransCategoryGroup to build this LglTransParentCategory with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LglTransParentCategory.LglTransParentCategoryBuilder lglTransCategoryGroup(
            final LglTransCategoryGroup value )
        {
            return toLglTransCategoryGroup(value);
        }

        private LglTransParentCategory.LglTransParentCategoryBuilder toLglTransCategory(
            final List<LglTransCategory> value )
        {
            toLglTransCategory.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LglTransCategory</b> for <b>LglTransParentCategory</b> to multiple
         * <b>LglTransCategory</b>.
         *
         * @param value
         *            The LglTransCategorys to build this LglTransParentCategory with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LglTransParentCategory.LglTransParentCategoryBuilder lglTransCategory( LglTransCategory... value )
        {
            return toLglTransCategory(Lists.newArrayList(value));
        }

    }

}
