/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.field.LglTransRelationshipField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable.LglTransRelationshipSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Relationships
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LglTransRelationshipType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LglTransRelationship extends VdmEntity<LglTransRelationship>
{

    /**
     * Selector for all available fields of LglTransRelationship.
     *
     */
    public final static LglTransRelationshipSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionRelshpUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @Key
    @SerializedName( "LegalTransactionRelshpUUID" )
    @JsonProperty( "LegalTransactionRelshpUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionRelshpUUID" )
    private UUID legalTransactionRelshpUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionRelshpUUID</b> field to query operations.
     *
     */
    public final static LglTransRelationshipField<UUID> LEGAL_TRANSACTION_RELSHP_UUID =
        new LglTransRelationshipField<UUID>("LegalTransactionRelshpUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMRelshpType</b>
     * </p>
     *
     * @return Relationship Type
     */
    @SerializedName( "LglCntntMRelshpType" )
    @JsonProperty( "LglCntntMRelshpType" )
    @Nullable
    @ODataField( odataName = "LglCntntMRelshpType" )
    private String lglCntntMRelshpType;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMRelshpType</b> field to query operations.
     *
     */
    public final static LglTransRelationshipField<String> LGL_CNTNT_M_RELSHP_TYPE =
        new LglTransRelationshipField<String>("LglCntntMRelshpType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RelshpLegalTransaction</b>
     * </p>
     *
     * @return Legal Transaction ID
     */
    @SerializedName( "RelshpLegalTransaction" )
    @JsonProperty( "RelshpLegalTransaction" )
    @Nullable
    @ODataField( odataName = "RelshpLegalTransaction" )
    private String relshpLegalTransaction;
    /**
     * Use with available fluent helpers to apply the <b>RelshpLegalTransaction</b> field to query operations.
     *
     */
    public final static LglTransRelationshipField<String> RELSHP_LEGAL_TRANSACTION =
        new LglTransRelationshipField<String>("RelshpLegalTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionMandatoryFlag</b>
     * </p>
     *
     * @return Control Parameter Legal Transaction Mandatory State
     */
    @SerializedName( "LegalTransactionMandatoryFlag" )
    @JsonProperty( "LegalTransactionMandatoryFlag" )
    @Nullable
    @ODataField( odataName = "LegalTransactionMandatoryFlag" )
    private String legalTransactionMandatoryFlag;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionMandatoryFlag</b> field to query operations.
     *
     */
    public final static LglTransRelationshipField<String> LEGAL_TRANSACTION_MANDATORY_FLAG =
        new LglTransRelationshipField<String>("LegalTransactionMandatoryFlag");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @SerializedName( "LegalTransactionUUID" )
    @JsonProperty( "LegalTransactionUUID" )
    @Nullable
    @ODataField( odataName = "LegalTransactionUUID" )
    private UUID legalTransactionUUID;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransactionUUID</b> field to query operations.
     *
     */
    public final static LglTransRelationshipField<UUID> LEGAL_TRANSACTION_UUID =
        new LglTransRelationshipField<UUID>("LegalTransactionUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RelshpLegalTransactionUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @SerializedName( "RelshpLegalTransactionUUID" )
    @JsonProperty( "RelshpLegalTransactionUUID" )
    @Nullable
    @ODataField( odataName = "RelshpLegalTransactionUUID" )
    private UUID relshpLegalTransactionUUID;
    /**
     * Use with available fluent helpers to apply the <b>RelshpLegalTransactionUUID</b> field to query operations.
     *
     */
    public final static LglTransRelationshipField<UUID> RELSHP_LEGAL_TRANSACTION_UUID =
        new LglTransRelationshipField<UUID>("RelshpLegalTransactionUUID");

    @Nonnull
    @Override
    public Class<LglTransRelationship> getType()
    {
        return LglTransRelationship.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionRelshpUUID</b>
     * </p>
     *
     * @param legalTransactionRelshpUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionRelshpUUID( @Nullable final UUID legalTransactionRelshpUUID )
    {
        rememberChangedField("LegalTransactionRelshpUUID", this.legalTransactionRelshpUUID);
        this.legalTransactionRelshpUUID = legalTransactionRelshpUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMRelshpType</b>
     * </p>
     *
     * @param lglCntntMRelshpType
     *            Relationship Type
     */
    public void setLglCntntMRelshpType( @Nullable final String lglCntntMRelshpType )
    {
        rememberChangedField("LglCntntMRelshpType", this.lglCntntMRelshpType);
        this.lglCntntMRelshpType = lglCntntMRelshpType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RelshpLegalTransaction</b>
     * </p>
     *
     * @param relshpLegalTransaction
     *            Legal Transaction ID
     */
    public void setRelshpLegalTransaction( @Nullable final String relshpLegalTransaction )
    {
        rememberChangedField("RelshpLegalTransaction", this.relshpLegalTransaction);
        this.relshpLegalTransaction = relshpLegalTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionMandatoryFlag</b>
     * </p>
     *
     * @param legalTransactionMandatoryFlag
     *            Control Parameter Legal Transaction Mandatory State
     */
    public void setLegalTransactionMandatoryFlag( @Nullable final String legalTransactionMandatoryFlag )
    {
        rememberChangedField("LegalTransactionMandatoryFlag", this.legalTransactionMandatoryFlag);
        this.legalTransactionMandatoryFlag = legalTransactionMandatoryFlag;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransactionUUID</b>
     * </p>
     *
     * @param legalTransactionUUID
     *            Universal Unique Identifier
     */
    public void setLegalTransactionUUID( @Nullable final UUID legalTransactionUUID )
    {
        rememberChangedField("LegalTransactionUUID", this.legalTransactionUUID);
        this.legalTransactionUUID = legalTransactionUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RelshpLegalTransactionUUID</b>
     * </p>
     *
     * @param relshpLegalTransactionUUID
     *            Universal Unique Identifier
     */
    public void setRelshpLegalTransactionUUID( @Nullable final UUID relshpLegalTransactionUUID )
    {
        rememberChangedField("RelshpLegalTransactionUUID", this.relshpLegalTransactionUUID);
        this.relshpLegalTransactionUUID = relshpLegalTransactionUUID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LglTransRelationship";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LegalTransactionRelshpUUID", getLegalTransactionRelshpUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LegalTransactionRelshpUUID", getLegalTransactionRelshpUUID());
        values.put("LglCntntMRelshpType", getLglCntntMRelshpType());
        values.put("RelshpLegalTransaction", getRelshpLegalTransaction());
        values.put("LegalTransactionMandatoryFlag", getLegalTransactionMandatoryFlag());
        values.put("LegalTransactionUUID", getLegalTransactionUUID());
        values.put("RelshpLegalTransactionUUID", getRelshpLegalTransactionUUID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LegalTransactionRelshpUUID") ) {
                final Object value = values.remove("LegalTransactionRelshpUUID");
                if( (value == null) || (!value.equals(getLegalTransactionRelshpUUID())) ) {
                    setLegalTransactionRelshpUUID(((UUID) value));
                }
            }
            if( values.containsKey("LglCntntMRelshpType") ) {
                final Object value = values.remove("LglCntntMRelshpType");
                if( (value == null) || (!value.equals(getLglCntntMRelshpType())) ) {
                    setLglCntntMRelshpType(((String) value));
                }
            }
            if( values.containsKey("RelshpLegalTransaction") ) {
                final Object value = values.remove("RelshpLegalTransaction");
                if( (value == null) || (!value.equals(getRelshpLegalTransaction())) ) {
                    setRelshpLegalTransaction(((String) value));
                }
            }
            if( values.containsKey("LegalTransactionMandatoryFlag") ) {
                final Object value = values.remove("LegalTransactionMandatoryFlag");
                if( (value == null) || (!value.equals(getLegalTransactionMandatoryFlag())) ) {
                    setLegalTransactionMandatoryFlag(((String) value));
                }
            }
            if( values.containsKey("LegalTransactionUUID") ) {
                final Object value = values.remove("LegalTransactionUUID");
                if( (value == null) || (!value.equals(getLegalTransactionUUID())) ) {
                    setLegalTransactionUUID(((UUID) value));
                }
            }
            if( values.containsKey("RelshpLegalTransactionUUID") ) {
                final Object value = values.remove("RelshpLegalTransactionUUID");
                if( (value == null) || (!value.equals(getRelshpLegalTransactionUUID())) ) {
                    setRelshpLegalTransactionUUID(((UUID) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LglTransRelationshipField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LglTransRelationshipField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LglTransRelationshipField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LglTransRelationshipField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService.DEFAULT_SERVICE_PATH);
    }

}
