/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable.LglTransRelationshipSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
 * LglTransRelationship} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class LglTransRelationshipByKeyFluentHelper
    extends
    FluentHelperByKey<LglTransRelationshipByKeyFluentHelper, LglTransRelationship, LglTransRelationshipSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     * LglTransRelationship} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code LglTransRelationship}
     * @param legalTransactionRelshpUUID
     *            Universal Unique Identifier
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code LglTransRelationship}
     */
    public LglTransRelationshipByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID legalTransactionRelshpUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("LegalTransactionRelshpUUID", legalTransactionRelshpUUID);
    }

    @Override
    @Nonnull
    protected Class<LglTransRelationship> getEntityClass()
    {
        return LglTransRelationship.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
