/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link LegalTransactionServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService LegalTransactionService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultLegalTransactionServiceBatch
    extends
    BatchFluentHelperBasic<LegalTransactionServiceBatch, LegalTransactionServiceBatchChangeSet>
    implements
    LegalTransactionServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultLegalTransactionServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultLegalTransactionServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultLegalTransactionServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultLegalTransactionServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultLegalTransactionServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultLegalTransactionServiceBatchChangeSet(this, service);
    }

}
