/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship;

/**
 * Implementation of the {@link LegalTransactionServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService LegalTransactionService}.
 *
 */
public class DefaultLegalTransactionServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<LegalTransactionServiceBatch, LegalTransactionServiceBatchChangeSet>
    implements
    LegalTransactionServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService service;

    @SuppressWarnings( "deprecation" )
    DefaultLegalTransactionServiceBatchChangeSet(
        @Nonnull final DefaultLegalTransactionServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultLegalTransactionServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet createLegalTransaction(
        @Nonnull final LegalTransaction legalTransaction )
    {
        return addRequestCreate(service::createLegalTransaction, legalTransaction);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet updateLegalTransaction(
        @Nonnull final LegalTransaction legalTransaction )
    {
        return addRequestUpdate(service::updateLegalTransaction, legalTransaction);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet createLglTransDate( @Nonnull final LglTransDate lglTransDate )
    {
        return addRequestCreate(service::createLglTransDate, lglTransDate);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet updateLglTransDate( @Nonnull final LglTransDate lglTransDate )
    {
        return addRequestUpdate(service::updateLglTransDate, lglTransDate);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet deleteLglTransDate( @Nonnull final LglTransDate lglTransDate )
    {
        return addRequestDelete(service::deleteLglTransDate, lglTransDate);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet createLglTransEntity( @Nonnull final LglTransEntity lglTransEntity )
    {
        return addRequestCreate(service::createLglTransEntity, lglTransEntity);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet updateLglTransEntity( @Nonnull final LglTransEntity lglTransEntity )
    {
        return addRequestUpdate(service::updateLglTransEntity, lglTransEntity);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet deleteLglTransEntity( @Nonnull final LglTransEntity lglTransEntity )
    {
        return addRequestDelete(service::deleteLglTransEntity, lglTransEntity);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet createLglTransExternalContact(
        @Nonnull final LglTransExternalContact lglTransExternalContact )
    {
        return addRequestCreate(service::createLglTransExternalContact, lglTransExternalContact);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet updateLglTransExternalContact(
        @Nonnull final LglTransExternalContact lglTransExternalContact )
    {
        return addRequestUpdate(service::updateLglTransExternalContact, lglTransExternalContact);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet deleteLglTransExternalContact(
        @Nonnull final LglTransExternalContact lglTransExternalContact )
    {
        return addRequestDelete(service::deleteLglTransExternalContact, lglTransExternalContact);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet createLglTransInternalContact(
        @Nonnull final LglTransInternalContact lglTransInternalContact )
    {
        return addRequestCreate(service::createLglTransInternalContact, lglTransInternalContact);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet updateLglTransInternalContact(
        @Nonnull final LglTransInternalContact lglTransInternalContact )
    {
        return addRequestUpdate(service::updateLglTransInternalContact, lglTransInternalContact);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet deleteLglTransInternalContact(
        @Nonnull final LglTransInternalContact lglTransInternalContact )
    {
        return addRequestDelete(service::deleteLglTransInternalContact, lglTransInternalContact);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet createLglTransLinkedObjects(
        @Nonnull final LglTransLinkedObjects lglTransLinkedObjects )
    {
        return addRequestCreate(service::createLglTransLinkedObjects, lglTransLinkedObjects);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet updateLglTransLinkedObjects(
        @Nonnull final LglTransLinkedObjects lglTransLinkedObjects )
    {
        return addRequestUpdate(service::updateLglTransLinkedObjects, lglTransLinkedObjects);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet deleteLglTransLinkedObjects(
        @Nonnull final LglTransLinkedObjects lglTransLinkedObjects )
    {
        return addRequestDelete(service::deleteLglTransLinkedObjects, lglTransLinkedObjects);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet createLglTransRelationship(
        @Nonnull final LglTransRelationship lglTransRelationship )
    {
        return addRequestCreate(service::createLglTransRelationship, lglTransRelationship);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet updateLglTransRelationship(
        @Nonnull final LglTransRelationship lglTransRelationship )
    {
        return addRequestUpdate(service::updateLglTransRelationship, lglTransRelationship);
    }

    @Nonnull
    @Override
    public LegalTransactionServiceBatchChangeSet deleteLglTransRelationship(
        @Nonnull final LglTransRelationship lglTransRelationship )
    {
        return addRequestDelete(service::deleteLglTransRelationship, lglTransRelationship);
    }

}
