/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalTransactionService LegalTransactionService}.
 *
 */
public interface LegalTransactionServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<LegalTransactionServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<LegalTransactionServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction
     * LegalTransaction} entity and save it to the S/4HANA system.
     *
     * @param legalTransaction
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction
     *            LegalTransaction} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet createLegalTransaction( @Nonnull final LegalTransaction legalTransaction );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction
     * LegalTransaction} entity and save it to the S/4HANA system.
     *
     * @param legalTransaction
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction
     *            LegalTransaction} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet updateLegalTransaction( @Nonnull final LegalTransaction legalTransaction );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate
     * LglTransDate} entity and save it to the S/4HANA system.
     *
     * @param lglTransDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate LglTransDate}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet createLglTransDate( @Nonnull final LglTransDate lglTransDate );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate
     * LglTransDate} entity and save it to the S/4HANA system.
     *
     * @param lglTransDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate LglTransDate}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet updateLglTransDate( @Nonnull final LglTransDate lglTransDate );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate
     * LglTransDate} entity in the S/4HANA system.
     *
     * @param lglTransDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransDate LglTransDate}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet deleteLglTransDate( @Nonnull final LglTransDate lglTransDate );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     * LglTransEntity} entity and save it to the S/4HANA system.
     *
     * @param lglTransEntity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     *            LglTransEntity} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet createLglTransEntity( @Nonnull final LglTransEntity lglTransEntity );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     * LglTransEntity} entity and save it to the S/4HANA system.
     *
     * @param lglTransEntity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     *            LglTransEntity} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet updateLglTransEntity( @Nonnull final LglTransEntity lglTransEntity );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     * LglTransEntity} entity in the S/4HANA system.
     *
     * @param lglTransEntity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity
     *            LglTransEntity} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet deleteLglTransEntity( @Nonnull final LglTransEntity lglTransEntity );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     * LglTransExternalContact} entity and save it to the S/4HANA system.
     *
     * @param lglTransExternalContact
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     *            LglTransExternalContact} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet
        createLglTransExternalContact( @Nonnull final LglTransExternalContact lglTransExternalContact );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     * LglTransExternalContact} entity and save it to the S/4HANA system.
     *
     * @param lglTransExternalContact
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     *            LglTransExternalContact} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet
        updateLglTransExternalContact( @Nonnull final LglTransExternalContact lglTransExternalContact );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     * LglTransExternalContact} entity in the S/4HANA system.
     *
     * @param lglTransExternalContact
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
     *            LglTransExternalContact} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet
        deleteLglTransExternalContact( @Nonnull final LglTransExternalContact lglTransExternalContact );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     * LglTransInternalContact} entity and save it to the S/4HANA system.
     *
     * @param lglTransInternalContact
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     *            LglTransInternalContact} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet
        createLglTransInternalContact( @Nonnull final LglTransInternalContact lglTransInternalContact );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     * LglTransInternalContact} entity and save it to the S/4HANA system.
     *
     * @param lglTransInternalContact
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     *            LglTransInternalContact} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet
        updateLglTransInternalContact( @Nonnull final LglTransInternalContact lglTransInternalContact );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     * LglTransInternalContact} entity in the S/4HANA system.
     *
     * @param lglTransInternalContact
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
     *            LglTransInternalContact} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet
        deleteLglTransInternalContact( @Nonnull final LglTransInternalContact lglTransInternalContact );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     * LglTransLinkedObjects} entity and save it to the S/4HANA system.
     *
     * @param lglTransLinkedObjects
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     *            LglTransLinkedObjects} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet
        createLglTransLinkedObjects( @Nonnull final LglTransLinkedObjects lglTransLinkedObjects );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     * LglTransLinkedObjects} entity and save it to the S/4HANA system.
     *
     * @param lglTransLinkedObjects
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     *            LglTransLinkedObjects} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet
        updateLglTransLinkedObjects( @Nonnull final LglTransLinkedObjects lglTransLinkedObjects );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     * LglTransLinkedObjects} entity in the S/4HANA system.
     *
     * @param lglTransLinkedObjects
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
     *            LglTransLinkedObjects} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet
        deleteLglTransLinkedObjects( @Nonnull final LglTransLinkedObjects lglTransLinkedObjects );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     * LglTransRelationship} entity and save it to the S/4HANA system.
     *
     * @param lglTransRelationship
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     *            LglTransRelationship} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet
        createLglTransRelationship( @Nonnull final LglTransRelationship lglTransRelationship );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     * LglTransRelationship} entity and save it to the S/4HANA system.
     *
     * @param lglTransRelationship
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     *            LglTransRelationship} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet
        updateLglTransRelationship( @Nonnull final LglTransRelationship lglTransRelationship );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     * LglTransRelationship} entity in the S/4HANA system.
     *
     * @param lglTransRelationship
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
     *            LglTransRelationship} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalTransactionServiceBatchChangeSet
        deleteLglTransRelationship( @Nonnull final LglTransRelationship lglTransRelationship );

}
