/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction LegalTransaction}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.field.LegalTransactionField
 * LegalTransactionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.link.LegalTransactionLink
 * LegalTransactionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#LEGAL_TRANSACTION_UUID
 * LEGAL_TRANSACTION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#LEGAL_TRANSACTION
 * LEGAL_TRANSACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#LEGAL_TRANSACTION_TITLE
 * LEGAL_TRANSACTION_TITLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#LGL_CNTNT_M_CONTEXT
 * LGL_CNTNT_M_CONTEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#LGL_CNTNT_M_CONTEXT_UUID
 * LGL_CNTNT_M_CONTEXT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#LGL_CNTNT_M_LANGUAGE
 * LGL_CNTNT_M_LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#LGL_CNTNT_M_CHANGED_BY_USER
 * LGL_CNTNT_M_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#LGL_CNTNT_M_CHANGED_UTC_DATE_TIME
 * LGL_CNTNT_M_CHANGED_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#LGL_CNTNT_M_CREATED_BY_USER
 * LGL_CNTNT_M_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#LGL_CNTNT_M_CREATED_UTC_DATE_TIME
 * LGL_CNTNT_M_CREATED_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#LEGAL_TRANSACTION_HEALTH
 * LEGAL_TRANSACTION_HEALTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#LGL_CNTNT_M_PROFILE
 * LGL_CNTNT_M_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#LEGAL_TRANSACTION_SOURCE
 * LEGAL_TRANSACTION_SOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#IS_END_OF_PURPOSE_BLOCKED
 * IS_END_OF_PURPOSE_BLOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#LGL_CNTNT_M_GOV_LAW
 * LGL_CNTNT_M_GOV_LAW}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#LGL_TRANS_ACCESS_LVL
 * LGL_TRANS_ACCESS_LVL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#LGL_CNTNT_M_MAIN_ORG_CO_CODE
 * LGL_CNTNT_M_MAIN_ORG_CO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#LGL_CNTNT_M_MAIN_ORG_SALES_ORG
 * LGL_CNTNT_M_MAIN_ORG_SALES_ORG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#LGL_CNTNT_M_MAIN_ORG_PUR_ORG
 * LGL_CNTNT_M_MAIN_ORG_PUR_ORG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#TO_LGL_TRANS_CATEGORY_GROUP
 * TO_LGL_TRANS_CATEGORY_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#TO_LGL_TRANS_DATE
 * TO_LGL_TRANS_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#TO_LGL_TRANS_ENTITY
 * TO_LGL_TRANS_ENTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#TO_LGL_TRANS_EXTERNAL_CONTACT
 * TO_LGL_TRANS_EXTERNAL_CONTACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#TO_LGL_TRANS_INTERNAL_CONTACT
 * TO_LGL_TRANS_INTERNAL_CONTACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#TO_LGL_TRANS_LINKED_OBJECTS
 * TO_LGL_TRANS_LINKED_OBJECTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LegalTransaction#TO_LGL_TRANS_RELATIONSHIP
 * TO_LGL_TRANS_RELATIONSHIP}</li>
 * </ul>
 *
 */
public interface LegalTransactionSelectable extends EntitySelectable<LegalTransaction>
{

}
