/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroup;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroup
 * LglTransCategoryGroup}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.field.LglTransCategoryGroupField
 * LglTransCategoryGroupField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.link.LglTransCategoryGroupLink
 * LglTransCategoryGroupLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroup#LEGAL_TRANSACTION_CAT_GROUP_UUID
 * LEGAL_TRANSACTION_CAT_GROUP_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroup#LEGAL_TRANSACTION_UUID
 * LEGAL_TRANSACTION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroup#LGL_CNTNT_M_CAT_GROUP_TITLE
 * LGL_CNTNT_M_CAT_GROUP_TITLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroup#LGL_CNTNT_M_INDEX
 * LGL_CNTNT_M_INDEX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransCategoryGroup#TO_LGL_TRANS_PARENT_CATEGORY
 * TO_LGL_TRANS_PARENT_CATEGORY}</li>
 * </ul>
 *
 */
public interface LglTransCategoryGroupSelectable extends EntitySelectable<LglTransCategoryGroup>
{

}
