/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity LglTransEntity}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.field.LglTransEntityField
 * LglTransEntityField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.link.LglTransEntityLink
 * LglTransEntityLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity#LEGAL_TRANSACTION_ENTITY_UUID
 * LEGAL_TRANSACTION_ENTITY_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity#LGL_CNTNT_M_RANK
 * LGL_CNTNT_M_RANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity#LGL_CNTNT_M_ENTITY_TYPE
 * LGL_CNTNT_M_ENTITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity#LGL_CNTNT_M_ENTITY
 * LGL_CNTNT_M_ENTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity#LEGAL_TRANSACTION_UUID
 * LEGAL_TRANSACTION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity#LEGAL_TRANSACTION_MANDATORY_FLAG
 * LEGAL_TRANSACTION_MANDATORY_FLAG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransEntity#LGL_CNTNT_M_IS_MAIN_ENTITY
 * LGL_CNTNT_M_IS_MAIN_ENTITY}</li>
 * </ul>
 *
 */
public interface LglTransEntitySelectable extends EntitySelectable<LglTransEntity>
{

}
