/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact
 * LglTransExternalContact}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.field.LglTransExternalContactField
 * LglTransExternalContactField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.link.LglTransExternalContactLink
 * LglTransExternalContactLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact#LEGAL_TRANSACTION_EXT_CNTCT_UUID
 * LEGAL_TRANSACTION_EXT_CNTCT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact#LGL_CNTNT_M_RANK
 * LGL_CNTNT_M_RANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact#LGL_CNTNT_M_EXT_CNTCT_TYPE
 * LGL_CNTNT_M_EXT_CNTCT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact#LGL_CNTNT_M_EXT_CNTCT_BP
 * LGL_CNTNT_M_EXT_CNTCT_BP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact#LEGAL_TRANSACTION_MANDATORY_FLAG
 * LEGAL_TRANSACTION_MANDATORY_FLAG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransExternalContact#LEGAL_TRANSACTION_UUID
 * LEGAL_TRANSACTION_UUID}</li>
 * </ul>
 *
 */
public interface LglTransExternalContactSelectable extends EntitySelectable<LglTransExternalContact>
{

}
