/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact
 * LglTransInternalContact}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.field.LglTransInternalContactField
 * LglTransInternalContactField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.link.LglTransInternalContactLink
 * LglTransInternalContactLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact#LEGAL_TRANSACTION_INT_CNTCT_UUID
 * LEGAL_TRANSACTION_INT_CNTCT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact#LGL_CNTNT_M_RANK
 * LGL_CNTNT_M_RANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact#LGL_CNTNT_M_INT_CNTCT_TYPE
 * LGL_CNTNT_M_INT_CNTCT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact#LGL_CNTNT_M_INT_CONTACT_USER_TYPE
 * LGL_CNTNT_M_INT_CONTACT_USER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact#LGL_CNTNT_M_INT_CNTCT_USER
 * LGL_CNTNT_M_INT_CNTCT_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact#LGL_CNTNT_M_INT_CONTACT_TEAM
 * LGL_CNTNT_M_INT_CONTACT_TEAM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact#LEGAL_TRANSACTION_MANDATORY_FLAG
 * LEGAL_TRANSACTION_MANDATORY_FLAG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransInternalContact#LEGAL_TRANSACTION_UUID
 * LEGAL_TRANSACTION_UUID}</li>
 * </ul>
 *
 */
public interface LglTransInternalContactSelectable extends EntitySelectable<LglTransInternalContact>
{

}
