/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects
 * LglTransLinkedObjects}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.field.LglTransLinkedObjectsField
 * LglTransLinkedObjectsField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.link.LglTransLinkedObjectsLink
 * LglTransLinkedObjectsLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects#LEGAL_TRANSACTION_LINKD_OBJ_UUID
 * LEGAL_TRANSACTION_LINKD_OBJ_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects#LGL_CNTNT_M_LINKD_OBJ_TYPE
 * LGL_CNTNT_M_LINKD_OBJ_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects#LGL_CNTNT_M_LINKD_OBJ
 * LGL_CNTNT_M_LINKD_OBJ}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects#LEGAL_TRANSACTION_MANDATORY_FLAG
 * LEGAL_TRANSACTION_MANDATORY_FLAG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects#LEGAL_TRANSACTION_UUID
 * LEGAL_TRANSACTION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects#LEGAL_TRANSACTION_IS_TRIGGER_OBJ
 * LEGAL_TRANSACTION_IS_TRIGGER_OBJ}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransLinkedObjects#LGL_CNTNT_M_INTEGRATION_LINK
 * LGL_CNTNT_M_INTEGRATION_LINK}</li>
 * </ul>
 *
 */
public interface LglTransLinkedObjectsSelectable extends EntitySelectable<LglTransLinkedObjects>
{

}
