/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategory;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategory
 * LglTransParentCategory}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.field.LglTransParentCategoryField
 * LglTransParentCategoryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.link.LglTransParentCategoryLink
 * LglTransParentCategoryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategory#LEGAL_TRANSACTION_PAR_CAT_UUID
 * LEGAL_TRANSACTION_PAR_CAT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategory#LEGAL_TRANSACTION_CAT_GROUP_UUID
 * LEGAL_TRANSACTION_CAT_GROUP_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategory#LEGAL_TRANSACTION_UUID
 * LEGAL_TRANSACTION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategory#LGL_CNTNT_M_PARENT_CATEGORY
 * LGL_CNTNT_M_PARENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategory#LGL_CNTNT_M_IS_MANDATORY
 * LGL_CNTNT_M_IS_MANDATORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategory#LGL_CNTNT_M_INDEX
 * LGL_CNTNT_M_INDEX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategory#TO_LGL_TRANS_CATEGORY_GROUP
 * TO_LGL_TRANS_CATEGORY_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransParentCategory#TO_LGL_TRANS_CATEGORY
 * TO_LGL_TRANS_CATEGORY}</li>
 * </ul>
 *
 */
public interface LglTransParentCategorySelectable extends EntitySelectable<LglTransParentCategory>
{

}
