/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship
 * LglTransRelationship}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.field.LglTransRelationshipField
 * LglTransRelationshipField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.link.LglTransRelationshipLink
 * LglTransRelationshipLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship#LEGAL_TRANSACTION_RELSHP_UUID
 * LEGAL_TRANSACTION_RELSHP_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship#LGL_CNTNT_M_RELSHP_TYPE
 * LGL_CNTNT_M_RELSHP_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship#RELSHP_LEGAL_TRANSACTION
 * RELSHP_LEGAL_TRANSACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship#LEGAL_TRANSACTION_MANDATORY_FLAG
 * LEGAL_TRANSACTION_MANDATORY_FLAG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship#LEGAL_TRANSACTION_UUID
 * LEGAL_TRANSACTION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaltransaction.LglTransRelationship#RELSHP_LEGAL_TRANSACTION_UUID
 * RELSHP_LEGAL_TRANSACTION_UUID}</li>
 * </ul>
 *
 */
public interface LglTransRelationshipSelectable extends EntitySelectable<LglTransRelationship>
{

}
