/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.field.TrsyPostgJrnlEntrItmField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.selectable.TrsyPostgJrnlEntrItmSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Treasury Posting Journal Entry
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_TrsyPostgJrnlEntrItmType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class TrsyPostgJrnlEntrItm extends VdmEntity<TrsyPostgJrnlEntrItm>
{

    /**
     * Selector for all available fields of TrsyPostgJrnlEntrItm.
     *
     */
    public final static TrsyPostgJrnlEntrItmSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>TrsyAccountingDocumentUUID</b>
     * </p>
     *
     * @return Object Identity in Database Format
     */
    @Key
    @SerializedName( "TrsyAccountingDocumentUUID" )
    @JsonProperty( "TrsyAccountingDocumentUUID" )
    @Nullable
    @ODataField( odataName = "TrsyAccountingDocumentUUID" )
    private UUID trsyAccountingDocumentUUID;
    /**
     * Use with available fluent helpers to apply the <b>TrsyAccountingDocumentUUID</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<UUID> TRSY_ACCOUNTING_DOCUMENT_UUID =
        new TrsyPostgJrnlEntrItmField<UUID>("TrsyAccountingDocumentUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentItemRef</b>
     * </p>
     *
     * @return Accounting Document Line Item Number
     */
    @Key
    @SerializedName( "AccountingDocumentItemRef" )
    @JsonProperty( "AccountingDocumentItemRef" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentItemRef" )
    private String accountingDocumentItemRef;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentItemRef</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> ACCOUNTING_DOCUMENT_ITEM_REF =
        new TrsyPostgJrnlEntrItmField<String>("AccountingDocumentItemRef");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPositionContextUUID</b>
     * </p>
     *
     * @return Object Identity in Database Format
     */
    @Key
    @SerializedName( "TrsyPositionContextUUID" )
    @JsonProperty( "TrsyPositionContextUUID" )
    @Nullable
    @ODataField( odataName = "TrsyPositionContextUUID" )
    private UUID trsyPositionContextUUID;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPositionContextUUID</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<UUID> TRSY_POSITION_CONTEXT_UUID =
        new TrsyPostgJrnlEntrItmField<UUID>("TrsyPositionContextUUID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryBusinessTransStatus</b>
     * </p>
     *
     * @return Posting Status
     */
    @SerializedName( "TreasuryBusinessTransStatus" )
    @JsonProperty( "TreasuryBusinessTransStatus" )
    @Nullable
    @ODataField( odataName = "TreasuryBusinessTransStatus" )
    private String treasuryBusinessTransStatus;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryBusinessTransStatus</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_BUSINESS_TRANS_STATUS =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryBusinessTransStatus");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryBusTransStatusName</b>
     * </p>
     *
     * @return Name of the Posting Status
     */
    @SerializedName( "TreasuryBusTransStatusName" )
    @JsonProperty( "TreasuryBusTransStatusName" )
    @Nullable
    @ODataField( odataName = "TreasuryBusTransStatusName" )
    private String treasuryBusTransStatusName;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryBusTransStatusName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_BUS_TRANS_STATUS_NAME =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryBusTransStatusName");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryUpdateType</b>
     * </p>
     *
     * @return Update Type
     */
    @SerializedName( "TreasuryUpdateType" )
    @JsonProperty( "TreasuryUpdateType" )
    @Nullable
    @ODataField( odataName = "TreasuryUpdateType" )
    private String treasuryUpdateType;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryUpdateType</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_UPDATE_TYPE =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryUpdateType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryUpdateTypeName</b>
     * </p>
     *
     * @return Name of the Update Type
     */
    @SerializedName( "TreasuryUpdateTypeName" )
    @JsonProperty( "TreasuryUpdateTypeName" )
    @Nullable
    @ODataField( odataName = "TreasuryUpdateTypeName" )
    private String treasuryUpdateTypeName;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryUpdateTypeName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_UPDATE_TYPE_NAME =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryUpdateTypeName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsUsedInPaymentTransaction</b>
     * </p>
     *
     * @return Payment Transaction
     */
    @SerializedName( "IsUsedInPaymentTransaction" )
    @JsonProperty( "IsUsedInPaymentTransaction" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsUsedInPaymentTransaction" )
    private Boolean isUsedInPaymentTransaction;
    /**
     * Use with available fluent helpers to apply the <b>IsUsedInPaymentTransaction</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<Boolean> IS_USED_IN_PAYMENT_TRANSACTION =
        new TrsyPostgJrnlEntrItmField<Boolean>("IsUsedInPaymentTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryGLAccountAssignmentRef</b>
     * </p>
     *
     * @return Account Assignment Reference of Position Management
     */
    @SerializedName( "TreasuryGLAccountAssignmentRef" )
    @JsonProperty( "TreasuryGLAccountAssignmentRef" )
    @Nullable
    @ODataField( odataName = "TreasuryGLAccountAssignmentRef" )
    private String treasuryGLAccountAssignmentRef;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryGLAccountAssignmentRef</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_GL_ACCOUNT_ASSIGNMENT_REF =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryGLAccountAssignmentRef");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryGLAccountAssignRefName</b>
     * </p>
     *
     * @return Name of the Account Assignment Reference
     */
    @SerializedName( "TreasuryGLAccountAssignRefName" )
    @JsonProperty( "TreasuryGLAccountAssignRefName" )
    @Nullable
    @ODataField( odataName = "TreasuryGLAccountAssignRefName" )
    private String treasuryGLAccountAssignRefName;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryGLAccountAssignRefName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_GL_ACCOUNT_ASSIGN_REF_NAME =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryGLAccountAssignRefName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPostingCategory</b>
     * </p>
     *
     * @return Posting Category
     */
    @SerializedName( "TreasuryPostingCategory" )
    @JsonProperty( "TreasuryPostingCategory" )
    @Nullable
    @ODataField( odataName = "TreasuryPostingCategory" )
    private Short treasuryPostingCategory;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryPostingCategory</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<Short> TREASURY_POSTING_CATEGORY =
        new TrsyPostgJrnlEntrItmField<Short>("TreasuryPostingCategory");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPostingCategoryName</b>
     * </p>
     *
     * @return Name of the Posting Category
     */
    @SerializedName( "TreasuryPostingCategoryName" )
    @JsonProperty( "TreasuryPostingCategoryName" )
    @Nullable
    @ODataField( odataName = "TreasuryPostingCategoryName" )
    private String treasuryPostingCategoryName;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryPostingCategoryName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_POSTING_CATEGORY_NAME =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryPostingCategoryName");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryGLAccountSymbol</b>
     * </p>
     *
     * @return Account Symbol for Account Assignment Reference
     */
    @SerializedName( "TreasuryGLAccountSymbol" )
    @JsonProperty( "TreasuryGLAccountSymbol" )
    @Nullable
    @ODataField( odataName = "TreasuryGLAccountSymbol" )
    private String treasuryGLAccountSymbol;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryGLAccountSymbol</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_GL_ACCOUNT_SYMBOL =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryGLAccountSymbol");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryGLAccountSymbolName</b>
     * </p>
     *
     * @return Name of the Account Symbol
     */
    @SerializedName( "TreasuryGLAccountSymbolName" )
    @JsonProperty( "TreasuryGLAccountSymbolName" )
    @Nullable
    @ODataField( odataName = "TreasuryGLAccountSymbolName" )
    private String treasuryGLAccountSymbolName;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryGLAccountSymbolName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_GL_ACCOUNT_SYMBOL_NAME =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryGLAccountSymbolName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingKey</b>
     * </p>
     *
     * @return Posting Key
     */
    @SerializedName( "PostingKey" )
    @JsonProperty( "PostingKey" )
    @Nullable
    @ODataField( odataName = "PostingKey" )
    private String postingKey;
    /**
     * Use with available fluent helpers to apply the <b>PostingKey</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> POSTING_KEY =
        new TrsyPostgJrnlEntrItmField<String>("PostingKey");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PostingKeyName</b>
     * </p>
     *
     * @return Posting Key Name
     */
    @SerializedName( "PostingKeyName" )
    @JsonProperty( "PostingKeyName" )
    @Nullable
    @ODataField( odataName = "PostingKeyName" )
    private String postingKeyName;
    /**
     * Use with available fluent helpers to apply the <b>PostingKeyName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> POSTING_KEY_NAME =
        new TrsyPostgJrnlEntrItmField<String>("PostingKeyName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> GL_ACCOUNT =
        new TrsyPostgJrnlEntrItmField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PositionCurrency</b>
     * </p>
     *
     * @return Position Currency
     */
    @SerializedName( "PositionCurrency" )
    @JsonProperty( "PositionCurrency" )
    @Nullable
    @ODataField( odataName = "PositionCurrency" )
    private String positionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>PositionCurrency</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> POSITION_CURRENCY =
        new TrsyPostgJrnlEntrItmField<String>("PositionCurrency");
    /**
     * Constraints: Not nullable, Precision: 22, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInPositionCurrency</b>
     * </p>
     *
     * @return Amount in Position Currency
     */
    @SerializedName( "AmountInPositionCurrency" )
    @JsonProperty( "AmountInPositionCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInPositionCurrency" )
    private BigDecimal amountInPositionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInPositionCurrency</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<BigDecimal> AMOUNT_IN_POSITION_CURRENCY =
        new TrsyPostgJrnlEntrItmField<BigDecimal>("AmountInPositionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @return Local Currency
     */
    @SerializedName( "CompanyCodeCurrency" )
    @JsonProperty( "CompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCurrency" )
    private String companyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> COMPANY_CODE_CURRENCY =
        new TrsyPostgJrnlEntrItmField<String>("CompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Precision: 22, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInCompanyCodeCurrency</b>
     * </p>
     *
     * @return Amount (Local Currency)
     */
    @SerializedName( "AmountInCompanyCodeCurrency" )
    @JsonProperty( "AmountInCompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInCompanyCodeCurrency" )
    private BigDecimal amountInCompanyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInCompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<BigDecimal> AMOUNT_IN_COMPANY_CODE_CURRENCY =
        new TrsyPostgJrnlEntrItmField<BigDecimal>("AmountInCompanyCodeCurrency");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryTransactionFlow</b>
     * </p>
     *
     * @return Number of a Distributor Flow
     */
    @SerializedName( "TreasuryTransactionFlow" )
    @JsonProperty( "TreasuryTransactionFlow" )
    @Nullable
    @ODataField( odataName = "TreasuryTransactionFlow" )
    private Integer treasuryTransactionFlow;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryTransactionFlow</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<Integer> TREASURY_TRANSACTION_FLOW =
        new TrsyPostgJrnlEntrItmField<Integer>("TreasuryTransactionFlow");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @return Document Number of an Accounting Document
     */
    @SerializedName( "AccountingDocument" )
    @JsonProperty( "AccountingDocument" )
    @Nullable
    @ODataField( odataName = "AccountingDocument" )
    private String accountingDocument;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocument</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> ACCOUNTING_DOCUMENT =
        new TrsyPostgJrnlEntrItmField<String>("AccountingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocument</b>
     * </p>
     *
     * @return Reverse Document
     */
    @SerializedName( "ReverseDocument" )
    @JsonProperty( "ReverseDocument" )
    @Nullable
    @ODataField( odataName = "ReverseDocument" )
    private String reverseDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReverseDocument</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> REVERSE_DOCUMENT =
        new TrsyPostgJrnlEntrItmField<String>("ReverseDocument");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JournalEntryType</b>
     * </p>
     *
     * @return Document Type
     */
    @SerializedName( "JournalEntryType" )
    @JsonProperty( "JournalEntryType" )
    @Nullable
    @ODataField( odataName = "JournalEntryType" )
    private String journalEntryType;
    /**
     * Use with available fluent helpers to apply the <b>JournalEntryType</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> JOURNAL_ENTRY_TYPE =
        new TrsyPostgJrnlEntrItmField<String>("JournalEntryType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentTypeName</b>
     * </p>
     *
     * @return Document Type Name
     */
    @SerializedName( "AccountingDocumentTypeName" )
    @JsonProperty( "AccountingDocumentTypeName" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentTypeName" )
    private String accountingDocumentTypeName;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentTypeName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> ACCOUNTING_DOCUMENT_TYPE_NAME =
        new TrsyPostgJrnlEntrItmField<String>("AccountingDocumentTypeName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PaymentDate</b>
     * </p>
     *
     * @return Payment Date
     */
    @SerializedName( "PaymentDate" )
    @JsonProperty( "PaymentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PaymentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime paymentDate;
    /**
     * Use with available fluent helpers to apply the <b>PaymentDate</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<LocalDateTime> PAYMENT_DATE =
        new TrsyPostgJrnlEntrItmField<LocalDateTime>("PaymentDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> CUSTOMER = new TrsyPostgJrnlEntrItmField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> PAYMENT_TERMS =
        new TrsyPostgJrnlEntrItmField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @return Payment Method
     */
    @SerializedName( "PaymentMethod" )
    @JsonProperty( "PaymentMethod" )
    @Nullable
    @ODataField( odataName = "PaymentMethod" )
    private String paymentMethod;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethod</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> PAYMENT_METHOD =
        new TrsyPostgJrnlEntrItmField<String>("PaymentMethod");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethodName</b>
     * </p>
     *
     * @return Payment Method Name
     */
    @SerializedName( "PaymentMethodName" )
    @JsonProperty( "PaymentMethodName" )
    @Nullable
    @ODataField( odataName = "PaymentMethodName" )
    private String paymentMethodName;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethodName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> PAYMENT_METHOD_NAME =
        new TrsyPostgJrnlEntrItmField<String>("PaymentMethodName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethodSupplement</b>
     * </p>
     *
     * @return Payment method supplement
     */
    @SerializedName( "PaymentMethodSupplement" )
    @JsonProperty( "PaymentMethodSupplement" )
    @Nullable
    @ODataField( odataName = "PaymentMethodSupplement" )
    private String paymentMethodSupplement;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethodSupplement</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> PAYMENT_METHOD_SUPPLEMENT =
        new TrsyPostgJrnlEntrItmField<String>("PaymentMethodSupplement");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethodSupplementName</b>
     * </p>
     *
     * @return Name of the Payment Method Supplement
     */
    @SerializedName( "PaymentMethodSupplementName" )
    @JsonProperty( "PaymentMethodSupplementName" )
    @Nullable
    @ODataField( odataName = "PaymentMethodSupplementName" )
    private String paymentMethodSupplementName;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethodSupplementName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> PAYMENT_METHOD_SUPPLEMENT_NAME =
        new TrsyPostgJrnlEntrItmField<String>("PaymentMethodSupplementName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentBlockingReason</b>
     * </p>
     *
     * @return Payment Block Key
     */
    @SerializedName( "PaymentBlockingReason" )
    @JsonProperty( "PaymentBlockingReason" )
    @Nullable
    @ODataField( odataName = "PaymentBlockingReason" )
    private String paymentBlockingReason;
    /**
     * Use with available fluent helpers to apply the <b>PaymentBlockingReason</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> PAYMENT_BLOCKING_REASON =
        new TrsyPostgJrnlEntrItmField<String>("PaymentBlockingReason");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PaymentBlockingReasonName</b>
     * </p>
     *
     * @return Name of a Payment Block Reason
     */
    @SerializedName( "PaymentBlockingReasonName" )
    @JsonProperty( "PaymentBlockingReasonName" )
    @Nullable
    @ODataField( odataName = "PaymentBlockingReasonName" )
    private String paymentBlockingReasonName;
    /**
     * Use with available fluent helpers to apply the <b>PaymentBlockingReasonName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> PAYMENT_BLOCKING_REASON_NAME =
        new TrsyPostgJrnlEntrItmField<String>("PaymentBlockingReasonName");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>PayerPayeeFullName</b>
     * </p>
     *
     * @return Full Name of the Payer / Payee
     */
    @SerializedName( "PayerPayeeFullName" )
    @JsonProperty( "PayerPayeeFullName" )
    @Nullable
    @ODataField( odataName = "PayerPayeeFullName" )
    private String payerPayeeFullName;
    /**
     * Use with available fluent helpers to apply the <b>PayerPayeeFullName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> PAYER_PAYEE_FULL_NAME =
        new TrsyPostgJrnlEntrItmField<String>("PayerPayeeFullName");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     *
     * @return Short Key for Own House Bank
     */
    @SerializedName( "HouseBank" )
    @JsonProperty( "HouseBank" )
    @Nullable
    @ODataField( odataName = "HouseBank" )
    private String houseBank;
    /**
     * Use with available fluent helpers to apply the <b>HouseBank</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> HOUSE_BANK =
        new TrsyPostgJrnlEntrItmField<String>("HouseBank");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StateCentralBankPaymentReason</b>
     * </p>
     *
     * @return State Central Bank Indicator
     */
    @SerializedName( "StateCentralBankPaymentReason" )
    @JsonProperty( "StateCentralBankPaymentReason" )
    @Nullable
    @ODataField( odataName = "StateCentralBankPaymentReason" )
    private String stateCentralBankPaymentReason;
    /**
     * Use with available fluent helpers to apply the <b>StateCentralBankPaymentReason</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> STATE_CENTRAL_BANK_PAYMENT_REASON =
        new TrsyPostgJrnlEntrItmField<String>("StateCentralBankPaymentReason");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingCountry</b>
     * </p>
     *
     * @return Supplying Country/Region
     */
    @SerializedName( "SupplyingCountry" )
    @JsonProperty( "SupplyingCountry" )
    @Nullable
    @ODataField( odataName = "SupplyingCountry" )
    private String supplyingCountry;
    /**
     * Use with available fluent helpers to apply the <b>SupplyingCountry</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> SUPPLYING_COUNTRY =
        new TrsyPostgJrnlEntrItmField<String>("SupplyingCountry");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CountryName</b>
     * </p>
     *
     * @return Country/Region Name
     */
    @SerializedName( "CountryName" )
    @JsonProperty( "CountryName" )
    @Nullable
    @ODataField( odataName = "CountryName" )
    private String countryName;
    /**
     * Use with available fluent helpers to apply the <b>CountryName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> COUNTRY_NAME =
        new TrsyPostgJrnlEntrItmField<String>("CountryName");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @return Assignment number
     */
    @SerializedName( "AssignmentReference" )
    @JsonProperty( "AssignmentReference" )
    @Nullable
    @ODataField( odataName = "AssignmentReference" )
    private String assignmentReference;
    /**
     * Use with available fluent helpers to apply the <b>AssignmentReference</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> ASSIGNMENT_REFERENCE =
        new TrsyPostgJrnlEntrItmField<String>("AssignmentReference");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>JournalEntryItemText</b>
     * </p>
     *
     * @return Journal Entry Item Text
     */
    @SerializedName( "JournalEntryItemText" )
    @JsonProperty( "JournalEntryItemText" )
    @Nullable
    @ODataField( odataName = "JournalEntryItemText" )
    private String journalEntryItemText;
    /**
     * Use with available fluent helpers to apply the <b>JournalEntryItemText</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> JOURNAL_ENTRY_ITEM_TEXT =
        new TrsyPostgJrnlEntrItmField<String>("JournalEntryItemText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> BUSINESS_AREA =
        new TrsyPostgJrnlEntrItmField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessAreaName</b>
     * </p>
     *
     * @return Business Area Description
     */
    @SerializedName( "BusinessAreaName" )
    @JsonProperty( "BusinessAreaName" )
    @Nullable
    @ODataField( odataName = "BusinessAreaName" )
    private String businessAreaName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessAreaName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> BUSINESS_AREA_NAME =
        new TrsyPostgJrnlEntrItmField<String>("BusinessAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> COST_CENTER =
        new TrsyPostgJrnlEntrItmField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @return Transaction Type (FI)
     */
    @SerializedName( "FinancialTransactionType" )
    @JsonProperty( "FinancialTransactionType" )
    @Nullable
    @ODataField( odataName = "FinancialTransactionType" )
    private String financialTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialTransactionType</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FINANCIAL_TRANSACTION_TYPE =
        new TrsyPostgJrnlEntrItmField<String>("FinancialTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionTypeName</b>
     * </p>
     *
     * @return Name of a Transaction Type (FI)
     */
    @SerializedName( "FinancialTransactionTypeName" )
    @JsonProperty( "FinancialTransactionTypeName" )
    @Nullable
    @ODataField( odataName = "FinancialTransactionTypeName" )
    private String financialTransactionTypeName;
    /**
     * Use with available fluent helpers to apply the <b>FinancialTransactionTypeName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FINANCIAL_TRANSACTION_TYPE_NAME =
        new TrsyPostgJrnlEntrItmField<String>("FinancialTransactionTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     *
     * @return Company ID
     */
    @SerializedName( "PartnerCompany" )
    @JsonProperty( "PartnerCompany" )
    @Nullable
    @ODataField( odataName = "PartnerCompany" )
    private String partnerCompany;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCompany</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> PARTNER_COMPANY =
        new TrsyPostgJrnlEntrItmField<String>("PartnerCompany");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CompanyName</b>
     * </p>
     *
     * @return Company Name
     */
    @SerializedName( "CompanyName" )
    @JsonProperty( "CompanyName" )
    @Nullable
    @ODataField( odataName = "CompanyName" )
    private String companyName;
    /**
     * Use with available fluent helpers to apply the <b>CompanyName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> COMPANY_NAME =
        new TrsyPostgJrnlEntrItmField<String>("CompanyName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Counterparty</b>
     * </p>
     *
     * @return Counterparty Number
     */
    @SerializedName( "Counterparty" )
    @JsonProperty( "Counterparty" )
    @Nullable
    @ODataField( odataName = "Counterparty" )
    private String counterparty;
    /**
     * Use with available fluent helpers to apply the <b>Counterparty</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> COUNTERPARTY =
        new TrsyPostgJrnlEntrItmField<String>("Counterparty");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CounterpartyFullName</b>
     * </p>
     *
     * @return Full Name of the Counterparty
     */
    @SerializedName( "CounterpartyFullName" )
    @JsonProperty( "CounterpartyFullName" )
    @Nullable
    @ODataField( odataName = "CounterpartyFullName" )
    private String counterpartyFullName;
    /**
     * Use with available fluent helpers to apply the <b>CounterpartyFullName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> COUNTERPARTY_FULL_NAME =
        new TrsyPostgJrnlEntrItmField<String>("CounterpartyFullName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Issuer</b>
     * </p>
     *
     * @return Issuer Identity Key
     */
    @SerializedName( "Issuer" )
    @JsonProperty( "Issuer" )
    @Nullable
    @ODataField( odataName = "Issuer" )
    private String issuer;
    /**
     * Use with available fluent helpers to apply the <b>Issuer</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> ISSUER = new TrsyPostgJrnlEntrItmField<String>("Issuer");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>IssuerFullName</b>
     * </p>
     *
     * @return Full Name of the Issuer
     */
    @SerializedName( "IssuerFullName" )
    @JsonProperty( "IssuerFullName" )
    @Nullable
    @ODataField( odataName = "IssuerFullName" )
    private String issuerFullName;
    /**
     * Use with available fluent helpers to apply the <b>IssuerFullName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> ISSUER_FULL_NAME =
        new TrsyPostgJrnlEntrItmField<String>("IssuerFullName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLCode</b>
     * </p>
     *
     * @return Special G/L Indicator
     */
    @SerializedName( "SpecialGLCode" )
    @JsonProperty( "SpecialGLCode" )
    @Nullable
    @ODataField( odataName = "SpecialGLCode" )
    private String specialGLCode;
    /**
     * Use with available fluent helpers to apply the <b>SpecialGLCode</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> SPECIAL_GL_CODE =
        new TrsyPostgJrnlEntrItmField<String>("SpecialGLCode");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLCodeName</b>
     * </p>
     *
     * @return Name of a Special GL Code
     */
    @SerializedName( "SpecialGLCodeName" )
    @JsonProperty( "SpecialGLCodeName" )
    @Nullable
    @ODataField( odataName = "SpecialGLCodeName" )
    private String specialGLCodeName;
    /**
     * Use with available fluent helpers to apply the <b>SpecialGLCodeName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> SPECIAL_GL_CODE_NAME =
        new TrsyPostgJrnlEntrItmField<String>("SpecialGLCodeName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryBusinessTransaction</b>
     * </p>
     *
     * @return Identifier of the Distributor Business Transaction
     */
    @SerializedName( "TreasuryBusinessTransaction" )
    @JsonProperty( "TreasuryBusinessTransaction" )
    @Nullable
    @ODataField( odataName = "TreasuryBusinessTransaction" )
    private UUID treasuryBusinessTransaction;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryBusinessTransaction</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<UUID> TREASURY_BUSINESS_TRANSACTION =
        new TrsyPostgJrnlEntrItmField<UUID>("TreasuryBusinessTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryValuationArea</b>
     * </p>
     *
     * @return Treasury Valuation Area
     */
    @SerializedName( "TreasuryValuationArea" )
    @JsonProperty( "TreasuryValuationArea" )
    @Nullable
    @ODataField( odataName = "TreasuryValuationArea" )
    private String treasuryValuationArea;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryValuationArea</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_VALUATION_AREA =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryValuationArea");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryValuationAreaName</b>
     * </p>
     *
     * @return Name of the Valuation Area
     */
    @SerializedName( "TreasuryValuationAreaName" )
    @JsonProperty( "TreasuryValuationAreaName" )
    @Nullable
    @ODataField( odataName = "TreasuryValuationAreaName" )
    private String treasuryValuationAreaName;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryValuationAreaName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_VALUATION_AREA_NAME =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryValuationAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @return Reference document number
     */
    @SerializedName( "ReferenceDocument" )
    @JsonProperty( "ReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceDocument" )
    private String referenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocument</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> REFERENCE_DOCUMENT =
        new TrsyPostgJrnlEntrItmField<String>("ReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentContext</b>
     * </p>
     *
     * @return Reference Organizational Units
     */
    @SerializedName( "ReferenceDocumentContext" )
    @JsonProperty( "ReferenceDocumentContext" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentContext" )
    private String referenceDocumentContext;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentContext</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> REFERENCE_DOCUMENT_CONTEXT =
        new TrsyPostgJrnlEntrItmField<String>("ReferenceDocumentContext");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date in the Document
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<LocalDateTime> POSTING_DATE =
        new TrsyPostgJrnlEntrItmField<LocalDateTime>("PostingDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @return Fiscal period
     */
    @SerializedName( "FiscalPeriod" )
    @JsonProperty( "FiscalPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalPeriod" )
    private String fiscalPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriod</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FISCAL_PERIOD =
        new TrsyPostgJrnlEntrItmField<String>("FiscalPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FISCAL_YEAR =
        new TrsyPostgJrnlEntrItmField<String>("FiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversalReferenceDocument</b>
     * </p>
     *
     * @return Reversal: Reference Document No. of Document to Be Reversed
     */
    @SerializedName( "ReversalReferenceDocument" )
    @JsonProperty( "ReversalReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ReversalReferenceDocument" )
    private String reversalReferenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReversalReferenceDocument</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> REVERSAL_REFERENCE_DOCUMENT =
        new TrsyPostgJrnlEntrItmField<String>("ReversalReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversalReferenceDocumentCntxt</b>
     * </p>
     *
     * @return Reversal: Reference Organizations of Document to Be Reversed
     */
    @SerializedName( "ReversalReferenceDocumentCntxt" )
    @JsonProperty( "ReversalReferenceDocumentCntxt" )
    @Nullable
    @ODataField( odataName = "ReversalReferenceDocumentCntxt" )
    private String reversalReferenceDocumentCntxt;
    /**
     * Use with available fluent helpers to apply the <b>ReversalReferenceDocumentCntxt</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> REVERSAL_REFERENCE_DOCUMENT_CNTXT =
        new TrsyPostgJrnlEntrItmField<String>("ReversalReferenceDocumentCntxt");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocumentPostingDate</b>
     * </p>
     *
     * @return Reverse Document Posting Date
     */
    @SerializedName( "ReverseDocumentPostingDate" )
    @JsonProperty( "ReverseDocumentPostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ReverseDocumentPostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime reverseDocumentPostingDate;
    /**
     * Use with available fluent helpers to apply the <b>ReverseDocumentPostingDate</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<LocalDateTime> REVERSE_DOCUMENT_POSTING_DATE =
        new TrsyPostgJrnlEntrItmField<LocalDateTime>("ReverseDocumentPostingDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocumentFiscalPeriod</b>
     * </p>
     *
     * @return Reverse Document Fiscal Period
     */
    @SerializedName( "ReverseDocumentFiscalPeriod" )
    @JsonProperty( "ReverseDocumentFiscalPeriod" )
    @Nullable
    @ODataField( odataName = "ReverseDocumentFiscalPeriod" )
    private String reverseDocumentFiscalPeriod;
    /**
     * Use with available fluent helpers to apply the <b>ReverseDocumentFiscalPeriod</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> REVERSE_DOCUMENT_FISCAL_PERIOD =
        new TrsyPostgJrnlEntrItmField<String>("ReverseDocumentFiscalPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocumentFiscalYear</b>
     * </p>
     *
     * @return Reverse Document Fiscal Year
     */
    @SerializedName( "ReverseDocumentFiscalYear" )
    @JsonProperty( "ReverseDocumentFiscalYear" )
    @Nullable
    @ODataField( odataName = "ReverseDocumentFiscalYear" )
    private String reverseDocumentFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>ReverseDocumentFiscalYear</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> REVERSE_DOCUMENT_FISCAL_YEAR =
        new TrsyPostgJrnlEntrItmField<String>("ReverseDocumentFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @return Ledger
     */
    @SerializedName( "Ledger" )
    @JsonProperty( "Ledger" )
    @Nullable
    @ODataField( odataName = "Ledger" )
    private String ledger;
    /**
     * Use with available fluent helpers to apply the <b>Ledger</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> LEDGER = new TrsyPostgJrnlEntrItmField<String>("Ledger");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @return Document Date in Document
     */
    @SerializedName( "DocumentDate" )
    @JsonProperty( "DocumentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DocumentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime documentDate;
    /**
     * Use with available fluent helpers to apply the <b>DocumentDate</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<LocalDateTime> DOCUMENT_DATE =
        new TrsyPostgJrnlEntrItmField<LocalDateTime>("DocumentDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AccountingPrinciple</b>
     * </p>
     *
     * @return Accounting Principle
     */
    @SerializedName( "AccountingPrinciple" )
    @JsonProperty( "AccountingPrinciple" )
    @Nullable
    @ODataField( odataName = "AccountingPrinciple" )
    private String accountingPrinciple;
    /**
     * Use with available fluent helpers to apply the <b>AccountingPrinciple</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> ACCOUNTING_PRINCIPLE =
        new TrsyPostgJrnlEntrItmField<String>("AccountingPrinciple");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryAcctgPostingCategory</b>
     * </p>
     *
     * @return Update to Financial Accounting Category
     */
    @SerializedName( "TreasuryAcctgPostingCategory" )
    @JsonProperty( "TreasuryAcctgPostingCategory" )
    @Nullable
    @ODataField( odataName = "TreasuryAcctgPostingCategory" )
    private String treasuryAcctgPostingCategory;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryAcctgPostingCategory</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_ACCTG_POSTING_CATEGORY =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryAcctgPostingCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryBusinessTransCategory</b>
     * </p>
     *
     * @return Business Transaction Category
     */
    @SerializedName( "TreasuryBusinessTransCategory" )
    @JsonProperty( "TreasuryBusinessTransCategory" )
    @Nullable
    @ODataField( odataName = "TreasuryBusinessTransCategory" )
    private String treasuryBusinessTransCategory;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryBusinessTransCategory</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_BUSINESS_TRANS_CATEGORY =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryBusinessTransCategory");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryBusTransCategoryName</b>
     * </p>
     *
     * @return Name of Business Transaction Category
     */
    @SerializedName( "TreasuryBusTransCategoryName" )
    @JsonProperty( "TreasuryBusTransCategoryName" )
    @Nullable
    @ODataField( odataName = "TreasuryBusTransCategoryName" )
    private String treasuryBusTransCategoryName;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryBusTransCategoryName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_BUS_TRANS_CATEGORY_NAME =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryBusTransCategoryName");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentHeaderText</b>
     * </p>
     *
     * @return Document Header Text
     */
    @SerializedName( "DocumentHeaderText" )
    @JsonProperty( "DocumentHeaderText" )
    @Nullable
    @ODataField( odataName = "DocumentHeaderText" )
    private String documentHeaderText;
    /**
     * Use with available fluent helpers to apply the <b>DocumentHeaderText</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> DOCUMENT_HEADER_TEXT =
        new TrsyPostgJrnlEntrItmField<String>("DocumentHeaderText");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReferenceID</b>
     * </p>
     *
     * @return Reference Document Number
     */
    @SerializedName( "DocumentReferenceID" )
    @JsonProperty( "DocumentReferenceID" )
    @Nullable
    @ODataField( odataName = "DocumentReferenceID" )
    private String documentReferenceID;
    /**
     * Use with available fluent helpers to apply the <b>DocumentReferenceID</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> DOCUMENT_REFERENCE_ID =
        new TrsyPostgJrnlEntrItmField<String>("DocumentReferenceID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrValuationClass</b>
     * </p>
     *
     * @return Financial Instrument Valuation Class
     */
    @SerializedName( "FinancialInstrValuationClass" )
    @JsonProperty( "FinancialInstrValuationClass" )
    @Nullable
    @ODataField( odataName = "FinancialInstrValuationClass" )
    private String financialInstrValuationClass;
    /**
     * Use with available fluent helpers to apply the <b>FinancialInstrValuationClass</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FINANCIAL_INSTR_VALUATION_CLASS =
        new TrsyPostgJrnlEntrItmField<String>("FinancialInstrValuationClass");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrValClassName</b>
     * </p>
     *
     * @return Name of the Financial Instrument Valuation Class
     */
    @SerializedName( "FinancialInstrValClassName" )
    @JsonProperty( "FinancialInstrValClassName" )
    @Nullable
    @ODataField( odataName = "FinancialInstrValClassName" )
    private String financialInstrValClassName;
    /**
     * Use with available fluent helpers to apply the <b>FinancialInstrValClassName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FINANCIAL_INSTR_VAL_CLASS_NAME =
        new TrsyPostgJrnlEntrItmField<String>("FinancialInstrValClassName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryValuationClass</b>
     * </p>
     *
     * @return Valuation Class
     */
    @SerializedName( "TreasuryValuationClass" )
    @JsonProperty( "TreasuryValuationClass" )
    @Nullable
    @ODataField( odataName = "TreasuryValuationClass" )
    private String treasuryValuationClass;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryValuationClass</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_VALUATION_CLASS =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryValuationClass");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryValuationClassName</b>
     * </p>
     *
     * @return Name of the Valuation Class
     */
    @SerializedName( "TreasuryValuationClassName" )
    @JsonProperty( "TreasuryValuationClassName" )
    @Nullable
    @ODataField( odataName = "TreasuryValuationClassName" )
    private String treasuryValuationClassName;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryValuationClassName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_VALUATION_CLASS_NAME =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryValuationClassName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> COMPANY_CODE =
        new TrsyPostgJrnlEntrItmField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrumentProductType</b>
     * </p>
     *
     * @return Product Type
     */
    @SerializedName( "FinancialInstrumentProductType" )
    @JsonProperty( "FinancialInstrumentProductType" )
    @Nullable
    @ODataField( odataName = "FinancialInstrumentProductType" )
    private String financialInstrumentProductType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialInstrumentProductType</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FINANCIAL_INSTRUMENT_PRODUCT_TYPE =
        new TrsyPostgJrnlEntrItmField<String>("FinancialInstrumentProductType");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrProdTypeName</b>
     * </p>
     *
     * @return Name of the Product Type
     */
    @SerializedName( "FinancialInstrProdTypeName" )
    @JsonProperty( "FinancialInstrProdTypeName" )
    @Nullable
    @ODataField( odataName = "FinancialInstrProdTypeName" )
    private String financialInstrProdTypeName;
    /**
     * Use with available fluent helpers to apply the <b>FinancialInstrProdTypeName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FINANCIAL_INSTR_PROD_TYPE_NAME =
        new TrsyPostgJrnlEntrItmField<String>("FinancialInstrProdTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SecurityAccount</b>
     * </p>
     *
     * @return Security Account
     */
    @SerializedName( "SecurityAccount" )
    @JsonProperty( "SecurityAccount" )
    @Nullable
    @ODataField( odataName = "SecurityAccount" )
    private String securityAccount;
    /**
     * Use with available fluent helpers to apply the <b>SecurityAccount</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> SECURITY_ACCOUNT =
        new TrsyPostgJrnlEntrItmField<String>("SecurityAccount");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SecurityAccountName</b>
     * </p>
     *
     * @return Name of the Security Account
     */
    @SerializedName( "SecurityAccountName" )
    @JsonProperty( "SecurityAccountName" )
    @Nullable
    @ODataField( odataName = "SecurityAccountName" )
    private String securityAccountName;
    /**
     * Use with available fluent helpers to apply the <b>SecurityAccountName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> SECURITY_ACCOUNT_NAME =
        new TrsyPostgJrnlEntrItmField<String>("SecurityAccountName");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>SecurityClass</b>
     * </p>
     *
     * @return Security Class
     */
    @SerializedName( "SecurityClass" )
    @JsonProperty( "SecurityClass" )
    @Nullable
    @ODataField( odataName = "SecurityClass" )
    private String securityClass;
    /**
     * Use with available fluent helpers to apply the <b>SecurityClass</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> SECURITY_CLASS =
        new TrsyPostgJrnlEntrItmField<String>("SecurityClass");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>SecurityClassName</b>
     * </p>
     *
     * @return Name of the Security Class
     */
    @SerializedName( "SecurityClassName" )
    @JsonProperty( "SecurityClassName" )
    @Nullable
    @ODataField( odataName = "SecurityClassName" )
    private String securityClassName;
    /**
     * Use with available fluent helpers to apply the <b>SecurityClassName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> SECURITY_CLASS_NAME =
        new TrsyPostgJrnlEntrItmField<String>("SecurityClassName");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SecurityClassDescription</b>
     * </p>
     *
     * @return Description of the Security Class
     */
    @SerializedName( "SecurityClassDescription" )
    @JsonProperty( "SecurityClassDescription" )
    @Nullable
    @ODataField( odataName = "SecurityClassDescription" )
    private String securityClassDescription;
    /**
     * Use with available fluent helpers to apply the <b>SecurityClassDescription</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> SECURITY_CLASS_DESCRIPTION =
        new TrsyPostgJrnlEntrItmField<String>("SecurityClassDescription");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DifferentiationPortfolio</b>
     * </p>
     *
     * @return Portfolio as Differentiation Characteristic
     */
    @SerializedName( "DifferentiationPortfolio" )
    @JsonProperty( "DifferentiationPortfolio" )
    @Nullable
    @ODataField( odataName = "DifferentiationPortfolio" )
    private String differentiationPortfolio;
    /**
     * Use with available fluent helpers to apply the <b>DifferentiationPortfolio</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> DIFFERENTIATION_PORTFOLIO =
        new TrsyPostgJrnlEntrItmField<String>("DifferentiationPortfolio");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>DifferentiationPortfolioName</b>
     * </p>
     *
     * @return Name of the Portfolio as Differentiation Characteristic
     */
    @SerializedName( "DifferentiationPortfolioName" )
    @JsonProperty( "DifferentiationPortfolioName" )
    @Nullable
    @ODataField( odataName = "DifferentiationPortfolioName" )
    private String differentiationPortfolioName;
    /**
     * Use with available fluent helpers to apply the <b>DifferentiationPortfolioName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> DIFFERENTIATION_PORTFOLIO_NAME =
        new TrsyPostgJrnlEntrItmField<String>("DifferentiationPortfolioName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SecurityAccountGroup</b>
     * </p>
     *
     * @return Securities Account Group
     */
    @SerializedName( "SecurityAccountGroup" )
    @JsonProperty( "SecurityAccountGroup" )
    @Nullable
    @ODataField( odataName = "SecurityAccountGroup" )
    private String securityAccountGroup;
    /**
     * Use with available fluent helpers to apply the <b>SecurityAccountGroup</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> SECURITY_ACCOUNT_GROUP =
        new TrsyPostgJrnlEntrItmField<String>("SecurityAccountGroup");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SecurityAccountGroupName</b>
     * </p>
     *
     * @return Name of Securities Account Group
     */
    @SerializedName( "SecurityAccountGroupName" )
    @JsonProperty( "SecurityAccountGroupName" )
    @Nullable
    @ODataField( odataName = "SecurityAccountGroupName" )
    private String securityAccountGroupName;
    /**
     * Use with available fluent helpers to apply the <b>SecurityAccountGroupName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> SECURITY_ACCOUNT_GROUP_NAME =
        new TrsyPostgJrnlEntrItmField<String>("SecurityAccountGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>LoanContract</b>
     * </p>
     *
     * @return Loan Contract Number
     */
    @SerializedName( "LoanContract" )
    @JsonProperty( "LoanContract" )
    @Nullable
    @ODataField( odataName = "LoanContract" )
    private String loanContract;
    /**
     * Use with available fluent helpers to apply the <b>LoanContract</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> LOAN_CONTRACT =
        new TrsyPostgJrnlEntrItmField<String>("LoanContract");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>LoanContractName</b>
     * </p>
     *
     * @return Name of the Loan Contract
     */
    @SerializedName( "LoanContractName" )
    @JsonProperty( "LoanContractName" )
    @Nullable
    @ODataField( odataName = "LoanContractName" )
    private String loanContractName;
    /**
     * Use with available fluent helpers to apply the <b>LoanContractName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> LOAN_CONTRACT_NAME =
        new TrsyPostgJrnlEntrItmField<String>("LoanContractName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPositionAccount</b>
     * </p>
     *
     * @return Futures Account for Listed Options and Futures
     */
    @SerializedName( "TreasuryPositionAccount" )
    @JsonProperty( "TreasuryPositionAccount" )
    @Nullable
    @ODataField( odataName = "TreasuryPositionAccount" )
    private String treasuryPositionAccount;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryPositionAccount</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_POSITION_ACCOUNT =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryPositionAccount");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPositionAccountName</b>
     * </p>
     *
     * @return Name of the Futures Account for Listed Options and Futures
     */
    @SerializedName( "TreasuryPositionAccountName" )
    @JsonProperty( "TreasuryPositionAccountName" )
    @Nullable
    @ODataField( odataName = "TreasuryPositionAccountName" )
    private String treasuryPositionAccountName;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryPositionAccountName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_POSITION_ACCOUNT_NAME =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryPositionAccountName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPositionLongShortCode</b>
     * </p>
     *
     * @return Code: Long or Short Position
     */
    @SerializedName( "TreasuryPositionLongShortCode" )
    @JsonProperty( "TreasuryPositionLongShortCode" )
    @Nullable
    @ODataField( odataName = "TreasuryPositionLongShortCode" )
    private String treasuryPositionLongShortCode;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryPositionLongShortCode</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TREASURY_POSITION_LONG_SHORT_CODE =
        new TrsyPostgJrnlEntrItmField<String>("TreasuryPositionLongShortCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Fund
     */
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FUND = new TrsyPostgJrnlEntrItmField<String>("Fund");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Grant
     */
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> GRANT_ID = new TrsyPostgJrnlEntrItmField<String>("GrantID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element) Edited
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> WBS_ELEMENT_EXTERNAL_ID =
        new TrsyPostgJrnlEntrItmField<String>("WBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WBSDescription</b>
     * </p>
     *
     * @return WBS Element Name
     */
    @SerializedName( "WBSDescription" )
    @JsonProperty( "WBSDescription" )
    @Nullable
    @ODataField( odataName = "WBSDescription" )
    private String wBSDescription;
    /**
     * Use with available fluent helpers to apply the <b>WBSDescription</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> WBS_DESCRIPTION =
        new TrsyPostgJrnlEntrItmField<String>("WBSDescription");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> PROFIT_CENTER =
        new TrsyPostgJrnlEntrItmField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DifferentiationCostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "DifferentiationCostCenter" )
    @JsonProperty( "DifferentiationCostCenter" )
    @Nullable
    @ODataField( odataName = "DifferentiationCostCenter" )
    private String differentiationCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>DifferentiationCostCenter</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> DIFFERENTIATION_COST_CENTER =
        new TrsyPostgJrnlEntrItmField<String>("DifferentiationCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FUNCTIONAL_AREA =
        new TrsyPostgJrnlEntrItmField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm1</b>
     * </p>
     *
     * @return Custom Differentiation Term 1 (Value)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm1" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm1" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm1" )
    private String trsyPosCustomDiffntnTerm1;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm1</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM1 =
        new TrsyPostgJrnlEntrItmField<String>("TrsyPosCustomDiffntnTerm1");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm1Name</b>
     * </p>
     *
     * @return Custom Differentiation Term 1 (Name)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm1Name" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm1Name" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm1Name" )
    private String trsyPosCustomDiffntnTerm1Name;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm1Name</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM1_NAME =
        new TrsyPostgJrnlEntrItmField<String>("TrsyPosCustomDiffntnTerm1Name");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm2</b>
     * </p>
     *
     * @return Custom Differentiation Term 2 (Value)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm2" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm2" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm2" )
    private String trsyPosCustomDiffntnTerm2;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm2</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM2 =
        new TrsyPostgJrnlEntrItmField<String>("TrsyPosCustomDiffntnTerm2");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm2Name</b>
     * </p>
     *
     * @return Custom Differentiation Term 2 (Name)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm2Name" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm2Name" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm2Name" )
    private String trsyPosCustomDiffntnTerm2Name;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm2Name</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM2_NAME =
        new TrsyPostgJrnlEntrItmField<String>("TrsyPosCustomDiffntnTerm2Name");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm3</b>
     * </p>
     *
     * @return Custom Differentiation Term 3 (Value)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm3" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm3" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm3" )
    private String trsyPosCustomDiffntnTerm3;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm3</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM3 =
        new TrsyPostgJrnlEntrItmField<String>("TrsyPosCustomDiffntnTerm3");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm3Name</b>
     * </p>
     *
     * @return Custom Differentiation Term 3 (Name)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm3Name" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm3Name" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm3Name" )
    private String trsyPosCustomDiffntnTerm3Name;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm3Name</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM3_NAME =
        new TrsyPostgJrnlEntrItmField<String>("TrsyPosCustomDiffntnTerm3Name");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm4</b>
     * </p>
     *
     * @return Custom Differentiation Term 4 (Value)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm4" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm4" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm4" )
    private String trsyPosCustomDiffntnTerm4;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm4</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM4 =
        new TrsyPostgJrnlEntrItmField<String>("TrsyPosCustomDiffntnTerm4");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm4Name</b>
     * </p>
     *
     * @return Custom Differentiation Term 4 (Name)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm4Name" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm4Name" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm4Name" )
    private String trsyPosCustomDiffntnTerm4Name;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm4Name</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM4_NAME =
        new TrsyPostgJrnlEntrItmField<String>("TrsyPosCustomDiffntnTerm4Name");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm5</b>
     * </p>
     *
     * @return Custom Differentiation Term 5 (Value)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm5" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm5" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm5" )
    private String trsyPosCustomDiffntnTerm5;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm5</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM5 =
        new TrsyPostgJrnlEntrItmField<String>("TrsyPosCustomDiffntnTerm5");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm5Name</b>
     * </p>
     *
     * @return Custom Differentiation Term 5 (Name)
     */
    @SerializedName( "TrsyPosCustomDiffntnTerm5Name" )
    @JsonProperty( "TrsyPosCustomDiffntnTerm5Name" )
    @Nullable
    @ODataField( odataName = "TrsyPosCustomDiffntnTerm5Name" )
    private String trsyPosCustomDiffntnTerm5Name;
    /**
     * Use with available fluent helpers to apply the <b>TrsyPosCustomDiffntnTerm5Name</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> TRSY_POS_CUSTOM_DIFFNTN_TERM5_NAME =
        new TrsyPostgJrnlEntrItmField<String>("TrsyPosCustomDiffntnTerm5Name");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralClearingAccount</b>
     * </p>
     *
     * @return Central Clearing Account
     */
    @SerializedName( "CentralClearingAccount" )
    @JsonProperty( "CentralClearingAccount" )
    @Nullable
    @ODataField( odataName = "CentralClearingAccount" )
    private String centralClearingAccount;
    /**
     * Use with available fluent helpers to apply the <b>CentralClearingAccount</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> CENTRAL_CLEARING_ACCOUNT =
        new TrsyPostgJrnlEntrItmField<String>("CentralClearingAccount");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CentralClearingAccountName</b>
     * </p>
     *
     * @return Name of the Central Clearing Account
     */
    @SerializedName( "CentralClearingAccountName" )
    @JsonProperty( "CentralClearingAccountName" )
    @Nullable
    @ODataField( odataName = "CentralClearingAccountName" )
    private String centralClearingAccountName;
    /**
     * Use with available fluent helpers to apply the <b>CentralClearingAccountName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> CENTRAL_CLEARING_ACCOUNT_NAME =
        new TrsyPostgJrnlEntrItmField<String>("CentralClearingAccountName");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>ActivityFinancialTransaction</b>
     * </p>
     *
     * @return Activity-Triggering Financial Transaction
     */
    @SerializedName( "ActivityFinancialTransaction" )
    @JsonProperty( "ActivityFinancialTransaction" )
    @Nullable
    @ODataField( odataName = "ActivityFinancialTransaction" )
    private String activityFinancialTransaction;
    /**
     * Use with available fluent helpers to apply the <b>ActivityFinancialTransaction</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> ACTIVITY_FINANCIAL_TRANSACTION =
        new TrsyPostgJrnlEntrItmField<String>("ActivityFinancialTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransaction</b>
     * </p>
     *
     * @return Financial Transaction
     */
    @SerializedName( "FinancialTransaction" )
    @JsonProperty( "FinancialTransaction" )
    @Nullable
    @ODataField( odataName = "FinancialTransaction" )
    private String financialTransaction;
    /**
     * Use with available fluent helpers to apply the <b>FinancialTransaction</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FINANCIAL_TRANSACTION =
        new TrsyPostgJrnlEntrItmField<String>("FinancialTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Entered By
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> CREATED_BY_USER =
        new TrsyPostgJrnlEntrItmField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return First Entered On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<LocalDateTime> CREATION_DATE =
        new TrsyPostgJrnlEntrItmField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Employee ID
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> LAST_CHANGED_BY_USER =
        new TrsyPostgJrnlEntrItmField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Edited On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<LocalDateTime> LAST_CHANGE_DATE =
        new TrsyPostgJrnlEntrItmField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountLongName</b>
     * </p>
     *
     * @return Description of a GL Account
     */
    @SerializedName( "GLAccountLongName" )
    @JsonProperty( "GLAccountLongName" )
    @Nullable
    @ODataField( odataName = "GLAccountLongName" )
    private String gLAccountLongName;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountLongName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> GL_ACCOUNT_LONG_NAME =
        new TrsyPostgJrnlEntrItmField<String>("GLAccountLongName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterName</b>
     * </p>
     *
     * @return Name of a Cost Center
     */
    @SerializedName( "CostCenterName" )
    @JsonProperty( "CostCenterName" )
    @Nullable
    @ODataField( odataName = "CostCenterName" )
    private String costCenterName;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> COST_CENTER_NAME =
        new TrsyPostgJrnlEntrItmField<String>("CostCenterName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrTransactionType</b>
     * </p>
     *
     * @return Financial Instrument Transaction Type
     */
    @SerializedName( "FinancialInstrTransactionType" )
    @JsonProperty( "FinancialInstrTransactionType" )
    @Nullable
    @ODataField( odataName = "FinancialInstrTransactionType" )
    private String financialInstrTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialInstrTransactionType</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FINANCIAL_INSTR_TRANSACTION_TYPE =
        new TrsyPostgJrnlEntrItmField<String>("FinancialInstrTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrTransTypeName</b>
     * </p>
     *
     * @return Name of Financial Instrument Transaction Type
     */
    @SerializedName( "FinancialInstrTransTypeName" )
    @JsonProperty( "FinancialInstrTransTypeName" )
    @Nullable
    @ODataField( odataName = "FinancialInstrTransTypeName" )
    private String financialInstrTransTypeName;
    /**
     * Use with available fluent helpers to apply the <b>FinancialInstrTransTypeName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FINANCIAL_INSTR_TRANS_TYPE_NAME =
        new TrsyPostgJrnlEntrItmField<String>("FinancialInstrTransTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrCharacteristic</b>
     * </p>
     *
     * @return Free Characteristic of Financial Transaction
     */
    @SerializedName( "FinancialInstrCharacteristic" )
    @JsonProperty( "FinancialInstrCharacteristic" )
    @Nullable
    @ODataField( odataName = "FinancialInstrCharacteristic" )
    private String financialInstrCharacteristic;
    /**
     * Use with available fluent helpers to apply the <b>FinancialInstrCharacteristic</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FINANCIAL_INSTR_CHARACTERISTIC =
        new TrsyPostgJrnlEntrItmField<String>("FinancialInstrCharacteristic");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrumentReference</b>
     * </p>
     *
     * @return Free Internal Reference of Financial Transaction
     */
    @SerializedName( "FinancialInstrumentReference" )
    @JsonProperty( "FinancialInstrumentReference" )
    @Nullable
    @ODataField( odataName = "FinancialInstrumentReference" )
    private String financialInstrumentReference;
    /**
     * Use with available fluent helpers to apply the <b>FinancialInstrumentReference</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FINANCIAL_INSTRUMENT_REFERENCE =
        new TrsyPostgJrnlEntrItmField<String>("FinancialInstrumentReference");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrumentAssignment</b>
     * </p>
     *
     * @return Free Assignment of Financial Transaction
     */
    @SerializedName( "FinancialInstrumentAssignment" )
    @JsonProperty( "FinancialInstrumentAssignment" )
    @Nullable
    @ODataField( odataName = "FinancialInstrumentAssignment" )
    private String financialInstrumentAssignment;
    /**
     * Use with available fluent helpers to apply the <b>FinancialInstrumentAssignment</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FINANCIAL_INSTRUMENT_ASSIGNMENT =
        new TrsyPostgJrnlEntrItmField<String>("FinancialInstrumentAssignment");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Portfolio</b>
     * </p>
     *
     * @return Portfolio
     */
    @SerializedName( "Portfolio" )
    @JsonProperty( "Portfolio" )
    @Nullable
    @ODataField( odataName = "Portfolio" )
    private String portfolio;
    /**
     * Use with available fluent helpers to apply the <b>Portfolio</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> PORTFOLIO =
        new TrsyPostgJrnlEntrItmField<String>("Portfolio");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>LetterOfCredit</b>
     * </p>
     *
     * @return Letter of Credit Number
     */
    @SerializedName( "LetterOfCredit" )
    @JsonProperty( "LetterOfCredit" )
    @Nullable
    @ODataField( odataName = "LetterOfCredit" )
    private String letterOfCredit;
    /**
     * Use with available fluent helpers to apply the <b>LetterOfCredit</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> LETTER_OF_CREDIT =
        new TrsyPostgJrnlEntrItmField<String>("LetterOfCredit");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HedgingClassification</b>
     * </p>
     *
     * @return Hedging Classification
     */
    @SerializedName( "HedgingClassification" )
    @JsonProperty( "HedgingClassification" )
    @Nullable
    @ODataField( odataName = "HedgingClassification" )
    private String hedgingClassification;
    /**
     * Use with available fluent helpers to apply the <b>HedgingClassification</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> HEDGING_CLASSIFICATION =
        new TrsyPostgJrnlEntrItmField<String>("HedgingClassification");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>HedgingClassificationName</b>
     * </p>
     *
     * @return Name of the Hedging Classification
     */
    @SerializedName( "HedgingClassificationName" )
    @JsonProperty( "HedgingClassificationName" )
    @Nullable
    @ODataField( odataName = "HedgingClassificationName" )
    private String hedgingClassificationName;
    /**
     * Use with available fluent helpers to apply the <b>HedgingClassificationName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> HEDGING_CLASSIFICATION_NAME =
        new TrsyPostgJrnlEntrItmField<String>("HedgingClassificationName");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>FinancialExposureItem</b>
     * </p>
     *
     * @return Exposure Item ID
     */
    @SerializedName( "FinancialExposureItem" )
    @JsonProperty( "FinancialExposureItem" )
    @Nullable
    @ODataField( odataName = "FinancialExposureItem" )
    private String financialExposureItem;
    /**
     * Use with available fluent helpers to apply the <b>FinancialExposureItem</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FINANCIAL_EXPOSURE_ITEM =
        new TrsyPostgJrnlEntrItmField<String>("FinancialExposureItem");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>FinancialExposureItemName</b>
     * </p>
     *
     * @return Exposure Item Description
     */
    @SerializedName( "FinancialExposureItemName" )
    @JsonProperty( "FinancialExposureItemName" )
    @Nullable
    @ODataField( odataName = "FinancialExposureItemName" )
    private String financialExposureItemName;
    /**
     * Use with available fluent helpers to apply the <b>FinancialExposureItemName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FINANCIAL_EXPOSURE_ITEM_NAME =
        new TrsyPostgJrnlEntrItmField<String>("FinancialExposureItemName");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>FinancialExposureSubItem</b>
     * </p>
     *
     * @return Exposure Subitem ID
     */
    @SerializedName( "FinancialExposureSubItem" )
    @JsonProperty( "FinancialExposureSubItem" )
    @Nullable
    @ODataField( odataName = "FinancialExposureSubItem" )
    private String financialExposureSubItem;
    /**
     * Use with available fluent helpers to apply the <b>FinancialExposureSubItem</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FINANCIAL_EXPOSURE_SUB_ITEM =
        new TrsyPostgJrnlEntrItmField<String>("FinancialExposureSubItem");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FinancialExposureSubItemName</b>
     * </p>
     *
     * @return Exposure Subitem Name
     */
    @SerializedName( "FinancialExposureSubItemName" )
    @JsonProperty( "FinancialExposureSubItemName" )
    @Nullable
    @ODataField( odataName = "FinancialExposureSubItemName" )
    private String financialExposureSubItemName;
    /**
     * Use with available fluent helpers to apply the <b>FinancialExposureSubItemName</b> field to query operations.
     *
     */
    public final static TrsyPostgJrnlEntrItmField<String> FINANCIAL_EXPOSURE_SUB_ITEM_NAME =
        new TrsyPostgJrnlEntrItmField<String>("FinancialExposureSubItemName");

    @Nonnull
    @Override
    public Class<TrsyPostgJrnlEntrItm> getType()
    {
        return TrsyPostgJrnlEntrItm.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>TrsyAccountingDocumentUUID</b>
     * </p>
     *
     * @param trsyAccountingDocumentUUID
     *            Object Identity in Database Format
     */
    public void setTrsyAccountingDocumentUUID( @Nullable final UUID trsyAccountingDocumentUUID )
    {
        rememberChangedField("TrsyAccountingDocumentUUID", this.trsyAccountingDocumentUUID);
        this.trsyAccountingDocumentUUID = trsyAccountingDocumentUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentItemRef</b>
     * </p>
     *
     * @param accountingDocumentItemRef
     *            Accounting Document Line Item Number
     */
    public void setAccountingDocumentItemRef( @Nullable final String accountingDocumentItemRef )
    {
        rememberChangedField("AccountingDocumentItemRef", this.accountingDocumentItemRef);
        this.accountingDocumentItemRef = accountingDocumentItemRef;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPositionContextUUID</b>
     * </p>
     *
     * @param trsyPositionContextUUID
     *            Object Identity in Database Format
     */
    public void setTrsyPositionContextUUID( @Nullable final UUID trsyPositionContextUUID )
    {
        rememberChangedField("TrsyPositionContextUUID", this.trsyPositionContextUUID);
        this.trsyPositionContextUUID = trsyPositionContextUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryBusinessTransStatus</b>
     * </p>
     *
     * @param treasuryBusinessTransStatus
     *            Posting Status
     */
    public void setTreasuryBusinessTransStatus( @Nullable final String treasuryBusinessTransStatus )
    {
        rememberChangedField("TreasuryBusinessTransStatus", this.treasuryBusinessTransStatus);
        this.treasuryBusinessTransStatus = treasuryBusinessTransStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryBusTransStatusName</b>
     * </p>
     *
     * @param treasuryBusTransStatusName
     *            Name of the Posting Status
     */
    public void setTreasuryBusTransStatusName( @Nullable final String treasuryBusTransStatusName )
    {
        rememberChangedField("TreasuryBusTransStatusName", this.treasuryBusTransStatusName);
        this.treasuryBusTransStatusName = treasuryBusTransStatusName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryUpdateType</b>
     * </p>
     *
     * @param treasuryUpdateType
     *            Update Type
     */
    public void setTreasuryUpdateType( @Nullable final String treasuryUpdateType )
    {
        rememberChangedField("TreasuryUpdateType", this.treasuryUpdateType);
        this.treasuryUpdateType = treasuryUpdateType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryUpdateTypeName</b>
     * </p>
     *
     * @param treasuryUpdateTypeName
     *            Name of the Update Type
     */
    public void setTreasuryUpdateTypeName( @Nullable final String treasuryUpdateTypeName )
    {
        rememberChangedField("TreasuryUpdateTypeName", this.treasuryUpdateTypeName);
        this.treasuryUpdateTypeName = treasuryUpdateTypeName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsUsedInPaymentTransaction</b>
     * </p>
     *
     * @param isUsedInPaymentTransaction
     *            Payment Transaction
     */
    public void setIsUsedInPaymentTransaction( @Nullable final Boolean isUsedInPaymentTransaction )
    {
        rememberChangedField("IsUsedInPaymentTransaction", this.isUsedInPaymentTransaction);
        this.isUsedInPaymentTransaction = isUsedInPaymentTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryGLAccountAssignmentRef</b>
     * </p>
     *
     * @param treasuryGLAccountAssignmentRef
     *            Account Assignment Reference of Position Management
     */
    public void setTreasuryGLAccountAssignmentRef( @Nullable final String treasuryGLAccountAssignmentRef )
    {
        rememberChangedField("TreasuryGLAccountAssignmentRef", this.treasuryGLAccountAssignmentRef);
        this.treasuryGLAccountAssignmentRef = treasuryGLAccountAssignmentRef;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryGLAccountAssignRefName</b>
     * </p>
     *
     * @param treasuryGLAccountAssignRefName
     *            Name of the Account Assignment Reference
     */
    public void setTreasuryGLAccountAssignRefName( @Nullable final String treasuryGLAccountAssignRefName )
    {
        rememberChangedField("TreasuryGLAccountAssignRefName", this.treasuryGLAccountAssignRefName);
        this.treasuryGLAccountAssignRefName = treasuryGLAccountAssignRefName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPostingCategory</b>
     * </p>
     *
     * @param treasuryPostingCategory
     *            Posting Category
     */
    public void setTreasuryPostingCategory( @Nullable final Short treasuryPostingCategory )
    {
        rememberChangedField("TreasuryPostingCategory", this.treasuryPostingCategory);
        this.treasuryPostingCategory = treasuryPostingCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPostingCategoryName</b>
     * </p>
     *
     * @param treasuryPostingCategoryName
     *            Name of the Posting Category
     */
    public void setTreasuryPostingCategoryName( @Nullable final String treasuryPostingCategoryName )
    {
        rememberChangedField("TreasuryPostingCategoryName", this.treasuryPostingCategoryName);
        this.treasuryPostingCategoryName = treasuryPostingCategoryName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryGLAccountSymbol</b>
     * </p>
     *
     * @param treasuryGLAccountSymbol
     *            Account Symbol for Account Assignment Reference
     */
    public void setTreasuryGLAccountSymbol( @Nullable final String treasuryGLAccountSymbol )
    {
        rememberChangedField("TreasuryGLAccountSymbol", this.treasuryGLAccountSymbol);
        this.treasuryGLAccountSymbol = treasuryGLAccountSymbol;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryGLAccountSymbolName</b>
     * </p>
     *
     * @param treasuryGLAccountSymbolName
     *            Name of the Account Symbol
     */
    public void setTreasuryGLAccountSymbolName( @Nullable final String treasuryGLAccountSymbolName )
    {
        rememberChangedField("TreasuryGLAccountSymbolName", this.treasuryGLAccountSymbolName);
        this.treasuryGLAccountSymbolName = treasuryGLAccountSymbolName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingKey</b>
     * </p>
     *
     * @param postingKey
     *            Posting Key
     */
    public void setPostingKey( @Nullable final String postingKey )
    {
        rememberChangedField("PostingKey", this.postingKey);
        this.postingKey = postingKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PostingKeyName</b>
     * </p>
     *
     * @param postingKeyName
     *            Posting Key Name
     */
    public void setPostingKeyName( @Nullable final String postingKeyName )
    {
        rememberChangedField("PostingKeyName", this.postingKeyName);
        this.postingKeyName = postingKeyName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account Number
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PositionCurrency</b>
     * </p>
     *
     * @param positionCurrency
     *            Position Currency
     */
    public void setPositionCurrency( @Nullable final String positionCurrency )
    {
        rememberChangedField("PositionCurrency", this.positionCurrency);
        this.positionCurrency = positionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 22, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInPositionCurrency</b>
     * </p>
     *
     * @param amountInPositionCurrency
     *            Amount in Position Currency
     */
    public void setAmountInPositionCurrency( @Nullable final BigDecimal amountInPositionCurrency )
    {
        rememberChangedField("AmountInPositionCurrency", this.amountInPositionCurrency);
        this.amountInPositionCurrency = amountInPositionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @param companyCodeCurrency
     *            Local Currency
     */
    public void setCompanyCodeCurrency( @Nullable final String companyCodeCurrency )
    {
        rememberChangedField("CompanyCodeCurrency", this.companyCodeCurrency);
        this.companyCodeCurrency = companyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 22, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInCompanyCodeCurrency</b>
     * </p>
     *
     * @param amountInCompanyCodeCurrency
     *            Amount (Local Currency)
     */
    public void setAmountInCompanyCodeCurrency( @Nullable final BigDecimal amountInCompanyCodeCurrency )
    {
        rememberChangedField("AmountInCompanyCodeCurrency", this.amountInCompanyCodeCurrency);
        this.amountInCompanyCodeCurrency = amountInCompanyCodeCurrency;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryTransactionFlow</b>
     * </p>
     *
     * @param treasuryTransactionFlow
     *            Number of a Distributor Flow
     */
    public void setTreasuryTransactionFlow( @Nullable final Integer treasuryTransactionFlow )
    {
        rememberChangedField("TreasuryTransactionFlow", this.treasuryTransactionFlow);
        this.treasuryTransactionFlow = treasuryTransactionFlow;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @param accountingDocument
     *            Document Number of an Accounting Document
     */
    public void setAccountingDocument( @Nullable final String accountingDocument )
    {
        rememberChangedField("AccountingDocument", this.accountingDocument);
        this.accountingDocument = accountingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocument</b>
     * </p>
     *
     * @param reverseDocument
     *            Reverse Document
     */
    public void setReverseDocument( @Nullable final String reverseDocument )
    {
        rememberChangedField("ReverseDocument", this.reverseDocument);
        this.reverseDocument = reverseDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JournalEntryType</b>
     * </p>
     *
     * @param journalEntryType
     *            Document Type
     */
    public void setJournalEntryType( @Nullable final String journalEntryType )
    {
        rememberChangedField("JournalEntryType", this.journalEntryType);
        this.journalEntryType = journalEntryType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentTypeName</b>
     * </p>
     *
     * @param accountingDocumentTypeName
     *            Document Type Name
     */
    public void setAccountingDocumentTypeName( @Nullable final String accountingDocumentTypeName )
    {
        rememberChangedField("AccountingDocumentTypeName", this.accountingDocumentTypeName);
        this.accountingDocumentTypeName = accountingDocumentTypeName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PaymentDate</b>
     * </p>
     *
     * @param paymentDate
     *            Payment Date
     */
    public void setPaymentDate( @Nullable final LocalDateTime paymentDate )
    {
        rememberChangedField("PaymentDate", this.paymentDate);
        this.paymentDate = paymentDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment Key
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @param paymentMethod
     *            Payment Method
     */
    public void setPaymentMethod( @Nullable final String paymentMethod )
    {
        rememberChangedField("PaymentMethod", this.paymentMethod);
        this.paymentMethod = paymentMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethodName</b>
     * </p>
     *
     * @param paymentMethodName
     *            Payment Method Name
     */
    public void setPaymentMethodName( @Nullable final String paymentMethodName )
    {
        rememberChangedField("PaymentMethodName", this.paymentMethodName);
        this.paymentMethodName = paymentMethodName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethodSupplement</b>
     * </p>
     *
     * @param paymentMethodSupplement
     *            Payment method supplement
     */
    public void setPaymentMethodSupplement( @Nullable final String paymentMethodSupplement )
    {
        rememberChangedField("PaymentMethodSupplement", this.paymentMethodSupplement);
        this.paymentMethodSupplement = paymentMethodSupplement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethodSupplementName</b>
     * </p>
     *
     * @param paymentMethodSupplementName
     *            Name of the Payment Method Supplement
     */
    public void setPaymentMethodSupplementName( @Nullable final String paymentMethodSupplementName )
    {
        rememberChangedField("PaymentMethodSupplementName", this.paymentMethodSupplementName);
        this.paymentMethodSupplementName = paymentMethodSupplementName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentBlockingReason</b>
     * </p>
     *
     * @param paymentBlockingReason
     *            Payment Block Key
     */
    public void setPaymentBlockingReason( @Nullable final String paymentBlockingReason )
    {
        rememberChangedField("PaymentBlockingReason", this.paymentBlockingReason);
        this.paymentBlockingReason = paymentBlockingReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PaymentBlockingReasonName</b>
     * </p>
     *
     * @param paymentBlockingReasonName
     *            Name of a Payment Block Reason
     */
    public void setPaymentBlockingReasonName( @Nullable final String paymentBlockingReasonName )
    {
        rememberChangedField("PaymentBlockingReasonName", this.paymentBlockingReasonName);
        this.paymentBlockingReasonName = paymentBlockingReasonName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>PayerPayeeFullName</b>
     * </p>
     *
     * @param payerPayeeFullName
     *            Full Name of the Payer / Payee
     */
    public void setPayerPayeeFullName( @Nullable final String payerPayeeFullName )
    {
        rememberChangedField("PayerPayeeFullName", this.payerPayeeFullName);
        this.payerPayeeFullName = payerPayeeFullName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     *
     * @param houseBank
     *            Short Key for Own House Bank
     */
    public void setHouseBank( @Nullable final String houseBank )
    {
        rememberChangedField("HouseBank", this.houseBank);
        this.houseBank = houseBank;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StateCentralBankPaymentReason</b>
     * </p>
     *
     * @param stateCentralBankPaymentReason
     *            State Central Bank Indicator
     */
    public void setStateCentralBankPaymentReason( @Nullable final String stateCentralBankPaymentReason )
    {
        rememberChangedField("StateCentralBankPaymentReason", this.stateCentralBankPaymentReason);
        this.stateCentralBankPaymentReason = stateCentralBankPaymentReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingCountry</b>
     * </p>
     *
     * @param supplyingCountry
     *            Supplying Country/Region
     */
    public void setSupplyingCountry( @Nullable final String supplyingCountry )
    {
        rememberChangedField("SupplyingCountry", this.supplyingCountry);
        this.supplyingCountry = supplyingCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CountryName</b>
     * </p>
     *
     * @param countryName
     *            Country/Region Name
     */
    public void setCountryName( @Nullable final String countryName )
    {
        rememberChangedField("CountryName", this.countryName);
        this.countryName = countryName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @param assignmentReference
     *            Assignment number
     */
    public void setAssignmentReference( @Nullable final String assignmentReference )
    {
        rememberChangedField("AssignmentReference", this.assignmentReference);
        this.assignmentReference = assignmentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>JournalEntryItemText</b>
     * </p>
     *
     * @param journalEntryItemText
     *            Journal Entry Item Text
     */
    public void setJournalEntryItemText( @Nullable final String journalEntryItemText )
    {
        rememberChangedField("JournalEntryItemText", this.journalEntryItemText);
        this.journalEntryItemText = journalEntryItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessAreaName</b>
     * </p>
     *
     * @param businessAreaName
     *            Business Area Description
     */
    public void setBusinessAreaName( @Nullable final String businessAreaName )
    {
        rememberChangedField("BusinessAreaName", this.businessAreaName);
        this.businessAreaName = businessAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @param financialTransactionType
     *            Transaction Type (FI)
     */
    public void setFinancialTransactionType( @Nullable final String financialTransactionType )
    {
        rememberChangedField("FinancialTransactionType", this.financialTransactionType);
        this.financialTransactionType = financialTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionTypeName</b>
     * </p>
     *
     * @param financialTransactionTypeName
     *            Name of a Transaction Type (FI)
     */
    public void setFinancialTransactionTypeName( @Nullable final String financialTransactionTypeName )
    {
        rememberChangedField("FinancialTransactionTypeName", this.financialTransactionTypeName);
        this.financialTransactionTypeName = financialTransactionTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     *
     * @param partnerCompany
     *            Company ID
     */
    public void setPartnerCompany( @Nullable final String partnerCompany )
    {
        rememberChangedField("PartnerCompany", this.partnerCompany);
        this.partnerCompany = partnerCompany;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CompanyName</b>
     * </p>
     *
     * @param companyName
     *            Company Name
     */
    public void setCompanyName( @Nullable final String companyName )
    {
        rememberChangedField("CompanyName", this.companyName);
        this.companyName = companyName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Counterparty</b>
     * </p>
     *
     * @param counterparty
     *            Counterparty Number
     */
    public void setCounterparty( @Nullable final String counterparty )
    {
        rememberChangedField("Counterparty", this.counterparty);
        this.counterparty = counterparty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CounterpartyFullName</b>
     * </p>
     *
     * @param counterpartyFullName
     *            Full Name of the Counterparty
     */
    public void setCounterpartyFullName( @Nullable final String counterpartyFullName )
    {
        rememberChangedField("CounterpartyFullName", this.counterpartyFullName);
        this.counterpartyFullName = counterpartyFullName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Issuer</b>
     * </p>
     *
     * @param issuer
     *            Issuer Identity Key
     */
    public void setIssuer( @Nullable final String issuer )
    {
        rememberChangedField("Issuer", this.issuer);
        this.issuer = issuer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>IssuerFullName</b>
     * </p>
     *
     * @param issuerFullName
     *            Full Name of the Issuer
     */
    public void setIssuerFullName( @Nullable final String issuerFullName )
    {
        rememberChangedField("IssuerFullName", this.issuerFullName);
        this.issuerFullName = issuerFullName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLCode</b>
     * </p>
     *
     * @param specialGLCode
     *            Special G/L Indicator
     */
    public void setSpecialGLCode( @Nullable final String specialGLCode )
    {
        rememberChangedField("SpecialGLCode", this.specialGLCode);
        this.specialGLCode = specialGLCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLCodeName</b>
     * </p>
     *
     * @param specialGLCodeName
     *            Name of a Special GL Code
     */
    public void setSpecialGLCodeName( @Nullable final String specialGLCodeName )
    {
        rememberChangedField("SpecialGLCodeName", this.specialGLCodeName);
        this.specialGLCodeName = specialGLCodeName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryBusinessTransaction</b>
     * </p>
     *
     * @param treasuryBusinessTransaction
     *            Identifier of the Distributor Business Transaction
     */
    public void setTreasuryBusinessTransaction( @Nullable final UUID treasuryBusinessTransaction )
    {
        rememberChangedField("TreasuryBusinessTransaction", this.treasuryBusinessTransaction);
        this.treasuryBusinessTransaction = treasuryBusinessTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryValuationArea</b>
     * </p>
     *
     * @param treasuryValuationArea
     *            Treasury Valuation Area
     */
    public void setTreasuryValuationArea( @Nullable final String treasuryValuationArea )
    {
        rememberChangedField("TreasuryValuationArea", this.treasuryValuationArea);
        this.treasuryValuationArea = treasuryValuationArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryValuationAreaName</b>
     * </p>
     *
     * @param treasuryValuationAreaName
     *            Name of the Valuation Area
     */
    public void setTreasuryValuationAreaName( @Nullable final String treasuryValuationAreaName )
    {
        rememberChangedField("TreasuryValuationAreaName", this.treasuryValuationAreaName);
        this.treasuryValuationAreaName = treasuryValuationAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @param referenceDocument
     *            Reference document number
     */
    public void setReferenceDocument( @Nullable final String referenceDocument )
    {
        rememberChangedField("ReferenceDocument", this.referenceDocument);
        this.referenceDocument = referenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentContext</b>
     * </p>
     *
     * @param referenceDocumentContext
     *            Reference Organizational Units
     */
    public void setReferenceDocumentContext( @Nullable final String referenceDocumentContext )
    {
        rememberChangedField("ReferenceDocumentContext", this.referenceDocumentContext);
        this.referenceDocumentContext = referenceDocumentContext;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date in the Document
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @param fiscalPeriod
     *            Fiscal period
     */
    public void setFiscalPeriod( @Nullable final String fiscalPeriod )
    {
        rememberChangedField("FiscalPeriod", this.fiscalPeriod);
        this.fiscalPeriod = fiscalPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversalReferenceDocument</b>
     * </p>
     *
     * @param reversalReferenceDocument
     *            Reversal: Reference Document No. of Document to Be Reversed
     */
    public void setReversalReferenceDocument( @Nullable final String reversalReferenceDocument )
    {
        rememberChangedField("ReversalReferenceDocument", this.reversalReferenceDocument);
        this.reversalReferenceDocument = reversalReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversalReferenceDocumentCntxt</b>
     * </p>
     *
     * @param reversalReferenceDocumentCntxt
     *            Reversal: Reference Organizations of Document to Be Reversed
     */
    public void setReversalReferenceDocumentCntxt( @Nullable final String reversalReferenceDocumentCntxt )
    {
        rememberChangedField("ReversalReferenceDocumentCntxt", this.reversalReferenceDocumentCntxt);
        this.reversalReferenceDocumentCntxt = reversalReferenceDocumentCntxt;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocumentPostingDate</b>
     * </p>
     *
     * @param reverseDocumentPostingDate
     *            Reverse Document Posting Date
     */
    public void setReverseDocumentPostingDate( @Nullable final LocalDateTime reverseDocumentPostingDate )
    {
        rememberChangedField("ReverseDocumentPostingDate", this.reverseDocumentPostingDate);
        this.reverseDocumentPostingDate = reverseDocumentPostingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocumentFiscalPeriod</b>
     * </p>
     *
     * @param reverseDocumentFiscalPeriod
     *            Reverse Document Fiscal Period
     */
    public void setReverseDocumentFiscalPeriod( @Nullable final String reverseDocumentFiscalPeriod )
    {
        rememberChangedField("ReverseDocumentFiscalPeriod", this.reverseDocumentFiscalPeriod);
        this.reverseDocumentFiscalPeriod = reverseDocumentFiscalPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocumentFiscalYear</b>
     * </p>
     *
     * @param reverseDocumentFiscalYear
     *            Reverse Document Fiscal Year
     */
    public void setReverseDocumentFiscalYear( @Nullable final String reverseDocumentFiscalYear )
    {
        rememberChangedField("ReverseDocumentFiscalYear", this.reverseDocumentFiscalYear);
        this.reverseDocumentFiscalYear = reverseDocumentFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @param ledger
     *            Ledger
     */
    public void setLedger( @Nullable final String ledger )
    {
        rememberChangedField("Ledger", this.ledger);
        this.ledger = ledger;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @param documentDate
     *            Document Date in Document
     */
    public void setDocumentDate( @Nullable final LocalDateTime documentDate )
    {
        rememberChangedField("DocumentDate", this.documentDate);
        this.documentDate = documentDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AccountingPrinciple</b>
     * </p>
     *
     * @param accountingPrinciple
     *            Accounting Principle
     */
    public void setAccountingPrinciple( @Nullable final String accountingPrinciple )
    {
        rememberChangedField("AccountingPrinciple", this.accountingPrinciple);
        this.accountingPrinciple = accountingPrinciple;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryAcctgPostingCategory</b>
     * </p>
     *
     * @param treasuryAcctgPostingCategory
     *            Update to Financial Accounting Category
     */
    public void setTreasuryAcctgPostingCategory( @Nullable final String treasuryAcctgPostingCategory )
    {
        rememberChangedField("TreasuryAcctgPostingCategory", this.treasuryAcctgPostingCategory);
        this.treasuryAcctgPostingCategory = treasuryAcctgPostingCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryBusinessTransCategory</b>
     * </p>
     *
     * @param treasuryBusinessTransCategory
     *            Business Transaction Category
     */
    public void setTreasuryBusinessTransCategory( @Nullable final String treasuryBusinessTransCategory )
    {
        rememberChangedField("TreasuryBusinessTransCategory", this.treasuryBusinessTransCategory);
        this.treasuryBusinessTransCategory = treasuryBusinessTransCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryBusTransCategoryName</b>
     * </p>
     *
     * @param treasuryBusTransCategoryName
     *            Name of Business Transaction Category
     */
    public void setTreasuryBusTransCategoryName( @Nullable final String treasuryBusTransCategoryName )
    {
        rememberChangedField("TreasuryBusTransCategoryName", this.treasuryBusTransCategoryName);
        this.treasuryBusTransCategoryName = treasuryBusTransCategoryName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentHeaderText</b>
     * </p>
     *
     * @param documentHeaderText
     *            Document Header Text
     */
    public void setDocumentHeaderText( @Nullable final String documentHeaderText )
    {
        rememberChangedField("DocumentHeaderText", this.documentHeaderText);
        this.documentHeaderText = documentHeaderText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReferenceID</b>
     * </p>
     *
     * @param documentReferenceID
     *            Reference Document Number
     */
    public void setDocumentReferenceID( @Nullable final String documentReferenceID )
    {
        rememberChangedField("DocumentReferenceID", this.documentReferenceID);
        this.documentReferenceID = documentReferenceID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrValuationClass</b>
     * </p>
     *
     * @param financialInstrValuationClass
     *            Financial Instrument Valuation Class
     */
    public void setFinancialInstrValuationClass( @Nullable final String financialInstrValuationClass )
    {
        rememberChangedField("FinancialInstrValuationClass", this.financialInstrValuationClass);
        this.financialInstrValuationClass = financialInstrValuationClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrValClassName</b>
     * </p>
     *
     * @param financialInstrValClassName
     *            Name of the Financial Instrument Valuation Class
     */
    public void setFinancialInstrValClassName( @Nullable final String financialInstrValClassName )
    {
        rememberChangedField("FinancialInstrValClassName", this.financialInstrValClassName);
        this.financialInstrValClassName = financialInstrValClassName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryValuationClass</b>
     * </p>
     *
     * @param treasuryValuationClass
     *            Valuation Class
     */
    public void setTreasuryValuationClass( @Nullable final String treasuryValuationClass )
    {
        rememberChangedField("TreasuryValuationClass", this.treasuryValuationClass);
        this.treasuryValuationClass = treasuryValuationClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryValuationClassName</b>
     * </p>
     *
     * @param treasuryValuationClassName
     *            Name of the Valuation Class
     */
    public void setTreasuryValuationClassName( @Nullable final String treasuryValuationClassName )
    {
        rememberChangedField("TreasuryValuationClassName", this.treasuryValuationClassName);
        this.treasuryValuationClassName = treasuryValuationClassName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrumentProductType</b>
     * </p>
     *
     * @param financialInstrumentProductType
     *            Product Type
     */
    public void setFinancialInstrumentProductType( @Nullable final String financialInstrumentProductType )
    {
        rememberChangedField("FinancialInstrumentProductType", this.financialInstrumentProductType);
        this.financialInstrumentProductType = financialInstrumentProductType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrProdTypeName</b>
     * </p>
     *
     * @param financialInstrProdTypeName
     *            Name of the Product Type
     */
    public void setFinancialInstrProdTypeName( @Nullable final String financialInstrProdTypeName )
    {
        rememberChangedField("FinancialInstrProdTypeName", this.financialInstrProdTypeName);
        this.financialInstrProdTypeName = financialInstrProdTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SecurityAccount</b>
     * </p>
     *
     * @param securityAccount
     *            Security Account
     */
    public void setSecurityAccount( @Nullable final String securityAccount )
    {
        rememberChangedField("SecurityAccount", this.securityAccount);
        this.securityAccount = securityAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SecurityAccountName</b>
     * </p>
     *
     * @param securityAccountName
     *            Name of the Security Account
     */
    public void setSecurityAccountName( @Nullable final String securityAccountName )
    {
        rememberChangedField("SecurityAccountName", this.securityAccountName);
        this.securityAccountName = securityAccountName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>SecurityClass</b>
     * </p>
     *
     * @param securityClass
     *            Security Class
     */
    public void setSecurityClass( @Nullable final String securityClass )
    {
        rememberChangedField("SecurityClass", this.securityClass);
        this.securityClass = securityClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>SecurityClassName</b>
     * </p>
     *
     * @param securityClassName
     *            Name of the Security Class
     */
    public void setSecurityClassName( @Nullable final String securityClassName )
    {
        rememberChangedField("SecurityClassName", this.securityClassName);
        this.securityClassName = securityClassName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SecurityClassDescription</b>
     * </p>
     *
     * @param securityClassDescription
     *            Description of the Security Class
     */
    public void setSecurityClassDescription( @Nullable final String securityClassDescription )
    {
        rememberChangedField("SecurityClassDescription", this.securityClassDescription);
        this.securityClassDescription = securityClassDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DifferentiationPortfolio</b>
     * </p>
     *
     * @param differentiationPortfolio
     *            Portfolio as Differentiation Characteristic
     */
    public void setDifferentiationPortfolio( @Nullable final String differentiationPortfolio )
    {
        rememberChangedField("DifferentiationPortfolio", this.differentiationPortfolio);
        this.differentiationPortfolio = differentiationPortfolio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>DifferentiationPortfolioName</b>
     * </p>
     *
     * @param differentiationPortfolioName
     *            Name of the Portfolio as Differentiation Characteristic
     */
    public void setDifferentiationPortfolioName( @Nullable final String differentiationPortfolioName )
    {
        rememberChangedField("DifferentiationPortfolioName", this.differentiationPortfolioName);
        this.differentiationPortfolioName = differentiationPortfolioName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SecurityAccountGroup</b>
     * </p>
     *
     * @param securityAccountGroup
     *            Securities Account Group
     */
    public void setSecurityAccountGroup( @Nullable final String securityAccountGroup )
    {
        rememberChangedField("SecurityAccountGroup", this.securityAccountGroup);
        this.securityAccountGroup = securityAccountGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SecurityAccountGroupName</b>
     * </p>
     *
     * @param securityAccountGroupName
     *            Name of Securities Account Group
     */
    public void setSecurityAccountGroupName( @Nullable final String securityAccountGroupName )
    {
        rememberChangedField("SecurityAccountGroupName", this.securityAccountGroupName);
        this.securityAccountGroupName = securityAccountGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>LoanContract</b>
     * </p>
     *
     * @param loanContract
     *            Loan Contract Number
     */
    public void setLoanContract( @Nullable final String loanContract )
    {
        rememberChangedField("LoanContract", this.loanContract);
        this.loanContract = loanContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>LoanContractName</b>
     * </p>
     *
     * @param loanContractName
     *            Name of the Loan Contract
     */
    public void setLoanContractName( @Nullable final String loanContractName )
    {
        rememberChangedField("LoanContractName", this.loanContractName);
        this.loanContractName = loanContractName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPositionAccount</b>
     * </p>
     *
     * @param treasuryPositionAccount
     *            Futures Account for Listed Options and Futures
     */
    public void setTreasuryPositionAccount( @Nullable final String treasuryPositionAccount )
    {
        rememberChangedField("TreasuryPositionAccount", this.treasuryPositionAccount);
        this.treasuryPositionAccount = treasuryPositionAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPositionAccountName</b>
     * </p>
     *
     * @param treasuryPositionAccountName
     *            Name of the Futures Account for Listed Options and Futures
     */
    public void setTreasuryPositionAccountName( @Nullable final String treasuryPositionAccountName )
    {
        rememberChangedField("TreasuryPositionAccountName", this.treasuryPositionAccountName);
        this.treasuryPositionAccountName = treasuryPositionAccountName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryPositionLongShortCode</b>
     * </p>
     *
     * @param treasuryPositionLongShortCode
     *            Code: Long or Short Position
     */
    public void setTreasuryPositionLongShortCode( @Nullable final String treasuryPositionLongShortCode )
    {
        rememberChangedField("TreasuryPositionLongShortCode", this.treasuryPositionLongShortCode);
        this.treasuryPositionLongShortCode = treasuryPositionLongShortCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            Work Breakdown Structure Element (WBS Element) Edited
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WBSDescription</b>
     * </p>
     *
     * @param wBSDescription
     *            WBS Element Name
     */
    public void setWBSDescription( @Nullable final String wBSDescription )
    {
        rememberChangedField("WBSDescription", this.wBSDescription);
        this.wBSDescription = wBSDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DifferentiationCostCenter</b>
     * </p>
     *
     * @param differentiationCostCenter
     *            Cost Center
     */
    public void setDifferentiationCostCenter( @Nullable final String differentiationCostCenter )
    {
        rememberChangedField("DifferentiationCostCenter", this.differentiationCostCenter);
        this.differentiationCostCenter = differentiationCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm1</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm1
     *            Custom Differentiation Term 1 (Value)
     */
    public void setTrsyPosCustomDiffntnTerm1( @Nullable final String trsyPosCustomDiffntnTerm1 )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm1", this.trsyPosCustomDiffntnTerm1);
        this.trsyPosCustomDiffntnTerm1 = trsyPosCustomDiffntnTerm1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm1Name</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm1Name
     *            Custom Differentiation Term 1 (Name)
     */
    public void setTrsyPosCustomDiffntnTerm1Name( @Nullable final String trsyPosCustomDiffntnTerm1Name )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm1Name", this.trsyPosCustomDiffntnTerm1Name);
        this.trsyPosCustomDiffntnTerm1Name = trsyPosCustomDiffntnTerm1Name;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm2</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm2
     *            Custom Differentiation Term 2 (Value)
     */
    public void setTrsyPosCustomDiffntnTerm2( @Nullable final String trsyPosCustomDiffntnTerm2 )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm2", this.trsyPosCustomDiffntnTerm2);
        this.trsyPosCustomDiffntnTerm2 = trsyPosCustomDiffntnTerm2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm2Name</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm2Name
     *            Custom Differentiation Term 2 (Name)
     */
    public void setTrsyPosCustomDiffntnTerm2Name( @Nullable final String trsyPosCustomDiffntnTerm2Name )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm2Name", this.trsyPosCustomDiffntnTerm2Name);
        this.trsyPosCustomDiffntnTerm2Name = trsyPosCustomDiffntnTerm2Name;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm3</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm3
     *            Custom Differentiation Term 3 (Value)
     */
    public void setTrsyPosCustomDiffntnTerm3( @Nullable final String trsyPosCustomDiffntnTerm3 )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm3", this.trsyPosCustomDiffntnTerm3);
        this.trsyPosCustomDiffntnTerm3 = trsyPosCustomDiffntnTerm3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm3Name</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm3Name
     *            Custom Differentiation Term 3 (Name)
     */
    public void setTrsyPosCustomDiffntnTerm3Name( @Nullable final String trsyPosCustomDiffntnTerm3Name )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm3Name", this.trsyPosCustomDiffntnTerm3Name);
        this.trsyPosCustomDiffntnTerm3Name = trsyPosCustomDiffntnTerm3Name;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm4</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm4
     *            Custom Differentiation Term 4 (Value)
     */
    public void setTrsyPosCustomDiffntnTerm4( @Nullable final String trsyPosCustomDiffntnTerm4 )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm4", this.trsyPosCustomDiffntnTerm4);
        this.trsyPosCustomDiffntnTerm4 = trsyPosCustomDiffntnTerm4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm4Name</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm4Name
     *            Custom Differentiation Term 4 (Name)
     */
    public void setTrsyPosCustomDiffntnTerm4Name( @Nullable final String trsyPosCustomDiffntnTerm4Name )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm4Name", this.trsyPosCustomDiffntnTerm4Name);
        this.trsyPosCustomDiffntnTerm4Name = trsyPosCustomDiffntnTerm4Name;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm5</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm5
     *            Custom Differentiation Term 5 (Value)
     */
    public void setTrsyPosCustomDiffntnTerm5( @Nullable final String trsyPosCustomDiffntnTerm5 )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm5", this.trsyPosCustomDiffntnTerm5);
        this.trsyPosCustomDiffntnTerm5 = trsyPosCustomDiffntnTerm5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TrsyPosCustomDiffntnTerm5Name</b>
     * </p>
     *
     * @param trsyPosCustomDiffntnTerm5Name
     *            Custom Differentiation Term 5 (Name)
     */
    public void setTrsyPosCustomDiffntnTerm5Name( @Nullable final String trsyPosCustomDiffntnTerm5Name )
    {
        rememberChangedField("TrsyPosCustomDiffntnTerm5Name", this.trsyPosCustomDiffntnTerm5Name);
        this.trsyPosCustomDiffntnTerm5Name = trsyPosCustomDiffntnTerm5Name;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralClearingAccount</b>
     * </p>
     *
     * @param centralClearingAccount
     *            Central Clearing Account
     */
    public void setCentralClearingAccount( @Nullable final String centralClearingAccount )
    {
        rememberChangedField("CentralClearingAccount", this.centralClearingAccount);
        this.centralClearingAccount = centralClearingAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CentralClearingAccountName</b>
     * </p>
     *
     * @param centralClearingAccountName
     *            Name of the Central Clearing Account
     */
    public void setCentralClearingAccountName( @Nullable final String centralClearingAccountName )
    {
        rememberChangedField("CentralClearingAccountName", this.centralClearingAccountName);
        this.centralClearingAccountName = centralClearingAccountName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>ActivityFinancialTransaction</b>
     * </p>
     *
     * @param activityFinancialTransaction
     *            Activity-Triggering Financial Transaction
     */
    public void setActivityFinancialTransaction( @Nullable final String activityFinancialTransaction )
    {
        rememberChangedField("ActivityFinancialTransaction", this.activityFinancialTransaction);
        this.activityFinancialTransaction = activityFinancialTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransaction</b>
     * </p>
     *
     * @param financialTransaction
     *            Financial Transaction
     */
    public void setFinancialTransaction( @Nullable final String financialTransaction )
    {
        rememberChangedField("FinancialTransaction", this.financialTransaction);
        this.financialTransaction = financialTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Entered By
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            First Entered On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Employee ID
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Edited On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountLongName</b>
     * </p>
     *
     * @param gLAccountLongName
     *            Description of a GL Account
     */
    public void setGLAccountLongName( @Nullable final String gLAccountLongName )
    {
        rememberChangedField("GLAccountLongName", this.gLAccountLongName);
        this.gLAccountLongName = gLAccountLongName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterName</b>
     * </p>
     *
     * @param costCenterName
     *            Name of a Cost Center
     */
    public void setCostCenterName( @Nullable final String costCenterName )
    {
        rememberChangedField("CostCenterName", this.costCenterName);
        this.costCenterName = costCenterName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrTransactionType</b>
     * </p>
     *
     * @param financialInstrTransactionType
     *            Financial Instrument Transaction Type
     */
    public void setFinancialInstrTransactionType( @Nullable final String financialInstrTransactionType )
    {
        rememberChangedField("FinancialInstrTransactionType", this.financialInstrTransactionType);
        this.financialInstrTransactionType = financialInstrTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrTransTypeName</b>
     * </p>
     *
     * @param financialInstrTransTypeName
     *            Name of Financial Instrument Transaction Type
     */
    public void setFinancialInstrTransTypeName( @Nullable final String financialInstrTransTypeName )
    {
        rememberChangedField("FinancialInstrTransTypeName", this.financialInstrTransTypeName);
        this.financialInstrTransTypeName = financialInstrTransTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrCharacteristic</b>
     * </p>
     *
     * @param financialInstrCharacteristic
     *            Free Characteristic of Financial Transaction
     */
    public void setFinancialInstrCharacteristic( @Nullable final String financialInstrCharacteristic )
    {
        rememberChangedField("FinancialInstrCharacteristic", this.financialInstrCharacteristic);
        this.financialInstrCharacteristic = financialInstrCharacteristic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrumentReference</b>
     * </p>
     *
     * @param financialInstrumentReference
     *            Free Internal Reference of Financial Transaction
     */
    public void setFinancialInstrumentReference( @Nullable final String financialInstrumentReference )
    {
        rememberChangedField("FinancialInstrumentReference", this.financialInstrumentReference);
        this.financialInstrumentReference = financialInstrumentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>FinancialInstrumentAssignment</b>
     * </p>
     *
     * @param financialInstrumentAssignment
     *            Free Assignment of Financial Transaction
     */
    public void setFinancialInstrumentAssignment( @Nullable final String financialInstrumentAssignment )
    {
        rememberChangedField("FinancialInstrumentAssignment", this.financialInstrumentAssignment);
        this.financialInstrumentAssignment = financialInstrumentAssignment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Portfolio</b>
     * </p>
     *
     * @param portfolio
     *            Portfolio
     */
    public void setPortfolio( @Nullable final String portfolio )
    {
        rememberChangedField("Portfolio", this.portfolio);
        this.portfolio = portfolio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>LetterOfCredit</b>
     * </p>
     *
     * @param letterOfCredit
     *            Letter of Credit Number
     */
    public void setLetterOfCredit( @Nullable final String letterOfCredit )
    {
        rememberChangedField("LetterOfCredit", this.letterOfCredit);
        this.letterOfCredit = letterOfCredit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HedgingClassification</b>
     * </p>
     *
     * @param hedgingClassification
     *            Hedging Classification
     */
    public void setHedgingClassification( @Nullable final String hedgingClassification )
    {
        rememberChangedField("HedgingClassification", this.hedgingClassification);
        this.hedgingClassification = hedgingClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>HedgingClassificationName</b>
     * </p>
     *
     * @param hedgingClassificationName
     *            Name of the Hedging Classification
     */
    public void setHedgingClassificationName( @Nullable final String hedgingClassificationName )
    {
        rememberChangedField("HedgingClassificationName", this.hedgingClassificationName);
        this.hedgingClassificationName = hedgingClassificationName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>FinancialExposureItem</b>
     * </p>
     *
     * @param financialExposureItem
     *            Exposure Item ID
     */
    public void setFinancialExposureItem( @Nullable final String financialExposureItem )
    {
        rememberChangedField("FinancialExposureItem", this.financialExposureItem);
        this.financialExposureItem = financialExposureItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>FinancialExposureItemName</b>
     * </p>
     *
     * @param financialExposureItemName
     *            Exposure Item Description
     */
    public void setFinancialExposureItemName( @Nullable final String financialExposureItemName )
    {
        rememberChangedField("FinancialExposureItemName", this.financialExposureItemName);
        this.financialExposureItemName = financialExposureItemName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>FinancialExposureSubItem</b>
     * </p>
     *
     * @param financialExposureSubItem
     *            Exposure Subitem ID
     */
    public void setFinancialExposureSubItem( @Nullable final String financialExposureSubItem )
    {
        rememberChangedField("FinancialExposureSubItem", this.financialExposureSubItem);
        this.financialExposureSubItem = financialExposureSubItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FinancialExposureSubItemName</b>
     * </p>
     *
     * @param financialExposureSubItemName
     *            Exposure Subitem Name
     */
    public void setFinancialExposureSubItemName( @Nullable final String financialExposureSubItemName )
    {
        rememberChangedField("FinancialExposureSubItemName", this.financialExposureSubItemName);
        this.financialExposureSubItemName = financialExposureSubItemName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_TrsyPostgJrnlEntrItm";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("TrsyAccountingDocumentUUID", getTrsyAccountingDocumentUUID());
        result.put("AccountingDocumentItemRef", getAccountingDocumentItemRef());
        result.put("TrsyPositionContextUUID", getTrsyPositionContextUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("TrsyAccountingDocumentUUID", getTrsyAccountingDocumentUUID());
        values.put("AccountingDocumentItemRef", getAccountingDocumentItemRef());
        values.put("TrsyPositionContextUUID", getTrsyPositionContextUUID());
        values.put("TreasuryBusinessTransStatus", getTreasuryBusinessTransStatus());
        values.put("TreasuryBusTransStatusName", getTreasuryBusTransStatusName());
        values.put("TreasuryUpdateType", getTreasuryUpdateType());
        values.put("TreasuryUpdateTypeName", getTreasuryUpdateTypeName());
        values.put("IsUsedInPaymentTransaction", getIsUsedInPaymentTransaction());
        values.put("TreasuryGLAccountAssignmentRef", getTreasuryGLAccountAssignmentRef());
        values.put("TreasuryGLAccountAssignRefName", getTreasuryGLAccountAssignRefName());
        values.put("TreasuryPostingCategory", getTreasuryPostingCategory());
        values.put("TreasuryPostingCategoryName", getTreasuryPostingCategoryName());
        values.put("TreasuryGLAccountSymbol", getTreasuryGLAccountSymbol());
        values.put("TreasuryGLAccountSymbolName", getTreasuryGLAccountSymbolName());
        values.put("PostingKey", getPostingKey());
        values.put("PostingKeyName", getPostingKeyName());
        values.put("GLAccount", getGLAccount());
        values.put("PositionCurrency", getPositionCurrency());
        values.put("AmountInPositionCurrency", getAmountInPositionCurrency());
        values.put("CompanyCodeCurrency", getCompanyCodeCurrency());
        values.put("AmountInCompanyCodeCurrency", getAmountInCompanyCodeCurrency());
        values.put("TreasuryTransactionFlow", getTreasuryTransactionFlow());
        values.put("AccountingDocument", getAccountingDocument());
        values.put("ReverseDocument", getReverseDocument());
        values.put("JournalEntryType", getJournalEntryType());
        values.put("AccountingDocumentTypeName", getAccountingDocumentTypeName());
        values.put("PaymentDate", getPaymentDate());
        values.put("Customer", getCustomer());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("PaymentMethod", getPaymentMethod());
        values.put("PaymentMethodName", getPaymentMethodName());
        values.put("PaymentMethodSupplement", getPaymentMethodSupplement());
        values.put("PaymentMethodSupplementName", getPaymentMethodSupplementName());
        values.put("PaymentBlockingReason", getPaymentBlockingReason());
        values.put("PaymentBlockingReasonName", getPaymentBlockingReasonName());
        values.put("PayerPayeeFullName", getPayerPayeeFullName());
        values.put("HouseBank", getHouseBank());
        values.put("StateCentralBankPaymentReason", getStateCentralBankPaymentReason());
        values.put("SupplyingCountry", getSupplyingCountry());
        values.put("CountryName", getCountryName());
        values.put("AssignmentReference", getAssignmentReference());
        values.put("JournalEntryItemText", getJournalEntryItemText());
        values.put("BusinessArea", getBusinessArea());
        values.put("BusinessAreaName", getBusinessAreaName());
        values.put("CostCenter", getCostCenter());
        values.put("FinancialTransactionType", getFinancialTransactionType());
        values.put("FinancialTransactionTypeName", getFinancialTransactionTypeName());
        values.put("PartnerCompany", getPartnerCompany());
        values.put("CompanyName", getCompanyName());
        values.put("Counterparty", getCounterparty());
        values.put("CounterpartyFullName", getCounterpartyFullName());
        values.put("Issuer", getIssuer());
        values.put("IssuerFullName", getIssuerFullName());
        values.put("SpecialGLCode", getSpecialGLCode());
        values.put("SpecialGLCodeName", getSpecialGLCodeName());
        values.put("TreasuryBusinessTransaction", getTreasuryBusinessTransaction());
        values.put("TreasuryValuationArea", getTreasuryValuationArea());
        values.put("TreasuryValuationAreaName", getTreasuryValuationAreaName());
        values.put("ReferenceDocument", getReferenceDocument());
        values.put("ReferenceDocumentContext", getReferenceDocumentContext());
        values.put("PostingDate", getPostingDate());
        values.put("FiscalPeriod", getFiscalPeriod());
        values.put("FiscalYear", getFiscalYear());
        values.put("ReversalReferenceDocument", getReversalReferenceDocument());
        values.put("ReversalReferenceDocumentCntxt", getReversalReferenceDocumentCntxt());
        values.put("ReverseDocumentPostingDate", getReverseDocumentPostingDate());
        values.put("ReverseDocumentFiscalPeriod", getReverseDocumentFiscalPeriod());
        values.put("ReverseDocumentFiscalYear", getReverseDocumentFiscalYear());
        values.put("Ledger", getLedger());
        values.put("DocumentDate", getDocumentDate());
        values.put("AccountingPrinciple", getAccountingPrinciple());
        values.put("TreasuryAcctgPostingCategory", getTreasuryAcctgPostingCategory());
        values.put("TreasuryBusinessTransCategory", getTreasuryBusinessTransCategory());
        values.put("TreasuryBusTransCategoryName", getTreasuryBusTransCategoryName());
        values.put("DocumentHeaderText", getDocumentHeaderText());
        values.put("DocumentReferenceID", getDocumentReferenceID());
        values.put("FinancialInstrValuationClass", getFinancialInstrValuationClass());
        values.put("FinancialInstrValClassName", getFinancialInstrValClassName());
        values.put("TreasuryValuationClass", getTreasuryValuationClass());
        values.put("TreasuryValuationClassName", getTreasuryValuationClassName());
        values.put("CompanyCode", getCompanyCode());
        values.put("FinancialInstrumentProductType", getFinancialInstrumentProductType());
        values.put("FinancialInstrProdTypeName", getFinancialInstrProdTypeName());
        values.put("SecurityAccount", getSecurityAccount());
        values.put("SecurityAccountName", getSecurityAccountName());
        values.put("SecurityClass", getSecurityClass());
        values.put("SecurityClassName", getSecurityClassName());
        values.put("SecurityClassDescription", getSecurityClassDescription());
        values.put("DifferentiationPortfolio", getDifferentiationPortfolio());
        values.put("DifferentiationPortfolioName", getDifferentiationPortfolioName());
        values.put("SecurityAccountGroup", getSecurityAccountGroup());
        values.put("SecurityAccountGroupName", getSecurityAccountGroupName());
        values.put("LoanContract", getLoanContract());
        values.put("LoanContractName", getLoanContractName());
        values.put("TreasuryPositionAccount", getTreasuryPositionAccount());
        values.put("TreasuryPositionAccountName", getTreasuryPositionAccountName());
        values.put("TreasuryPositionLongShortCode", getTreasuryPositionLongShortCode());
        values.put("Fund", getFund());
        values.put("GrantID", getGrantID());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        values.put("WBSDescription", getWBSDescription());
        values.put("ProfitCenter", getProfitCenter());
        values.put("DifferentiationCostCenter", getDifferentiationCostCenter());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("TrsyPosCustomDiffntnTerm1", getTrsyPosCustomDiffntnTerm1());
        values.put("TrsyPosCustomDiffntnTerm1Name", getTrsyPosCustomDiffntnTerm1Name());
        values.put("TrsyPosCustomDiffntnTerm2", getTrsyPosCustomDiffntnTerm2());
        values.put("TrsyPosCustomDiffntnTerm2Name", getTrsyPosCustomDiffntnTerm2Name());
        values.put("TrsyPosCustomDiffntnTerm3", getTrsyPosCustomDiffntnTerm3());
        values.put("TrsyPosCustomDiffntnTerm3Name", getTrsyPosCustomDiffntnTerm3Name());
        values.put("TrsyPosCustomDiffntnTerm4", getTrsyPosCustomDiffntnTerm4());
        values.put("TrsyPosCustomDiffntnTerm4Name", getTrsyPosCustomDiffntnTerm4Name());
        values.put("TrsyPosCustomDiffntnTerm5", getTrsyPosCustomDiffntnTerm5());
        values.put("TrsyPosCustomDiffntnTerm5Name", getTrsyPosCustomDiffntnTerm5Name());
        values.put("CentralClearingAccount", getCentralClearingAccount());
        values.put("CentralClearingAccountName", getCentralClearingAccountName());
        values.put("ActivityFinancialTransaction", getActivityFinancialTransaction());
        values.put("FinancialTransaction", getFinancialTransaction());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("GLAccountLongName", getGLAccountLongName());
        values.put("CostCenterName", getCostCenterName());
        values.put("FinancialInstrTransactionType", getFinancialInstrTransactionType());
        values.put("FinancialInstrTransTypeName", getFinancialInstrTransTypeName());
        values.put("FinancialInstrCharacteristic", getFinancialInstrCharacteristic());
        values.put("FinancialInstrumentReference", getFinancialInstrumentReference());
        values.put("FinancialInstrumentAssignment", getFinancialInstrumentAssignment());
        values.put("Portfolio", getPortfolio());
        values.put("LetterOfCredit", getLetterOfCredit());
        values.put("HedgingClassification", getHedgingClassification());
        values.put("HedgingClassificationName", getHedgingClassificationName());
        values.put("FinancialExposureItem", getFinancialExposureItem());
        values.put("FinancialExposureItemName", getFinancialExposureItemName());
        values.put("FinancialExposureSubItem", getFinancialExposureSubItem());
        values.put("FinancialExposureSubItemName", getFinancialExposureSubItemName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("TrsyAccountingDocumentUUID") ) {
                final Object value = values.remove("TrsyAccountingDocumentUUID");
                if( (value == null) || (!value.equals(getTrsyAccountingDocumentUUID())) ) {
                    setTrsyAccountingDocumentUUID(((UUID) value));
                }
            }
            if( values.containsKey("AccountingDocumentItemRef") ) {
                final Object value = values.remove("AccountingDocumentItemRef");
                if( (value == null) || (!value.equals(getAccountingDocumentItemRef())) ) {
                    setAccountingDocumentItemRef(((String) value));
                }
            }
            if( values.containsKey("TrsyPositionContextUUID") ) {
                final Object value = values.remove("TrsyPositionContextUUID");
                if( (value == null) || (!value.equals(getTrsyPositionContextUUID())) ) {
                    setTrsyPositionContextUUID(((UUID) value));
                }
            }
            if( values.containsKey("TreasuryBusinessTransStatus") ) {
                final Object value = values.remove("TreasuryBusinessTransStatus");
                if( (value == null) || (!value.equals(getTreasuryBusinessTransStatus())) ) {
                    setTreasuryBusinessTransStatus(((String) value));
                }
            }
            if( values.containsKey("TreasuryBusTransStatusName") ) {
                final Object value = values.remove("TreasuryBusTransStatusName");
                if( (value == null) || (!value.equals(getTreasuryBusTransStatusName())) ) {
                    setTreasuryBusTransStatusName(((String) value));
                }
            }
            if( values.containsKey("TreasuryUpdateType") ) {
                final Object value = values.remove("TreasuryUpdateType");
                if( (value == null) || (!value.equals(getTreasuryUpdateType())) ) {
                    setTreasuryUpdateType(((String) value));
                }
            }
            if( values.containsKey("TreasuryUpdateTypeName") ) {
                final Object value = values.remove("TreasuryUpdateTypeName");
                if( (value == null) || (!value.equals(getTreasuryUpdateTypeName())) ) {
                    setTreasuryUpdateTypeName(((String) value));
                }
            }
            if( values.containsKey("IsUsedInPaymentTransaction") ) {
                final Object value = values.remove("IsUsedInPaymentTransaction");
                if( (value == null) || (!value.equals(getIsUsedInPaymentTransaction())) ) {
                    setIsUsedInPaymentTransaction(((Boolean) value));
                }
            }
            if( values.containsKey("TreasuryGLAccountAssignmentRef") ) {
                final Object value = values.remove("TreasuryGLAccountAssignmentRef");
                if( (value == null) || (!value.equals(getTreasuryGLAccountAssignmentRef())) ) {
                    setTreasuryGLAccountAssignmentRef(((String) value));
                }
            }
            if( values.containsKey("TreasuryGLAccountAssignRefName") ) {
                final Object value = values.remove("TreasuryGLAccountAssignRefName");
                if( (value == null) || (!value.equals(getTreasuryGLAccountAssignRefName())) ) {
                    setTreasuryGLAccountAssignRefName(((String) value));
                }
            }
            if( values.containsKey("TreasuryPostingCategory") ) {
                final Object value = values.remove("TreasuryPostingCategory");
                if( (value == null) || (!value.equals(getTreasuryPostingCategory())) ) {
                    setTreasuryPostingCategory(((Short) value));
                }
            }
            if( values.containsKey("TreasuryPostingCategoryName") ) {
                final Object value = values.remove("TreasuryPostingCategoryName");
                if( (value == null) || (!value.equals(getTreasuryPostingCategoryName())) ) {
                    setTreasuryPostingCategoryName(((String) value));
                }
            }
            if( values.containsKey("TreasuryGLAccountSymbol") ) {
                final Object value = values.remove("TreasuryGLAccountSymbol");
                if( (value == null) || (!value.equals(getTreasuryGLAccountSymbol())) ) {
                    setTreasuryGLAccountSymbol(((String) value));
                }
            }
            if( values.containsKey("TreasuryGLAccountSymbolName") ) {
                final Object value = values.remove("TreasuryGLAccountSymbolName");
                if( (value == null) || (!value.equals(getTreasuryGLAccountSymbolName())) ) {
                    setTreasuryGLAccountSymbolName(((String) value));
                }
            }
            if( values.containsKey("PostingKey") ) {
                final Object value = values.remove("PostingKey");
                if( (value == null) || (!value.equals(getPostingKey())) ) {
                    setPostingKey(((String) value));
                }
            }
            if( values.containsKey("PostingKeyName") ) {
                final Object value = values.remove("PostingKeyName");
                if( (value == null) || (!value.equals(getPostingKeyName())) ) {
                    setPostingKeyName(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("PositionCurrency") ) {
                final Object value = values.remove("PositionCurrency");
                if( (value == null) || (!value.equals(getPositionCurrency())) ) {
                    setPositionCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInPositionCurrency") ) {
                final Object value = values.remove("AmountInPositionCurrency");
                if( (value == null) || (!value.equals(getAmountInPositionCurrency())) ) {
                    setAmountInPositionCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CompanyCodeCurrency") ) {
                final Object value = values.remove("CompanyCodeCurrency");
                if( (value == null) || (!value.equals(getCompanyCodeCurrency())) ) {
                    setCompanyCodeCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInCompanyCodeCurrency") ) {
                final Object value = values.remove("AmountInCompanyCodeCurrency");
                if( (value == null) || (!value.equals(getAmountInCompanyCodeCurrency())) ) {
                    setAmountInCompanyCodeCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("TreasuryTransactionFlow") ) {
                final Object value = values.remove("TreasuryTransactionFlow");
                if( (value == null) || (!value.equals(getTreasuryTransactionFlow())) ) {
                    setTreasuryTransactionFlow(((Integer) value));
                }
            }
            if( values.containsKey("AccountingDocument") ) {
                final Object value = values.remove("AccountingDocument");
                if( (value == null) || (!value.equals(getAccountingDocument())) ) {
                    setAccountingDocument(((String) value));
                }
            }
            if( values.containsKey("ReverseDocument") ) {
                final Object value = values.remove("ReverseDocument");
                if( (value == null) || (!value.equals(getReverseDocument())) ) {
                    setReverseDocument(((String) value));
                }
            }
            if( values.containsKey("JournalEntryType") ) {
                final Object value = values.remove("JournalEntryType");
                if( (value == null) || (!value.equals(getJournalEntryType())) ) {
                    setJournalEntryType(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentTypeName") ) {
                final Object value = values.remove("AccountingDocumentTypeName");
                if( (value == null) || (!value.equals(getAccountingDocumentTypeName())) ) {
                    setAccountingDocumentTypeName(((String) value));
                }
            }
            if( values.containsKey("PaymentDate") ) {
                final Object value = values.remove("PaymentDate");
                if( (value == null) || (!value.equals(getPaymentDate())) ) {
                    setPaymentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("PaymentMethod") ) {
                final Object value = values.remove("PaymentMethod");
                if( (value == null) || (!value.equals(getPaymentMethod())) ) {
                    setPaymentMethod(((String) value));
                }
            }
            if( values.containsKey("PaymentMethodName") ) {
                final Object value = values.remove("PaymentMethodName");
                if( (value == null) || (!value.equals(getPaymentMethodName())) ) {
                    setPaymentMethodName(((String) value));
                }
            }
            if( values.containsKey("PaymentMethodSupplement") ) {
                final Object value = values.remove("PaymentMethodSupplement");
                if( (value == null) || (!value.equals(getPaymentMethodSupplement())) ) {
                    setPaymentMethodSupplement(((String) value));
                }
            }
            if( values.containsKey("PaymentMethodSupplementName") ) {
                final Object value = values.remove("PaymentMethodSupplementName");
                if( (value == null) || (!value.equals(getPaymentMethodSupplementName())) ) {
                    setPaymentMethodSupplementName(((String) value));
                }
            }
            if( values.containsKey("PaymentBlockingReason") ) {
                final Object value = values.remove("PaymentBlockingReason");
                if( (value == null) || (!value.equals(getPaymentBlockingReason())) ) {
                    setPaymentBlockingReason(((String) value));
                }
            }
            if( values.containsKey("PaymentBlockingReasonName") ) {
                final Object value = values.remove("PaymentBlockingReasonName");
                if( (value == null) || (!value.equals(getPaymentBlockingReasonName())) ) {
                    setPaymentBlockingReasonName(((String) value));
                }
            }
            if( values.containsKey("PayerPayeeFullName") ) {
                final Object value = values.remove("PayerPayeeFullName");
                if( (value == null) || (!value.equals(getPayerPayeeFullName())) ) {
                    setPayerPayeeFullName(((String) value));
                }
            }
            if( values.containsKey("HouseBank") ) {
                final Object value = values.remove("HouseBank");
                if( (value == null) || (!value.equals(getHouseBank())) ) {
                    setHouseBank(((String) value));
                }
            }
            if( values.containsKey("StateCentralBankPaymentReason") ) {
                final Object value = values.remove("StateCentralBankPaymentReason");
                if( (value == null) || (!value.equals(getStateCentralBankPaymentReason())) ) {
                    setStateCentralBankPaymentReason(((String) value));
                }
            }
            if( values.containsKey("SupplyingCountry") ) {
                final Object value = values.remove("SupplyingCountry");
                if( (value == null) || (!value.equals(getSupplyingCountry())) ) {
                    setSupplyingCountry(((String) value));
                }
            }
            if( values.containsKey("CountryName") ) {
                final Object value = values.remove("CountryName");
                if( (value == null) || (!value.equals(getCountryName())) ) {
                    setCountryName(((String) value));
                }
            }
            if( values.containsKey("AssignmentReference") ) {
                final Object value = values.remove("AssignmentReference");
                if( (value == null) || (!value.equals(getAssignmentReference())) ) {
                    setAssignmentReference(((String) value));
                }
            }
            if( values.containsKey("JournalEntryItemText") ) {
                final Object value = values.remove("JournalEntryItemText");
                if( (value == null) || (!value.equals(getJournalEntryItemText())) ) {
                    setJournalEntryItemText(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("BusinessAreaName") ) {
                final Object value = values.remove("BusinessAreaName");
                if( (value == null) || (!value.equals(getBusinessAreaName())) ) {
                    setBusinessAreaName(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("FinancialTransactionType") ) {
                final Object value = values.remove("FinancialTransactionType");
                if( (value == null) || (!value.equals(getFinancialTransactionType())) ) {
                    setFinancialTransactionType(((String) value));
                }
            }
            if( values.containsKey("FinancialTransactionTypeName") ) {
                final Object value = values.remove("FinancialTransactionTypeName");
                if( (value == null) || (!value.equals(getFinancialTransactionTypeName())) ) {
                    setFinancialTransactionTypeName(((String) value));
                }
            }
            if( values.containsKey("PartnerCompany") ) {
                final Object value = values.remove("PartnerCompany");
                if( (value == null) || (!value.equals(getPartnerCompany())) ) {
                    setPartnerCompany(((String) value));
                }
            }
            if( values.containsKey("CompanyName") ) {
                final Object value = values.remove("CompanyName");
                if( (value == null) || (!value.equals(getCompanyName())) ) {
                    setCompanyName(((String) value));
                }
            }
            if( values.containsKey("Counterparty") ) {
                final Object value = values.remove("Counterparty");
                if( (value == null) || (!value.equals(getCounterparty())) ) {
                    setCounterparty(((String) value));
                }
            }
            if( values.containsKey("CounterpartyFullName") ) {
                final Object value = values.remove("CounterpartyFullName");
                if( (value == null) || (!value.equals(getCounterpartyFullName())) ) {
                    setCounterpartyFullName(((String) value));
                }
            }
            if( values.containsKey("Issuer") ) {
                final Object value = values.remove("Issuer");
                if( (value == null) || (!value.equals(getIssuer())) ) {
                    setIssuer(((String) value));
                }
            }
            if( values.containsKey("IssuerFullName") ) {
                final Object value = values.remove("IssuerFullName");
                if( (value == null) || (!value.equals(getIssuerFullName())) ) {
                    setIssuerFullName(((String) value));
                }
            }
            if( values.containsKey("SpecialGLCode") ) {
                final Object value = values.remove("SpecialGLCode");
                if( (value == null) || (!value.equals(getSpecialGLCode())) ) {
                    setSpecialGLCode(((String) value));
                }
            }
            if( values.containsKey("SpecialGLCodeName") ) {
                final Object value = values.remove("SpecialGLCodeName");
                if( (value == null) || (!value.equals(getSpecialGLCodeName())) ) {
                    setSpecialGLCodeName(((String) value));
                }
            }
            if( values.containsKey("TreasuryBusinessTransaction") ) {
                final Object value = values.remove("TreasuryBusinessTransaction");
                if( (value == null) || (!value.equals(getTreasuryBusinessTransaction())) ) {
                    setTreasuryBusinessTransaction(((UUID) value));
                }
            }
            if( values.containsKey("TreasuryValuationArea") ) {
                final Object value = values.remove("TreasuryValuationArea");
                if( (value == null) || (!value.equals(getTreasuryValuationArea())) ) {
                    setTreasuryValuationArea(((String) value));
                }
            }
            if( values.containsKey("TreasuryValuationAreaName") ) {
                final Object value = values.remove("TreasuryValuationAreaName");
                if( (value == null) || (!value.equals(getTreasuryValuationAreaName())) ) {
                    setTreasuryValuationAreaName(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocument") ) {
                final Object value = values.remove("ReferenceDocument");
                if( (value == null) || (!value.equals(getReferenceDocument())) ) {
                    setReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentContext") ) {
                final Object value = values.remove("ReferenceDocumentContext");
                if( (value == null) || (!value.equals(getReferenceDocumentContext())) ) {
                    setReferenceDocumentContext(((String) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FiscalPeriod") ) {
                final Object value = values.remove("FiscalPeriod");
                if( (value == null) || (!value.equals(getFiscalPeriod())) ) {
                    setFiscalPeriod(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("ReversalReferenceDocument") ) {
                final Object value = values.remove("ReversalReferenceDocument");
                if( (value == null) || (!value.equals(getReversalReferenceDocument())) ) {
                    setReversalReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ReversalReferenceDocumentCntxt") ) {
                final Object value = values.remove("ReversalReferenceDocumentCntxt");
                if( (value == null) || (!value.equals(getReversalReferenceDocumentCntxt())) ) {
                    setReversalReferenceDocumentCntxt(((String) value));
                }
            }
            if( values.containsKey("ReverseDocumentPostingDate") ) {
                final Object value = values.remove("ReverseDocumentPostingDate");
                if( (value == null) || (!value.equals(getReverseDocumentPostingDate())) ) {
                    setReverseDocumentPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ReverseDocumentFiscalPeriod") ) {
                final Object value = values.remove("ReverseDocumentFiscalPeriod");
                if( (value == null) || (!value.equals(getReverseDocumentFiscalPeriod())) ) {
                    setReverseDocumentFiscalPeriod(((String) value));
                }
            }
            if( values.containsKey("ReverseDocumentFiscalYear") ) {
                final Object value = values.remove("ReverseDocumentFiscalYear");
                if( (value == null) || (!value.equals(getReverseDocumentFiscalYear())) ) {
                    setReverseDocumentFiscalYear(((String) value));
                }
            }
            if( values.containsKey("Ledger") ) {
                final Object value = values.remove("Ledger");
                if( (value == null) || (!value.equals(getLedger())) ) {
                    setLedger(((String) value));
                }
            }
            if( values.containsKey("DocumentDate") ) {
                final Object value = values.remove("DocumentDate");
                if( (value == null) || (!value.equals(getDocumentDate())) ) {
                    setDocumentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AccountingPrinciple") ) {
                final Object value = values.remove("AccountingPrinciple");
                if( (value == null) || (!value.equals(getAccountingPrinciple())) ) {
                    setAccountingPrinciple(((String) value));
                }
            }
            if( values.containsKey("TreasuryAcctgPostingCategory") ) {
                final Object value = values.remove("TreasuryAcctgPostingCategory");
                if( (value == null) || (!value.equals(getTreasuryAcctgPostingCategory())) ) {
                    setTreasuryAcctgPostingCategory(((String) value));
                }
            }
            if( values.containsKey("TreasuryBusinessTransCategory") ) {
                final Object value = values.remove("TreasuryBusinessTransCategory");
                if( (value == null) || (!value.equals(getTreasuryBusinessTransCategory())) ) {
                    setTreasuryBusinessTransCategory(((String) value));
                }
            }
            if( values.containsKey("TreasuryBusTransCategoryName") ) {
                final Object value = values.remove("TreasuryBusTransCategoryName");
                if( (value == null) || (!value.equals(getTreasuryBusTransCategoryName())) ) {
                    setTreasuryBusTransCategoryName(((String) value));
                }
            }
            if( values.containsKey("DocumentHeaderText") ) {
                final Object value = values.remove("DocumentHeaderText");
                if( (value == null) || (!value.equals(getDocumentHeaderText())) ) {
                    setDocumentHeaderText(((String) value));
                }
            }
            if( values.containsKey("DocumentReferenceID") ) {
                final Object value = values.remove("DocumentReferenceID");
                if( (value == null) || (!value.equals(getDocumentReferenceID())) ) {
                    setDocumentReferenceID(((String) value));
                }
            }
            if( values.containsKey("FinancialInstrValuationClass") ) {
                final Object value = values.remove("FinancialInstrValuationClass");
                if( (value == null) || (!value.equals(getFinancialInstrValuationClass())) ) {
                    setFinancialInstrValuationClass(((String) value));
                }
            }
            if( values.containsKey("FinancialInstrValClassName") ) {
                final Object value = values.remove("FinancialInstrValClassName");
                if( (value == null) || (!value.equals(getFinancialInstrValClassName())) ) {
                    setFinancialInstrValClassName(((String) value));
                }
            }
            if( values.containsKey("TreasuryValuationClass") ) {
                final Object value = values.remove("TreasuryValuationClass");
                if( (value == null) || (!value.equals(getTreasuryValuationClass())) ) {
                    setTreasuryValuationClass(((String) value));
                }
            }
            if( values.containsKey("TreasuryValuationClassName") ) {
                final Object value = values.remove("TreasuryValuationClassName");
                if( (value == null) || (!value.equals(getTreasuryValuationClassName())) ) {
                    setTreasuryValuationClassName(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("FinancialInstrumentProductType") ) {
                final Object value = values.remove("FinancialInstrumentProductType");
                if( (value == null) || (!value.equals(getFinancialInstrumentProductType())) ) {
                    setFinancialInstrumentProductType(((String) value));
                }
            }
            if( values.containsKey("FinancialInstrProdTypeName") ) {
                final Object value = values.remove("FinancialInstrProdTypeName");
                if( (value == null) || (!value.equals(getFinancialInstrProdTypeName())) ) {
                    setFinancialInstrProdTypeName(((String) value));
                }
            }
            if( values.containsKey("SecurityAccount") ) {
                final Object value = values.remove("SecurityAccount");
                if( (value == null) || (!value.equals(getSecurityAccount())) ) {
                    setSecurityAccount(((String) value));
                }
            }
            if( values.containsKey("SecurityAccountName") ) {
                final Object value = values.remove("SecurityAccountName");
                if( (value == null) || (!value.equals(getSecurityAccountName())) ) {
                    setSecurityAccountName(((String) value));
                }
            }
            if( values.containsKey("SecurityClass") ) {
                final Object value = values.remove("SecurityClass");
                if( (value == null) || (!value.equals(getSecurityClass())) ) {
                    setSecurityClass(((String) value));
                }
            }
            if( values.containsKey("SecurityClassName") ) {
                final Object value = values.remove("SecurityClassName");
                if( (value == null) || (!value.equals(getSecurityClassName())) ) {
                    setSecurityClassName(((String) value));
                }
            }
            if( values.containsKey("SecurityClassDescription") ) {
                final Object value = values.remove("SecurityClassDescription");
                if( (value == null) || (!value.equals(getSecurityClassDescription())) ) {
                    setSecurityClassDescription(((String) value));
                }
            }
            if( values.containsKey("DifferentiationPortfolio") ) {
                final Object value = values.remove("DifferentiationPortfolio");
                if( (value == null) || (!value.equals(getDifferentiationPortfolio())) ) {
                    setDifferentiationPortfolio(((String) value));
                }
            }
            if( values.containsKey("DifferentiationPortfolioName") ) {
                final Object value = values.remove("DifferentiationPortfolioName");
                if( (value == null) || (!value.equals(getDifferentiationPortfolioName())) ) {
                    setDifferentiationPortfolioName(((String) value));
                }
            }
            if( values.containsKey("SecurityAccountGroup") ) {
                final Object value = values.remove("SecurityAccountGroup");
                if( (value == null) || (!value.equals(getSecurityAccountGroup())) ) {
                    setSecurityAccountGroup(((String) value));
                }
            }
            if( values.containsKey("SecurityAccountGroupName") ) {
                final Object value = values.remove("SecurityAccountGroupName");
                if( (value == null) || (!value.equals(getSecurityAccountGroupName())) ) {
                    setSecurityAccountGroupName(((String) value));
                }
            }
            if( values.containsKey("LoanContract") ) {
                final Object value = values.remove("LoanContract");
                if( (value == null) || (!value.equals(getLoanContract())) ) {
                    setLoanContract(((String) value));
                }
            }
            if( values.containsKey("LoanContractName") ) {
                final Object value = values.remove("LoanContractName");
                if( (value == null) || (!value.equals(getLoanContractName())) ) {
                    setLoanContractName(((String) value));
                }
            }
            if( values.containsKey("TreasuryPositionAccount") ) {
                final Object value = values.remove("TreasuryPositionAccount");
                if( (value == null) || (!value.equals(getTreasuryPositionAccount())) ) {
                    setTreasuryPositionAccount(((String) value));
                }
            }
            if( values.containsKey("TreasuryPositionAccountName") ) {
                final Object value = values.remove("TreasuryPositionAccountName");
                if( (value == null) || (!value.equals(getTreasuryPositionAccountName())) ) {
                    setTreasuryPositionAccountName(((String) value));
                }
            }
            if( values.containsKey("TreasuryPositionLongShortCode") ) {
                final Object value = values.remove("TreasuryPositionLongShortCode");
                if( (value == null) || (!value.equals(getTreasuryPositionLongShortCode())) ) {
                    setTreasuryPositionLongShortCode(((String) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("WBSDescription") ) {
                final Object value = values.remove("WBSDescription");
                if( (value == null) || (!value.equals(getWBSDescription())) ) {
                    setWBSDescription(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("DifferentiationCostCenter") ) {
                final Object value = values.remove("DifferentiationCostCenter");
                if( (value == null) || (!value.equals(getDifferentiationCostCenter())) ) {
                    setDifferentiationCostCenter(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm1") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm1");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm1())) ) {
                    setTrsyPosCustomDiffntnTerm1(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm1Name") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm1Name");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm1Name())) ) {
                    setTrsyPosCustomDiffntnTerm1Name(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm2") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm2");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm2())) ) {
                    setTrsyPosCustomDiffntnTerm2(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm2Name") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm2Name");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm2Name())) ) {
                    setTrsyPosCustomDiffntnTerm2Name(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm3") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm3");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm3())) ) {
                    setTrsyPosCustomDiffntnTerm3(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm3Name") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm3Name");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm3Name())) ) {
                    setTrsyPosCustomDiffntnTerm3Name(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm4") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm4");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm4())) ) {
                    setTrsyPosCustomDiffntnTerm4(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm4Name") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm4Name");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm4Name())) ) {
                    setTrsyPosCustomDiffntnTerm4Name(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm5") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm5");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm5())) ) {
                    setTrsyPosCustomDiffntnTerm5(((String) value));
                }
            }
            if( values.containsKey("TrsyPosCustomDiffntnTerm5Name") ) {
                final Object value = values.remove("TrsyPosCustomDiffntnTerm5Name");
                if( (value == null) || (!value.equals(getTrsyPosCustomDiffntnTerm5Name())) ) {
                    setTrsyPosCustomDiffntnTerm5Name(((String) value));
                }
            }
            if( values.containsKey("CentralClearingAccount") ) {
                final Object value = values.remove("CentralClearingAccount");
                if( (value == null) || (!value.equals(getCentralClearingAccount())) ) {
                    setCentralClearingAccount(((String) value));
                }
            }
            if( values.containsKey("CentralClearingAccountName") ) {
                final Object value = values.remove("CentralClearingAccountName");
                if( (value == null) || (!value.equals(getCentralClearingAccountName())) ) {
                    setCentralClearingAccountName(((String) value));
                }
            }
            if( values.containsKey("ActivityFinancialTransaction") ) {
                final Object value = values.remove("ActivityFinancialTransaction");
                if( (value == null) || (!value.equals(getActivityFinancialTransaction())) ) {
                    setActivityFinancialTransaction(((String) value));
                }
            }
            if( values.containsKey("FinancialTransaction") ) {
                final Object value = values.remove("FinancialTransaction");
                if( (value == null) || (!value.equals(getFinancialTransaction())) ) {
                    setFinancialTransaction(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("GLAccountLongName") ) {
                final Object value = values.remove("GLAccountLongName");
                if( (value == null) || (!value.equals(getGLAccountLongName())) ) {
                    setGLAccountLongName(((String) value));
                }
            }
            if( values.containsKey("CostCenterName") ) {
                final Object value = values.remove("CostCenterName");
                if( (value == null) || (!value.equals(getCostCenterName())) ) {
                    setCostCenterName(((String) value));
                }
            }
            if( values.containsKey("FinancialInstrTransactionType") ) {
                final Object value = values.remove("FinancialInstrTransactionType");
                if( (value == null) || (!value.equals(getFinancialInstrTransactionType())) ) {
                    setFinancialInstrTransactionType(((String) value));
                }
            }
            if( values.containsKey("FinancialInstrTransTypeName") ) {
                final Object value = values.remove("FinancialInstrTransTypeName");
                if( (value == null) || (!value.equals(getFinancialInstrTransTypeName())) ) {
                    setFinancialInstrTransTypeName(((String) value));
                }
            }
            if( values.containsKey("FinancialInstrCharacteristic") ) {
                final Object value = values.remove("FinancialInstrCharacteristic");
                if( (value == null) || (!value.equals(getFinancialInstrCharacteristic())) ) {
                    setFinancialInstrCharacteristic(((String) value));
                }
            }
            if( values.containsKey("FinancialInstrumentReference") ) {
                final Object value = values.remove("FinancialInstrumentReference");
                if( (value == null) || (!value.equals(getFinancialInstrumentReference())) ) {
                    setFinancialInstrumentReference(((String) value));
                }
            }
            if( values.containsKey("FinancialInstrumentAssignment") ) {
                final Object value = values.remove("FinancialInstrumentAssignment");
                if( (value == null) || (!value.equals(getFinancialInstrumentAssignment())) ) {
                    setFinancialInstrumentAssignment(((String) value));
                }
            }
            if( values.containsKey("Portfolio") ) {
                final Object value = values.remove("Portfolio");
                if( (value == null) || (!value.equals(getPortfolio())) ) {
                    setPortfolio(((String) value));
                }
            }
            if( values.containsKey("LetterOfCredit") ) {
                final Object value = values.remove("LetterOfCredit");
                if( (value == null) || (!value.equals(getLetterOfCredit())) ) {
                    setLetterOfCredit(((String) value));
                }
            }
            if( values.containsKey("HedgingClassification") ) {
                final Object value = values.remove("HedgingClassification");
                if( (value == null) || (!value.equals(getHedgingClassification())) ) {
                    setHedgingClassification(((String) value));
                }
            }
            if( values.containsKey("HedgingClassificationName") ) {
                final Object value = values.remove("HedgingClassificationName");
                if( (value == null) || (!value.equals(getHedgingClassificationName())) ) {
                    setHedgingClassificationName(((String) value));
                }
            }
            if( values.containsKey("FinancialExposureItem") ) {
                final Object value = values.remove("FinancialExposureItem");
                if( (value == null) || (!value.equals(getFinancialExposureItem())) ) {
                    setFinancialExposureItem(((String) value));
                }
            }
            if( values.containsKey("FinancialExposureItemName") ) {
                final Object value = values.remove("FinancialExposureItemName");
                if( (value == null) || (!value.equals(getFinancialExposureItemName())) ) {
                    setFinancialExposureItemName(((String) value));
                }
            }
            if( values.containsKey("FinancialExposureSubItem") ) {
                final Object value = values.remove("FinancialExposureSubItem");
                if( (value == null) || (!value.equals(getFinancialExposureSubItem())) ) {
                    setFinancialExposureSubItem(((String) value));
                }
            }
            if( values.containsKey("FinancialExposureSubItemName") ) {
                final Object value = values.remove("FinancialExposureSubItemName");
                if( (value == null) || (!value.equals(getFinancialExposureSubItemName())) ) {
                    setFinancialExposureSubItemName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> TrsyPostgJrnlEntrItmField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new TrsyPostgJrnlEntrItmField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> TrsyPostgJrnlEntrItmField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new TrsyPostgJrnlEntrItmField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LineItemOfTreasuryPostingJournalEntryService.DEFAULT_SERVICE_PATH);
    }

}
