/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.selectable.TrsyPostgJrnlEntrItmSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm
 * TrsyPostgJrnlEntrItm} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class TrsyPostgJrnlEntrItmByKeyFluentHelper
    extends
    FluentHelperByKey<TrsyPostgJrnlEntrItmByKeyFluentHelper, TrsyPostgJrnlEntrItm, TrsyPostgJrnlEntrItmSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm
     * TrsyPostgJrnlEntrItm} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code TrsyPostgJrnlEntrItm}
     * @param trsyPositionContextUUID
     *            Object Identity in Database Format
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code TrsyPostgJrnlEntrItm}
     * @param trsyAccountingDocumentUUID
     *            Object Identity in Database Format
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param accountingDocumentItemRef
     *            Accounting Document Line Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public TrsyPostgJrnlEntrItmByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID trsyAccountingDocumentUUID,
        final String accountingDocumentItemRef,
        final UUID trsyPositionContextUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("TrsyAccountingDocumentUUID", trsyAccountingDocumentUUID);
        this.key.put("AccountingDocumentItemRef", accountingDocumentItemRef);
        this.key.put("TrsyPositionContextUUID", trsyPositionContextUUID);
    }

    @Override
    @Nonnull
    protected Class<TrsyPostgJrnlEntrItm> getEntityClass()
    {
        return TrsyPostgJrnlEntrItm.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
