/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link LineItemOfTreasuryPostingJournalEntryServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.LineItemOfTreasuryPostingJournalEntryService
 * LineItemOfTreasuryPostingJournalEntryService}, allowing you to create multiple changesets and finally execute the
 * batch request.
 *
 */
public class DefaultLineItemOfTreasuryPostingJournalEntryServiceBatch
    extends
    BatchFluentHelperBasic<LineItemOfTreasuryPostingJournalEntryServiceBatch, LineItemOfTreasuryPostingJournalEntryServiceBatchChangeSet>
    implements
    LineItemOfTreasuryPostingJournalEntryServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LineItemOfTreasuryPostingJournalEntryService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultLineItemOfTreasuryPostingJournalEntryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultLineItemOfTreasuryPostingJournalEntryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LineItemOfTreasuryPostingJournalEntryService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.LineItemOfTreasuryPostingJournalEntryService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultLineItemOfTreasuryPostingJournalEntryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultLineItemOfTreasuryPostingJournalEntryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LineItemOfTreasuryPostingJournalEntryService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultLineItemOfTreasuryPostingJournalEntryServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public LineItemOfTreasuryPostingJournalEntryServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultLineItemOfTreasuryPostingJournalEntryServiceBatchChangeSet(this, service);
    }

}
