/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm
 * TrsyPostgJrnlEntrItm}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.field.TrsyPostgJrnlEntrItmField
 * TrsyPostgJrnlEntrItmField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.link.TrsyPostgJrnlEntrItmLink
 * TrsyPostgJrnlEntrItmLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TRSY_ACCOUNTING_DOCUMENT_UUID
 * TRSY_ACCOUNTING_DOCUMENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#ACCOUNTING_DOCUMENT_ITEM_REF
 * ACCOUNTING_DOCUMENT_ITEM_REF}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TRSY_POSITION_CONTEXT_UUID
 * TRSY_POSITION_CONTEXT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_BUSINESS_TRANS_STATUS
 * TREASURY_BUSINESS_TRANS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_BUS_TRANS_STATUS_NAME
 * TREASURY_BUS_TRANS_STATUS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_UPDATE_TYPE
 * TREASURY_UPDATE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_UPDATE_TYPE_NAME
 * TREASURY_UPDATE_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#IS_USED_IN_PAYMENT_TRANSACTION
 * IS_USED_IN_PAYMENT_TRANSACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_GL_ACCOUNT_ASSIGNMENT_REF
 * TREASURY_GL_ACCOUNT_ASSIGNMENT_REF}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_GL_ACCOUNT_ASSIGN_REF_NAME
 * TREASURY_GL_ACCOUNT_ASSIGN_REF_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_POSTING_CATEGORY
 * TREASURY_POSTING_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_POSTING_CATEGORY_NAME
 * TREASURY_POSTING_CATEGORY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_GL_ACCOUNT_SYMBOL
 * TREASURY_GL_ACCOUNT_SYMBOL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_GL_ACCOUNT_SYMBOL_NAME
 * TREASURY_GL_ACCOUNT_SYMBOL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#POSTING_KEY
 * POSTING_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#POSTING_KEY_NAME
 * POSTING_KEY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#POSITION_CURRENCY
 * POSITION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#AMOUNT_IN_POSITION_CURRENCY
 * AMOUNT_IN_POSITION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#COMPANY_CODE_CURRENCY
 * COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#AMOUNT_IN_COMPANY_CODE_CURRENCY
 * AMOUNT_IN_COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_TRANSACTION_FLOW
 * TREASURY_TRANSACTION_FLOW}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#ACCOUNTING_DOCUMENT
 * ACCOUNTING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#REVERSE_DOCUMENT
 * REVERSE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#JOURNAL_ENTRY_TYPE
 * JOURNAL_ENTRY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#ACCOUNTING_DOCUMENT_TYPE_NAME
 * ACCOUNTING_DOCUMENT_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#PAYMENT_DATE
 * PAYMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#PAYMENT_TERMS
 * PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#PAYMENT_METHOD
 * PAYMENT_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#PAYMENT_METHOD_NAME
 * PAYMENT_METHOD_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#PAYMENT_METHOD_SUPPLEMENT
 * PAYMENT_METHOD_SUPPLEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#PAYMENT_METHOD_SUPPLEMENT_NAME
 * PAYMENT_METHOD_SUPPLEMENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#PAYMENT_BLOCKING_REASON
 * PAYMENT_BLOCKING_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#PAYMENT_BLOCKING_REASON_NAME
 * PAYMENT_BLOCKING_REASON_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#PAYER_PAYEE_FULL_NAME
 * PAYER_PAYEE_FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#HOUSE_BANK
 * HOUSE_BANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#STATE_CENTRAL_BANK_PAYMENT_REASON
 * STATE_CENTRAL_BANK_PAYMENT_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#SUPPLYING_COUNTRY
 * SUPPLYING_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#COUNTRY_NAME
 * COUNTRY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#ASSIGNMENT_REFERENCE
 * ASSIGNMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#JOURNAL_ENTRY_ITEM_TEXT
 * JOURNAL_ENTRY_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#BUSINESS_AREA_NAME
 * BUSINESS_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FINANCIAL_TRANSACTION_TYPE
 * FINANCIAL_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FINANCIAL_TRANSACTION_TYPE_NAME
 * FINANCIAL_TRANSACTION_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#PARTNER_COMPANY
 * PARTNER_COMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#COMPANY_NAME
 * COMPANY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#COUNTERPARTY
 * COUNTERPARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#COUNTERPARTY_FULL_NAME
 * COUNTERPARTY_FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#ISSUER
 * ISSUER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#ISSUER_FULL_NAME
 * ISSUER_FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#SPECIAL_GL_CODE
 * SPECIAL_GL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#SPECIAL_GL_CODE_NAME
 * SPECIAL_GL_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_BUSINESS_TRANSACTION
 * TREASURY_BUSINESS_TRANSACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_VALUATION_AREA
 * TREASURY_VALUATION_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_VALUATION_AREA_NAME
 * TREASURY_VALUATION_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#REFERENCE_DOCUMENT
 * REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#REFERENCE_DOCUMENT_CONTEXT
 * REFERENCE_DOCUMENT_CONTEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FISCAL_PERIOD
 * FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#REVERSAL_REFERENCE_DOCUMENT
 * REVERSAL_REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#REVERSAL_REFERENCE_DOCUMENT_CNTXT
 * REVERSAL_REFERENCE_DOCUMENT_CNTXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#REVERSE_DOCUMENT_POSTING_DATE
 * REVERSE_DOCUMENT_POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#REVERSE_DOCUMENT_FISCAL_PERIOD
 * REVERSE_DOCUMENT_FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#REVERSE_DOCUMENT_FISCAL_YEAR
 * REVERSE_DOCUMENT_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#LEDGER
 * LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#DOCUMENT_DATE
 * DOCUMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#ACCOUNTING_PRINCIPLE
 * ACCOUNTING_PRINCIPLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_ACCTG_POSTING_CATEGORY
 * TREASURY_ACCTG_POSTING_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_BUSINESS_TRANS_CATEGORY
 * TREASURY_BUSINESS_TRANS_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_BUS_TRANS_CATEGORY_NAME
 * TREASURY_BUS_TRANS_CATEGORY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#DOCUMENT_HEADER_TEXT
 * DOCUMENT_HEADER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#DOCUMENT_REFERENCE_ID
 * DOCUMENT_REFERENCE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FINANCIAL_INSTR_VALUATION_CLASS
 * FINANCIAL_INSTR_VALUATION_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FINANCIAL_INSTR_VAL_CLASS_NAME
 * FINANCIAL_INSTR_VAL_CLASS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_VALUATION_CLASS
 * TREASURY_VALUATION_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_VALUATION_CLASS_NAME
 * TREASURY_VALUATION_CLASS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FINANCIAL_INSTRUMENT_PRODUCT_TYPE
 * FINANCIAL_INSTRUMENT_PRODUCT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FINANCIAL_INSTR_PROD_TYPE_NAME
 * FINANCIAL_INSTR_PROD_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#SECURITY_ACCOUNT
 * SECURITY_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#SECURITY_ACCOUNT_NAME
 * SECURITY_ACCOUNT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#SECURITY_CLASS
 * SECURITY_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#SECURITY_CLASS_NAME
 * SECURITY_CLASS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#SECURITY_CLASS_DESCRIPTION
 * SECURITY_CLASS_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#DIFFERENTIATION_PORTFOLIO
 * DIFFERENTIATION_PORTFOLIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#DIFFERENTIATION_PORTFOLIO_NAME
 * DIFFERENTIATION_PORTFOLIO_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#SECURITY_ACCOUNT_GROUP
 * SECURITY_ACCOUNT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#SECURITY_ACCOUNT_GROUP_NAME
 * SECURITY_ACCOUNT_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#LOAN_CONTRACT
 * LOAN_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#LOAN_CONTRACT_NAME
 * LOAN_CONTRACT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_POSITION_ACCOUNT
 * TREASURY_POSITION_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_POSITION_ACCOUNT_NAME
 * TREASURY_POSITION_ACCOUNT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TREASURY_POSITION_LONG_SHORT_CODE
 * TREASURY_POSITION_LONG_SHORT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FUND
 * FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#GRANT_ID
 * GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#WBS_DESCRIPTION
 * WBS_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#DIFFERENTIATION_COST_CENTER
 * DIFFERENTIATION_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TRSY_POS_CUSTOM_DIFFNTN_TERM1
 * TRSY_POS_CUSTOM_DIFFNTN_TERM1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TRSY_POS_CUSTOM_DIFFNTN_TERM1_NAME
 * TRSY_POS_CUSTOM_DIFFNTN_TERM1_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TRSY_POS_CUSTOM_DIFFNTN_TERM2
 * TRSY_POS_CUSTOM_DIFFNTN_TERM2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TRSY_POS_CUSTOM_DIFFNTN_TERM2_NAME
 * TRSY_POS_CUSTOM_DIFFNTN_TERM2_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TRSY_POS_CUSTOM_DIFFNTN_TERM3
 * TRSY_POS_CUSTOM_DIFFNTN_TERM3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TRSY_POS_CUSTOM_DIFFNTN_TERM3_NAME
 * TRSY_POS_CUSTOM_DIFFNTN_TERM3_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TRSY_POS_CUSTOM_DIFFNTN_TERM4
 * TRSY_POS_CUSTOM_DIFFNTN_TERM4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TRSY_POS_CUSTOM_DIFFNTN_TERM4_NAME
 * TRSY_POS_CUSTOM_DIFFNTN_TERM4_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TRSY_POS_CUSTOM_DIFFNTN_TERM5
 * TRSY_POS_CUSTOM_DIFFNTN_TERM5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#TRSY_POS_CUSTOM_DIFFNTN_TERM5_NAME
 * TRSY_POS_CUSTOM_DIFFNTN_TERM5_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#CENTRAL_CLEARING_ACCOUNT
 * CENTRAL_CLEARING_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#CENTRAL_CLEARING_ACCOUNT_NAME
 * CENTRAL_CLEARING_ACCOUNT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#ACTIVITY_FINANCIAL_TRANSACTION
 * ACTIVITY_FINANCIAL_TRANSACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FINANCIAL_TRANSACTION
 * FINANCIAL_TRANSACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#GL_ACCOUNT_LONG_NAME
 * GL_ACCOUNT_LONG_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#COST_CENTER_NAME
 * COST_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FINANCIAL_INSTR_TRANSACTION_TYPE
 * FINANCIAL_INSTR_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FINANCIAL_INSTR_TRANS_TYPE_NAME
 * FINANCIAL_INSTR_TRANS_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FINANCIAL_INSTR_CHARACTERISTIC
 * FINANCIAL_INSTR_CHARACTERISTIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FINANCIAL_INSTRUMENT_REFERENCE
 * FINANCIAL_INSTRUMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FINANCIAL_INSTRUMENT_ASSIGNMENT
 * FINANCIAL_INSTRUMENT_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#PORTFOLIO
 * PORTFOLIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#LETTER_OF_CREDIT
 * LETTER_OF_CREDIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#HEDGING_CLASSIFICATION
 * HEDGING_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#HEDGING_CLASSIFICATION_NAME
 * HEDGING_CLASSIFICATION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FINANCIAL_EXPOSURE_ITEM
 * FINANCIAL_EXPOSURE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FINANCIAL_EXPOSURE_ITEM_NAME
 * FINANCIAL_EXPOSURE_ITEM_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FINANCIAL_EXPOSURE_SUB_ITEM
 * FINANCIAL_EXPOSURE_SUB_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.lineitemoftreasurypostingjournalentry.TrsyPostgJrnlEntrItm#FINANCIAL_EXPOSURE_SUB_ITEM_NAME
 * FINANCIAL_EXPOSURE_SUB_ITEM_NAME}</li>
 * </ul>
 *
 */
public interface TrsyPostgJrnlEntrItmSelectable extends EntitySelectable<TrsyPostgJrnlEntrItm>
{

}
