/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.selectable.BOMItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem BOMItem} entity using
 * key fields. This fluent helper allows methods which modify the underlying query to be called before executing the
 * query itself.
 *
 */
public class BOMItemByKeyFluentHelper extends FluentHelperByKey<BOMItemByKeyFluentHelper, BOMItem, BOMItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem BOMItem} entity with
     * the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method on
     * the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BOMItem}
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BOMItem}
     * @param billOfMaterialVersion
     *            BOM Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param engineeringChangeDocument
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param billOfMaterial
     *
     * @param technicalObject
     *            Material 1
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param billOfMaterialItemNodeNumber
     *            BOM item node number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     */
    public BOMItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String billOfMaterial,
        final String billOfMaterialCategory,
        final String billOfMaterialVariant,
        final String billOfMaterialVersion,
        final String technicalObject,
        final String plant,
        final String engineeringChangeDocument,
        final String billOfMaterialVariantUsage,
        final String billOfMaterialItemNodeNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("BillOfMaterial", billOfMaterial);
        this.key.put("BillOfMaterialCategory", billOfMaterialCategory);
        this.key.put("BillOfMaterialVariant", billOfMaterialVariant);
        this.key.put("BillOfMaterialVersion", billOfMaterialVersion);
        this.key.put("TechnicalObject", technicalObject);
        this.key.put("Plant", plant);
        this.key.put("EngineeringChangeDocument", engineeringChangeDocument);
        this.key.put("BillOfMaterialVariantUsage", billOfMaterialVariantUsage);
        this.key.put("BillOfMaterialItemNodeNumber", billOfMaterialItemNodeNumber);
    }

    @Override
    @Nonnull
    protected Class<BOMItem> getEntityClass()
    {
        return BOMItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
