/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>D_MaintBOMGetMaintBOMItemsR</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class D_MaintBOMGetMaintBOMItemsR extends VdmComplex<D_MaintBOMGetMaintBOMItemsR>
{

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>AlternativeItemGroup</b>
     * </p>
     *
     * @param alternativeItemGroup
     *
     * @return AltItemGroup
     */
    @SerializedName( "AlternativeItemGroup" )
    @JsonProperty( "AlternativeItemGroup" )
    @Nullable
    @ODataField( odataName = "AlternativeItemGroup" )
    private String alternativeItemGroup;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @param billOfMaterial
     *
     * @return Bill of Material
     */
    @SerializedName( "BillOfMaterial" )
    @JsonProperty( "BillOfMaterial" )
    @Nullable
    @ODataField( odataName = "BillOfMaterial" )
    private String billOfMaterial;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @param billOfMaterialCategory
     *
     * @return BOM category
     */
    @SerializedName( "BillOfMaterialCategory" )
    @JsonProperty( "BillOfMaterialCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialCategory" )
    private String billOfMaterialCategory;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialComponent</b>
     * </p>
     *
     * @param billOfMaterialComponent
     *
     * @return Component
     */
    @SerializedName( "BillOfMaterialComponent" )
    @JsonProperty( "BillOfMaterialComponent" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialComponent" )
    private String billOfMaterialComponent;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialHeaderUUID</b>
     * </p>
     *
     * @param billOfMaterialHeaderUUID
     *
     * @return ID hdr chge status
     */
    @SerializedName( "BillOfMaterialHeaderUUID" )
    @JsonProperty( "BillOfMaterialHeaderUUID" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialHeaderUUID" )
    private UUID billOfMaterialHeaderUUID;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialItemCategory</b>
     * </p>
     *
     * @param billOfMaterialItemCategory
     *
     * @return Item Category
     */
    @SerializedName( "BillOfMaterialItemCategory" )
    @JsonProperty( "BillOfMaterialItemCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemCategory" )
    private String billOfMaterialItemCategory;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialItemNodeNumber</b>
     * </p>
     *
     * @param billOfMaterialItemNodeNumber
     *
     * @return Item node
     */
    @SerializedName( "BillOfMaterialItemNodeNumber" )
    @JsonProperty( "BillOfMaterialItemNodeNumber" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemNodeNumber" )
    private String billOfMaterialItemNodeNumber;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialItemNumber</b>
     * </p>
     *
     * @param billOfMaterialItemNumber
     *
     * @return Item Number
     */
    @SerializedName( "BillOfMaterialItemNumber" )
    @JsonProperty( "BillOfMaterialItemNumber" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemNumber" )
    private String billOfMaterialItemNumber;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialItemQuantity</b>
     * </p>
     *
     * @param billOfMaterialItemQuantity
     *
     * @return Component Quantity
     */
    @SerializedName( "BillOfMaterialItemQuantity" )
    @JsonProperty( "BillOfMaterialItemQuantity" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemQuantity" )
    private BigDecimal billOfMaterialItemQuantity;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialItemUnit</b>
     * </p>
     *
     * @param billOfMaterialItemUnit
     *
     * @return Component UoM
     */
    @SerializedName( "BillOfMaterialItemUnit" )
    @JsonProperty( "BillOfMaterialItemUnit" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemUnit" )
    private String billOfMaterialItemUnit;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialItemUUID</b>
     * </p>
     *
     * @param billOfMaterialItemUUID
     *
     * @return ID item chge status
     */
    @SerializedName( "BillOfMaterialItemUUID" )
    @JsonProperty( "BillOfMaterialItemUUID" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemUUID" )
    private UUID billOfMaterialItemUUID;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @param billOfMaterialVariant
     *
     * @return Alternative BOM
     */
    @SerializedName( "BillOfMaterialVariant" )
    @JsonProperty( "BillOfMaterialVariant" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariant" )
    private String billOfMaterialVariant;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     * </p>
     *
     * @param billOfMaterialVariantUsage
     *
     * @return BOM Usage
     */
    @SerializedName( "BillOfMaterialVariantUsage" )
    @JsonProperty( "BillOfMaterialVariantUsage" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariantUsage" )
    private String billOfMaterialVariantUsage;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialVersion</b>
     * </p>
     *
     * @param billOfMaterialVersion
     *
     * @return BOM Version
     */
    @SerializedName( "BillOfMaterialVersion" )
    @JsonProperty( "BillOfMaterialVersion" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVersion" )
    private String billOfMaterialVersion;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>BOMIsRecursive</b>
     * </p>
     *
     * @param bOMIsRecursive
     *
     * @return Recursive
     */
    @SerializedName( "BOMIsRecursive" )
    @JsonProperty( "BOMIsRecursive" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BOMIsRecursive" )
    private Boolean bOMIsRecursive;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>BOMItemCreatedByUser</b>
     * </p>
     *
     * @param bOMItemCreatedByUser
     *
     * @return Created By
     */
    @SerializedName( "BOMItemCreatedByUser" )
    @JsonProperty( "BOMItemCreatedByUser" )
    @Nullable
    @ODataField( odataName = "BOMItemCreatedByUser" )
    private String bOMItemCreatedByUser;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>BOMItemDescription</b>
     * </p>
     *
     * @param bOMItemDescription
     *
     * @return Item Text
     */
    @SerializedName( "BOMItemDescription" )
    @JsonProperty( "BOMItemDescription" )
    @Nullable
    @ODataField( odataName = "BOMItemDescription" )
    private String bOMItemDescription;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>BOMItemInternalChangeCount</b>
     * </p>
     *
     * @param bOMItemInternalChangeCount
     *
     * @return Counter
     */
    @SerializedName( "BOMItemInternalChangeCount" )
    @JsonProperty( "BOMItemInternalChangeCount" )
    @Nullable
    @ODataField( odataName = "BOMItemInternalChangeCount" )
    private String bOMItemInternalChangeCount;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>BOMItemIsCostingRelevant</b>
     * </p>
     *
     * @param bOMItemIsCostingRelevant
     *
     * @return Relevancy to costing
     */
    @SerializedName( "BOMItemIsCostingRelevant" )
    @JsonProperty( "BOMItemIsCostingRelevant" )
    @Nullable
    @ODataField( odataName = "BOMItemIsCostingRelevant" )
    private String bOMItemIsCostingRelevant;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>BOMItemIsPlantMaintRelevant</b>
     * </p>
     *
     * @param bOMItemIsPlantMaintRelevant
     *
     * @return Plant maintenance
     */
    @SerializedName( "BOMItemIsPlantMaintRelevant" )
    @JsonProperty( "BOMItemIsPlantMaintRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BOMItemIsPlantMaintRelevant" )
    private Boolean bOMItemIsPlantMaintRelevant;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>BOMItemIsSalesRelevant</b>
     * </p>
     *
     * @param bOMItemIsSalesRelevant
     *
     * @return Relevant to sales
     */
    @SerializedName( "BOMItemIsSalesRelevant" )
    @JsonProperty( "BOMItemIsSalesRelevant" )
    @Nullable
    @ODataField( odataName = "BOMItemIsSalesRelevant" )
    private String bOMItemIsSalesRelevant;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>BOMItemIsSparePart</b>
     * </p>
     *
     * @param bOMItemIsSparePart
     *
     * @return Spare Part Indicator
     */
    @SerializedName( "BOMItemIsSparePart" )
    @JsonProperty( "BOMItemIsSparePart" )
    @Nullable
    @ODataField( odataName = "BOMItemIsSparePart" )
    private String bOMItemIsSparePart;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>BOMItemLastChangeDate</b>
     * </p>
     *
     * @param bOMItemLastChangeDate
     *
     * @return Changed On
     */
    @SerializedName( "BOMItemLastChangeDate" )
    @JsonProperty( "BOMItemLastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BOMItemLastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bOMItemLastChangeDate;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>BOMItemLastChangedByUser</b>
     * </p>
     *
     * @param bOMItemLastChangedByUser
     *
     * @return Changed By
     */
    @SerializedName( "BOMItemLastChangedByUser" )
    @JsonProperty( "BOMItemLastChangedByUser" )
    @Nullable
    @ODataField( odataName = "BOMItemLastChangedByUser" )
    private String bOMItemLastChangedByUser;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>BOMItemRecordCreationDate</b>
     * </p>
     *
     * @param bOMItemRecordCreationDate
     *
     * @return Created On
     */
    @SerializedName( "BOMItemRecordCreationDate" )
    @JsonProperty( "BOMItemRecordCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BOMItemRecordCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bOMItemRecordCreationDate;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>BOMItemSorter</b>
     * </p>
     *
     * @param bOMItemSorter
     *
     * @return Sort String
     */
    @SerializedName( "BOMItemSorter" )
    @JsonProperty( "BOMItemSorter" )
    @Nullable
    @ODataField( odataName = "BOMItemSorter" )
    private String bOMItemSorter;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>BOMItemText2</b>
     * </p>
     *
     * @param bOMItemText2
     *
     * @return Item Text 2
     */
    @SerializedName( "BOMItemText2" )
    @JsonProperty( "BOMItemText2" )
    @Nullable
    @ODataField( odataName = "BOMItemText2" )
    private String bOMItemText2;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>ChgToEngineeringChgDocument</b>
     * </p>
     *
     * @param chgToEngineeringChgDocument
     *
     * @return Change Number To
     */
    @SerializedName( "ChgToEngineeringChgDocument" )
    @JsonProperty( "ChgToEngineeringChgDocument" )
    @Nullable
    @ODataField( odataName = "ChgToEngineeringChgDocument" )
    private String chgToEngineeringChgDocument;
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property from the Odata EDM: <b>ClassNumber</b>
     * </p>
     *
     * @param classNumber
     *
     * @return Class
     */
    @SerializedName( "ClassNumber" )
    @JsonProperty( "ClassNumber" )
    @Nullable
    @ODataField( odataName = "ClassNumber" )
    private String classNumber;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @param classType
     *
     * @return Class Type
     */
    @SerializedName( "ClassType" )
    @JsonProperty( "ClassType" )
    @Nullable
    @ODataField( odataName = "ClassType" )
    private String classType;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>ComponentDescription</b>
     * </p>
     *
     * @param componentDescription
     *
     * @return Item Text
     */
    @SerializedName( "ComponentDescription" )
    @JsonProperty( "ComponentDescription" )
    @Nullable
    @ODataField( odataName = "ComponentDescription" )
    private String componentDescription;
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property from the Odata EDM: <b>ComponentScrapInPercent</b>
     * </p>
     *
     * @param componentScrapInPercent
     *
     * @return Component Scrap (%)
     */
    @SerializedName( "ComponentScrapInPercent" )
    @JsonProperty( "ComponentScrapInPercent" )
    @Nullable
    @ODataField( odataName = "ComponentScrapInPercent" )
    private BigDecimal componentScrapInPercent;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>CostElement</b>
     * </p>
     *
     * @param costElement
     *
     * @return Cost element
     */
    @SerializedName( "CostElement" )
    @JsonProperty( "CostElement" )
    @Nullable
    @ODataField( odataName = "CostElement" )
    private String costElement;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>Creditor</b>
     * </p>
     *
     * @param creditor
     *
     * @return Supplier
     */
    @SerializedName( "Creditor" )
    @JsonProperty( "Creditor" )
    @Nullable
    @ODataField( odataName = "Creditor" )
    private String creditor;
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *
     * @return Currency
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>DeliveryDurationInDays</b>
     * </p>
     *
     * @param deliveryDurationInDays
     *
     * @return Delivery time (days)
     */
    @SerializedName( "DeliveryDurationInDays" )
    @JsonProperty( "DeliveryDurationInDays" )
    @Nullable
    @ODataField( odataName = "DeliveryDurationInDays" )
    private BigDecimal deliveryDurationInDays;
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property from the Odata EDM: <b>DependencyObjectNumber</b>
     * </p>
     *
     * @param dependencyObjectNumber
     *
     * @return Assignment number
     */
    @SerializedName( "DependencyObjectNumber" )
    @JsonProperty( "DependencyObjectNumber" )
    @Nullable
    @ODataField( odataName = "DependencyObjectNumber" )
    private String dependencyObjectNumber;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>DiscontinuationGroup</b>
     * </p>
     *
     * @param discontinuationGroup
     *
     * @return Discont. group
     */
    @SerializedName( "DiscontinuationGroup" )
    @JsonProperty( "DiscontinuationGroup" )
    @Nullable
    @ODataField( odataName = "DiscontinuationGroup" )
    private String discontinuationGroup;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>DistrKeyCompConsumption</b>
     * </p>
     *
     * @param distrKeyCompConsumption
     *
     * @return Distribution key
     */
    @SerializedName( "DistrKeyCompConsumption" )
    @JsonProperty( "DistrKeyCompConsumption" )
    @Nullable
    @ODataField( odataName = "DistrKeyCompConsumption" )
    private String distrKeyCompConsumption;
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property from the Odata EDM: <b>DocNumber</b>
     * </p>
     *
     * @param docNumber
     *
     * @return Document
     */
    @SerializedName( "DocNumber" )
    @JsonProperty( "DocNumber" )
    @Nullable
    @ODataField( odataName = "DocNumber" )
    private String docNumber;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>DocumentIsCreatedByCAD</b>
     * </p>
     *
     * @param documentIsCreatedByCAD
     *
     * @return CAD Indicator
     */
    @SerializedName( "DocumentIsCreatedByCAD" )
    @JsonProperty( "DocumentIsCreatedByCAD" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DocumentIsCreatedByCAD" )
    private Boolean documentIsCreatedByCAD;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>DocumentPart</b>
     * </p>
     *
     * @param documentPart
     *
     * @return Document Part
     */
    @SerializedName( "DocumentPart" )
    @JsonProperty( "DocumentPart" )
    @Nullable
    @ODataField( odataName = "DocumentPart" )
    private String documentPart;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>DocumentType</b>
     * </p>
     *
     * @param documentType
     *
     * @return Document Type
     */
    @SerializedName( "DocumentType" )
    @JsonProperty( "DocumentType" )
    @Nullable
    @ODataField( odataName = "DocumentType" )
    private String documentType;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>DocumentVersion</b>
     * </p>
     *
     * @param documentVersion
     *
     * @return Document Version
     */
    @SerializedName( "DocumentVersion" )
    @JsonProperty( "DocumentVersion" )
    @Nullable
    @ODataField( odataName = "DocumentVersion" )
    private String documentVersion;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>EngineeringChangeDocument</b>
     * </p>
     *
     * @param engineeringChangeDocument
     *
     * @return Change Number
     */
    @SerializedName( "EngineeringChangeDocument" )
    @JsonProperty( "EngineeringChangeDocument" )
    @Nullable
    @ODataField( odataName = "EngineeringChangeDocument" )
    private String engineeringChangeDocument;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>ExplosionType</b>
     * </p>
     *
     * @param explosionType
     *
     * @return Explosion type
     */
    @SerializedName( "ExplosionType" )
    @JsonProperty( "ExplosionType" )
    @Nullable
    @ODataField( odataName = "ExplosionType" )
    private String explosionType;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>FollowUpGroup</b>
     * </p>
     *
     * @param followUpGroup
     *
     * @return Follow-up group
     */
    @SerializedName( "FollowUpGroup" )
    @JsonProperty( "FollowUpGroup" )
    @Nullable
    @ODataField( odataName = "FollowUpGroup" )
    private String followUpGroup;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>FormulaKey</b>
     * </p>
     *
     * @param formulaKey
     *
     * @return VSI Formula
     */
    @SerializedName( "FormulaKey" )
    @JsonProperty( "FormulaKey" )
    @Nullable
    @ODataField( odataName = "FormulaKey" )
    private String formulaKey;
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>GoodsReceiptDuration</b>
     * </p>
     *
     * @param goodsReceiptDuration
     *
     * @return GR processing time
     */
    @SerializedName( "GoodsReceiptDuration" )
    @JsonProperty( "GoodsReceiptDuration" )
    @Nullable
    @ODataField( odataName = "GoodsReceiptDuration" )
    private BigDecimal goodsReceiptDuration;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>IdentifierBOMItem</b>
     * </p>
     *
     * @param identifierBOMItem
     *
     * @return Item identification
     */
    @SerializedName( "IdentifierBOMItem" )
    @JsonProperty( "IdentifierBOMItem" )
    @Nullable
    @ODataField( odataName = "IdentifierBOMItem" )
    private String identifierBOMItem;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>InheritedNodeNumberForBOMItem</b>
     * </p>
     *
     * @param inheritedNodeNumberForBOMItem
     *
     * @return Item node
     */
    @SerializedName( "InheritedNodeNumberForBOMItem" )
    @JsonProperty( "InheritedNodeNumberForBOMItem" )
    @Nullable
    @ODataField( odataName = "InheritedNodeNumberForBOMItem" )
    private String inheritedNodeNumberForBOMItem;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsALE</b>
     * </p>
     *
     * @param isALE
     *
     * @return ALE indicator
     */
    @SerializedName( "IsALE" )
    @JsonProperty( "IsALE" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsALE" )
    private Boolean isALE;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>IsAssembly</b>
     * </p>
     *
     * @param isAssembly
     *
     * @return Assembly
     */
    @SerializedName( "IsAssembly" )
    @JsonProperty( "IsAssembly" )
    @Nullable
    @ODataField( odataName = "IsAssembly" )
    private String isAssembly;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsBOMRecursiveAllowed</b>
     * </p>
     *
     * @param isBOMRecursiveAllowed
     *
     * @return Recurs. allowed
     */
    @SerializedName( "IsBOMRecursiveAllowed" )
    @JsonProperty( "IsBOMRecursiveAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsBOMRecursiveAllowed" )
    private Boolean isBOMRecursiveAllowed;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsBulkMaterial</b>
     * </p>
     *
     * @param isBulkMaterial
     *
     * @return Bulk Material
     */
    @SerializedName( "IsBulkMaterial" )
    @JsonProperty( "IsBulkMaterial" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsBulkMaterial" )
    private Boolean isBulkMaterial;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsClassificationRelevant</b>
     * </p>
     *
     * @param isClassificationRelevant
     *
     * @return as selection cond.
     */
    @SerializedName( "IsClassificationRelevant" )
    @JsonProperty( "IsClassificationRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsClassificationRelevant" )
    private Boolean isClassificationRelevant;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>IsConfigurableBOM</b>
     * </p>
     *
     * @param isConfigurableBOM
     *
     * @return Selection indicator
     */
    @SerializedName( "IsConfigurableBOM" )
    @JsonProperty( "IsConfigurableBOM" )
    @Nullable
    @ODataField( odataName = "IsConfigurableBOM" )
    private String isConfigurableBOM;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *
     * @return Deletion Indicator
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDeleted" )
    private Boolean isDeleted;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsEngineeringRelevant</b>
     * </p>
     *
     * @param isEngineeringRelevant
     *
     * @return Engineering/design
     */
    @SerializedName( "IsEngineeringRelevant" )
    @JsonProperty( "IsEngineeringRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsEngineeringRelevant" )
    private Boolean isEngineeringRelevant;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>IsMaterialProvision</b>
     * </p>
     *
     * @param isMaterialProvision
     *
     * @return Mat. Provision Ind.
     */
    @SerializedName( "IsMaterialProvision" )
    @JsonProperty( "IsMaterialProvision" )
    @Nullable
    @ODataField( odataName = "IsMaterialProvision" )
    private String isMaterialProvision;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsNetScrap</b>
     * </p>
     *
     * @param isNetScrap
     *
     * @return Net Scrap Indicator
     */
    @SerializedName( "IsNetScrap" )
    @JsonProperty( "IsNetScrap" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsNetScrap" )
    private Boolean isNetScrap;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsProductionRelevant</b>
     * </p>
     *
     * @param isProductionRelevant
     *
     * @return Production relevant
     */
    @SerializedName( "IsProductionRelevant" )
    @JsonProperty( "IsProductionRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsProductionRelevant" )
    private Boolean isProductionRelevant;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsSubItem</b>
     * </p>
     *
     * @param isSubItem
     *
     * @return Sub-item indicator
     */
    @SerializedName( "IsSubItem" )
    @JsonProperty( "IsSubItem" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsSubItem" )
    private Boolean isSubItem;
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>LeadTimeOffset</b>
     * </p>
     *
     * @param leadTimeOffset
     *
     * @return Lead-time offset
     */
    @SerializedName( "LeadTimeOffset" )
    @JsonProperty( "LeadTimeOffset" )
    @Nullable
    @ODataField( odataName = "LeadTimeOffset" )
    private BigDecimal leadTimeOffset;
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>MaterialComponentPrice</b>
     * </p>
     *
     * @param materialComponentPrice
     *
     * @return Price
     */
    @SerializedName( "MaterialComponentPrice" )
    @JsonProperty( "MaterialComponentPrice" )
    @Nullable
    @ODataField( odataName = "MaterialComponentPrice" )
    private BigDecimal materialComponentPrice;
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>MaterialIsCoProduct</b>
     * </p>
     *
     * @param materialIsCoProduct
     *
     * @return Co-product
     */
    @SerializedName( "MaterialIsCoProduct" )
    @JsonProperty( "MaterialIsCoProduct" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaterialIsCoProduct" )
    private Boolean materialIsCoProduct;
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>MaterialPriceUnitQty</b>
     * </p>
     *
     * @param materialPriceUnitQty
     *
     * @return Price unit
     */
    @SerializedName( "MaterialPriceUnitQty" )
    @JsonProperty( "MaterialPriceUnitQty" )
    @Nullable
    @ODataField( odataName = "MaterialPriceUnitQty" )
    private BigDecimal materialPriceUnitQty;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>MultipleSelectionAllowed</b>
     * </p>
     *
     * @param multipleSelectionAllowed
     *
     * @return Multiple Selection
     */
    @SerializedName( "MultipleSelectionAllowed" )
    @JsonProperty( "MultipleSelectionAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MultipleSelectionAllowed" )
    private Boolean multipleSelectionAllowed;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>ObjectType</b>
     * </p>
     *
     * @param objectType
     *
     * @return Object Type
     */
    @SerializedName( "ObjectType" )
    @JsonProperty( "ObjectType" )
    @Nullable
    @ODataField( odataName = "ObjectType" )
    private String objectType;
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>OperationLeadTimeOffset</b>
     * </p>
     *
     * @param operationLeadTimeOffset
     *
     * @return Oper. LT offset
     */
    @SerializedName( "OperationLeadTimeOffset" )
    @JsonProperty( "OperationLeadTimeOffset" )
    @Nullable
    @ODataField( odataName = "OperationLeadTimeOffset" )
    private BigDecimal operationLeadTimeOffset;
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property from the Odata EDM: <b>OperationScrapInPercent</b>
     * </p>
     *
     * @param operationScrapInPercent
     *
     * @return Operation Scrap in %
     */
    @SerializedName( "OperationScrapInPercent" )
    @JsonProperty( "OperationScrapInPercent" )
    @Nullable
    @ODataField( odataName = "OperationScrapInPercent" )
    private BigDecimal operationScrapInPercent;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>OpsLeadTimeOffsetUnit</b>
     * </p>
     *
     * @param opsLeadTimeOffsetUnit
     *
     * @return Operation LTO unit
     */
    @SerializedName( "OpsLeadTimeOffsetUnit" )
    @JsonProperty( "OpsLeadTimeOffsetUnit" )
    @Nullable
    @ODataField( odataName = "OpsLeadTimeOffsetUnit" )
    private String opsLeadTimeOffsetUnit;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>ProdOrderIssueLocation</b>
     * </p>
     *
     * @param prodOrderIssueLocation
     *
     * @return Storage Location
     */
    @SerializedName( "ProdOrderIssueLocation" )
    @JsonProperty( "ProdOrderIssueLocation" )
    @Nullable
    @ODataField( odataName = "ProdOrderIssueLocation" )
    private String prodOrderIssueLocation;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @param productionSupplyArea
     *
     * @return Prodn Supply Area
     */
    @SerializedName( "ProductionSupplyArea" )
    @JsonProperty( "ProductionSupplyArea" )
    @Nullable
    @ODataField( odataName = "ProductionSupplyArea" )
    private String productionSupplyArea;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *
     * @return Purch. Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>QuantityVariableSizeItem</b>
     * </p>
     *
     * @param quantityVariableSizeItem
     *
     * @return VSI Quantity per PC
     */
    @SerializedName( "QuantityVariableSizeItem" )
    @JsonProperty( "QuantityVariableSizeItem" )
    @Nullable
    @ODataField( odataName = "QuantityVariableSizeItem" )
    private BigDecimal quantityVariableSizeItem;
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property from the Odata EDM: <b>ReferencePoint</b>
     * </p>
     *
     * @param referencePoint
     *
     * @return Reference point
     */
    @SerializedName( "ReferencePoint" )
    @JsonProperty( "ReferencePoint" )
    @Nullable
    @ODataField( odataName = "ReferencePoint" )
    private String referencePoint;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>RequiredComponent</b>
     * </p>
     *
     * @param requiredComponent
     *
     * @return Required Component
     */
    @SerializedName( "RequiredComponent" )
    @JsonProperty( "RequiredComponent" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "RequiredComponent" )
    private Boolean requiredComponent;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>ResultingItemCategory</b>
     * </p>
     *
     * @param resultingItemCategory
     *
     * @return Res. item category
     */
    @SerializedName( "ResultingItemCategory" )
    @JsonProperty( "ResultingItemCategory" )
    @Nullable
    @ODataField( odataName = "ResultingItemCategory" )
    private String resultingItemCategory;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>Size1</b>
     * </p>
     *
     * @param size1
     *
     * @return Size 1
     */
    @SerializedName( "Size1" )
    @JsonProperty( "Size1" )
    @Nullable
    @ODataField( odataName = "Size1" )
    private BigDecimal size1;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>Size2</b>
     * </p>
     *
     * @param size2
     *
     * @return Size 2
     */
    @SerializedName( "Size2" )
    @JsonProperty( "Size2" )
    @Nullable
    @ODataField( odataName = "Size2" )
    private BigDecimal size2;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>Size3</b>
     * </p>
     *
     * @param size3
     *
     * @return Size 3
     */
    @SerializedName( "Size3" )
    @JsonProperty( "Size3" )
    @Nullable
    @ODataField( odataName = "Size3" )
    private BigDecimal size3;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>SpecialProcurementType</b>
     * </p>
     *
     * @param specialProcurementType
     *
     * @return Special Procurement
     */
    @SerializedName( "SpecialProcurementType" )
    @JsonProperty( "SpecialProcurementType" )
    @Nullable
    @ODataField( odataName = "SpecialProcurementType" )
    private String specialProcurementType;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>TechnicalObject</b>
     * </p>
     *
     * @param technicalObject
     *
     * @return Technical Object
     */
    @SerializedName( "TechnicalObject" )
    @JsonProperty( "TechnicalObject" )
    @Nullable
    @ODataField( odataName = "TechnicalObject" )
    private String technicalObject;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>UnitOfMeasureForSize1To3</b>
     * </p>
     *
     * @param unitOfMeasureForSize1To3
     *
     * @return Size unit
     */
    @SerializedName( "UnitOfMeasureForSize1To3" )
    @JsonProperty( "UnitOfMeasureForSize1To3" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasureForSize1To3" )
    private String unitOfMeasureForSize1To3;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *
     * @return Valid to
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *
     * @return Valid From
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;

    @Nonnull
    @Override
    public Class<D_MaintBOMGetMaintBOMItemsR> getType()
    {
        return D_MaintBOMGetMaintBOMItemsR.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AlternativeItemGroup", getAlternativeItemGroup());
        values.put("BillOfMaterial", getBillOfMaterial());
        values.put("BillOfMaterialCategory", getBillOfMaterialCategory());
        values.put("BillOfMaterialComponent", getBillOfMaterialComponent());
        values.put("BillOfMaterialHeaderUUID", getBillOfMaterialHeaderUUID());
        values.put("BillOfMaterialItemCategory", getBillOfMaterialItemCategory());
        values.put("BillOfMaterialItemNodeNumber", getBillOfMaterialItemNodeNumber());
        values.put("BillOfMaterialItemNumber", getBillOfMaterialItemNumber());
        values.put("BillOfMaterialItemQuantity", getBillOfMaterialItemQuantity());
        values.put("BillOfMaterialItemUnit", getBillOfMaterialItemUnit());
        values.put("BillOfMaterialItemUUID", getBillOfMaterialItemUUID());
        values.put("BillOfMaterialVariant", getBillOfMaterialVariant());
        values.put("BillOfMaterialVariantUsage", getBillOfMaterialVariantUsage());
        values.put("BillOfMaterialVersion", getBillOfMaterialVersion());
        values.put("BOMIsRecursive", getBOMIsRecursive());
        values.put("BOMItemCreatedByUser", getBOMItemCreatedByUser());
        values.put("BOMItemDescription", getBOMItemDescription());
        values.put("BOMItemInternalChangeCount", getBOMItemInternalChangeCount());
        values.put("BOMItemIsCostingRelevant", getBOMItemIsCostingRelevant());
        values.put("BOMItemIsPlantMaintRelevant", getBOMItemIsPlantMaintRelevant());
        values.put("BOMItemIsSalesRelevant", getBOMItemIsSalesRelevant());
        values.put("BOMItemIsSparePart", getBOMItemIsSparePart());
        values.put("BOMItemLastChangeDate", getBOMItemLastChangeDate());
        values.put("BOMItemLastChangedByUser", getBOMItemLastChangedByUser());
        values.put("BOMItemRecordCreationDate", getBOMItemRecordCreationDate());
        values.put("BOMItemSorter", getBOMItemSorter());
        values.put("BOMItemText2", getBOMItemText2());
        values.put("ChgToEngineeringChgDocument", getChgToEngineeringChgDocument());
        values.put("ClassNumber", getClassNumber());
        values.put("ClassType", getClassType());
        values.put("ComponentDescription", getComponentDescription());
        values.put("ComponentScrapInPercent", getComponentScrapInPercent());
        values.put("CostElement", getCostElement());
        values.put("Creditor", getCreditor());
        values.put("Currency", getCurrency());
        values.put("DeliveryDurationInDays", getDeliveryDurationInDays());
        values.put("DependencyObjectNumber", getDependencyObjectNumber());
        values.put("DiscontinuationGroup", getDiscontinuationGroup());
        values.put("DistrKeyCompConsumption", getDistrKeyCompConsumption());
        values.put("DocNumber", getDocNumber());
        values.put("DocumentIsCreatedByCAD", getDocumentIsCreatedByCAD());
        values.put("DocumentPart", getDocumentPart());
        values.put("DocumentType", getDocumentType());
        values.put("DocumentVersion", getDocumentVersion());
        values.put("EngineeringChangeDocument", getEngineeringChangeDocument());
        values.put("ExplosionType", getExplosionType());
        values.put("FollowUpGroup", getFollowUpGroup());
        values.put("FormulaKey", getFormulaKey());
        values.put("GoodsReceiptDuration", getGoodsReceiptDuration());
        values.put("IdentifierBOMItem", getIdentifierBOMItem());
        values.put("InheritedNodeNumberForBOMItem", getInheritedNodeNumberForBOMItem());
        values.put("IsALE", getIsALE());
        values.put("IsAssembly", getIsAssembly());
        values.put("IsBOMRecursiveAllowed", getIsBOMRecursiveAllowed());
        values.put("IsBulkMaterial", getIsBulkMaterial());
        values.put("IsClassificationRelevant", getIsClassificationRelevant());
        values.put("IsConfigurableBOM", getIsConfigurableBOM());
        values.put("IsDeleted", getIsDeleted());
        values.put("IsEngineeringRelevant", getIsEngineeringRelevant());
        values.put("IsMaterialProvision", getIsMaterialProvision());
        values.put("IsNetScrap", getIsNetScrap());
        values.put("IsProductionRelevant", getIsProductionRelevant());
        values.put("IsSubItem", getIsSubItem());
        values.put("LeadTimeOffset", getLeadTimeOffset());
        values.put("MaterialComponentPrice", getMaterialComponentPrice());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("MaterialIsCoProduct", getMaterialIsCoProduct());
        values.put("MaterialPriceUnitQty", getMaterialPriceUnitQty());
        values.put("MultipleSelectionAllowed", getMultipleSelectionAllowed());
        values.put("ObjectType", getObjectType());
        values.put("OperationLeadTimeOffset", getOperationLeadTimeOffset());
        values.put("OperationScrapInPercent", getOperationScrapInPercent());
        values.put("OpsLeadTimeOffsetUnit", getOpsLeadTimeOffsetUnit());
        values.put("Plant", getPlant());
        values.put("ProdOrderIssueLocation", getProdOrderIssueLocation());
        values.put("ProductionSupplyArea", getProductionSupplyArea());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("QuantityVariableSizeItem", getQuantityVariableSizeItem());
        values.put("ReferencePoint", getReferencePoint());
        values.put("RequiredComponent", getRequiredComponent());
        values.put("ResultingItemCategory", getResultingItemCategory());
        values.put("Size1", getSize1());
        values.put("Size2", getSize2());
        values.put("Size3", getSize3());
        values.put("SpecialProcurementType", getSpecialProcurementType());
        values.put("TechnicalObject", getTechnicalObject());
        values.put("UnitOfMeasureForSize1To3", getUnitOfMeasureForSize1To3());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ValidityStartDate", getValidityStartDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AlternativeItemGroup") ) {
                final Object value = values.remove("AlternativeItemGroup");
                if( (value == null) || (!value.equals(getAlternativeItemGroup())) ) {
                    setAlternativeItemGroup(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterial") ) {
                final Object value = values.remove("BillOfMaterial");
                if( (value == null) || (!value.equals(getBillOfMaterial())) ) {
                    setBillOfMaterial(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialCategory") ) {
                final Object value = values.remove("BillOfMaterialCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialCategory())) ) {
                    setBillOfMaterialCategory(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialComponent") ) {
                final Object value = values.remove("BillOfMaterialComponent");
                if( (value == null) || (!value.equals(getBillOfMaterialComponent())) ) {
                    setBillOfMaterialComponent(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialHeaderUUID") ) {
                final Object value = values.remove("BillOfMaterialHeaderUUID");
                if( (value == null) || (!value.equals(getBillOfMaterialHeaderUUID())) ) {
                    setBillOfMaterialHeaderUUID(((UUID) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemCategory") ) {
                final Object value = values.remove("BillOfMaterialItemCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialItemCategory())) ) {
                    setBillOfMaterialItemCategory(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemNodeNumber") ) {
                final Object value = values.remove("BillOfMaterialItemNodeNumber");
                if( (value == null) || (!value.equals(getBillOfMaterialItemNodeNumber())) ) {
                    setBillOfMaterialItemNodeNumber(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemNumber") ) {
                final Object value = values.remove("BillOfMaterialItemNumber");
                if( (value == null) || (!value.equals(getBillOfMaterialItemNumber())) ) {
                    setBillOfMaterialItemNumber(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemQuantity") ) {
                final Object value = values.remove("BillOfMaterialItemQuantity");
                if( (value == null) || (!value.equals(getBillOfMaterialItemQuantity())) ) {
                    setBillOfMaterialItemQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemUnit") ) {
                final Object value = values.remove("BillOfMaterialItemUnit");
                if( (value == null) || (!value.equals(getBillOfMaterialItemUnit())) ) {
                    setBillOfMaterialItemUnit(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemUUID") ) {
                final Object value = values.remove("BillOfMaterialItemUUID");
                if( (value == null) || (!value.equals(getBillOfMaterialItemUUID())) ) {
                    setBillOfMaterialItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariant") ) {
                final Object value = values.remove("BillOfMaterialVariant");
                if( (value == null) || (!value.equals(getBillOfMaterialVariant())) ) {
                    setBillOfMaterialVariant(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariantUsage") ) {
                final Object value = values.remove("BillOfMaterialVariantUsage");
                if( (value == null) || (!value.equals(getBillOfMaterialVariantUsage())) ) {
                    setBillOfMaterialVariantUsage(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVersion") ) {
                final Object value = values.remove("BillOfMaterialVersion");
                if( (value == null) || (!value.equals(getBillOfMaterialVersion())) ) {
                    setBillOfMaterialVersion(((String) value));
                }
            }
            if( values.containsKey("BOMIsRecursive") ) {
                final Object value = values.remove("BOMIsRecursive");
                if( (value == null) || (!value.equals(getBOMIsRecursive())) ) {
                    setBOMIsRecursive(((Boolean) value));
                }
            }
            if( values.containsKey("BOMItemCreatedByUser") ) {
                final Object value = values.remove("BOMItemCreatedByUser");
                if( (value == null) || (!value.equals(getBOMItemCreatedByUser())) ) {
                    setBOMItemCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("BOMItemDescription") ) {
                final Object value = values.remove("BOMItemDescription");
                if( (value == null) || (!value.equals(getBOMItemDescription())) ) {
                    setBOMItemDescription(((String) value));
                }
            }
            if( values.containsKey("BOMItemInternalChangeCount") ) {
                final Object value = values.remove("BOMItemInternalChangeCount");
                if( (value == null) || (!value.equals(getBOMItemInternalChangeCount())) ) {
                    setBOMItemInternalChangeCount(((String) value));
                }
            }
            if( values.containsKey("BOMItemIsCostingRelevant") ) {
                final Object value = values.remove("BOMItemIsCostingRelevant");
                if( (value == null) || (!value.equals(getBOMItemIsCostingRelevant())) ) {
                    setBOMItemIsCostingRelevant(((String) value));
                }
            }
            if( values.containsKey("BOMItemIsPlantMaintRelevant") ) {
                final Object value = values.remove("BOMItemIsPlantMaintRelevant");
                if( (value == null) || (!value.equals(getBOMItemIsPlantMaintRelevant())) ) {
                    setBOMItemIsPlantMaintRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("BOMItemIsSalesRelevant") ) {
                final Object value = values.remove("BOMItemIsSalesRelevant");
                if( (value == null) || (!value.equals(getBOMItemIsSalesRelevant())) ) {
                    setBOMItemIsSalesRelevant(((String) value));
                }
            }
            if( values.containsKey("BOMItemIsSparePart") ) {
                final Object value = values.remove("BOMItemIsSparePart");
                if( (value == null) || (!value.equals(getBOMItemIsSparePart())) ) {
                    setBOMItemIsSparePart(((String) value));
                }
            }
            if( values.containsKey("BOMItemLastChangeDate") ) {
                final Object value = values.remove("BOMItemLastChangeDate");
                if( (value == null) || (!value.equals(getBOMItemLastChangeDate())) ) {
                    setBOMItemLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BOMItemLastChangedByUser") ) {
                final Object value = values.remove("BOMItemLastChangedByUser");
                if( (value == null) || (!value.equals(getBOMItemLastChangedByUser())) ) {
                    setBOMItemLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("BOMItemRecordCreationDate") ) {
                final Object value = values.remove("BOMItemRecordCreationDate");
                if( (value == null) || (!value.equals(getBOMItemRecordCreationDate())) ) {
                    setBOMItemRecordCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BOMItemSorter") ) {
                final Object value = values.remove("BOMItemSorter");
                if( (value == null) || (!value.equals(getBOMItemSorter())) ) {
                    setBOMItemSorter(((String) value));
                }
            }
            if( values.containsKey("BOMItemText2") ) {
                final Object value = values.remove("BOMItemText2");
                if( (value == null) || (!value.equals(getBOMItemText2())) ) {
                    setBOMItemText2(((String) value));
                }
            }
            if( values.containsKey("ChgToEngineeringChgDocument") ) {
                final Object value = values.remove("ChgToEngineeringChgDocument");
                if( (value == null) || (!value.equals(getChgToEngineeringChgDocument())) ) {
                    setChgToEngineeringChgDocument(((String) value));
                }
            }
            if( values.containsKey("ClassNumber") ) {
                final Object value = values.remove("ClassNumber");
                if( (value == null) || (!value.equals(getClassNumber())) ) {
                    setClassNumber(((String) value));
                }
            }
            if( values.containsKey("ClassType") ) {
                final Object value = values.remove("ClassType");
                if( (value == null) || (!value.equals(getClassType())) ) {
                    setClassType(((String) value));
                }
            }
            if( values.containsKey("ComponentDescription") ) {
                final Object value = values.remove("ComponentDescription");
                if( (value == null) || (!value.equals(getComponentDescription())) ) {
                    setComponentDescription(((String) value));
                }
            }
            if( values.containsKey("ComponentScrapInPercent") ) {
                final Object value = values.remove("ComponentScrapInPercent");
                if( (value == null) || (!value.equals(getComponentScrapInPercent())) ) {
                    setComponentScrapInPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CostElement") ) {
                final Object value = values.remove("CostElement");
                if( (value == null) || (!value.equals(getCostElement())) ) {
                    setCostElement(((String) value));
                }
            }
            if( values.containsKey("Creditor") ) {
                final Object value = values.remove("Creditor");
                if( (value == null) || (!value.equals(getCreditor())) ) {
                    setCreditor(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("DeliveryDurationInDays") ) {
                final Object value = values.remove("DeliveryDurationInDays");
                if( (value == null) || (!value.equals(getDeliveryDurationInDays())) ) {
                    setDeliveryDurationInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("DependencyObjectNumber") ) {
                final Object value = values.remove("DependencyObjectNumber");
                if( (value == null) || (!value.equals(getDependencyObjectNumber())) ) {
                    setDependencyObjectNumber(((String) value));
                }
            }
            if( values.containsKey("DiscontinuationGroup") ) {
                final Object value = values.remove("DiscontinuationGroup");
                if( (value == null) || (!value.equals(getDiscontinuationGroup())) ) {
                    setDiscontinuationGroup(((String) value));
                }
            }
            if( values.containsKey("DistrKeyCompConsumption") ) {
                final Object value = values.remove("DistrKeyCompConsumption");
                if( (value == null) || (!value.equals(getDistrKeyCompConsumption())) ) {
                    setDistrKeyCompConsumption(((String) value));
                }
            }
            if( values.containsKey("DocNumber") ) {
                final Object value = values.remove("DocNumber");
                if( (value == null) || (!value.equals(getDocNumber())) ) {
                    setDocNumber(((String) value));
                }
            }
            if( values.containsKey("DocumentIsCreatedByCAD") ) {
                final Object value = values.remove("DocumentIsCreatedByCAD");
                if( (value == null) || (!value.equals(getDocumentIsCreatedByCAD())) ) {
                    setDocumentIsCreatedByCAD(((Boolean) value));
                }
            }
            if( values.containsKey("DocumentPart") ) {
                final Object value = values.remove("DocumentPart");
                if( (value == null) || (!value.equals(getDocumentPart())) ) {
                    setDocumentPart(((String) value));
                }
            }
            if( values.containsKey("DocumentType") ) {
                final Object value = values.remove("DocumentType");
                if( (value == null) || (!value.equals(getDocumentType())) ) {
                    setDocumentType(((String) value));
                }
            }
            if( values.containsKey("DocumentVersion") ) {
                final Object value = values.remove("DocumentVersion");
                if( (value == null) || (!value.equals(getDocumentVersion())) ) {
                    setDocumentVersion(((String) value));
                }
            }
            if( values.containsKey("EngineeringChangeDocument") ) {
                final Object value = values.remove("EngineeringChangeDocument");
                if( (value == null) || (!value.equals(getEngineeringChangeDocument())) ) {
                    setEngineeringChangeDocument(((String) value));
                }
            }
            if( values.containsKey("ExplosionType") ) {
                final Object value = values.remove("ExplosionType");
                if( (value == null) || (!value.equals(getExplosionType())) ) {
                    setExplosionType(((String) value));
                }
            }
            if( values.containsKey("FollowUpGroup") ) {
                final Object value = values.remove("FollowUpGroup");
                if( (value == null) || (!value.equals(getFollowUpGroup())) ) {
                    setFollowUpGroup(((String) value));
                }
            }
            if( values.containsKey("FormulaKey") ) {
                final Object value = values.remove("FormulaKey");
                if( (value == null) || (!value.equals(getFormulaKey())) ) {
                    setFormulaKey(((String) value));
                }
            }
            if( values.containsKey("GoodsReceiptDuration") ) {
                final Object value = values.remove("GoodsReceiptDuration");
                if( (value == null) || (!value.equals(getGoodsReceiptDuration())) ) {
                    setGoodsReceiptDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("IdentifierBOMItem") ) {
                final Object value = values.remove("IdentifierBOMItem");
                if( (value == null) || (!value.equals(getIdentifierBOMItem())) ) {
                    setIdentifierBOMItem(((String) value));
                }
            }
            if( values.containsKey("InheritedNodeNumberForBOMItem") ) {
                final Object value = values.remove("InheritedNodeNumberForBOMItem");
                if( (value == null) || (!value.equals(getInheritedNodeNumberForBOMItem())) ) {
                    setInheritedNodeNumberForBOMItem(((String) value));
                }
            }
            if( values.containsKey("IsALE") ) {
                final Object value = values.remove("IsALE");
                if( (value == null) || (!value.equals(getIsALE())) ) {
                    setIsALE(((Boolean) value));
                }
            }
            if( values.containsKey("IsAssembly") ) {
                final Object value = values.remove("IsAssembly");
                if( (value == null) || (!value.equals(getIsAssembly())) ) {
                    setIsAssembly(((String) value));
                }
            }
            if( values.containsKey("IsBOMRecursiveAllowed") ) {
                final Object value = values.remove("IsBOMRecursiveAllowed");
                if( (value == null) || (!value.equals(getIsBOMRecursiveAllowed())) ) {
                    setIsBOMRecursiveAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("IsBulkMaterial") ) {
                final Object value = values.remove("IsBulkMaterial");
                if( (value == null) || (!value.equals(getIsBulkMaterial())) ) {
                    setIsBulkMaterial(((Boolean) value));
                }
            }
            if( values.containsKey("IsClassificationRelevant") ) {
                final Object value = values.remove("IsClassificationRelevant");
                if( (value == null) || (!value.equals(getIsClassificationRelevant())) ) {
                    setIsClassificationRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("IsConfigurableBOM") ) {
                final Object value = values.remove("IsConfigurableBOM");
                if( (value == null) || (!value.equals(getIsConfigurableBOM())) ) {
                    setIsConfigurableBOM(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("IsEngineeringRelevant") ) {
                final Object value = values.remove("IsEngineeringRelevant");
                if( (value == null) || (!value.equals(getIsEngineeringRelevant())) ) {
                    setIsEngineeringRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("IsMaterialProvision") ) {
                final Object value = values.remove("IsMaterialProvision");
                if( (value == null) || (!value.equals(getIsMaterialProvision())) ) {
                    setIsMaterialProvision(((String) value));
                }
            }
            if( values.containsKey("IsNetScrap") ) {
                final Object value = values.remove("IsNetScrap");
                if( (value == null) || (!value.equals(getIsNetScrap())) ) {
                    setIsNetScrap(((Boolean) value));
                }
            }
            if( values.containsKey("IsProductionRelevant") ) {
                final Object value = values.remove("IsProductionRelevant");
                if( (value == null) || (!value.equals(getIsProductionRelevant())) ) {
                    setIsProductionRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("IsSubItem") ) {
                final Object value = values.remove("IsSubItem");
                if( (value == null) || (!value.equals(getIsSubItem())) ) {
                    setIsSubItem(((Boolean) value));
                }
            }
            if( values.containsKey("LeadTimeOffset") ) {
                final Object value = values.remove("LeadTimeOffset");
                if( (value == null) || (!value.equals(getLeadTimeOffset())) ) {
                    setLeadTimeOffset(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialComponentPrice") ) {
                final Object value = values.remove("MaterialComponentPrice");
                if( (value == null) || (!value.equals(getMaterialComponentPrice())) ) {
                    setMaterialComponentPrice(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialIsCoProduct") ) {
                final Object value = values.remove("MaterialIsCoProduct");
                if( (value == null) || (!value.equals(getMaterialIsCoProduct())) ) {
                    setMaterialIsCoProduct(((Boolean) value));
                }
            }
            if( values.containsKey("MaterialPriceUnitQty") ) {
                final Object value = values.remove("MaterialPriceUnitQty");
                if( (value == null) || (!value.equals(getMaterialPriceUnitQty())) ) {
                    setMaterialPriceUnitQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("MultipleSelectionAllowed") ) {
                final Object value = values.remove("MultipleSelectionAllowed");
                if( (value == null) || (!value.equals(getMultipleSelectionAllowed())) ) {
                    setMultipleSelectionAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("ObjectType") ) {
                final Object value = values.remove("ObjectType");
                if( (value == null) || (!value.equals(getObjectType())) ) {
                    setObjectType(((String) value));
                }
            }
            if( values.containsKey("OperationLeadTimeOffset") ) {
                final Object value = values.remove("OperationLeadTimeOffset");
                if( (value == null) || (!value.equals(getOperationLeadTimeOffset())) ) {
                    setOperationLeadTimeOffset(((BigDecimal) value));
                }
            }
            if( values.containsKey("OperationScrapInPercent") ) {
                final Object value = values.remove("OperationScrapInPercent");
                if( (value == null) || (!value.equals(getOperationScrapInPercent())) ) {
                    setOperationScrapInPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpsLeadTimeOffsetUnit") ) {
                final Object value = values.remove("OpsLeadTimeOffsetUnit");
                if( (value == null) || (!value.equals(getOpsLeadTimeOffsetUnit())) ) {
                    setOpsLeadTimeOffsetUnit(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ProdOrderIssueLocation") ) {
                final Object value = values.remove("ProdOrderIssueLocation");
                if( (value == null) || (!value.equals(getProdOrderIssueLocation())) ) {
                    setProdOrderIssueLocation(((String) value));
                }
            }
            if( values.containsKey("ProductionSupplyArea") ) {
                final Object value = values.remove("ProductionSupplyArea");
                if( (value == null) || (!value.equals(getProductionSupplyArea())) ) {
                    setProductionSupplyArea(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("QuantityVariableSizeItem") ) {
                final Object value = values.remove("QuantityVariableSizeItem");
                if( (value == null) || (!value.equals(getQuantityVariableSizeItem())) ) {
                    setQuantityVariableSizeItem(((BigDecimal) value));
                }
            }
            if( values.containsKey("ReferencePoint") ) {
                final Object value = values.remove("ReferencePoint");
                if( (value == null) || (!value.equals(getReferencePoint())) ) {
                    setReferencePoint(((String) value));
                }
            }
            if( values.containsKey("RequiredComponent") ) {
                final Object value = values.remove("RequiredComponent");
                if( (value == null) || (!value.equals(getRequiredComponent())) ) {
                    setRequiredComponent(((Boolean) value));
                }
            }
            if( values.containsKey("ResultingItemCategory") ) {
                final Object value = values.remove("ResultingItemCategory");
                if( (value == null) || (!value.equals(getResultingItemCategory())) ) {
                    setResultingItemCategory(((String) value));
                }
            }
            if( values.containsKey("Size1") ) {
                final Object value = values.remove("Size1");
                if( (value == null) || (!value.equals(getSize1())) ) {
                    setSize1(((BigDecimal) value));
                }
            }
            if( values.containsKey("Size2") ) {
                final Object value = values.remove("Size2");
                if( (value == null) || (!value.equals(getSize2())) ) {
                    setSize2(((BigDecimal) value));
                }
            }
            if( values.containsKey("Size3") ) {
                final Object value = values.remove("Size3");
                if( (value == null) || (!value.equals(getSize3())) ) {
                    setSize3(((BigDecimal) value));
                }
            }
            if( values.containsKey("SpecialProcurementType") ) {
                final Object value = values.remove("SpecialProcurementType");
                if( (value == null) || (!value.equals(getSpecialProcurementType())) ) {
                    setSpecialProcurementType(((String) value));
                }
            }
            if( values.containsKey("TechnicalObject") ) {
                final Object value = values.remove("TechnicalObject");
                if( (value == null) || (!value.equals(getTechnicalObject())) ) {
                    setTechnicalObject(((String) value));
                }
            }
            if( values.containsKey("UnitOfMeasureForSize1To3") ) {
                final Object value = values.remove("UnitOfMeasureForSize1To3");
                if( (value == null) || (!value.equals(getUnitOfMeasureForSize1To3())) ) {
                    setUnitOfMeasureForSize1To3(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>AlternativeItemGroup</b>
     * </p>
     *
     * @param alternativeItemGroup
     *            AltItemGroup
     */
    public void setAlternativeItemGroup( @Nullable final String alternativeItemGroup )
    {
        rememberChangedField("AlternativeItemGroup", this.alternativeItemGroup);
        this.alternativeItemGroup = alternativeItemGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @param billOfMaterial
     *            Bill of Material
     */
    public void setBillOfMaterial( @Nullable final String billOfMaterial )
    {
        rememberChangedField("BillOfMaterial", this.billOfMaterial);
        this.billOfMaterial = billOfMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @param billOfMaterialCategory
     *            BOM category
     */
    public void setBillOfMaterialCategory( @Nullable final String billOfMaterialCategory )
    {
        rememberChangedField("BillOfMaterialCategory", this.billOfMaterialCategory);
        this.billOfMaterialCategory = billOfMaterialCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialComponent</b>
     * </p>
     *
     * @param billOfMaterialComponent
     *            Component
     */
    public void setBillOfMaterialComponent( @Nullable final String billOfMaterialComponent )
    {
        rememberChangedField("BillOfMaterialComponent", this.billOfMaterialComponent);
        this.billOfMaterialComponent = billOfMaterialComponent;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialHeaderUUID</b>
     * </p>
     *
     * @param billOfMaterialHeaderUUID
     *            ID hdr chge status
     */
    public void setBillOfMaterialHeaderUUID( @Nullable final UUID billOfMaterialHeaderUUID )
    {
        rememberChangedField("BillOfMaterialHeaderUUID", this.billOfMaterialHeaderUUID);
        this.billOfMaterialHeaderUUID = billOfMaterialHeaderUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialItemCategory</b>
     * </p>
     *
     * @param billOfMaterialItemCategory
     *            Item Category
     */
    public void setBillOfMaterialItemCategory( @Nullable final String billOfMaterialItemCategory )
    {
        rememberChangedField("BillOfMaterialItemCategory", this.billOfMaterialItemCategory);
        this.billOfMaterialItemCategory = billOfMaterialItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialItemNodeNumber</b>
     * </p>
     *
     * @param billOfMaterialItemNodeNumber
     *            Item node
     */
    public void setBillOfMaterialItemNodeNumber( @Nullable final String billOfMaterialItemNodeNumber )
    {
        rememberChangedField("BillOfMaterialItemNodeNumber", this.billOfMaterialItemNodeNumber);
        this.billOfMaterialItemNodeNumber = billOfMaterialItemNodeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialItemNumber</b>
     * </p>
     *
     * @param billOfMaterialItemNumber
     *            Item Number
     */
    public void setBillOfMaterialItemNumber( @Nullable final String billOfMaterialItemNumber )
    {
        rememberChangedField("BillOfMaterialItemNumber", this.billOfMaterialItemNumber);
        this.billOfMaterialItemNumber = billOfMaterialItemNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialItemQuantity</b>
     * </p>
     *
     * @param billOfMaterialItemQuantity
     *            Component Quantity
     */
    public void setBillOfMaterialItemQuantity( @Nullable final BigDecimal billOfMaterialItemQuantity )
    {
        rememberChangedField("BillOfMaterialItemQuantity", this.billOfMaterialItemQuantity);
        this.billOfMaterialItemQuantity = billOfMaterialItemQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialItemUnit</b>
     * </p>
     *
     * @param billOfMaterialItemUnit
     *            Component UoM
     */
    public void setBillOfMaterialItemUnit( @Nullable final String billOfMaterialItemUnit )
    {
        rememberChangedField("BillOfMaterialItemUnit", this.billOfMaterialItemUnit);
        this.billOfMaterialItemUnit = billOfMaterialItemUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialItemUUID</b>
     * </p>
     *
     * @param billOfMaterialItemUUID
     *            ID item chge status
     */
    public void setBillOfMaterialItemUUID( @Nullable final UUID billOfMaterialItemUUID )
    {
        rememberChangedField("BillOfMaterialItemUUID", this.billOfMaterialItemUUID);
        this.billOfMaterialItemUUID = billOfMaterialItemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @param billOfMaterialVariant
     *            Alternative BOM
     */
    public void setBillOfMaterialVariant( @Nullable final String billOfMaterialVariant )
    {
        rememberChangedField("BillOfMaterialVariant", this.billOfMaterialVariant);
        this.billOfMaterialVariant = billOfMaterialVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     * </p>
     *
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     */
    public void setBillOfMaterialVariantUsage( @Nullable final String billOfMaterialVariantUsage )
    {
        rememberChangedField("BillOfMaterialVariantUsage", this.billOfMaterialVariantUsage);
        this.billOfMaterialVariantUsage = billOfMaterialVariantUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>BillOfMaterialVersion</b>
     * </p>
     *
     * @param billOfMaterialVersion
     *            BOM Version
     */
    public void setBillOfMaterialVersion( @Nullable final String billOfMaterialVersion )
    {
        rememberChangedField("BillOfMaterialVersion", this.billOfMaterialVersion);
        this.billOfMaterialVersion = billOfMaterialVersion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>BOMIsRecursive</b>
     * </p>
     *
     * @param bOMIsRecursive
     *            Recursive
     */
    public void setBOMIsRecursive( @Nullable final Boolean bOMIsRecursive )
    {
        rememberChangedField("BOMIsRecursive", this.bOMIsRecursive);
        this.bOMIsRecursive = bOMIsRecursive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>BOMItemCreatedByUser</b>
     * </p>
     *
     * @param bOMItemCreatedByUser
     *            Created By
     */
    public void setBOMItemCreatedByUser( @Nullable final String bOMItemCreatedByUser )
    {
        rememberChangedField("BOMItemCreatedByUser", this.bOMItemCreatedByUser);
        this.bOMItemCreatedByUser = bOMItemCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>BOMItemDescription</b>
     * </p>
     *
     * @param bOMItemDescription
     *            Item Text
     */
    public void setBOMItemDescription( @Nullable final String bOMItemDescription )
    {
        rememberChangedField("BOMItemDescription", this.bOMItemDescription);
        this.bOMItemDescription = bOMItemDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>BOMItemInternalChangeCount</b>
     * </p>
     *
     * @param bOMItemInternalChangeCount
     *            Counter
     */
    public void setBOMItemInternalChangeCount( @Nullable final String bOMItemInternalChangeCount )
    {
        rememberChangedField("BOMItemInternalChangeCount", this.bOMItemInternalChangeCount);
        this.bOMItemInternalChangeCount = bOMItemInternalChangeCount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>BOMItemIsCostingRelevant</b>
     * </p>
     *
     * @param bOMItemIsCostingRelevant
     *            Relevancy to costing
     */
    public void setBOMItemIsCostingRelevant( @Nullable final String bOMItemIsCostingRelevant )
    {
        rememberChangedField("BOMItemIsCostingRelevant", this.bOMItemIsCostingRelevant);
        this.bOMItemIsCostingRelevant = bOMItemIsCostingRelevant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>BOMItemIsPlantMaintRelevant</b>
     * </p>
     *
     * @param bOMItemIsPlantMaintRelevant
     *            Plant maintenance
     */
    public void setBOMItemIsPlantMaintRelevant( @Nullable final Boolean bOMItemIsPlantMaintRelevant )
    {
        rememberChangedField("BOMItemIsPlantMaintRelevant", this.bOMItemIsPlantMaintRelevant);
        this.bOMItemIsPlantMaintRelevant = bOMItemIsPlantMaintRelevant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>BOMItemIsSalesRelevant</b>
     * </p>
     *
     * @param bOMItemIsSalesRelevant
     *            Relevant to sales
     */
    public void setBOMItemIsSalesRelevant( @Nullable final String bOMItemIsSalesRelevant )
    {
        rememberChangedField("BOMItemIsSalesRelevant", this.bOMItemIsSalesRelevant);
        this.bOMItemIsSalesRelevant = bOMItemIsSalesRelevant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>BOMItemIsSparePart</b>
     * </p>
     *
     * @param bOMItemIsSparePart
     *            Spare Part Indicator
     */
    public void setBOMItemIsSparePart( @Nullable final String bOMItemIsSparePart )
    {
        rememberChangedField("BOMItemIsSparePart", this.bOMItemIsSparePart);
        this.bOMItemIsSparePart = bOMItemIsSparePart;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>BOMItemLastChangeDate</b>
     * </p>
     *
     * @param bOMItemLastChangeDate
     *            Changed On
     */
    public void setBOMItemLastChangeDate( @Nullable final LocalDateTime bOMItemLastChangeDate )
    {
        rememberChangedField("BOMItemLastChangeDate", this.bOMItemLastChangeDate);
        this.bOMItemLastChangeDate = bOMItemLastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>BOMItemLastChangedByUser</b>
     * </p>
     *
     * @param bOMItemLastChangedByUser
     *            Changed By
     */
    public void setBOMItemLastChangedByUser( @Nullable final String bOMItemLastChangedByUser )
    {
        rememberChangedField("BOMItemLastChangedByUser", this.bOMItemLastChangedByUser);
        this.bOMItemLastChangedByUser = bOMItemLastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>BOMItemRecordCreationDate</b>
     * </p>
     *
     * @param bOMItemRecordCreationDate
     *            Created On
     */
    public void setBOMItemRecordCreationDate( @Nullable final LocalDateTime bOMItemRecordCreationDate )
    {
        rememberChangedField("BOMItemRecordCreationDate", this.bOMItemRecordCreationDate);
        this.bOMItemRecordCreationDate = bOMItemRecordCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>BOMItemSorter</b>
     * </p>
     *
     * @param bOMItemSorter
     *            Sort String
     */
    public void setBOMItemSorter( @Nullable final String bOMItemSorter )
    {
        rememberChangedField("BOMItemSorter", this.bOMItemSorter);
        this.bOMItemSorter = bOMItemSorter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>BOMItemText2</b>
     * </p>
     *
     * @param bOMItemText2
     *            Item Text 2
     */
    public void setBOMItemText2( @Nullable final String bOMItemText2 )
    {
        rememberChangedField("BOMItemText2", this.bOMItemText2);
        this.bOMItemText2 = bOMItemText2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>ChgToEngineeringChgDocument</b>
     * </p>
     *
     * @param chgToEngineeringChgDocument
     *            Change Number To
     */
    public void setChgToEngineeringChgDocument( @Nullable final String chgToEngineeringChgDocument )
    {
        rememberChangedField("ChgToEngineeringChgDocument", this.chgToEngineeringChgDocument);
        this.chgToEngineeringChgDocument = chgToEngineeringChgDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property from the Odata EDM: <b>ClassNumber</b>
     * </p>
     *
     * @param classNumber
     *            Class
     */
    public void setClassNumber( @Nullable final String classNumber )
    {
        rememberChangedField("ClassNumber", this.classNumber);
        this.classNumber = classNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @param classType
     *            Class Type
     */
    public void setClassType( @Nullable final String classType )
    {
        rememberChangedField("ClassType", this.classType);
        this.classType = classType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>ComponentDescription</b>
     * </p>
     *
     * @param componentDescription
     *            Item Text
     */
    public void setComponentDescription( @Nullable final String componentDescription )
    {
        rememberChangedField("ComponentDescription", this.componentDescription);
        this.componentDescription = componentDescription;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property from the Odata EDM: <b>ComponentScrapInPercent</b>
     * </p>
     *
     * @param componentScrapInPercent
     *            Component Scrap (%)
     */
    public void setComponentScrapInPercent( @Nullable final BigDecimal componentScrapInPercent )
    {
        rememberChangedField("ComponentScrapInPercent", this.componentScrapInPercent);
        this.componentScrapInPercent = componentScrapInPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>CostElement</b>
     * </p>
     *
     * @param costElement
     *            Cost element
     */
    public void setCostElement( @Nullable final String costElement )
    {
        rememberChangedField("CostElement", this.costElement);
        this.costElement = costElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>Creditor</b>
     * </p>
     *
     * @param creditor
     *            Supplier
     */
    public void setCreditor( @Nullable final String creditor )
    {
        rememberChangedField("Creditor", this.creditor);
        this.creditor = creditor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>DeliveryDurationInDays</b>
     * </p>
     *
     * @param deliveryDurationInDays
     *            Delivery time (days)
     */
    public void setDeliveryDurationInDays( @Nullable final BigDecimal deliveryDurationInDays )
    {
        rememberChangedField("DeliveryDurationInDays", this.deliveryDurationInDays);
        this.deliveryDurationInDays = deliveryDurationInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property from the Odata EDM: <b>DependencyObjectNumber</b>
     * </p>
     *
     * @param dependencyObjectNumber
     *            Assignment number
     */
    public void setDependencyObjectNumber( @Nullable final String dependencyObjectNumber )
    {
        rememberChangedField("DependencyObjectNumber", this.dependencyObjectNumber);
        this.dependencyObjectNumber = dependencyObjectNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>DiscontinuationGroup</b>
     * </p>
     *
     * @param discontinuationGroup
     *            Discont. group
     */
    public void setDiscontinuationGroup( @Nullable final String discontinuationGroup )
    {
        rememberChangedField("DiscontinuationGroup", this.discontinuationGroup);
        this.discontinuationGroup = discontinuationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>DistrKeyCompConsumption</b>
     * </p>
     *
     * @param distrKeyCompConsumption
     *            Distribution key
     */
    public void setDistrKeyCompConsumption( @Nullable final String distrKeyCompConsumption )
    {
        rememberChangedField("DistrKeyCompConsumption", this.distrKeyCompConsumption);
        this.distrKeyCompConsumption = distrKeyCompConsumption;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property from the Odata EDM: <b>DocNumber</b>
     * </p>
     *
     * @param docNumber
     *            Document
     */
    public void setDocNumber( @Nullable final String docNumber )
    {
        rememberChangedField("DocNumber", this.docNumber);
        this.docNumber = docNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>DocumentIsCreatedByCAD</b>
     * </p>
     *
     * @param documentIsCreatedByCAD
     *            CAD Indicator
     */
    public void setDocumentIsCreatedByCAD( @Nullable final Boolean documentIsCreatedByCAD )
    {
        rememberChangedField("DocumentIsCreatedByCAD", this.documentIsCreatedByCAD);
        this.documentIsCreatedByCAD = documentIsCreatedByCAD;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>DocumentPart</b>
     * </p>
     *
     * @param documentPart
     *            Document Part
     */
    public void setDocumentPart( @Nullable final String documentPart )
    {
        rememberChangedField("DocumentPart", this.documentPart);
        this.documentPart = documentPart;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>DocumentType</b>
     * </p>
     *
     * @param documentType
     *            Document Type
     */
    public void setDocumentType( @Nullable final String documentType )
    {
        rememberChangedField("DocumentType", this.documentType);
        this.documentType = documentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>DocumentVersion</b>
     * </p>
     *
     * @param documentVersion
     *            Document Version
     */
    public void setDocumentVersion( @Nullable final String documentVersion )
    {
        rememberChangedField("DocumentVersion", this.documentVersion);
        this.documentVersion = documentVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>EngineeringChangeDocument</b>
     * </p>
     *
     * @param engineeringChangeDocument
     *            Change Number
     */
    public void setEngineeringChangeDocument( @Nullable final String engineeringChangeDocument )
    {
        rememberChangedField("EngineeringChangeDocument", this.engineeringChangeDocument);
        this.engineeringChangeDocument = engineeringChangeDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>ExplosionType</b>
     * </p>
     *
     * @param explosionType
     *            Explosion type
     */
    public void setExplosionType( @Nullable final String explosionType )
    {
        rememberChangedField("ExplosionType", this.explosionType);
        this.explosionType = explosionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>FollowUpGroup</b>
     * </p>
     *
     * @param followUpGroup
     *            Follow-up group
     */
    public void setFollowUpGroup( @Nullable final String followUpGroup )
    {
        rememberChangedField("FollowUpGroup", this.followUpGroup);
        this.followUpGroup = followUpGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>FormulaKey</b>
     * </p>
     *
     * @param formulaKey
     *            VSI Formula
     */
    public void setFormulaKey( @Nullable final String formulaKey )
    {
        rememberChangedField("FormulaKey", this.formulaKey);
        this.formulaKey = formulaKey;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>GoodsReceiptDuration</b>
     * </p>
     *
     * @param goodsReceiptDuration
     *            GR processing time
     */
    public void setGoodsReceiptDuration( @Nullable final BigDecimal goodsReceiptDuration )
    {
        rememberChangedField("GoodsReceiptDuration", this.goodsReceiptDuration);
        this.goodsReceiptDuration = goodsReceiptDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>IdentifierBOMItem</b>
     * </p>
     *
     * @param identifierBOMItem
     *            Item identification
     */
    public void setIdentifierBOMItem( @Nullable final String identifierBOMItem )
    {
        rememberChangedField("IdentifierBOMItem", this.identifierBOMItem);
        this.identifierBOMItem = identifierBOMItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>InheritedNodeNumberForBOMItem</b>
     * </p>
     *
     * @param inheritedNodeNumberForBOMItem
     *            Item node
     */
    public void setInheritedNodeNumberForBOMItem( @Nullable final String inheritedNodeNumberForBOMItem )
    {
        rememberChangedField("InheritedNodeNumberForBOMItem", this.inheritedNodeNumberForBOMItem);
        this.inheritedNodeNumberForBOMItem = inheritedNodeNumberForBOMItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsALE</b>
     * </p>
     *
     * @param isALE
     *            ALE indicator
     */
    public void setIsALE( @Nullable final Boolean isALE )
    {
        rememberChangedField("IsALE", this.isALE);
        this.isALE = isALE;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>IsAssembly</b>
     * </p>
     *
     * @param isAssembly
     *            Assembly
     */
    public void setIsAssembly( @Nullable final String isAssembly )
    {
        rememberChangedField("IsAssembly", this.isAssembly);
        this.isAssembly = isAssembly;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsBOMRecursiveAllowed</b>
     * </p>
     *
     * @param isBOMRecursiveAllowed
     *            Recurs. allowed
     */
    public void setIsBOMRecursiveAllowed( @Nullable final Boolean isBOMRecursiveAllowed )
    {
        rememberChangedField("IsBOMRecursiveAllowed", this.isBOMRecursiveAllowed);
        this.isBOMRecursiveAllowed = isBOMRecursiveAllowed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsBulkMaterial</b>
     * </p>
     *
     * @param isBulkMaterial
     *            Bulk Material
     */
    public void setIsBulkMaterial( @Nullable final Boolean isBulkMaterial )
    {
        rememberChangedField("IsBulkMaterial", this.isBulkMaterial);
        this.isBulkMaterial = isBulkMaterial;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsClassificationRelevant</b>
     * </p>
     *
     * @param isClassificationRelevant
     *            as selection cond.
     */
    public void setIsClassificationRelevant( @Nullable final Boolean isClassificationRelevant )
    {
        rememberChangedField("IsClassificationRelevant", this.isClassificationRelevant);
        this.isClassificationRelevant = isClassificationRelevant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>IsConfigurableBOM</b>
     * </p>
     *
     * @param isConfigurableBOM
     *            Selection indicator
     */
    public void setIsConfigurableBOM( @Nullable final String isConfigurableBOM )
    {
        rememberChangedField("IsConfigurableBOM", this.isConfigurableBOM);
        this.isConfigurableBOM = isConfigurableBOM;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Deletion Indicator
     */
    public void setIsDeleted( @Nullable final Boolean isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsEngineeringRelevant</b>
     * </p>
     *
     * @param isEngineeringRelevant
     *            Engineering/design
     */
    public void setIsEngineeringRelevant( @Nullable final Boolean isEngineeringRelevant )
    {
        rememberChangedField("IsEngineeringRelevant", this.isEngineeringRelevant);
        this.isEngineeringRelevant = isEngineeringRelevant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>IsMaterialProvision</b>
     * </p>
     *
     * @param isMaterialProvision
     *            Mat. Provision Ind.
     */
    public void setIsMaterialProvision( @Nullable final String isMaterialProvision )
    {
        rememberChangedField("IsMaterialProvision", this.isMaterialProvision);
        this.isMaterialProvision = isMaterialProvision;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsNetScrap</b>
     * </p>
     *
     * @param isNetScrap
     *            Net Scrap Indicator
     */
    public void setIsNetScrap( @Nullable final Boolean isNetScrap )
    {
        rememberChangedField("IsNetScrap", this.isNetScrap);
        this.isNetScrap = isNetScrap;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsProductionRelevant</b>
     * </p>
     *
     * @param isProductionRelevant
     *            Production relevant
     */
    public void setIsProductionRelevant( @Nullable final Boolean isProductionRelevant )
    {
        rememberChangedField("IsProductionRelevant", this.isProductionRelevant);
        this.isProductionRelevant = isProductionRelevant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsSubItem</b>
     * </p>
     *
     * @param isSubItem
     *            Sub-item indicator
     */
    public void setIsSubItem( @Nullable final Boolean isSubItem )
    {
        rememberChangedField("IsSubItem", this.isSubItem);
        this.isSubItem = isSubItem;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>LeadTimeOffset</b>
     * </p>
     *
     * @param leadTimeOffset
     *            Lead-time offset
     */
    public void setLeadTimeOffset( @Nullable final BigDecimal leadTimeOffset )
    {
        rememberChangedField("LeadTimeOffset", this.leadTimeOffset);
        this.leadTimeOffset = leadTimeOffset;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>MaterialComponentPrice</b>
     * </p>
     *
     * @param materialComponentPrice
     *            Price
     */
    public void setMaterialComponentPrice( @Nullable final BigDecimal materialComponentPrice )
    {
        rememberChangedField("MaterialComponentPrice", this.materialComponentPrice);
        this.materialComponentPrice = materialComponentPrice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>MaterialIsCoProduct</b>
     * </p>
     *
     * @param materialIsCoProduct
     *            Co-product
     */
    public void setMaterialIsCoProduct( @Nullable final Boolean materialIsCoProduct )
    {
        rememberChangedField("MaterialIsCoProduct", this.materialIsCoProduct);
        this.materialIsCoProduct = materialIsCoProduct;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>MaterialPriceUnitQty</b>
     * </p>
     *
     * @param materialPriceUnitQty
     *            Price unit
     */
    public void setMaterialPriceUnitQty( @Nullable final BigDecimal materialPriceUnitQty )
    {
        rememberChangedField("MaterialPriceUnitQty", this.materialPriceUnitQty);
        this.materialPriceUnitQty = materialPriceUnitQty;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>MultipleSelectionAllowed</b>
     * </p>
     *
     * @param multipleSelectionAllowed
     *            Multiple Selection
     */
    public void setMultipleSelectionAllowed( @Nullable final Boolean multipleSelectionAllowed )
    {
        rememberChangedField("MultipleSelectionAllowed", this.multipleSelectionAllowed);
        this.multipleSelectionAllowed = multipleSelectionAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>ObjectType</b>
     * </p>
     *
     * @param objectType
     *            Object Type
     */
    public void setObjectType( @Nullable final String objectType )
    {
        rememberChangedField("ObjectType", this.objectType);
        this.objectType = objectType;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>OperationLeadTimeOffset</b>
     * </p>
     *
     * @param operationLeadTimeOffset
     *            Oper. LT offset
     */
    public void setOperationLeadTimeOffset( @Nullable final BigDecimal operationLeadTimeOffset )
    {
        rememberChangedField("OperationLeadTimeOffset", this.operationLeadTimeOffset);
        this.operationLeadTimeOffset = operationLeadTimeOffset;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property from the Odata EDM: <b>OperationScrapInPercent</b>
     * </p>
     *
     * @param operationScrapInPercent
     *            Operation Scrap in %
     */
    public void setOperationScrapInPercent( @Nullable final BigDecimal operationScrapInPercent )
    {
        rememberChangedField("OperationScrapInPercent", this.operationScrapInPercent);
        this.operationScrapInPercent = operationScrapInPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>OpsLeadTimeOffsetUnit</b>
     * </p>
     *
     * @param opsLeadTimeOffsetUnit
     *            Operation LTO unit
     */
    public void setOpsLeadTimeOffsetUnit( @Nullable final String opsLeadTimeOffsetUnit )
    {
        rememberChangedField("OpsLeadTimeOffsetUnit", this.opsLeadTimeOffsetUnit);
        this.opsLeadTimeOffsetUnit = opsLeadTimeOffsetUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>ProdOrderIssueLocation</b>
     * </p>
     *
     * @param prodOrderIssueLocation
     *            Storage Location
     */
    public void setProdOrderIssueLocation( @Nullable final String prodOrderIssueLocation )
    {
        rememberChangedField("ProdOrderIssueLocation", this.prodOrderIssueLocation);
        this.prodOrderIssueLocation = prodOrderIssueLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @param productionSupplyArea
     *            Prodn Supply Area
     */
    public void setProductionSupplyArea( @Nullable final String productionSupplyArea )
    {
        rememberChangedField("ProductionSupplyArea", this.productionSupplyArea);
        this.productionSupplyArea = productionSupplyArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purch. Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>QuantityVariableSizeItem</b>
     * </p>
     *
     * @param quantityVariableSizeItem
     *            VSI Quantity per PC
     */
    public void setQuantityVariableSizeItem( @Nullable final BigDecimal quantityVariableSizeItem )
    {
        rememberChangedField("QuantityVariableSizeItem", this.quantityVariableSizeItem);
        this.quantityVariableSizeItem = quantityVariableSizeItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property from the Odata EDM: <b>ReferencePoint</b>
     * </p>
     *
     * @param referencePoint
     *            Reference point
     */
    public void setReferencePoint( @Nullable final String referencePoint )
    {
        rememberChangedField("ReferencePoint", this.referencePoint);
        this.referencePoint = referencePoint;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>RequiredComponent</b>
     * </p>
     *
     * @param requiredComponent
     *            Required Component
     */
    public void setRequiredComponent( @Nullable final Boolean requiredComponent )
    {
        rememberChangedField("RequiredComponent", this.requiredComponent);
        this.requiredComponent = requiredComponent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>ResultingItemCategory</b>
     * </p>
     *
     * @param resultingItemCategory
     *            Res. item category
     */
    public void setResultingItemCategory( @Nullable final String resultingItemCategory )
    {
        rememberChangedField("ResultingItemCategory", this.resultingItemCategory);
        this.resultingItemCategory = resultingItemCategory;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>Size1</b>
     * </p>
     *
     * @param size1
     *            Size 1
     */
    public void setSize1( @Nullable final BigDecimal size1 )
    {
        rememberChangedField("Size1", this.size1);
        this.size1 = size1;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>Size2</b>
     * </p>
     *
     * @param size2
     *            Size 2
     */
    public void setSize2( @Nullable final BigDecimal size2 )
    {
        rememberChangedField("Size2", this.size2);
        this.size2 = size2;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>Size3</b>
     * </p>
     *
     * @param size3
     *            Size 3
     */
    public void setSize3( @Nullable final BigDecimal size3 )
    {
        rememberChangedField("Size3", this.size3);
        this.size3 = size3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>SpecialProcurementType</b>
     * </p>
     *
     * @param specialProcurementType
     *            Special Procurement
     */
    public void setSpecialProcurementType( @Nullable final String specialProcurementType )
    {
        rememberChangedField("SpecialProcurementType", this.specialProcurementType);
        this.specialProcurementType = specialProcurementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>TechnicalObject</b>
     * </p>
     *
     * @param technicalObject
     *            Technical Object
     */
    public void setTechnicalObject( @Nullable final String technicalObject )
    {
        rememberChangedField("TechnicalObject", this.technicalObject);
        this.technicalObject = technicalObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>UnitOfMeasureForSize1To3</b>
     * </p>
     *
     * @param unitOfMeasureForSize1To3
     *            Size unit
     */
    public void setUnitOfMeasureForSize1To3( @Nullable final String unitOfMeasureForSize1To3 )
    {
        rememberChangedField("UnitOfMeasureForSize1To3", this.unitOfMeasureForSize1To3);
        this.unitOfMeasureForSize1To3 = unitOfMeasureForSize1To3;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid to
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid From
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

}
