/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.field.MaintBOMHeaderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.link.MaintBOMHeaderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.selectable.MaintBOMHeaderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Bill Of Material
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintBOMHeader_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintBOMHeader extends VdmEntity<MaintBOMHeader>
{

    /**
     * Selector for all available fields of MaintBOMHeader.
     *
     */
    public final static MaintBOMHeaderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @return The billOfMaterial contained in this entity.
     */
    @Key
    @SerializedName( "BillOfMaterial" )
    @JsonProperty( "BillOfMaterial" )
    @Nullable
    @ODataField( odataName = "BillOfMaterial" )
    private String billOfMaterial;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterial</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> BILL_OF_MATERIAL =
        new MaintBOMHeaderField<String>("BillOfMaterial");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @return BOM category
     */
    @Key
    @SerializedName( "BillOfMaterialCategory" )
    @JsonProperty( "BillOfMaterialCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialCategory" )
    private String billOfMaterialCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialCategory</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> BILL_OF_MATERIAL_CATEGORY =
        new MaintBOMHeaderField<String>("BillOfMaterialCategory");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @return Alternative BOM
     */
    @Key
    @SerializedName( "BillOfMaterialVariant" )
    @JsonProperty( "BillOfMaterialVariant" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariant" )
    private String billOfMaterialVariant;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariant</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> BILL_OF_MATERIAL_VARIANT =
        new MaintBOMHeaderField<String>("BillOfMaterialVariant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVersion</b>
     * </p>
     *
     * @return BOM Version
     */
    @Key
    @SerializedName( "BillOfMaterialVersion" )
    @JsonProperty( "BillOfMaterialVersion" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVersion" )
    private String billOfMaterialVersion;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVersion</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> BILL_OF_MATERIAL_VERSION =
        new MaintBOMHeaderField<String>("BillOfMaterialVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObject</b>
     * </p>
     *
     * @return Material 1
     */
    @Key
    @SerializedName( "TechnicalObject" )
    @JsonProperty( "TechnicalObject" )
    @Nullable
    @ODataField( odataName = "TechnicalObject" )
    private String technicalObject;
    /**
     * Use with available fluent helpers to apply the <b>TechnicalObject</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> TECHNICAL_OBJECT =
        new MaintBOMHeaderField<String>("TechnicalObject");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> PLANT = new MaintBOMHeaderField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EngineeringChangeDocument</b>
     * </p>
     *
     * @return Change Number
     */
    @Key
    @SerializedName( "EngineeringChangeDocument" )
    @JsonProperty( "EngineeringChangeDocument" )
    @Nullable
    @ODataField( odataName = "EngineeringChangeDocument" )
    private String engineeringChangeDocument;
    /**
     * Use with available fluent helpers to apply the <b>EngineeringChangeDocument</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> ENGINEERING_CHANGE_DOCUMENT =
        new MaintBOMHeaderField<String>("EngineeringChangeDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     * </p>
     *
     * @return BOM Usage
     */
    @Key
    @SerializedName( "BillOfMaterialVariantUsage" )
    @JsonProperty( "BillOfMaterialVariantUsage" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariantUsage" )
    private String billOfMaterialVariantUsage;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariantUsage</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> BILL_OF_MATERIAL_VARIANT_USAGE =
        new MaintBOMHeaderField<String>("BillOfMaterialVariantUsage");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialHeaderUUID</b>
     * </p>
     *
     * @return Global identification of a BOM header change status
     */
    @SerializedName( "BillOfMaterialHeaderUUID" )
    @JsonProperty( "BillOfMaterialHeaderUUID" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialHeaderUUID" )
    private UUID billOfMaterialHeaderUUID;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialHeaderUUID</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<UUID> BILL_OF_MATERIAL_HEADER_UUID =
        new MaintBOMHeaderField<UUID>("BillOfMaterialHeaderUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMultipleBOMAlt</b>
     * </p>
     *
     * @return Indicator: alternative determination for multiple BOMs
     */
    @SerializedName( "IsMultipleBOMAlt" )
    @JsonProperty( "IsMultipleBOMAlt" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMultipleBOMAlt" )
    private Boolean isMultipleBOMAlt;
    /**
     * Use with available fluent helpers to apply the <b>IsMultipleBOMAlt</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<Boolean> IS_MULTIPLE_BOM_ALT =
        new MaintBOMHeaderField<Boolean>("IsMultipleBOMAlt");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderInternalChangeCount</b>
     * </p>
     *
     * @return Internal counter
     */
    @SerializedName( "BOMHeaderInternalChangeCount" )
    @JsonProperty( "BOMHeaderInternalChangeCount" )
    @Nullable
    @ODataField( odataName = "BOMHeaderInternalChangeCount" )
    private String bOMHeaderInternalChangeCount;
    /**
     * Use with available fluent helpers to apply the <b>BOMHeaderInternalChangeCount</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> BOM_HEADER_INTERNAL_CHANGE_COUNT =
        new MaintBOMHeaderField<String>("BOMHeaderInternalChangeCount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BOMUsagePriority</b>
     * </p>
     *
     * @return CIM priority for selection ID
     */
    @SerializedName( "BOMUsagePriority" )
    @JsonProperty( "BOMUsagePriority" )
    @Nullable
    @ODataField( odataName = "BOMUsagePriority" )
    private String bOMUsagePriority;
    /**
     * Use with available fluent helpers to apply the <b>BOMUsagePriority</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> BOM_USAGE_PRIORITY =
        new MaintBOMHeaderField<String>("BOMUsagePriority");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialAuthsnGrp</b>
     * </p>
     *
     * @return Authorization group for bills of material
     */
    @SerializedName( "BillOfMaterialAuthsnGrp" )
    @JsonProperty( "BillOfMaterialAuthsnGrp" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialAuthsnGrp" )
    private String billOfMaterialAuthsnGrp;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialAuthsnGrp</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> BILL_OF_MATERIAL_AUTHSN_GRP =
        new MaintBOMHeaderField<String>("BillOfMaterialAuthsnGrp");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BOMVersionStatus</b>
     * </p>
     *
     * @return BOM Version Status
     */
    @SerializedName( "BOMVersionStatus" )
    @JsonProperty( "BOMVersionStatus" )
    @Nullable
    @ODataField( odataName = "BOMVersionStatus" )
    private String bOMVersionStatus;
    /**
     * Use with available fluent helpers to apply the <b>BOMVersionStatus</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> BOM_VERSION_STATUS =
        new MaintBOMHeaderField<String>("BOMVersionStatus");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsVersionBillOfMaterial</b>
     * </p>
     *
     * @return Indicator: Relevant for Versioning
     */
    @SerializedName( "IsVersionBillOfMaterial" )
    @JsonProperty( "IsVersionBillOfMaterial" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsVersionBillOfMaterial" )
    private Boolean isVersionBillOfMaterial;
    /**
     * Use with available fluent helpers to apply the <b>IsVersionBillOfMaterial</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<Boolean> IS_VERSION_BILL_OF_MATERIAL =
        new MaintBOMHeaderField<Boolean>("IsVersionBillOfMaterial");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsLatestBOMVersion</b>
     * </p>
     *
     * @return Indicator: Latest Released BOM Version
     */
    @SerializedName( "IsLatestBOMVersion" )
    @JsonProperty( "IsLatestBOMVersion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsLatestBOMVersion" )
    private Boolean isLatestBOMVersion;
    /**
     * Use with available fluent helpers to apply the <b>IsLatestBOMVersion</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<Boolean> IS_LATEST_BOM_VERSION =
        new MaintBOMHeaderField<Boolean>("IsLatestBOMVersion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsConfiguredMaterial</b>
     * </p>
     *
     * @return Indicator: configurable BOM
     */
    @SerializedName( "IsConfiguredMaterial" )
    @JsonProperty( "IsConfiguredMaterial" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsConfiguredMaterial" )
    private Boolean isConfiguredMaterial;
    /**
     * Use with available fluent helpers to apply the <b>IsConfiguredMaterial</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<Boolean> IS_CONFIGURED_MATERIAL =
        new MaintBOMHeaderField<Boolean>("IsConfiguredMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMTechnicalType</b>
     * </p>
     *
     * @return Technical type
     */
    @SerializedName( "BOMTechnicalType" )
    @JsonProperty( "BOMTechnicalType" )
    @Nullable
    @ODataField( odataName = "BOMTechnicalType" )
    private String bOMTechnicalType;
    /**
     * Use with available fluent helpers to apply the <b>BOMTechnicalType</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> BOM_TECHNICAL_TYPE =
        new MaintBOMHeaderField<String>("BOMTechnicalType");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BOMGroup</b>
     * </p>
     *
     * @return BOM group
     */
    @SerializedName( "BOMGroup" )
    @JsonProperty( "BOMGroup" )
    @Nullable
    @ODataField( odataName = "BOMGroup" )
    private String bOMGroup;
    /**
     * Use with available fluent helpers to apply the <b>BOMGroup</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> BOM_GROUP = new MaintBOMHeaderField<String>("BOMGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderText</b>
     * </p>
     *
     * @return BOM Description
     */
    @SerializedName( "BOMHeaderText" )
    @JsonProperty( "BOMHeaderText" )
    @Nullable
    @ODataField( odataName = "BOMHeaderText" )
    private String bOMHeaderText;
    /**
     * Use with available fluent helpers to apply the <b>BOMHeaderText</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> BOM_HEADER_TEXT = new MaintBOMHeaderField<String>("BOMHeaderText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMAlternativeText</b>
     * </p>
     *
     * @return Alternative BOM Text
     */
    @SerializedName( "BOMAlternativeText" )
    @JsonProperty( "BOMAlternativeText" )
    @Nullable
    @ODataField( odataName = "BOMAlternativeText" )
    private String bOMAlternativeText;
    /**
     * Use with available fluent helpers to apply the <b>BOMAlternativeText</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> BOM_ALTERNATIVE_TEXT =
        new MaintBOMHeaderField<String>("BOMAlternativeText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialStatus</b>
     * </p>
     *
     * @return Bill of Material Status
     */
    @SerializedName( "BillOfMaterialStatus" )
    @JsonProperty( "BillOfMaterialStatus" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialStatus" )
    private String billOfMaterialStatus;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialStatus</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> BILL_OF_MATERIAL_STATUS =
        new MaintBOMHeaderField<String>("BillOfMaterialStatus");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>HeaderValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "HeaderValidityStartDate" )
    @JsonProperty( "HeaderValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "HeaderValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime headerValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>HeaderValidityStartDate</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<LocalDateTime> HEADER_VALIDITY_START_DATE =
        new MaintBOMHeaderField<LocalDateTime>("HeaderValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>HeaderValidityEndDate</b>
     * </p>
     *
     * @return Valid-to date
     */
    @SerializedName( "HeaderValidityEndDate" )
    @JsonProperty( "HeaderValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "HeaderValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime headerValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>HeaderValidityEndDate</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<LocalDateTime> HEADER_VALIDITY_END_DATE =
        new MaintBOMHeaderField<LocalDateTime>("HeaderValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChgToEngineeringChgDocument</b>
     * </p>
     *
     * @return Change Number To
     */
    @SerializedName( "ChgToEngineeringChgDocument" )
    @JsonProperty( "ChgToEngineeringChgDocument" )
    @Nullable
    @ODataField( odataName = "ChgToEngineeringChgDocument" )
    private String chgToEngineeringChgDocument;
    /**
     * Use with available fluent helpers to apply the <b>ChgToEngineeringChgDocument</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> CHG_TO_ENGINEERING_CHG_DOCUMENT =
        new MaintBOMHeaderField<String>("ChgToEngineeringChgDocument");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "IsMarkedForDeletion" )
    @JsonProperty( "IsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMarkedForDeletion" )
    private Boolean isMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>IsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<Boolean> IS_MARKED_FOR_DELETION =
        new MaintBOMHeaderField<Boolean>("IsMarkedForDeletion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsALE</b>
     * </p>
     *
     * @return ALE indicator
     */
    @SerializedName( "IsALE" )
    @JsonProperty( "IsALE" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsALE" )
    private Boolean isALE;
    /**
     * Use with available fluent helpers to apply the <b>IsALE</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<Boolean> IS_ALE = new MaintBOMHeaderField<Boolean>("IsALE");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderBaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure for BOM
     */
    @SerializedName( "BOMHeaderBaseUnit" )
    @JsonProperty( "BOMHeaderBaseUnit" )
    @Nullable
    @ODataField( odataName = "BOMHeaderBaseUnit" )
    private String bOMHeaderBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BOMHeaderBaseUnit</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> BOM_HEADER_BASE_UNIT =
        new MaintBOMHeaderField<String>("BOMHeaderBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderQuantityInBaseUnit</b>
     * </p>
     *
     * @return Base quantity
     */
    @SerializedName( "BOMHeaderQuantityInBaseUnit" )
    @JsonProperty( "BOMHeaderQuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "BOMHeaderQuantityInBaseUnit" )
    private BigDecimal bOMHeaderQuantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BOMHeaderQuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<BigDecimal> BOM_HEADER_QUANTITY_IN_BASE_UNIT =
        new MaintBOMHeaderField<BigDecimal>("BOMHeaderQuantityInBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecordCreationDate</b>
     * </p>
     *
     * @return Date Record Created On
     */
    @SerializedName( "RecordCreationDate" )
    @JsonProperty( "RecordCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RecordCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime recordCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>RecordCreationDate</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<LocalDateTime> RECORD_CREATION_DATE =
        new MaintBOMHeaderField<LocalDateTime>("RecordCreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<LocalDateTime> LAST_CHANGE_DATE =
        new MaintBOMHeaderField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return User Who Created Record
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> CREATED_BY_USER = new MaintBOMHeaderField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> LAST_CHANGED_BY_USER =
        new MaintBOMHeaderField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMIsToBeDeleted</b>
     * </p>
     *
     * @return Handling Deletion Flag During BOM Explosion
     */
    @SerializedName( "BOMIsToBeDeleted" )
    @JsonProperty( "BOMIsToBeDeleted" )
    @Nullable
    @ODataField( odataName = "BOMIsToBeDeleted" )
    private String bOMIsToBeDeleted;
    /**
     * Use with available fluent helpers to apply the <b>BOMIsToBeDeleted</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> BOM_IS_TO_BE_DELETED =
        new MaintBOMHeaderField<String>("BOMIsToBeDeleted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocumentIsCreatedByCAD</b>
     * </p>
     *
     * @return CAD Indicator
     */
    @SerializedName( "DocumentIsCreatedByCAD" )
    @JsonProperty( "DocumentIsCreatedByCAD" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DocumentIsCreatedByCAD" )
    private Boolean documentIsCreatedByCAD;
    /**
     * Use with available fluent helpers to apply the <b>DocumentIsCreatedByCAD</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<Boolean> DOCUMENT_IS_CREATED_BY_CAD =
        new MaintBOMHeaderField<Boolean>("DocumentIsCreatedByCAD");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LaboratoryOrDesignOffice</b>
     * </p>
     *
     * @return Laboratory/Design Office
     */
    @SerializedName( "LaboratoryOrDesignOffice" )
    @JsonProperty( "LaboratoryOrDesignOffice" )
    @Nullable
    @ODataField( odataName = "LaboratoryOrDesignOffice" )
    private String laboratoryOrDesignOffice;
    /**
     * Use with available fluent helpers to apply the <b>LaboratoryOrDesignOffice</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> LABORATORY_OR_DESIGN_OFFICE =
        new MaintBOMHeaderField<String>("LaboratoryOrDesignOffice");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedBillOfMaterialVersion</b>
     * </p>
     *
     * @return The selectedBillOfMaterialVersion contained in this entity.
     */
    @SerializedName( "SelectedBillOfMaterialVersion" )
    @JsonProperty( "SelectedBillOfMaterialVersion" )
    @Nullable
    @ODataField( odataName = "SelectedBillOfMaterialVersion" )
    private String selectedBillOfMaterialVersion;
    /**
     * Use with available fluent helpers to apply the <b>SelectedBillOfMaterialVersion</b> field to query operations.
     *
     */
    public final static MaintBOMHeaderField<String> SELECTED_BILL_OF_MATERIAL_VERSION =
        new MaintBOMHeaderField<String>("SelectedBillOfMaterialVersion");
    /**
     * Navigation property <b>to_MaintBillOfMaterialItem</b> for <b>MaintBOMHeader</b> to multiple <b>BOMItem</b>.
     *
     */
    @SerializedName( "to_MaintBillOfMaterialItem" )
    @JsonProperty( "to_MaintBillOfMaterialItem" )
    @ODataField( odataName = "to_MaintBillOfMaterialItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BOMItem> toMaintBillOfMaterialItem;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintBillOfMaterialItem</b> navigation property to query
     * operations.
     *
     */
    public final static MaintBOMHeaderLink<BOMItem> TO_MAINT_BILL_OF_MATERIAL_ITEM =
        new MaintBOMHeaderLink<BOMItem>("to_MaintBillOfMaterialItem");

    @Nonnull
    @Override
    public Class<MaintBOMHeader> getType()
    {
        return MaintBOMHeader.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @param billOfMaterial
     *            The billOfMaterial to set.
     */
    public void setBillOfMaterial( @Nullable final String billOfMaterial )
    {
        rememberChangedField("BillOfMaterial", this.billOfMaterial);
        this.billOfMaterial = billOfMaterial;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @param billOfMaterialCategory
     *            BOM category
     */
    public void setBillOfMaterialCategory( @Nullable final String billOfMaterialCategory )
    {
        rememberChangedField("BillOfMaterialCategory", this.billOfMaterialCategory);
        this.billOfMaterialCategory = billOfMaterialCategory;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @param billOfMaterialVariant
     *            Alternative BOM
     */
    public void setBillOfMaterialVariant( @Nullable final String billOfMaterialVariant )
    {
        rememberChangedField("BillOfMaterialVariant", this.billOfMaterialVariant);
        this.billOfMaterialVariant = billOfMaterialVariant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVersion</b>
     * </p>
     *
     * @param billOfMaterialVersion
     *            BOM Version
     */
    public void setBillOfMaterialVersion( @Nullable final String billOfMaterialVersion )
    {
        rememberChangedField("BillOfMaterialVersion", this.billOfMaterialVersion);
        this.billOfMaterialVersion = billOfMaterialVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObject</b>
     * </p>
     *
     * @param technicalObject
     *            Material 1
     */
    public void setTechnicalObject( @Nullable final String technicalObject )
    {
        rememberChangedField("TechnicalObject", this.technicalObject);
        this.technicalObject = technicalObject;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EngineeringChangeDocument</b>
     * </p>
     *
     * @param engineeringChangeDocument
     *            Change Number
     */
    public void setEngineeringChangeDocument( @Nullable final String engineeringChangeDocument )
    {
        rememberChangedField("EngineeringChangeDocument", this.engineeringChangeDocument);
        this.engineeringChangeDocument = engineeringChangeDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     * </p>
     *
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     */
    public void setBillOfMaterialVariantUsage( @Nullable final String billOfMaterialVariantUsage )
    {
        rememberChangedField("BillOfMaterialVariantUsage", this.billOfMaterialVariantUsage);
        this.billOfMaterialVariantUsage = billOfMaterialVariantUsage;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialHeaderUUID</b>
     * </p>
     *
     * @param billOfMaterialHeaderUUID
     *            Global identification of a BOM header change status
     */
    public void setBillOfMaterialHeaderUUID( @Nullable final UUID billOfMaterialHeaderUUID )
    {
        rememberChangedField("BillOfMaterialHeaderUUID", this.billOfMaterialHeaderUUID);
        this.billOfMaterialHeaderUUID = billOfMaterialHeaderUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMultipleBOMAlt</b>
     * </p>
     *
     * @param isMultipleBOMAlt
     *            Indicator: alternative determination for multiple BOMs
     */
    public void setIsMultipleBOMAlt( @Nullable final Boolean isMultipleBOMAlt )
    {
        rememberChangedField("IsMultipleBOMAlt", this.isMultipleBOMAlt);
        this.isMultipleBOMAlt = isMultipleBOMAlt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderInternalChangeCount</b>
     * </p>
     *
     * @param bOMHeaderInternalChangeCount
     *            Internal counter
     */
    public void setBOMHeaderInternalChangeCount( @Nullable final String bOMHeaderInternalChangeCount )
    {
        rememberChangedField("BOMHeaderInternalChangeCount", this.bOMHeaderInternalChangeCount);
        this.bOMHeaderInternalChangeCount = bOMHeaderInternalChangeCount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BOMUsagePriority</b>
     * </p>
     *
     * @param bOMUsagePriority
     *            CIM priority for selection ID
     */
    public void setBOMUsagePriority( @Nullable final String bOMUsagePriority )
    {
        rememberChangedField("BOMUsagePriority", this.bOMUsagePriority);
        this.bOMUsagePriority = bOMUsagePriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialAuthsnGrp</b>
     * </p>
     *
     * @param billOfMaterialAuthsnGrp
     *            Authorization group for bills of material
     */
    public void setBillOfMaterialAuthsnGrp( @Nullable final String billOfMaterialAuthsnGrp )
    {
        rememberChangedField("BillOfMaterialAuthsnGrp", this.billOfMaterialAuthsnGrp);
        this.billOfMaterialAuthsnGrp = billOfMaterialAuthsnGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BOMVersionStatus</b>
     * </p>
     *
     * @param bOMVersionStatus
     *            BOM Version Status
     */
    public void setBOMVersionStatus( @Nullable final String bOMVersionStatus )
    {
        rememberChangedField("BOMVersionStatus", this.bOMVersionStatus);
        this.bOMVersionStatus = bOMVersionStatus;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsVersionBillOfMaterial</b>
     * </p>
     *
     * @param isVersionBillOfMaterial
     *            Indicator: Relevant for Versioning
     */
    public void setIsVersionBillOfMaterial( @Nullable final Boolean isVersionBillOfMaterial )
    {
        rememberChangedField("IsVersionBillOfMaterial", this.isVersionBillOfMaterial);
        this.isVersionBillOfMaterial = isVersionBillOfMaterial;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsLatestBOMVersion</b>
     * </p>
     *
     * @param isLatestBOMVersion
     *            Indicator: Latest Released BOM Version
     */
    public void setIsLatestBOMVersion( @Nullable final Boolean isLatestBOMVersion )
    {
        rememberChangedField("IsLatestBOMVersion", this.isLatestBOMVersion);
        this.isLatestBOMVersion = isLatestBOMVersion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsConfiguredMaterial</b>
     * </p>
     *
     * @param isConfiguredMaterial
     *            Indicator: configurable BOM
     */
    public void setIsConfiguredMaterial( @Nullable final Boolean isConfiguredMaterial )
    {
        rememberChangedField("IsConfiguredMaterial", this.isConfiguredMaterial);
        this.isConfiguredMaterial = isConfiguredMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMTechnicalType</b>
     * </p>
     *
     * @param bOMTechnicalType
     *            Technical type
     */
    public void setBOMTechnicalType( @Nullable final String bOMTechnicalType )
    {
        rememberChangedField("BOMTechnicalType", this.bOMTechnicalType);
        this.bOMTechnicalType = bOMTechnicalType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BOMGroup</b>
     * </p>
     *
     * @param bOMGroup
     *            BOM group
     */
    public void setBOMGroup( @Nullable final String bOMGroup )
    {
        rememberChangedField("BOMGroup", this.bOMGroup);
        this.bOMGroup = bOMGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderText</b>
     * </p>
     *
     * @param bOMHeaderText
     *            BOM Description
     */
    public void setBOMHeaderText( @Nullable final String bOMHeaderText )
    {
        rememberChangedField("BOMHeaderText", this.bOMHeaderText);
        this.bOMHeaderText = bOMHeaderText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMAlternativeText</b>
     * </p>
     *
     * @param bOMAlternativeText
     *            Alternative BOM Text
     */
    public void setBOMAlternativeText( @Nullable final String bOMAlternativeText )
    {
        rememberChangedField("BOMAlternativeText", this.bOMAlternativeText);
        this.bOMAlternativeText = bOMAlternativeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialStatus</b>
     * </p>
     *
     * @param billOfMaterialStatus
     *            Bill of Material Status
     */
    public void setBillOfMaterialStatus( @Nullable final String billOfMaterialStatus )
    {
        rememberChangedField("BillOfMaterialStatus", this.billOfMaterialStatus);
        this.billOfMaterialStatus = billOfMaterialStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>HeaderValidityStartDate</b>
     * </p>
     *
     * @param headerValidityStartDate
     *            Valid-From Date
     */
    public void setHeaderValidityStartDate( @Nullable final LocalDateTime headerValidityStartDate )
    {
        rememberChangedField("HeaderValidityStartDate", this.headerValidityStartDate);
        this.headerValidityStartDate = headerValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>HeaderValidityEndDate</b>
     * </p>
     *
     * @param headerValidityEndDate
     *            Valid-to date
     */
    public void setHeaderValidityEndDate( @Nullable final LocalDateTime headerValidityEndDate )
    {
        rememberChangedField("HeaderValidityEndDate", this.headerValidityEndDate);
        this.headerValidityEndDate = headerValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChgToEngineeringChgDocument</b>
     * </p>
     *
     * @param chgToEngineeringChgDocument
     *            Change Number To
     */
    public void setChgToEngineeringChgDocument( @Nullable final String chgToEngineeringChgDocument )
    {
        rememberChangedField("ChgToEngineeringChgDocument", this.chgToEngineeringChgDocument);
        this.chgToEngineeringChgDocument = chgToEngineeringChgDocument;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @param isMarkedForDeletion
     *            Deletion Indicator
     */
    public void setIsMarkedForDeletion( @Nullable final Boolean isMarkedForDeletion )
    {
        rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsALE</b>
     * </p>
     *
     * @param isALE
     *            ALE indicator
     */
    public void setIsALE( @Nullable final Boolean isALE )
    {
        rememberChangedField("IsALE", this.isALE);
        this.isALE = isALE;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderBaseUnit</b>
     * </p>
     *
     * @param bOMHeaderBaseUnit
     *            Base Unit of Measure for BOM
     */
    public void setBOMHeaderBaseUnit( @Nullable final String bOMHeaderBaseUnit )
    {
        rememberChangedField("BOMHeaderBaseUnit", this.bOMHeaderBaseUnit);
        this.bOMHeaderBaseUnit = bOMHeaderBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderQuantityInBaseUnit</b>
     * </p>
     *
     * @param bOMHeaderQuantityInBaseUnit
     *            Base quantity
     */
    public void setBOMHeaderQuantityInBaseUnit( @Nullable final BigDecimal bOMHeaderQuantityInBaseUnit )
    {
        rememberChangedField("BOMHeaderQuantityInBaseUnit", this.bOMHeaderQuantityInBaseUnit);
        this.bOMHeaderQuantityInBaseUnit = bOMHeaderQuantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecordCreationDate</b>
     * </p>
     *
     * @param recordCreationDate
     *            Date Record Created On
     */
    public void setRecordCreationDate( @Nullable final LocalDateTime recordCreationDate )
    {
        rememberChangedField("RecordCreationDate", this.recordCreationDate);
        this.recordCreationDate = recordCreationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            User Who Created Record
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMIsToBeDeleted</b>
     * </p>
     *
     * @param bOMIsToBeDeleted
     *            Handling Deletion Flag During BOM Explosion
     */
    public void setBOMIsToBeDeleted( @Nullable final String bOMIsToBeDeleted )
    {
        rememberChangedField("BOMIsToBeDeleted", this.bOMIsToBeDeleted);
        this.bOMIsToBeDeleted = bOMIsToBeDeleted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocumentIsCreatedByCAD</b>
     * </p>
     *
     * @param documentIsCreatedByCAD
     *            CAD Indicator
     */
    public void setDocumentIsCreatedByCAD( @Nullable final Boolean documentIsCreatedByCAD )
    {
        rememberChangedField("DocumentIsCreatedByCAD", this.documentIsCreatedByCAD);
        this.documentIsCreatedByCAD = documentIsCreatedByCAD;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LaboratoryOrDesignOffice</b>
     * </p>
     *
     * @param laboratoryOrDesignOffice
     *            Laboratory/Design Office
     */
    public void setLaboratoryOrDesignOffice( @Nullable final String laboratoryOrDesignOffice )
    {
        rememberChangedField("LaboratoryOrDesignOffice", this.laboratoryOrDesignOffice);
        this.laboratoryOrDesignOffice = laboratoryOrDesignOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedBillOfMaterialVersion</b>
     * </p>
     *
     * @param selectedBillOfMaterialVersion
     *            The selectedBillOfMaterialVersion to set.
     */
    public void setSelectedBillOfMaterialVersion( @Nullable final String selectedBillOfMaterialVersion )
    {
        rememberChangedField("SelectedBillOfMaterialVersion", this.selectedBillOfMaterialVersion);
        this.selectedBillOfMaterialVersion = selectedBillOfMaterialVersion;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BOMHeader";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BillOfMaterial", getBillOfMaterial());
        result.put("BillOfMaterialCategory", getBillOfMaterialCategory());
        result.put("BillOfMaterialVariant", getBillOfMaterialVariant());
        result.put("BillOfMaterialVersion", getBillOfMaterialVersion());
        result.put("TechnicalObject", getTechnicalObject());
        result.put("Plant", getPlant());
        result.put("EngineeringChangeDocument", getEngineeringChangeDocument());
        result.put("BillOfMaterialVariantUsage", getBillOfMaterialVariantUsage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BillOfMaterial", getBillOfMaterial());
        values.put("BillOfMaterialCategory", getBillOfMaterialCategory());
        values.put("BillOfMaterialVariant", getBillOfMaterialVariant());
        values.put("BillOfMaterialVersion", getBillOfMaterialVersion());
        values.put("TechnicalObject", getTechnicalObject());
        values.put("Plant", getPlant());
        values.put("EngineeringChangeDocument", getEngineeringChangeDocument());
        values.put("BillOfMaterialVariantUsage", getBillOfMaterialVariantUsage());
        values.put("BillOfMaterialHeaderUUID", getBillOfMaterialHeaderUUID());
        values.put("IsMultipleBOMAlt", getIsMultipleBOMAlt());
        values.put("BOMHeaderInternalChangeCount", getBOMHeaderInternalChangeCount());
        values.put("BOMUsagePriority", getBOMUsagePriority());
        values.put("BillOfMaterialAuthsnGrp", getBillOfMaterialAuthsnGrp());
        values.put("BOMVersionStatus", getBOMVersionStatus());
        values.put("IsVersionBillOfMaterial", getIsVersionBillOfMaterial());
        values.put("IsLatestBOMVersion", getIsLatestBOMVersion());
        values.put("IsConfiguredMaterial", getIsConfiguredMaterial());
        values.put("BOMTechnicalType", getBOMTechnicalType());
        values.put("BOMGroup", getBOMGroup());
        values.put("BOMHeaderText", getBOMHeaderText());
        values.put("BOMAlternativeText", getBOMAlternativeText());
        values.put("BillOfMaterialStatus", getBillOfMaterialStatus());
        values.put("HeaderValidityStartDate", getHeaderValidityStartDate());
        values.put("HeaderValidityEndDate", getHeaderValidityEndDate());
        values.put("ChgToEngineeringChgDocument", getChgToEngineeringChgDocument());
        values.put("IsMarkedForDeletion", getIsMarkedForDeletion());
        values.put("IsALE", getIsALE());
        values.put("BOMHeaderBaseUnit", getBOMHeaderBaseUnit());
        values.put("BOMHeaderQuantityInBaseUnit", getBOMHeaderQuantityInBaseUnit());
        values.put("RecordCreationDate", getRecordCreationDate());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("BOMIsToBeDeleted", getBOMIsToBeDeleted());
        values.put("DocumentIsCreatedByCAD", getDocumentIsCreatedByCAD());
        values.put("LaboratoryOrDesignOffice", getLaboratoryOrDesignOffice());
        values.put("SelectedBillOfMaterialVersion", getSelectedBillOfMaterialVersion());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BillOfMaterial") ) {
                final Object value = values.remove("BillOfMaterial");
                if( (value == null) || (!value.equals(getBillOfMaterial())) ) {
                    setBillOfMaterial(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialCategory") ) {
                final Object value = values.remove("BillOfMaterialCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialCategory())) ) {
                    setBillOfMaterialCategory(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariant") ) {
                final Object value = values.remove("BillOfMaterialVariant");
                if( (value == null) || (!value.equals(getBillOfMaterialVariant())) ) {
                    setBillOfMaterialVariant(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVersion") ) {
                final Object value = values.remove("BillOfMaterialVersion");
                if( (value == null) || (!value.equals(getBillOfMaterialVersion())) ) {
                    setBillOfMaterialVersion(((String) value));
                }
            }
            if( values.containsKey("TechnicalObject") ) {
                final Object value = values.remove("TechnicalObject");
                if( (value == null) || (!value.equals(getTechnicalObject())) ) {
                    setTechnicalObject(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("EngineeringChangeDocument") ) {
                final Object value = values.remove("EngineeringChangeDocument");
                if( (value == null) || (!value.equals(getEngineeringChangeDocument())) ) {
                    setEngineeringChangeDocument(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariantUsage") ) {
                final Object value = values.remove("BillOfMaterialVariantUsage");
                if( (value == null) || (!value.equals(getBillOfMaterialVariantUsage())) ) {
                    setBillOfMaterialVariantUsage(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialHeaderUUID") ) {
                final Object value = values.remove("BillOfMaterialHeaderUUID");
                if( (value == null) || (!value.equals(getBillOfMaterialHeaderUUID())) ) {
                    setBillOfMaterialHeaderUUID(((UUID) value));
                }
            }
            if( values.containsKey("IsMultipleBOMAlt") ) {
                final Object value = values.remove("IsMultipleBOMAlt");
                if( (value == null) || (!value.equals(getIsMultipleBOMAlt())) ) {
                    setIsMultipleBOMAlt(((Boolean) value));
                }
            }
            if( values.containsKey("BOMHeaderInternalChangeCount") ) {
                final Object value = values.remove("BOMHeaderInternalChangeCount");
                if( (value == null) || (!value.equals(getBOMHeaderInternalChangeCount())) ) {
                    setBOMHeaderInternalChangeCount(((String) value));
                }
            }
            if( values.containsKey("BOMUsagePriority") ) {
                final Object value = values.remove("BOMUsagePriority");
                if( (value == null) || (!value.equals(getBOMUsagePriority())) ) {
                    setBOMUsagePriority(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialAuthsnGrp") ) {
                final Object value = values.remove("BillOfMaterialAuthsnGrp");
                if( (value == null) || (!value.equals(getBillOfMaterialAuthsnGrp())) ) {
                    setBillOfMaterialAuthsnGrp(((String) value));
                }
            }
            if( values.containsKey("BOMVersionStatus") ) {
                final Object value = values.remove("BOMVersionStatus");
                if( (value == null) || (!value.equals(getBOMVersionStatus())) ) {
                    setBOMVersionStatus(((String) value));
                }
            }
            if( values.containsKey("IsVersionBillOfMaterial") ) {
                final Object value = values.remove("IsVersionBillOfMaterial");
                if( (value == null) || (!value.equals(getIsVersionBillOfMaterial())) ) {
                    setIsVersionBillOfMaterial(((Boolean) value));
                }
            }
            if( values.containsKey("IsLatestBOMVersion") ) {
                final Object value = values.remove("IsLatestBOMVersion");
                if( (value == null) || (!value.equals(getIsLatestBOMVersion())) ) {
                    setIsLatestBOMVersion(((Boolean) value));
                }
            }
            if( values.containsKey("IsConfiguredMaterial") ) {
                final Object value = values.remove("IsConfiguredMaterial");
                if( (value == null) || (!value.equals(getIsConfiguredMaterial())) ) {
                    setIsConfiguredMaterial(((Boolean) value));
                }
            }
            if( values.containsKey("BOMTechnicalType") ) {
                final Object value = values.remove("BOMTechnicalType");
                if( (value == null) || (!value.equals(getBOMTechnicalType())) ) {
                    setBOMTechnicalType(((String) value));
                }
            }
            if( values.containsKey("BOMGroup") ) {
                final Object value = values.remove("BOMGroup");
                if( (value == null) || (!value.equals(getBOMGroup())) ) {
                    setBOMGroup(((String) value));
                }
            }
            if( values.containsKey("BOMHeaderText") ) {
                final Object value = values.remove("BOMHeaderText");
                if( (value == null) || (!value.equals(getBOMHeaderText())) ) {
                    setBOMHeaderText(((String) value));
                }
            }
            if( values.containsKey("BOMAlternativeText") ) {
                final Object value = values.remove("BOMAlternativeText");
                if( (value == null) || (!value.equals(getBOMAlternativeText())) ) {
                    setBOMAlternativeText(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialStatus") ) {
                final Object value = values.remove("BillOfMaterialStatus");
                if( (value == null) || (!value.equals(getBillOfMaterialStatus())) ) {
                    setBillOfMaterialStatus(((String) value));
                }
            }
            if( values.containsKey("HeaderValidityStartDate") ) {
                final Object value = values.remove("HeaderValidityStartDate");
                if( (value == null) || (!value.equals(getHeaderValidityStartDate())) ) {
                    setHeaderValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("HeaderValidityEndDate") ) {
                final Object value = values.remove("HeaderValidityEndDate");
                if( (value == null) || (!value.equals(getHeaderValidityEndDate())) ) {
                    setHeaderValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChgToEngineeringChgDocument") ) {
                final Object value = values.remove("ChgToEngineeringChgDocument");
                if( (value == null) || (!value.equals(getChgToEngineeringChgDocument())) ) {
                    setChgToEngineeringChgDocument(((String) value));
                }
            }
            if( values.containsKey("IsMarkedForDeletion") ) {
                final Object value = values.remove("IsMarkedForDeletion");
                if( (value == null) || (!value.equals(getIsMarkedForDeletion())) ) {
                    setIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("IsALE") ) {
                final Object value = values.remove("IsALE");
                if( (value == null) || (!value.equals(getIsALE())) ) {
                    setIsALE(((Boolean) value));
                }
            }
            if( values.containsKey("BOMHeaderBaseUnit") ) {
                final Object value = values.remove("BOMHeaderBaseUnit");
                if( (value == null) || (!value.equals(getBOMHeaderBaseUnit())) ) {
                    setBOMHeaderBaseUnit(((String) value));
                }
            }
            if( values.containsKey("BOMHeaderQuantityInBaseUnit") ) {
                final Object value = values.remove("BOMHeaderQuantityInBaseUnit");
                if( (value == null) || (!value.equals(getBOMHeaderQuantityInBaseUnit())) ) {
                    setBOMHeaderQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("RecordCreationDate") ) {
                final Object value = values.remove("RecordCreationDate");
                if( (value == null) || (!value.equals(getRecordCreationDate())) ) {
                    setRecordCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("BOMIsToBeDeleted") ) {
                final Object value = values.remove("BOMIsToBeDeleted");
                if( (value == null) || (!value.equals(getBOMIsToBeDeleted())) ) {
                    setBOMIsToBeDeleted(((String) value));
                }
            }
            if( values.containsKey("DocumentIsCreatedByCAD") ) {
                final Object value = values.remove("DocumentIsCreatedByCAD");
                if( (value == null) || (!value.equals(getDocumentIsCreatedByCAD())) ) {
                    setDocumentIsCreatedByCAD(((Boolean) value));
                }
            }
            if( values.containsKey("LaboratoryOrDesignOffice") ) {
                final Object value = values.remove("LaboratoryOrDesignOffice");
                if( (value == null) || (!value.equals(getLaboratoryOrDesignOffice())) ) {
                    setLaboratoryOrDesignOffice(((String) value));
                }
            }
            if( values.containsKey("SelectedBillOfMaterialVersion") ) {
                final Object value = values.remove("SelectedBillOfMaterialVersion");
                if( (value == null) || (!value.equals(getSelectedBillOfMaterialVersion())) ) {
                    setSelectedBillOfMaterialVersion(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintBillOfMaterialItem") ) {
                final Object value = (values).remove("to_MaintBillOfMaterialItem");
                if( value instanceof Iterable ) {
                    if( toMaintBillOfMaterialItem == null ) {
                        toMaintBillOfMaterialItem = Lists.newArrayList();
                    } else {
                        toMaintBillOfMaterialItem = Lists.newArrayList(toMaintBillOfMaterialItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BOMItem entity;
                        if( toMaintBillOfMaterialItem.size() > i ) {
                            entity = toMaintBillOfMaterialItem.get(i);
                        } else {
                            entity = new BOMItem();
                            toMaintBillOfMaterialItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> MaintBOMHeaderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintBOMHeaderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintBOMHeaderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintBOMHeaderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceBillOfMaterialService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintBillOfMaterialItem != null ) {
            (values).put("to_MaintBillOfMaterialItem", toMaintBillOfMaterialItem);
        }
        return values;
    }

    /**
     * Fetches the <b>BOMItem</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_MaintBillOfMaterialItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BOMItem</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BOMItem> fetchMaintBillOfMaterialItem()
    {
        return fetchFieldAsList("to_MaintBillOfMaterialItem", BOMItem.class);
    }

    /**
     * Retrieval of associated <b>BOMItem</b> entities (one to many). This corresponds to the OData navigation property
     * <b>to_MaintBillOfMaterialItem</b>.
     * <p>
     * If the navigation property <b>to_MaintBillOfMaterialItem</b> of a queried <b>MaintBOMHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BOMItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BOMItem> getMaintBillOfMaterialItemOrFetch()
    {
        if( toMaintBillOfMaterialItem == null ) {
            toMaintBillOfMaterialItem = fetchMaintBillOfMaterialItem();
        }
        return toMaintBillOfMaterialItem;
    }

    /**
     * Retrieval of associated <b>BOMItem</b> entities (one to many). This corresponds to the OData navigation property
     * <b>to_MaintBillOfMaterialItem</b>.
     * <p>
     * If the navigation property for an entity <b>MaintBOMHeader</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintBillOfMaterialItem</b> is already loaded, the
     *         result will contain the <b>BOMItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BOMItem>> getMaintBillOfMaterialItemIfPresent()
    {
        return Option.of(toMaintBillOfMaterialItem);
    }

    /**
     * Overwrites the list of associated <b>BOMItem</b> entities for the loaded navigation property
     * <b>to_MaintBillOfMaterialItem</b>.
     * <p>
     * If the navigation property <b>to_MaintBillOfMaterialItem</b> of a queried <b>MaintBOMHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BOMItem</b> entities.
     */
    public void setMaintBillOfMaterialItem( @Nonnull final List<BOMItem> value )
    {
        if( toMaintBillOfMaterialItem == null ) {
            toMaintBillOfMaterialItem = Lists.newArrayList();
        }
        toMaintBillOfMaterialItem.clear();
        toMaintBillOfMaterialItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BOMItem</b> entities. This corresponds to the OData navigation
     * property <b>to_MaintBillOfMaterialItem</b>.
     * <p>
     * If the navigation property <b>to_MaintBillOfMaterialItem</b> of a queried <b>MaintBOMHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BOMItem</b> entities.
     */
    public void addMaintBillOfMaterialItem( BOMItem... entity )
    {
        if( toMaintBillOfMaterialItem == null ) {
            toMaintBillOfMaterialItem = Lists.newArrayList();
        }
        toMaintBillOfMaterialItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaintBOMHeader instances.
     *
     */
    public final static class MaintBOMHeaderBuilder
    {

        private List<BOMItem> toMaintBillOfMaterialItem = Lists.newArrayList();

        private MaintBOMHeader.MaintBOMHeaderBuilder toMaintBillOfMaterialItem( final List<BOMItem> value )
        {
            toMaintBillOfMaterialItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintBillOfMaterialItem</b> for <b>MaintBOMHeader</b> to multiple <b>BOMItem</b>.
         *
         * @param value
         *            The BOMItems to build this MaintBOMHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintBOMHeader.MaintBOMHeaderBuilder maintBillOfMaterialItem( BOMItem... value )
        {
            return toMaintBillOfMaterialItem(Lists.newArrayList(value));
        }

    }

}
