/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link MaintenanceBillOfMaterialServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceBillOfMaterialService
 * MaintenanceBillOfMaterialService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultMaintenanceBillOfMaterialServiceBatch
    extends
    BatchFluentHelperBasic<MaintenanceBillOfMaterialServiceBatch, MaintenanceBillOfMaterialServiceBatchChangeSet>
    implements
    MaintenanceBillOfMaterialServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceBillOfMaterialService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultMaintenanceBillOfMaterialServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMaintenanceBillOfMaterialServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceBillOfMaterialService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceBillOfMaterialService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultMaintenanceBillOfMaterialServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMaintenanceBillOfMaterialServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceBillOfMaterialService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultMaintenanceBillOfMaterialServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MaintenanceBillOfMaterialServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultMaintenanceBillOfMaterialServiceBatchChangeSet(this, service);
    }

}
