/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader;

/**
 * Implementation of the {@link MaintenanceBillOfMaterialServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceBillOfMaterialService
 * MaintenanceBillOfMaterialService}.
 *
 */
public class DefaultMaintenanceBillOfMaterialServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<MaintenanceBillOfMaterialServiceBatch, MaintenanceBillOfMaterialServiceBatchChangeSet>
    implements
    MaintenanceBillOfMaterialServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceBillOfMaterialService service;

    @SuppressWarnings( "deprecation" )
    DefaultMaintenanceBillOfMaterialServiceBatchChangeSet(
        @Nonnull final DefaultMaintenanceBillOfMaterialServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceBillOfMaterialService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultMaintenanceBillOfMaterialServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MaintenanceBillOfMaterialServiceBatchChangeSet createBOMItem( @Nonnull final BOMItem bOMItem )
    {
        return addRequestCreate(service::createBOMItem, bOMItem);
    }

    @Nonnull
    @Override
    public MaintenanceBillOfMaterialServiceBatchChangeSet updateBOMItem( @Nonnull final BOMItem bOMItem )
    {
        return addRequestUpdate(service::updateBOMItem, bOMItem);
    }

    @Nonnull
    @Override
    public MaintenanceBillOfMaterialServiceBatchChangeSet deleteBOMItem( @Nonnull final BOMItem bOMItem )
    {
        return addRequestDelete(service::deleteBOMItem, bOMItem);
    }

    @Nonnull
    @Override
    public MaintenanceBillOfMaterialServiceBatchChangeSet createMaintBOMHeader(
        @Nonnull final MaintBOMHeader maintBOMHeader )
    {
        return addRequestCreate(service::createMaintBOMHeader, maintBOMHeader);
    }

    @Nonnull
    @Override
    public MaintenanceBillOfMaterialServiceBatchChangeSet updateMaintBOMHeader(
        @Nonnull final MaintBOMHeader maintBOMHeader )
    {
        return addRequestUpdate(service::updateMaintBOMHeader, maintBOMHeader);
    }

    @Nonnull
    @Override
    public MaintenanceBillOfMaterialServiceBatchChangeSet deleteMaintBOMHeader(
        @Nonnull final MaintBOMHeader maintBOMHeader )
    {
        return addRequestDelete(service::deleteMaintBOMHeader, maintBOMHeader);
    }

}
