/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceBillOfMaterialService
 * MaintenanceBillOfMaterialService}.
 *
 */
public interface MaintenanceBillOfMaterialServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<MaintenanceBillOfMaterialServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<MaintenanceBillOfMaterialServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem
     * BOMItem} entity and save it to the S/4HANA system.
     *
     * @param bOMItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem BOMItem}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceBillOfMaterialServiceBatchChangeSet createBOMItem( @Nonnull final BOMItem bOMItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem
     * BOMItem} entity and save it to the S/4HANA system.
     *
     * @param bOMItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem BOMItem}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceBillOfMaterialServiceBatchChangeSet updateBOMItem( @Nonnull final BOMItem bOMItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem
     * BOMItem} entity in the S/4HANA system.
     *
     * @param bOMItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.BOMItem BOMItem}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceBillOfMaterialServiceBatchChangeSet deleteBOMItem( @Nonnull final BOMItem bOMItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     * MaintBOMHeader} entity and save it to the S/4HANA system.
     *
     * @param maintBOMHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     *            MaintBOMHeader} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceBillOfMaterialServiceBatchChangeSet createMaintBOMHeader( @Nonnull final MaintBOMHeader maintBOMHeader );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     * MaintBOMHeader} entity and save it to the S/4HANA system.
     *
     * @param maintBOMHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     *            MaintBOMHeader} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceBillOfMaterialServiceBatchChangeSet updateMaintBOMHeader( @Nonnull final MaintBOMHeader maintBOMHeader );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     * MaintBOMHeader} entity in the S/4HANA system.
     *
     * @param maintBOMHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader
     *            MaintBOMHeader} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceBillOfMaterialServiceBatchChangeSet deleteMaintBOMHeader( @Nonnull final MaintBOMHeader maintBOMHeader );

}
