/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader MaintBOMHeader}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.field.MaintBOMHeaderField
 * MaintBOMHeaderField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.link.MaintBOMHeaderLink
 * MaintBOMHeaderLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#BILL_OF_MATERIAL
 * BILL_OF_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#BILL_OF_MATERIAL_CATEGORY
 * BILL_OF_MATERIAL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#BILL_OF_MATERIAL_VARIANT
 * BILL_OF_MATERIAL_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#BILL_OF_MATERIAL_VERSION
 * BILL_OF_MATERIAL_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#TECHNICAL_OBJECT
 * TECHNICAL_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#ENGINEERING_CHANGE_DOCUMENT
 * ENGINEERING_CHANGE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#BILL_OF_MATERIAL_VARIANT_USAGE
 * BILL_OF_MATERIAL_VARIANT_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#BILL_OF_MATERIAL_HEADER_UUID
 * BILL_OF_MATERIAL_HEADER_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#IS_MULTIPLE_BOM_ALT
 * IS_MULTIPLE_BOM_ALT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#BOM_HEADER_INTERNAL_CHANGE_COUNT
 * BOM_HEADER_INTERNAL_CHANGE_COUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#BOM_USAGE_PRIORITY
 * BOM_USAGE_PRIORITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#BILL_OF_MATERIAL_AUTHSN_GRP
 * BILL_OF_MATERIAL_AUTHSN_GRP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#BOM_VERSION_STATUS
 * BOM_VERSION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#IS_VERSION_BILL_OF_MATERIAL
 * IS_VERSION_BILL_OF_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#IS_LATEST_BOM_VERSION
 * IS_LATEST_BOM_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#IS_CONFIGURED_MATERIAL
 * IS_CONFIGURED_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#BOM_TECHNICAL_TYPE
 * BOM_TECHNICAL_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#BOM_GROUP
 * BOM_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#BOM_HEADER_TEXT
 * BOM_HEADER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#BOM_ALTERNATIVE_TEXT
 * BOM_ALTERNATIVE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#BILL_OF_MATERIAL_STATUS
 * BILL_OF_MATERIAL_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#HEADER_VALIDITY_START_DATE
 * HEADER_VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#HEADER_VALIDITY_END_DATE
 * HEADER_VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#CHG_TO_ENGINEERING_CHG_DOCUMENT
 * CHG_TO_ENGINEERING_CHG_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#IS_MARKED_FOR_DELETION
 * IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#IS_ALE
 * IS_ALE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#BOM_HEADER_BASE_UNIT
 * BOM_HEADER_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#BOM_HEADER_QUANTITY_IN_BASE_UNIT
 * BOM_HEADER_QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#RECORD_CREATION_DATE
 * RECORD_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#BOM_IS_TO_BE_DELETED
 * BOM_IS_TO_BE_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#DOCUMENT_IS_CREATED_BY_CAD
 * DOCUMENT_IS_CREATED_BY_CAD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#LABORATORY_OR_DESIGN_OFFICE
 * LABORATORY_OR_DESIGN_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#SELECTED_BILL_OF_MATERIAL_VERSION
 * SELECTED_BILL_OF_MATERIAL_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancebillofmaterial.MaintBOMHeader#TO_MAINT_BILL_OF_MATERIAL_ITEM
 * TO_MAINT_BILL_OF_MATERIAL_ITEM}</li>
 * </ul>
 *
 */
public interface MaintBOMHeaderSelectable extends EntitySelectable<MaintBOMHeader>
{

}
