/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.field.MaintenanceItemReasonField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.link.MaintenanceItemReasonLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.link.MaintenanceItemReasonOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.selectable.MaintenanceItemReasonSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Item Reason
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenanceItemReasonType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintenanceItemReason extends VdmEntity<MaintenanceItemReason>
{

    /**
     * Selector for all available fields of MaintenanceItemReason.
     *
     */
    public final static MaintenanceItemReasonSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItem</b>
     * </p>
     *
     * @return Maintenance Item
     */
    @Key
    @SerializedName( "MaintenanceItem" )
    @JsonProperty( "MaintenanceItem" )
    @Nullable
    @ODataField( odataName = "MaintenanceItem" )
    private String maintenanceItem;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceItem</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonField<String> MAINTENANCE_ITEM =
        new MaintenanceItemReasonField<String>("MaintenanceItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>NmbrOfMaintComplianceItems</b>
     * </p>
     *
     * @return Sequential Number for Compliance
     */
    @Key
    @SerializedName( "NmbrOfMaintComplianceItems" )
    @JsonProperty( "NmbrOfMaintComplianceItems" )
    @Nullable
    @ODataField( odataName = "NmbrOfMaintComplianceItems" )
    private String nmbrOfMaintComplianceItems;
    /**
     * Use with available fluent helpers to apply the <b>NmbrOfMaintComplianceItems</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonField<String> NMBR_OF_MAINT_COMPLIANCE_ITEMS =
        new MaintenanceItemReasonField<String>("NmbrOfMaintComplianceItems");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceComplianceGroupCode</b>
     * </p>
     *
     * @return Compliance Group
     */
    @SerializedName( "MaintenanceComplianceGroupCode" )
    @JsonProperty( "MaintenanceComplianceGroupCode" )
    @Nullable
    @ODataField( odataName = "MaintenanceComplianceGroupCode" )
    private String maintenanceComplianceGroupCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceComplianceGroupCode</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonField<String> MAINTENANCE_COMPLIANCE_GROUP_CODE =
        new MaintenanceItemReasonField<String>("MaintenanceComplianceGroupCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceComplianceCode</b>
     * </p>
     *
     * @return Compliance Code
     */
    @SerializedName( "MaintenanceComplianceCode" )
    @JsonProperty( "MaintenanceComplianceCode" )
    @Nullable
    @ODataField( odataName = "MaintenanceComplianceCode" )
    private String maintenanceComplianceCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceComplianceCode</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonField<String> MAINTENANCE_COMPLIANCE_CODE =
        new MaintenanceItemReasonField<String>("MaintenanceComplianceCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceComplianceTypeCode</b>
     * </p>
     *
     * @return Compliance Type: 'C'ause or 'R'eason
     */
    @SerializedName( "MaintenanceComplianceTypeCode" )
    @JsonProperty( "MaintenanceComplianceTypeCode" )
    @Nullable
    @ODataField( odataName = "MaintenanceComplianceTypeCode" )
    private String maintenanceComplianceTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceComplianceTypeCode</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonField<String> MAINTENANCE_COMPLIANCE_TYPE_CODE =
        new MaintenanceItemReasonField<String>("MaintenanceComplianceTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintComplianceCatalogCode</b>
     * </p>
     *
     * @return Compliance Catalog
     */
    @SerializedName( "MaintComplianceCatalogCode" )
    @JsonProperty( "MaintComplianceCatalogCode" )
    @Nullable
    @ODataField( odataName = "MaintComplianceCatalogCode" )
    private String maintComplianceCatalogCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintComplianceCatalogCode</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonField<String> MAINT_COMPLIANCE_CATALOG_CODE =
        new MaintenanceItemReasonField<String>("MaintComplianceCatalogCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintComplianceDescription</b>
     * </p>
     *
     * @return Compliance Description
     */
    @SerializedName( "MaintComplianceDescription" )
    @JsonProperty( "MaintComplianceDescription" )
    @Nullable
    @ODataField( odataName = "MaintComplianceDescription" )
    private String maintComplianceDescription;
    /**
     * Use with available fluent helpers to apply the <b>MaintComplianceDescription</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonField<String> MAINT_COMPLIANCE_DESCRIPTION =
        new MaintenanceItemReasonField<String>("MaintComplianceDescription");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePackage</b>
     * </p>
     *
     * @return Maintenance Package Number
     */
    @SerializedName( "MaintenancePackage" )
    @JsonProperty( "MaintenancePackage" )
    @Nullable
    @ODataField( odataName = "MaintenancePackage" )
    private String maintenancePackage;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePackage</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonField<String> MAINTENANCE_PACKAGE =
        new MaintenanceItemReasonField<String>("MaintenancePackage");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintCmplRqIsLegallyBinding</b>
     * </p>
     *
     * @return Legally Binding Requirement
     */
    @SerializedName( "MaintCmplRqIsLegallyBinding" )
    @JsonProperty( "MaintCmplRqIsLegallyBinding" )
    @Nullable
    @ODataField( odataName = "MaintCmplRqIsLegallyBinding" )
    private String maintCmplRqIsLegallyBinding;
    /**
     * Use with available fluent helpers to apply the <b>MaintCmplRqIsLegallyBinding</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonField<String> MAINT_CMPL_RQ_IS_LEGALLY_BINDING =
        new MaintenanceItemReasonField<String>("MaintCmplRqIsLegallyBinding");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintCmplRqOriginCode</b>
     * </p>
     *
     * @return Origin of Compliance Requirement
     */
    @SerializedName( "MaintCmplRqOriginCode" )
    @JsonProperty( "MaintCmplRqOriginCode" )
    @Nullable
    @ODataField( odataName = "MaintCmplRqOriginCode" )
    private String maintCmplRqOriginCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintCmplRqOriginCode</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonField<String> MAINT_CMPL_RQ_ORIGIN_CODE =
        new MaintenanceItemReasonField<String>("MaintCmplRqOriginCode");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonField<String> CREATED_BY_USER =
        new MaintenanceItemReasonField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonField<LocalDateTime> CREATION_DATE =
        new MaintenanceItemReasonField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonField<String> LAST_CHANGED_BY_USER =
        new MaintenanceItemReasonField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonField<LocalDateTime> LAST_CHANGE_DATE =
        new MaintenanceItemReasonField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Changed Date and Time
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new MaintenanceItemReasonField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>to_MaintenanceItem</b> for <b>MaintenanceItemReason</b> to single <b>MaintenanceItem</b>.
     *
     */
    @SerializedName( "to_MaintenanceItem" )
    @JsonProperty( "to_MaintenanceItem" )
    @ODataField( odataName = "to_MaintenanceItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceItem toMaintenanceItem;
    /**
     * Navigation property <b>to_MaintenanceItemReasonText</b> for <b>MaintenanceItemReason</b> to multiple
     * <b>MaintenanceItemReasonText</b>.
     *
     */
    @SerializedName( "to_MaintenanceItemReasonText" )
    @JsonProperty( "to_MaintenanceItemReasonText" )
    @ODataField( odataName = "to_MaintenanceItemReasonText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenanceItemReasonText> toMaintenanceItemReasonText;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceItem</b> navigation property to query operations.
     *
     */
    public final static MaintenanceItemReasonOneToOneLink<MaintenanceItem> TO_MAINTENANCE_ITEM =
        new MaintenanceItemReasonOneToOneLink<MaintenanceItem>("to_MaintenanceItem");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceItemReasonText</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenanceItemReasonLink<MaintenanceItemReasonText> TO_MAINTENANCE_ITEM_REASON_TEXT =
        new MaintenanceItemReasonLink<MaintenanceItemReasonText>("to_MaintenanceItemReasonText");

    @Nonnull
    @Override
    public Class<MaintenanceItemReason> getType()
    {
        return MaintenanceItemReason.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItem</b>
     * </p>
     *
     * @param maintenanceItem
     *            Maintenance Item
     */
    public void setMaintenanceItem( @Nullable final String maintenanceItem )
    {
        rememberChangedField("MaintenanceItem", this.maintenanceItem);
        this.maintenanceItem = maintenanceItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>NmbrOfMaintComplianceItems</b>
     * </p>
     *
     * @param nmbrOfMaintComplianceItems
     *            Sequential Number for Compliance
     */
    public void setNmbrOfMaintComplianceItems( @Nullable final String nmbrOfMaintComplianceItems )
    {
        rememberChangedField("NmbrOfMaintComplianceItems", this.nmbrOfMaintComplianceItems);
        this.nmbrOfMaintComplianceItems = nmbrOfMaintComplianceItems;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceComplianceGroupCode</b>
     * </p>
     *
     * @param maintenanceComplianceGroupCode
     *            Compliance Group
     */
    public void setMaintenanceComplianceGroupCode( @Nullable final String maintenanceComplianceGroupCode )
    {
        rememberChangedField("MaintenanceComplianceGroupCode", this.maintenanceComplianceGroupCode);
        this.maintenanceComplianceGroupCode = maintenanceComplianceGroupCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceComplianceCode</b>
     * </p>
     *
     * @param maintenanceComplianceCode
     *            Compliance Code
     */
    public void setMaintenanceComplianceCode( @Nullable final String maintenanceComplianceCode )
    {
        rememberChangedField("MaintenanceComplianceCode", this.maintenanceComplianceCode);
        this.maintenanceComplianceCode = maintenanceComplianceCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceComplianceTypeCode</b>
     * </p>
     *
     * @param maintenanceComplianceTypeCode
     *            Compliance Type: 'C'ause or 'R'eason
     */
    public void setMaintenanceComplianceTypeCode( @Nullable final String maintenanceComplianceTypeCode )
    {
        rememberChangedField("MaintenanceComplianceTypeCode", this.maintenanceComplianceTypeCode);
        this.maintenanceComplianceTypeCode = maintenanceComplianceTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintComplianceCatalogCode</b>
     * </p>
     *
     * @param maintComplianceCatalogCode
     *            Compliance Catalog
     */
    public void setMaintComplianceCatalogCode( @Nullable final String maintComplianceCatalogCode )
    {
        rememberChangedField("MaintComplianceCatalogCode", this.maintComplianceCatalogCode);
        this.maintComplianceCatalogCode = maintComplianceCatalogCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintComplianceDescription</b>
     * </p>
     *
     * @param maintComplianceDescription
     *            Compliance Description
     */
    public void setMaintComplianceDescription( @Nullable final String maintComplianceDescription )
    {
        rememberChangedField("MaintComplianceDescription", this.maintComplianceDescription);
        this.maintComplianceDescription = maintComplianceDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePackage</b>
     * </p>
     *
     * @param maintenancePackage
     *            Maintenance Package Number
     */
    public void setMaintenancePackage( @Nullable final String maintenancePackage )
    {
        rememberChangedField("MaintenancePackage", this.maintenancePackage);
        this.maintenancePackage = maintenancePackage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintCmplRqIsLegallyBinding</b>
     * </p>
     *
     * @param maintCmplRqIsLegallyBinding
     *            Legally Binding Requirement
     */
    public void setMaintCmplRqIsLegallyBinding( @Nullable final String maintCmplRqIsLegallyBinding )
    {
        rememberChangedField("MaintCmplRqIsLegallyBinding", this.maintCmplRqIsLegallyBinding);
        this.maintCmplRqIsLegallyBinding = maintCmplRqIsLegallyBinding;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintCmplRqOriginCode</b>
     * </p>
     *
     * @param maintCmplRqOriginCode
     *            Origin of Compliance Requirement
     */
    public void setMaintCmplRqOriginCode( @Nullable final String maintCmplRqOriginCode )
    {
        rememberChangedField("MaintCmplRqOriginCode", this.maintCmplRqOriginCode);
        this.maintCmplRqOriginCode = maintCmplRqOriginCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Changed Date and Time
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintenanceItemReason";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceItem", getMaintenanceItem());
        result.put("NmbrOfMaintComplianceItems", getNmbrOfMaintComplianceItems());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceItem", getMaintenanceItem());
        values.put("NmbrOfMaintComplianceItems", getNmbrOfMaintComplianceItems());
        values.put("MaintenanceComplianceGroupCode", getMaintenanceComplianceGroupCode());
        values.put("MaintenanceComplianceCode", getMaintenanceComplianceCode());
        values.put("MaintenanceComplianceTypeCode", getMaintenanceComplianceTypeCode());
        values.put("MaintComplianceCatalogCode", getMaintComplianceCatalogCode());
        values.put("MaintComplianceDescription", getMaintComplianceDescription());
        values.put("MaintenancePackage", getMaintenancePackage());
        values.put("MaintCmplRqIsLegallyBinding", getMaintCmplRqIsLegallyBinding());
        values.put("MaintCmplRqOriginCode", getMaintCmplRqOriginCode());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceItem") ) {
                final Object value = values.remove("MaintenanceItem");
                if( (value == null) || (!value.equals(getMaintenanceItem())) ) {
                    setMaintenanceItem(((String) value));
                }
            }
            if( values.containsKey("NmbrOfMaintComplianceItems") ) {
                final Object value = values.remove("NmbrOfMaintComplianceItems");
                if( (value == null) || (!value.equals(getNmbrOfMaintComplianceItems())) ) {
                    setNmbrOfMaintComplianceItems(((String) value));
                }
            }
            if( values.containsKey("MaintenanceComplianceGroupCode") ) {
                final Object value = values.remove("MaintenanceComplianceGroupCode");
                if( (value == null) || (!value.equals(getMaintenanceComplianceGroupCode())) ) {
                    setMaintenanceComplianceGroupCode(((String) value));
                }
            }
            if( values.containsKey("MaintenanceComplianceCode") ) {
                final Object value = values.remove("MaintenanceComplianceCode");
                if( (value == null) || (!value.equals(getMaintenanceComplianceCode())) ) {
                    setMaintenanceComplianceCode(((String) value));
                }
            }
            if( values.containsKey("MaintenanceComplianceTypeCode") ) {
                final Object value = values.remove("MaintenanceComplianceTypeCode");
                if( (value == null) || (!value.equals(getMaintenanceComplianceTypeCode())) ) {
                    setMaintenanceComplianceTypeCode(((String) value));
                }
            }
            if( values.containsKey("MaintComplianceCatalogCode") ) {
                final Object value = values.remove("MaintComplianceCatalogCode");
                if( (value == null) || (!value.equals(getMaintComplianceCatalogCode())) ) {
                    setMaintComplianceCatalogCode(((String) value));
                }
            }
            if( values.containsKey("MaintComplianceDescription") ) {
                final Object value = values.remove("MaintComplianceDescription");
                if( (value == null) || (!value.equals(getMaintComplianceDescription())) ) {
                    setMaintComplianceDescription(((String) value));
                }
            }
            if( values.containsKey("MaintenancePackage") ) {
                final Object value = values.remove("MaintenancePackage");
                if( (value == null) || (!value.equals(getMaintenancePackage())) ) {
                    setMaintenancePackage(((String) value));
                }
            }
            if( values.containsKey("MaintCmplRqIsLegallyBinding") ) {
                final Object value = values.remove("MaintCmplRqIsLegallyBinding");
                if( (value == null) || (!value.equals(getMaintCmplRqIsLegallyBinding())) ) {
                    setMaintCmplRqIsLegallyBinding(((String) value));
                }
            }
            if( values.containsKey("MaintCmplRqOriginCode") ) {
                final Object value = values.remove("MaintCmplRqOriginCode");
                if( (value == null) || (!value.equals(getMaintCmplRqOriginCode())) ) {
                    setMaintCmplRqOriginCode(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenanceItem") ) {
                final Object value = (values).remove("to_MaintenanceItem");
                if( value instanceof Map ) {
                    if( toMaintenanceItem == null ) {
                        toMaintenanceItem = new MaintenanceItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceItem.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_MaintenanceItemReasonText") ) {
                final Object value = (values).remove("to_MaintenanceItemReasonText");
                if( value instanceof Iterable ) {
                    if( toMaintenanceItemReasonText == null ) {
                        toMaintenanceItemReasonText = Lists.newArrayList();
                    } else {
                        toMaintenanceItemReasonText = Lists.newArrayList(toMaintenanceItemReasonText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenanceItemReasonText entity;
                        if( toMaintenanceItemReasonText.size() > i ) {
                            entity = toMaintenanceItemReasonText.get(i);
                        } else {
                            entity = new MaintenanceItemReasonText();
                            toMaintenanceItemReasonText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintenanceItemReasonField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintenanceItemReasonField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintenanceItemReasonField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintenanceItemReasonField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceItemService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenanceItem != null ) {
            (values).put("to_MaintenanceItem", toMaintenanceItem);
        }
        if( toMaintenanceItemReasonText != null ) {
            (values).put("to_MaintenanceItemReasonText", toMaintenanceItemReasonText);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceItem</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_MaintenanceItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceItem fetchMaintenanceItem()
    {
        return fetchFieldAsSingle("to_MaintenanceItem", MaintenanceItem.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceItem</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceItem</b> of a queried <b>MaintenanceItemReason</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceItem getMaintenanceItemOrFetch()
    {
        if( toMaintenanceItem == null ) {
            toMaintenanceItem = fetchMaintenanceItem();
        }
        return toMaintenanceItem;
    }

    /**
     * Retrieval of associated <b>MaintenanceItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceItem</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceItemReason</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceItem</b> is already loaded, the result will
     *         contain the <b>MaintenanceItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceItem> getMaintenanceItemIfPresent()
    {
        return Option.of(toMaintenanceItem);
    }

    /**
     * Overwrites the associated <b>MaintenanceItem</b> entity for the loaded navigation property
     * <b>to_MaintenanceItem</b>.
     *
     * @param value
     *            New <b>MaintenanceItem</b> entity.
     */
    public void setMaintenanceItem( final MaintenanceItem value )
    {
        toMaintenanceItem = value;
    }

    /**
     * Fetches the <b>MaintenanceItemReasonText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_MaintenanceItemReasonText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintenanceItemReasonText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceItemReasonText> fetchMaintenanceItemReasonText()
    {
        return fetchFieldAsList("to_MaintenanceItemReasonText", MaintenanceItemReasonText.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceItemReasonText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenanceItemReasonText</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceItemReasonText</b> of a queried <b>MaintenanceItemReason</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceItemReasonText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceItemReasonText> getMaintenanceItemReasonTextOrFetch()
    {
        if( toMaintenanceItemReasonText == null ) {
            toMaintenanceItemReasonText = fetchMaintenanceItemReasonText();
        }
        return toMaintenanceItemReasonText;
    }

    /**
     * Retrieval of associated <b>MaintenanceItemReasonText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenanceItemReasonText</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceItemReason</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceItemReasonText</b> is already loaded, the
     *         result will contain the <b>MaintenanceItemReasonText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenanceItemReasonText>> getMaintenanceItemReasonTextIfPresent()
    {
        return Option.of(toMaintenanceItemReasonText);
    }

    /**
     * Overwrites the list of associated <b>MaintenanceItemReasonText</b> entities for the loaded navigation property
     * <b>to_MaintenanceItemReasonText</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceItemReasonText</b> of a queried <b>MaintenanceItemReason</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintenanceItemReasonText</b> entities.
     */
    public void setMaintenanceItemReasonText( @Nonnull final List<MaintenanceItemReasonText> value )
    {
        if( toMaintenanceItemReasonText == null ) {
            toMaintenanceItemReasonText = Lists.newArrayList();
        }
        toMaintenanceItemReasonText.clear();
        toMaintenanceItemReasonText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenanceItemReasonText</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintenanceItemReasonText</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceItemReasonText</b> of a queried <b>MaintenanceItemReason</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintenanceItemReasonText</b> entities.
     */
    public void addMaintenanceItemReasonText( MaintenanceItemReasonText... entity )
    {
        if( toMaintenanceItemReasonText == null ) {
            toMaintenanceItemReasonText = Lists.newArrayList();
        }
        toMaintenanceItemReasonText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaintenanceItemReason instances.
     *
     */
    public final static class MaintenanceItemReasonBuilder
    {

        private MaintenanceItem toMaintenanceItem;
        private String maintenanceItem = null;
        private List<MaintenanceItemReasonText> toMaintenanceItemReasonText = Lists.newArrayList();

        private MaintenanceItemReason.MaintenanceItemReasonBuilder toMaintenanceItem( final MaintenanceItem value )
        {
            toMaintenanceItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceItem</b> for <b>MaintenanceItemReason</b> to single
         * <b>MaintenanceItem</b>.
         *
         * @param value
         *            The MaintenanceItem to build this MaintenanceItemReason with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceItemReason.MaintenanceItemReasonBuilder maintenanceItem( final MaintenanceItem value )
        {
            return toMaintenanceItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 16
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceItem</b>
         * </p>
         *
         * @param value
         *            The maintenanceItem to build this MaintenanceItemReason with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceItemReason.MaintenanceItemReasonBuilder maintenanceItem( final String value )
        {
            maintenanceItem = value;
            return this;
        }

        private MaintenanceItemReason.MaintenanceItemReasonBuilder toMaintenanceItemReasonText(
            final List<MaintenanceItemReasonText> value )
        {
            toMaintenanceItemReasonText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceItemReasonText</b> for <b>MaintenanceItemReason</b> to multiple
         * <b>MaintenanceItemReasonText</b>.
         *
         * @param value
         *            The MaintenanceItemReasonTexts to build this MaintenanceItemReason with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceItemReason.MaintenanceItemReasonBuilder maintenanceItemReasonText(
            MaintenanceItemReasonText... value )
        {
            return toMaintenanceItemReasonText(Lists.newArrayList(value));
        }

    }

}
