/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.selectable.MaintenanceItemReasonTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText
 * MaintenanceItemReasonText} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class MaintenanceItemReasonTextByKeyFluentHelper
    extends
    FluentHelperByKey<MaintenanceItemReasonTextByKeyFluentHelper, MaintenanceItemReasonText, MaintenanceItemReasonTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText
     * MaintenanceItemReasonText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param nmbrOfMaintComplianceItems
     *            Sequential Number for Compliance
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintenanceItemReasonText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintenanceItemReasonText}
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public MaintenanceItemReasonTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String maintenanceItem,
        final String nmbrOfMaintComplianceItems,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("MaintenanceItem", maintenanceItem);
        this.key.put("NmbrOfMaintComplianceItems", nmbrOfMaintComplianceItems);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<MaintenanceItemReasonText> getEntityClass()
    {
        return MaintenanceItemReasonText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
