/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.field.MaintenanceItemTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.link.MaintenanceItemTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.selectable.MaintenanceItemTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Item Long Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenanceItemTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintenanceItemText extends VdmEntity<MaintenanceItemText>
{

    /**
     * Selector for all available fields of MaintenanceItemText.
     *
     */
    public final static MaintenanceItemTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItem</b>
     * </p>
     *
     * @return Maintenance Item
     */
    @Key
    @SerializedName( "MaintenanceItem" )
    @JsonProperty( "MaintenanceItem" )
    @Nullable
    @ODataField( odataName = "MaintenanceItem" )
    private String maintenanceItem;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceItem</b> field to query operations.
     *
     */
    public final static MaintenanceItemTextField<String> MAINTENANCE_ITEM =
        new MaintenanceItemTextField<String>("MaintenanceItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static MaintenanceItemTextField<String> LANGUAGE = new MaintenanceItemTextField<String>("Language");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItemLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "MaintenanceItemLongText" )
    @JsonProperty( "MaintenanceItemLongText" )
    @Nullable
    @ODataField( odataName = "MaintenanceItemLongText" )
    private String maintenanceItemLongText;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceItemLongText</b> field to query operations.
     *
     */
    public final static MaintenanceItemTextField<String> MAINTENANCE_ITEM_LONG_TEXT =
        new MaintenanceItemTextField<String>("MaintenanceItemLongText");
    /**
     * Navigation property <b>to_MaintenanceItem</b> for <b>MaintenanceItemText</b> to single <b>MaintenanceItem</b>.
     *
     */
    @SerializedName( "to_MaintenanceItem" )
    @JsonProperty( "to_MaintenanceItem" )
    @ODataField( odataName = "to_MaintenanceItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceItem toMaintenanceItem;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceItem</b> navigation property to query operations.
     *
     */
    public final static MaintenanceItemTextOneToOneLink<MaintenanceItem> TO_MAINTENANCE_ITEM =
        new MaintenanceItemTextOneToOneLink<MaintenanceItem>("to_MaintenanceItem");

    @Nonnull
    @Override
    public Class<MaintenanceItemText> getType()
    {
        return MaintenanceItemText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItem</b>
     * </p>
     *
     * @param maintenanceItem
     *            Maintenance Item
     */
    public void setMaintenanceItem( @Nullable final String maintenanceItem )
    {
        rememberChangedField("MaintenanceItem", this.maintenanceItem);
        this.maintenanceItem = maintenanceItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItemLongText</b>
     * </p>
     *
     * @param maintenanceItemLongText
     *            Long Text
     */
    public void setMaintenanceItemLongText( @Nullable final String maintenanceItemLongText )
    {
        rememberChangedField("MaintenanceItemLongText", this.maintenanceItemLongText);
        this.maintenanceItemLongText = maintenanceItemLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintenanceItemText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceItem", getMaintenanceItem());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceItem", getMaintenanceItem());
        values.put("Language", getLanguage());
        values.put("MaintenanceItemLongText", getMaintenanceItemLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceItem") ) {
                final Object value = values.remove("MaintenanceItem");
                if( (value == null) || (!value.equals(getMaintenanceItem())) ) {
                    setMaintenanceItem(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("MaintenanceItemLongText") ) {
                final Object value = values.remove("MaintenanceItemLongText");
                if( (value == null) || (!value.equals(getMaintenanceItemLongText())) ) {
                    setMaintenanceItemLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenanceItem") ) {
                final Object value = (values).remove("to_MaintenanceItem");
                if( value instanceof Map ) {
                    if( toMaintenanceItem == null ) {
                        toMaintenanceItem = new MaintenanceItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintenanceItemTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintenanceItemTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintenanceItemTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintenanceItemTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceItemService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenanceItem != null ) {
            (values).put("to_MaintenanceItem", toMaintenanceItem);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceItem</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_MaintenanceItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceItem fetchMaintenanceItem()
    {
        return fetchFieldAsSingle("to_MaintenanceItem", MaintenanceItem.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceItem</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceItem</b> of a queried <b>MaintenanceItemText</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceItem getMaintenanceItemOrFetch()
    {
        if( toMaintenanceItem == null ) {
            toMaintenanceItem = fetchMaintenanceItem();
        }
        return toMaintenanceItem;
    }

    /**
     * Retrieval of associated <b>MaintenanceItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceItem</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceItemText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceItem</b> is already loaded, the result will
     *         contain the <b>MaintenanceItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceItem> getMaintenanceItemIfPresent()
    {
        return Option.of(toMaintenanceItem);
    }

    /**
     * Overwrites the associated <b>MaintenanceItem</b> entity for the loaded navigation property
     * <b>to_MaintenanceItem</b>.
     *
     * @param value
     *            New <b>MaintenanceItem</b> entity.
     */
    public void setMaintenanceItem( final MaintenanceItem value )
    {
        toMaintenanceItem = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintenanceItemText instances.
     *
     */
    public final static class MaintenanceItemTextBuilder
    {

        private MaintenanceItem toMaintenanceItem;
        private String maintenanceItem = null;

        private MaintenanceItemText.MaintenanceItemTextBuilder toMaintenanceItem( final MaintenanceItem value )
        {
            toMaintenanceItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceItem</b> for <b>MaintenanceItemText</b> to single
         * <b>MaintenanceItem</b>.
         *
         * @param value
         *            The MaintenanceItem to build this MaintenanceItemText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceItemText.MaintenanceItemTextBuilder maintenanceItem( final MaintenanceItem value )
        {
            return toMaintenanceItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 16
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceItem</b>
         * </p>
         *
         * @param value
         *            The maintenanceItem to build this MaintenanceItemText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceItemText.MaintenanceItemTextBuilder maintenanceItem( final String value )
        {
            maintenanceItem = value;
            return this;
        }

    }

}
