/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.field.MaintenancePlanCallObjectField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.selectable.MaintenancePlanCallObjectSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Maintenance Plan Call Objects
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenancePlanCallObject_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintenancePlanCallObject extends VdmEntity<MaintenancePlanCallObject>
{

    /**
     * Selector for all available fields of MaintenancePlanCallObject.
     *
     */
    public final static MaintenancePlanCallObjectSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @return Maintenance Plan
     */
    @Key
    @SerializedName( "MaintenancePlan" )
    @JsonProperty( "MaintenancePlan" )
    @Nullable
    @ODataField( odataName = "MaintenancePlan" )
    private String maintenancePlan;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlan</b> field to query operations.
     *
     */
    public final static MaintenancePlanCallObjectField<String> MAINTENANCE_PLAN =
        new MaintenancePlanCallObjectField<String>("MaintenancePlan");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCallNumber</b>
     * </p>
     *
     * @return Maintenance Plan Call Number
     */
    @Key
    @SerializedName( "MaintenancePlanCallNumber" )
    @JsonProperty( "MaintenancePlanCallNumber" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanCallNumber" )
    private Integer maintenancePlanCallNumber;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanCallNumber</b> field to query operations.
     *
     */
    public final static MaintenancePlanCallObjectField<Integer> MAINTENANCE_PLAN_CALL_NUMBER =
        new MaintenancePlanCallObjectField<Integer>("MaintenancePlanCallNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItem</b>
     * </p>
     *
     * @return Maintenance Item
     */
    @Key
    @SerializedName( "MaintenanceItem" )
    @JsonProperty( "MaintenanceItem" )
    @Nullable
    @ODataField( odataName = "MaintenanceItem" )
    private String maintenanceItem;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceItem</b> field to query operations.
     *
     */
    public final static MaintenancePlanCallObjectField<String> MAINTENANCE_ITEM =
        new MaintenancePlanCallObjectField<String>("MaintenanceItem");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @SerializedName( "MaintenanceOrder" )
    @JsonProperty( "MaintenanceOrder" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrder" )
    private String maintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrder</b> field to query operations.
     *
     */
    public final static MaintenancePlanCallObjectField<String> MAINTENANCE_ORDER =
        new MaintenancePlanCallObjectField<String>("MaintenanceOrder");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotification</b>
     * </p>
     *
     * @return Notification Number
     */
    @SerializedName( "MaintenanceNotification" )
    @JsonProperty( "MaintenanceNotification" )
    @Nullable
    @ODataField( odataName = "MaintenanceNotification" )
    private String maintenanceNotification;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceNotification</b> field to query operations.
     *
     */
    public final static MaintenancePlanCallObjectField<String> MAINTENANCE_NOTIFICATION =
        new MaintenancePlanCallObjectField<String>("MaintenanceNotification");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "ServiceOrder" )
    @JsonProperty( "ServiceOrder" )
    @Nullable
    @ODataField( odataName = "ServiceOrder" )
    private String serviceOrder;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrder</b> field to query operations.
     *
     */
    public final static MaintenancePlanCallObjectField<String> SERVICE_ORDER =
        new MaintenancePlanCallObjectField<String>("ServiceOrder");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintCallHorizonIsNotReached</b>
     * </p>
     *
     * @return Scheduling status: call horizon not reached
     */
    @SerializedName( "MaintCallHorizonIsNotReached" )
    @JsonProperty( "MaintCallHorizonIsNotReached" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaintCallHorizonIsNotReached" )
    private Boolean maintCallHorizonIsNotReached;
    /**
     * Use with available fluent helpers to apply the <b>MaintCallHorizonIsNotReached</b> field to query operations.
     *
     */
    public final static MaintenancePlanCallObjectField<Boolean> MAINT_CALL_HORIZON_IS_NOT_REACHED =
        new MaintenancePlanCallObjectField<Boolean>("MaintCallHorizonIsNotReached");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingStatus</b>
     * </p>
     *
     * @return Single-Character Flag
     */
    @SerializedName( "SchedulingStatus" )
    @JsonProperty( "SchedulingStatus" )
    @Nullable
    @ODataField( odataName = "SchedulingStatus" )
    private String schedulingStatus;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingStatus</b> field to query operations.
     *
     */
    public final static MaintenancePlanCallObjectField<String> SCHEDULING_STATUS =
        new MaintenancePlanCallObjectField<String>("SchedulingStatus");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedStartDate</b>
     * </p>
     *
     * @return Basic start date
     */
    @SerializedName( "PlannedStartDate" )
    @JsonProperty( "PlannedStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime plannedStartDate;
    /**
     * Use with available fluent helpers to apply the <b>PlannedStartDate</b> field to query operations.
     *
     */
    public final static MaintenancePlanCallObjectField<LocalDateTime> PLANNED_START_DATE =
        new MaintenancePlanCallObjectField<LocalDateTime>("PlannedStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReleasedByUserName</b>
     * </p>
     *
     * @return Scheduling determined by user
     */
    @SerializedName( "ReleasedByUserName" )
    @JsonProperty( "ReleasedByUserName" )
    @Nullable
    @ODataField( odataName = "ReleasedByUserName" )
    private String releasedByUserName;
    /**
     * Use with available fluent helpers to apply the <b>ReleasedByUserName</b> field to query operations.
     *
     */
    public final static MaintenancePlanCallObjectField<String> RELEASED_BY_USER_NAME =
        new MaintenancePlanCallObjectField<String>("ReleasedByUserName");

    @Nonnull
    @Override
    public Class<MaintenancePlanCallObject> getType()
    {
        return MaintenancePlanCallObject.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @param maintenancePlan
     *            Maintenance Plan
     */
    public void setMaintenancePlan( @Nullable final String maintenancePlan )
    {
        rememberChangedField("MaintenancePlan", this.maintenancePlan);
        this.maintenancePlan = maintenancePlan;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCallNumber</b>
     * </p>
     *
     * @param maintenancePlanCallNumber
     *            Maintenance Plan Call Number
     */
    public void setMaintenancePlanCallNumber( @Nullable final Integer maintenancePlanCallNumber )
    {
        rememberChangedField("MaintenancePlanCallNumber", this.maintenancePlanCallNumber);
        this.maintenancePlanCallNumber = maintenancePlanCallNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItem</b>
     * </p>
     *
     * @param maintenanceItem
     *            Maintenance Item
     */
    public void setMaintenanceItem( @Nullable final String maintenanceItem )
    {
        rememberChangedField("MaintenanceItem", this.maintenanceItem);
        this.maintenanceItem = maintenanceItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @param maintenanceOrder
     *            Order Number
     */
    public void setMaintenanceOrder( @Nullable final String maintenanceOrder )
    {
        rememberChangedField("MaintenanceOrder", this.maintenanceOrder);
        this.maintenanceOrder = maintenanceOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotification</b>
     * </p>
     *
     * @param maintenanceNotification
     *            Notification Number
     */
    public void setMaintenanceNotification( @Nullable final String maintenanceNotification )
    {
        rememberChangedField("MaintenanceNotification", this.maintenanceNotification);
        this.maintenanceNotification = maintenanceNotification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @param serviceOrder
     *            Transaction ID
     */
    public void setServiceOrder( @Nullable final String serviceOrder )
    {
        rememberChangedField("ServiceOrder", this.serviceOrder);
        this.serviceOrder = serviceOrder;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintCallHorizonIsNotReached</b>
     * </p>
     *
     * @param maintCallHorizonIsNotReached
     *            Scheduling status: call horizon not reached
     */
    public void setMaintCallHorizonIsNotReached( @Nullable final Boolean maintCallHorizonIsNotReached )
    {
        rememberChangedField("MaintCallHorizonIsNotReached", this.maintCallHorizonIsNotReached);
        this.maintCallHorizonIsNotReached = maintCallHorizonIsNotReached;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingStatus</b>
     * </p>
     *
     * @param schedulingStatus
     *            Single-Character Flag
     */
    public void setSchedulingStatus( @Nullable final String schedulingStatus )
    {
        rememberChangedField("SchedulingStatus", this.schedulingStatus);
        this.schedulingStatus = schedulingStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedStartDate</b>
     * </p>
     *
     * @param plannedStartDate
     *            Basic start date
     */
    public void setPlannedStartDate( @Nullable final LocalDateTime plannedStartDate )
    {
        rememberChangedField("PlannedStartDate", this.plannedStartDate);
        this.plannedStartDate = plannedStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReleasedByUserName</b>
     * </p>
     *
     * @param releasedByUserName
     *            Scheduling determined by user
     */
    public void setReleasedByUserName( @Nullable final String releasedByUserName )
    {
        rememberChangedField("ReleasedByUserName", this.releasedByUserName);
        this.releasedByUserName = releasedByUserName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintenancePlanCallObject";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenancePlan", getMaintenancePlan());
        result.put("MaintenancePlanCallNumber", getMaintenancePlanCallNumber());
        result.put("MaintenanceItem", getMaintenanceItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenancePlan", getMaintenancePlan());
        values.put("MaintenancePlanCallNumber", getMaintenancePlanCallNumber());
        values.put("MaintenanceItem", getMaintenanceItem());
        values.put("MaintenanceOrder", getMaintenanceOrder());
        values.put("MaintenanceNotification", getMaintenanceNotification());
        values.put("ServiceOrder", getServiceOrder());
        values.put("MaintCallHorizonIsNotReached", getMaintCallHorizonIsNotReached());
        values.put("SchedulingStatus", getSchedulingStatus());
        values.put("PlannedStartDate", getPlannedStartDate());
        values.put("ReleasedByUserName", getReleasedByUserName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenancePlan") ) {
                final Object value = values.remove("MaintenancePlan");
                if( (value == null) || (!value.equals(getMaintenancePlan())) ) {
                    setMaintenancePlan(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanCallNumber") ) {
                final Object value = values.remove("MaintenancePlanCallNumber");
                if( (value == null) || (!value.equals(getMaintenancePlanCallNumber())) ) {
                    setMaintenancePlanCallNumber(((Integer) value));
                }
            }
            if( values.containsKey("MaintenanceItem") ) {
                final Object value = values.remove("MaintenanceItem");
                if( (value == null) || (!value.equals(getMaintenanceItem())) ) {
                    setMaintenanceItem(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrder") ) {
                final Object value = values.remove("MaintenanceOrder");
                if( (value == null) || (!value.equals(getMaintenanceOrder())) ) {
                    setMaintenanceOrder(((String) value));
                }
            }
            if( values.containsKey("MaintenanceNotification") ) {
                final Object value = values.remove("MaintenanceNotification");
                if( (value == null) || (!value.equals(getMaintenanceNotification())) ) {
                    setMaintenanceNotification(((String) value));
                }
            }
            if( values.containsKey("ServiceOrder") ) {
                final Object value = values.remove("ServiceOrder");
                if( (value == null) || (!value.equals(getServiceOrder())) ) {
                    setServiceOrder(((String) value));
                }
            }
            if( values.containsKey("MaintCallHorizonIsNotReached") ) {
                final Object value = values.remove("MaintCallHorizonIsNotReached");
                if( (value == null) || (!value.equals(getMaintCallHorizonIsNotReached())) ) {
                    setMaintCallHorizonIsNotReached(((Boolean) value));
                }
            }
            if( values.containsKey("SchedulingStatus") ) {
                final Object value = values.remove("SchedulingStatus");
                if( (value == null) || (!value.equals(getSchedulingStatus())) ) {
                    setSchedulingStatus(((String) value));
                }
            }
            if( values.containsKey("PlannedStartDate") ) {
                final Object value = values.remove("PlannedStartDate");
                if( (value == null) || (!value.equals(getPlannedStartDate())) ) {
                    setPlannedStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ReleasedByUserName") ) {
                final Object value = values.remove("ReleasedByUserName");
                if( (value == null) || (!value.equals(getReleasedByUserName())) ) {
                    setReleasedByUserName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintenancePlanCallObjectField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintenancePlanCallObjectField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintenancePlanCallObjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintenancePlanCallObjectField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceItemService.DEFAULT_SERVICE_PATH);
    }

}
