/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link MaintenanceItemServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceItemService MaintenanceItemService}, allowing you
 * to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultMaintenanceItemServiceBatch
    extends
    BatchFluentHelperBasic<MaintenanceItemServiceBatch, MaintenanceItemServiceBatchChangeSet>
    implements
    MaintenanceItemServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceItemService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultMaintenanceItemServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMaintenanceItemServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceItemService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceItemService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultMaintenanceItemServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMaintenanceItemServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceItemService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultMaintenanceItemServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MaintenanceItemServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultMaintenanceItemServiceBatchChangeSet(this, service);
    }

}
