/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemText;

/**
 * Implementation of the {@link MaintenanceItemServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceItemService MaintenanceItemService}.
 *
 */
public class DefaultMaintenanceItemServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<MaintenanceItemServiceBatch, MaintenanceItemServiceBatchChangeSet>
    implements
    MaintenanceItemServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceItemService service;

    @SuppressWarnings( "deprecation" )
    DefaultMaintenanceItemServiceBatchChangeSet(
        @Nonnull final DefaultMaintenanceItemServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceItemService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultMaintenanceItemServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MaintenanceItemServiceBatchChangeSet createMaintenanceItem( @Nonnull final MaintenanceItem maintenanceItem )
    {
        return addRequestCreate(service::createMaintenanceItem, maintenanceItem);
    }

    @Nonnull
    @Override
    public MaintenanceItemServiceBatchChangeSet updateMaintenanceItem( @Nonnull final MaintenanceItem maintenanceItem )
    {
        return addRequestUpdate(service::updateMaintenanceItem, maintenanceItem);
    }

    @Nonnull
    @Override
    public MaintenanceItemServiceBatchChangeSet createMaintenanceItemCause(
        @Nonnull final MaintenanceItemCause maintenanceItemCause )
    {
        return addRequestCreate(service::createMaintenanceItemCause, maintenanceItemCause);
    }

    @Nonnull
    @Override
    public MaintenanceItemServiceBatchChangeSet updateMaintenanceItemCause(
        @Nonnull final MaintenanceItemCause maintenanceItemCause )
    {
        return addRequestUpdate(service::updateMaintenanceItemCause, maintenanceItemCause);
    }

    @Nonnull
    @Override
    public MaintenanceItemServiceBatchChangeSet deleteMaintenanceItemCause(
        @Nonnull final MaintenanceItemCause maintenanceItemCause )
    {
        return addRequestDelete(service::deleteMaintenanceItemCause, maintenanceItemCause);
    }

    @Nonnull
    @Override
    public MaintenanceItemServiceBatchChangeSet updateMaintenanceItemCauseText(
        @Nonnull final MaintenanceItemCauseText maintenanceItemCauseText )
    {
        return addRequestUpdate(service::updateMaintenanceItemCauseText, maintenanceItemCauseText);
    }

    @Nonnull
    @Override
    public MaintenanceItemServiceBatchChangeSet deleteMaintenanceItemCauseText(
        @Nonnull final MaintenanceItemCauseText maintenanceItemCauseText )
    {
        return addRequestDelete(service::deleteMaintenanceItemCauseText, maintenanceItemCauseText);
    }

    @Nonnull
    @Override
    public MaintenanceItemServiceBatchChangeSet createMaintenanceItemReason(
        @Nonnull final MaintenanceItemReason maintenanceItemReason )
    {
        return addRequestCreate(service::createMaintenanceItemReason, maintenanceItemReason);
    }

    @Nonnull
    @Override
    public MaintenanceItemServiceBatchChangeSet updateMaintenanceItemReason(
        @Nonnull final MaintenanceItemReason maintenanceItemReason )
    {
        return addRequestUpdate(service::updateMaintenanceItemReason, maintenanceItemReason);
    }

    @Nonnull
    @Override
    public MaintenanceItemServiceBatchChangeSet deleteMaintenanceItemReason(
        @Nonnull final MaintenanceItemReason maintenanceItemReason )
    {
        return addRequestDelete(service::deleteMaintenanceItemReason, maintenanceItemReason);
    }

    @Nonnull
    @Override
    public MaintenanceItemServiceBatchChangeSet updateMaintenanceItemReasonText(
        @Nonnull final MaintenanceItemReasonText maintenanceItemReasonText )
    {
        return addRequestUpdate(service::updateMaintenanceItemReasonText, maintenanceItemReasonText);
    }

    @Nonnull
    @Override
    public MaintenanceItemServiceBatchChangeSet deleteMaintenanceItemReasonText(
        @Nonnull final MaintenanceItemReasonText maintenanceItemReasonText )
    {
        return addRequestDelete(service::deleteMaintenanceItemReasonText, maintenanceItemReasonText);
    }

    @Nonnull
    @Override
    public MaintenanceItemServiceBatchChangeSet updateMaintenanceItemText(
        @Nonnull final MaintenanceItemText maintenanceItemText )
    {
        return addRequestUpdate(service::updateMaintenanceItemText, maintenanceItemText);
    }

    @Nonnull
    @Override
    public MaintenanceItemServiceBatchChangeSet updateMaintItemObjectListItem(
        @Nonnull final MaintItemObjectListItem maintItemObjectListItem )
    {
        return addRequestUpdate(service::updateMaintItemObjectListItem, maintItemObjectListItem);
    }

    @Nonnull
    @Override
    public MaintenanceItemServiceBatchChangeSet deleteMaintItemObjectListItem(
        @Nonnull final MaintItemObjectListItem maintItemObjectListItem )
    {
        return addRequestDelete(service::deleteMaintItemObjectListItem, maintItemObjectListItem);
    }

}
