/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceItemService MaintenanceItemService}.
 *
 */
public interface MaintenanceItemServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<MaintenanceItemServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<MaintenanceItemServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem
     * MaintenanceItem} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem
     *            MaintenanceItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceItemServiceBatchChangeSet createMaintenanceItem( @Nonnull final MaintenanceItem maintenanceItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem
     * MaintenanceItem} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem
     *            MaintenanceItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceItemServiceBatchChangeSet updateMaintenanceItem( @Nonnull final MaintenanceItem maintenanceItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     * MaintenanceItemCause} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemCause
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     *            MaintenanceItemCause} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceItemServiceBatchChangeSet
        createMaintenanceItemCause( @Nonnull final MaintenanceItemCause maintenanceItemCause );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     * MaintenanceItemCause} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemCause
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     *            MaintenanceItemCause} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceItemServiceBatchChangeSet
        updateMaintenanceItemCause( @Nonnull final MaintenanceItemCause maintenanceItemCause );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     * MaintenanceItemCause} entity in the S/4HANA system.
     *
     * @param maintenanceItemCause
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCause
     *            MaintenanceItemCause} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceItemServiceBatchChangeSet
        deleteMaintenanceItemCause( @Nonnull final MaintenanceItemCause maintenanceItemCause );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseText
     * MaintenanceItemCauseText} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemCauseText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseText
     *            MaintenanceItemCauseText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceItemServiceBatchChangeSet
        updateMaintenanceItemCauseText( @Nonnull final MaintenanceItemCauseText maintenanceItemCauseText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseText
     * MaintenanceItemCauseText} entity in the S/4HANA system.
     *
     * @param maintenanceItemCauseText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemCauseText
     *            MaintenanceItemCauseText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceItemServiceBatchChangeSet
        deleteMaintenanceItemCauseText( @Nonnull final MaintenanceItemCauseText maintenanceItemCauseText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     * MaintenanceItemReason} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemReason
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     *            MaintenanceItemReason} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceItemServiceBatchChangeSet
        createMaintenanceItemReason( @Nonnull final MaintenanceItemReason maintenanceItemReason );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     * MaintenanceItemReason} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemReason
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     *            MaintenanceItemReason} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceItemServiceBatchChangeSet
        updateMaintenanceItemReason( @Nonnull final MaintenanceItemReason maintenanceItemReason );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     * MaintenanceItemReason} entity in the S/4HANA system.
     *
     * @param maintenanceItemReason
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReason
     *            MaintenanceItemReason} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceItemServiceBatchChangeSet
        deleteMaintenanceItemReason( @Nonnull final MaintenanceItemReason maintenanceItemReason );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText
     * MaintenanceItemReasonText} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemReasonText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText
     *            MaintenanceItemReasonText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceItemServiceBatchChangeSet
        updateMaintenanceItemReasonText( @Nonnull final MaintenanceItemReasonText maintenanceItemReasonText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText
     * MaintenanceItemReasonText} entity in the S/4HANA system.
     *
     * @param maintenanceItemReasonText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText
     *            MaintenanceItemReasonText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceItemServiceBatchChangeSet
        deleteMaintenanceItemReasonText( @Nonnull final MaintenanceItemReasonText maintenanceItemReasonText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemText
     * MaintenanceItemText} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemText
     *            MaintenanceItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceItemServiceBatchChangeSet
        updateMaintenanceItemText( @Nonnull final MaintenanceItemText maintenanceItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItem
     * MaintItemObjectListItem} entity and save it to the S/4HANA system.
     *
     * @param maintItemObjectListItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItem
     *            MaintItemObjectListItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceItemServiceBatchChangeSet
        updateMaintItemObjectListItem( @Nonnull final MaintItemObjectListItem maintItemObjectListItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItem
     * MaintItemObjectListItem} entity in the S/4HANA system.
     *
     * @param maintItemObjectListItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintItemObjectListItem
     *            MaintItemObjectListItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenanceItemServiceBatchChangeSet
        deleteMaintItemObjectListItem( @Nonnull final MaintItemObjectListItem maintItemObjectListItem );

}
