/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText
 * MaintenanceItemReasonText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.field.MaintenanceItemReasonTextField
 * MaintenanceItemReasonTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.link.MaintenanceItemReasonTextLink
 * MaintenanceItemReasonTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText#MAINTENANCE_ITEM
 * MAINTENANCE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText#NMBR_OF_MAINT_COMPLIANCE_ITEMS
 * NMBR_OF_MAINT_COMPLIANCE_ITEMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText#PLAIN_LONG_TEXT
 * PLAIN_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText#TO_MAINTENANCE_ITEM_REASON
 * TO_MAINTENANCE_ITEM_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItemReasonText#TO_MAINTENANCE_ITEM
 * TO_MAINTENANCE_ITEM}</li>
 * </ul>
 *
 */
public interface MaintenanceItemReasonTextSelectable extends EntitySelectable<MaintenanceItemReasonText>
{

}
