/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem MaintenanceItem}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.field.MaintenanceItemField
 * MaintenanceItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.link.MaintenanceItemLink
 * MaintenanceItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINTENANCE_ITEM
 * MAINTENANCE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINTENANCE_ITEM_DESCRIPTION
 * MAINTENANCE_ITEM_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINTENANCE_STRATEGY
 * MAINTENANCE_STRATEGY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINTENANCE_PLAN_CATEGORY
 * MAINTENANCE_PLAN_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINTENANCE_PLAN_CALL_OBJECT
 * MAINTENANCE_PLAN_CALL_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINTENANCE_PLAN
 * MAINTENANCE_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINTENANCE_PLAN_ITEM_POSITION
 * MAINTENANCE_PLAN_ITEM_POSITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINTENANCE_ITEM_OBJECT_LIST
 * MAINTENANCE_ITEM_OBJECT_LIST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#FUNCTIONAL_LOCATION_LABEL_NAME
 * FUNCTIONAL_LOCATION_LABEL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#EQUIPMENT
 * EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#ASSEMBLY
 * ASSEMBLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#ADDITIONAL_DEVICE_DATA
 * ADDITIONAL_DEVICE_DATA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#TASK_LIST_TYPE
 * TASK_LIST_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#TASK_LIST_GROUP
 * TASK_LIST_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#TASK_LIST_GROUP_COUNTER
 * TASK_LIST_GROUP_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#OPERATION_SYSTEM_CONDITION
 * OPERATION_SYSTEM_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#NUMBER_OF_TASK_LIST_EXECUTIONS
 * NUMBER_OF_TASK_LIST_EXECUTIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINT_NOTIF_TSK_IS_AUTOMLY_DTMND
 * MAINT_NOTIF_TSK_IS_AUTOMLY_DTMND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINTENANCE_PLANNING_PLANT
 * MAINTENANCE_PLANNING_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINTENANCE_PLANNER_GROUP
 * MAINTENANCE_PLANNER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINTENANCE_ORDER_TYPE
 * MAINTENANCE_ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#NOTIFICATION_TYPE
 * NOTIFICATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINTENANCE_ACTIVITY_TYPE
 * MAINTENANCE_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAIN_WORK_CENTER
 * MAIN_WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAIN_WORK_CENTER_PLANT
 * MAIN_WORK_CENTER_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINT_PRIORITY
 * MAINT_PRIORITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINT_PRIORITY_TYPE
 * MAINT_PRIORITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#IMMEDIATE_RELEASE_IS_BLOCKED
 * IMMEDIATE_RELEASE_IS_BLOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#SERIAL_NUMBER
 * SERIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#SERVICE_DOCUMENT_TYPE
 * SERVICE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#SERVICE_CONTRACT
 * SERVICE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#SERVICE_CONTRACT_ITEM
 * SERVICE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#SERVICE_ORDER_TEMPLATE
 * SERVICE_ORDER_TEMPLATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#SERVICE_DOCUMENT_PRIORITY
 * SERVICE_DOCUMENT_PRIORITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#PRODUCT PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINT_CMPLNC_CALCULATION_METHOD
 * MAINT_CMPLNC_CALCULATION_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINT_CMPLNC_STRT_DTE_OFFSET_IN_DAYS
 * MAINT_CMPLNC_STRT_DTE_OFFSET_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINT_CMPLNC_END_DATE_OFFSET_IN_DAYS
 * MAINT_CMPLNC_END_DATE_OFFSET_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINTENANCE_PLANT
 * MAINTENANCE_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#ASSET_LOCATION
 * ASSET_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#ASSET_ROOM
 * ASSET_ROOM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#PLANT_SECTION
 * PLANT_SECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#WORK_CENTER
 * WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#ABC_INDICATOR
 * ABC_INDICATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MAINT_OBJECT_FREE_DEFINED_ATTRIB
 * MAINT_OBJECT_FREE_DEFINED_ATTRIB}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#MASTER_FIXED_ASSET
 * MASTER_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#FIXED_ASSET
 * FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#LOC_ACCT_ASSGMT_BUSINESS_AREA
 * LOC_ACCT_ASSGMT_BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#SETTLEMENT_ORDER
 * SETTLEMENT_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#CYCLE_SET_SEQUENCE
 * CYCLE_SET_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#STANDING_ORDER_NUMBER
 * STANDING_ORDER_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#TO_LONG_TEXT
 * TO_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#TO_MAINTENANCE_ITEM_CAUSE
 * TO_MAINTENANCE_ITEM_CAUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#TO_MAINTENANCE_ITEM_REASON
 * TO_MAINTENANCE_ITEM_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#TO_MAINT_ITEM_OBJECT_LIST_ITEM
 * TO_MAINT_ITEM_OBJECT_LIST_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceitem.MaintenanceItem#TO_MAINT_PLAN_CALL_OBJECTS
 * TO_MAINT_PLAN_CALL_OBJECTS}</li>
 * </ul>
 *
 */
public interface MaintenanceItemSelectable extends EntitySelectable<MaintenanceItem>
{

}
