/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification;

import java.net.URI;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>CompleteMaintNotification</b> OData function import.
 *
 */
public class CompleteMaintNotificationFluentHelper
    extends
    SingleValuedFluentHelperFunction<CompleteMaintNotificationFluentHelper, MaintenanceNotification, MaintenanceNotification>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>CompleteMaintNotification</b> OData function import with
     * the provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param notificationReferenceDate
     *            Reference Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>NotificationReferenceDate</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param maintenanceNotification
     *            Notification
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceNotification</b>
     *            </p>
     * @param notificationReferenceTime
     *            Reference Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>NotificationReferenceTime</b>
     *            </p>
     */
    public CompleteMaintNotificationFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String maintenanceNotification,
        @Nullable final LocalDateTime notificationReferenceDate,
        @Nullable final LocalTime notificationReferenceTime )
    {
        super(servicePath);
        values.put("MaintenanceNotification", maintenanceNotification);
        if( notificationReferenceDate != null ) {
            values.put("NotificationReferenceDate", notificationReferenceDate);
        }
        if( notificationReferenceTime != null ) {
            values.put("NotificationReferenceTime", notificationReferenceTime);
        }
    }

    /**
     * Creates a fluent helper object that will execute the <b>CompleteMaintNotification</b> OData function import with
     * the provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param notificationReferenceDate
     *            Reference Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>NotificationReferenceDate</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param maintenanceNotification
     *            Notification
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceNotification</b>
     *            </p>
     * @param notificationReferenceTime
     *            Reference Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>NotificationReferenceTime</b>
     *            </p>
     * @param maintNotifReferenceDateTime
     *            Reference Date Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintNotifReferenceDateTime</b>
     *            </p>
     */
    public CompleteMaintNotificationFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String maintenanceNotification,
        @Nullable final LocalDateTime notificationReferenceDate,
        @Nullable final LocalTime notificationReferenceTime,
        @Nullable final ZonedDateTime maintNotifReferenceDateTime )
    {
        super(servicePath);
        values.put("MaintenanceNotification", maintenanceNotification);
        if( notificationReferenceDate != null ) {
            values.put("NotificationReferenceDate", notificationReferenceDate);
        }
        if( notificationReferenceTime != null ) {
            values.put("NotificationReferenceTime", notificationReferenceTime);
        }
        if( maintNotifReferenceDateTime != null ) {
            values.put("MaintNotifReferenceDateTime", maintNotifReferenceDateTime);
        }
    }

    @Override
    @Nonnull
    protected Class<MaintenanceNotification> getEntityClass()
    {
        return MaintenanceNotification.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "CompleteMaintNotification";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpPost(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nullable
    public MaintenanceNotification executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeSingle(destination);
    }

}
