/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.field.MaintNotificationItemActivityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.link.MaintNotificationItemActivityOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.selectable.MaintNotificationItemActivitySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Notification Item Activity
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintNotificationItemActivityType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintNotificationItemActivity extends VdmEntity<MaintNotificationItemActivity>
{

    /**
     * Selector for all available fields of MaintNotificationItemActivity.
     *
     */
    public final static MaintNotificationItemActivitySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationActivity</b>
     * </p>
     *
     * @return Consecutive Number of Activity
     */
    @Key
    @SerializedName( "MaintNotificationActivity" )
    @JsonProperty( "MaintNotificationActivity" )
    @Nullable
    @ODataField( odataName = "MaintNotificationActivity" )
    private String maintNotificationActivity;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotificationActivity</b> field to query operations.
     *
     */
    public final static MaintNotificationItemActivityField<String> MAINT_NOTIFICATION_ACTIVITY =
        new MaintNotificationItemActivityField<String>("MaintNotificationActivity");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotification</b>
     * </p>
     *
     * @return Notification Number
     */
    @Key
    @SerializedName( "MaintenanceNotification" )
    @JsonProperty( "MaintenanceNotification" )
    @Nullable
    @ODataField( odataName = "MaintenanceNotification" )
    private String maintenanceNotification;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceNotification</b> field to query operations.
     *
     */
    public final static MaintNotificationItemActivityField<String> MAINTENANCE_NOTIFICATION =
        new MaintNotificationItemActivityField<String>("MaintenanceNotification");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotificationItem</b>
     * </p>
     *
     * @return Item Number in Item Record
     */
    @Key
    @SerializedName( "MaintenanceNotificationItem" )
    @JsonProperty( "MaintenanceNotificationItem" )
    @Nullable
    @ODataField( odataName = "MaintenanceNotificationItem" )
    private String maintenanceNotificationItem;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceNotificationItem</b> field to query operations.
     *
     */
    public final static MaintNotificationItemActivityField<String> MAINTENANCE_NOTIFICATION_ITEM =
        new MaintNotificationItemActivityField<String>("MaintenanceNotificationItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifActivitySortNumber</b>
     * </p>
     *
     * @return Sort Number for Activity
     */
    @SerializedName( "MaintNotifActivitySortNumber" )
    @JsonProperty( "MaintNotifActivitySortNumber" )
    @Nullable
    @ODataField( odataName = "MaintNotifActivitySortNumber" )
    private String maintNotifActivitySortNumber;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifActivitySortNumber</b> field to query operations.
     *
     */
    public final static MaintNotificationItemActivityField<String> MAINT_NOTIF_ACTIVITY_SORT_NUMBER =
        new MaintNotificationItemActivityField<String>("MaintNotifActivitySortNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifActyTxt</b>
     * </p>
     *
     * @return Activity Text
     */
    @SerializedName( "MaintNotifActyTxt" )
    @JsonProperty( "MaintNotifActyTxt" )
    @Nullable
    @ODataField( odataName = "MaintNotifActyTxt" )
    private String maintNotifActyTxt;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifActyTxt</b> field to query operations.
     *
     */
    public final static MaintNotificationItemActivityField<String> MAINT_NOTIF_ACTY_TXT =
        new MaintNotificationItemActivityField<String>("MaintNotifActyTxt");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifActivityCodeGroup</b>
     * </p>
     *
     * @return Activity Code Group
     */
    @SerializedName( "MaintNotifActivityCodeGroup" )
    @JsonProperty( "MaintNotifActivityCodeGroup" )
    @Nullable
    @ODataField( odataName = "MaintNotifActivityCodeGroup" )
    private String maintNotifActivityCodeGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifActivityCodeGroup</b> field to query operations.
     *
     */
    public final static MaintNotificationItemActivityField<String> MAINT_NOTIF_ACTIVITY_CODE_GROUP =
        new MaintNotificationItemActivityField<String>("MaintNotifActivityCodeGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>NotifActivityCodeGroupText</b>
     * </p>
     *
     * @return Text for Code Group
     */
    @SerializedName( "NotifActivityCodeGroupText" )
    @JsonProperty( "NotifActivityCodeGroupText" )
    @Nullable
    @ODataField( odataName = "NotifActivityCodeGroupText" )
    private String notifActivityCodeGroupText;
    /**
     * Use with available fluent helpers to apply the <b>NotifActivityCodeGroupText</b> field to query operations.
     *
     */
    public final static MaintNotificationItemActivityField<String> NOTIF_ACTIVITY_CODE_GROUP_TEXT =
        new MaintNotificationItemActivityField<String>("NotifActivityCodeGroupText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationActivityCode</b>
     * </p>
     *
     * @return Activity Code
     */
    @SerializedName( "MaintNotificationActivityCode" )
    @JsonProperty( "MaintNotificationActivityCode" )
    @Nullable
    @ODataField( odataName = "MaintNotificationActivityCode" )
    private String maintNotificationActivityCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotificationActivityCode</b> field to query operations.
     *
     */
    public final static MaintNotificationItemActivityField<String> MAINT_NOTIFICATION_ACTIVITY_CODE =
        new MaintNotificationItemActivityField<String>("MaintNotificationActivityCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>NotifActivityCodeText</b>
     * </p>
     *
     * @return Text for Code
     */
    @SerializedName( "NotifActivityCodeText" )
    @JsonProperty( "NotifActivityCodeText" )
    @Nullable
    @ODataField( odataName = "NotifActivityCodeText" )
    private String notifActivityCodeText;
    /**
     * Use with available fluent helpers to apply the <b>NotifActivityCodeText</b> field to query operations.
     *
     */
    public final static MaintNotificationItemActivityField<String> NOTIF_ACTIVITY_CODE_TEXT =
        new MaintNotificationItemActivityField<String>("NotifActivityCodeText");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedStartDate</b>
     * </p>
     *
     * @return Activity Start Date
     */
    @SerializedName( "PlannedStartDate" )
    @JsonProperty( "PlannedStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime plannedStartDate;
    /**
     * Use with available fluent helpers to apply the <b>PlannedStartDate</b> field to query operations.
     *
     */
    public final static MaintNotificationItemActivityField<LocalDateTime> PLANNED_START_DATE =
        new MaintNotificationItemActivityField<LocalDateTime>("PlannedStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedStartTime</b>
     * </p>
     *
     * @return Start Time of Activity
     */
    @SerializedName( "PlannedStartTime" )
    @JsonProperty( "PlannedStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "PlannedStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime plannedStartTime;
    /**
     * Use with available fluent helpers to apply the <b>PlannedStartTime</b> field to query operations.
     *
     */
    public final static MaintNotificationItemActivityField<LocalTime> PLANNED_START_TIME =
        new MaintNotificationItemActivityField<LocalTime>("PlannedStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedEndDate</b>
     * </p>
     *
     * @return Activity End Date
     */
    @SerializedName( "PlannedEndDate" )
    @JsonProperty( "PlannedEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime plannedEndDate;
    /**
     * Use with available fluent helpers to apply the <b>PlannedEndDate</b> field to query operations.
     *
     */
    public final static MaintNotificationItemActivityField<LocalDateTime> PLANNED_END_DATE =
        new MaintNotificationItemActivityField<LocalDateTime>("PlannedEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedEndTime</b>
     * </p>
     *
     * @return End Time of Activity
     */
    @SerializedName( "PlannedEndTime" )
    @JsonProperty( "PlannedEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "PlannedEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime plannedEndTime;
    /**
     * Use with available fluent helpers to apply the <b>PlannedEndTime</b> field to query operations.
     *
     */
    public final static MaintNotificationItemActivityField<LocalTime> PLANNED_END_TIME =
        new MaintNotificationItemActivityField<LocalTime>("PlannedEndTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Delete Data Record
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDeleted" )
    private Boolean isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static MaintNotificationItemActivityField<Boolean> IS_DELETED =
        new MaintNotificationItemActivityField<Boolean>("IsDeleted");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifItmActyStrtDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MaintNotifItmActyStrtDateTime" )
    @JsonProperty( "MaintNotifItmActyStrtDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintNotifItmActyStrtDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintNotifItmActyStrtDateTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifItmActyStrtDateTime</b> field to query operations.
     *
     */
    public final static MaintNotificationItemActivityField<ZonedDateTime> MAINT_NOTIF_ITM_ACTY_STRT_DATE_TIME =
        new MaintNotificationItemActivityField<ZonedDateTime>("MaintNotifItmActyStrtDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifItemActyEndDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MaintNotifItemActyEndDateTime" )
    @JsonProperty( "MaintNotifItemActyEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintNotifItemActyEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintNotifItemActyEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifItemActyEndDateTime</b> field to query operations.
     *
     */
    public final static MaintNotificationItemActivityField<ZonedDateTime> MAINT_NOTIF_ITEM_ACTY_END_DATE_TIME =
        new MaintNotificationItemActivityField<ZonedDateTime>("MaintNotifItemActyEndDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifItemActyCrtnDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MaintNotifItemActyCrtnDateTime" )
    @JsonProperty( "MaintNotifItemActyCrtnDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintNotifItemActyCrtnDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintNotifItemActyCrtnDateTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifItemActyCrtnDateTime</b> field to query operations.
     *
     */
    public final static MaintNotificationItemActivityField<ZonedDateTime> MAINT_NOTIF_ITEM_ACTY_CRTN_DATE_TIME =
        new MaintNotificationItemActivityField<ZonedDateTime>("MaintNotifItemActyCrtnDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifItemActyChgdDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MaintNotifItemActyChgdDateTime" )
    @JsonProperty( "MaintNotifItemActyChgdDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintNotifItemActyChgdDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintNotifItemActyChgdDateTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifItemActyChgdDateTime</b> field to query operations.
     *
     */
    public final static MaintNotificationItemActivityField<ZonedDateTime> MAINT_NOTIF_ITEM_ACTY_CHGD_DATE_TIME =
        new MaintNotificationItemActivityField<ZonedDateTime>("MaintNotifItemActyChgdDateTime");
    /**
     * Navigation property <b>to_Item</b> for <b>MaintNotificationItemActivity</b> to single
     * <b>MaintenanceNotificationItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceNotificationItem toItem;
    /**
     * Navigation property <b>to_Notif</b> for <b>MaintNotificationItemActivity</b> to single
     * <b>MaintenanceNotification</b>.
     *
     */
    @SerializedName( "to_Notif" )
    @JsonProperty( "to_Notif" )
    @ODataField( odataName = "to_Notif" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceNotification toNotif;
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static MaintNotificationItemActivityOneToOneLink<MaintenanceNotificationItem> TO_ITEM =
        new MaintNotificationItemActivityOneToOneLink<MaintenanceNotificationItem>("to_Item");
    /**
     * Use with available fluent helpers to apply the <b>to_Notif</b> navigation property to query operations.
     *
     */
    public final static MaintNotificationItemActivityOneToOneLink<MaintenanceNotification> TO_NOTIF =
        new MaintNotificationItemActivityOneToOneLink<MaintenanceNotification>("to_Notif");

    @Nonnull
    @Override
    public Class<MaintNotificationItemActivity> getType()
    {
        return MaintNotificationItemActivity.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationActivity</b>
     * </p>
     *
     * @param maintNotificationActivity
     *            Consecutive Number of Activity
     */
    public void setMaintNotificationActivity( @Nullable final String maintNotificationActivity )
    {
        rememberChangedField("MaintNotificationActivity", this.maintNotificationActivity);
        this.maintNotificationActivity = maintNotificationActivity;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotification</b>
     * </p>
     *
     * @param maintenanceNotification
     *            Notification Number
     */
    public void setMaintenanceNotification( @Nullable final String maintenanceNotification )
    {
        rememberChangedField("MaintenanceNotification", this.maintenanceNotification);
        this.maintenanceNotification = maintenanceNotification;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotificationItem</b>
     * </p>
     *
     * @param maintenanceNotificationItem
     *            Item Number in Item Record
     */
    public void setMaintenanceNotificationItem( @Nullable final String maintenanceNotificationItem )
    {
        rememberChangedField("MaintenanceNotificationItem", this.maintenanceNotificationItem);
        this.maintenanceNotificationItem = maintenanceNotificationItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifActivitySortNumber</b>
     * </p>
     *
     * @param maintNotifActivitySortNumber
     *            Sort Number for Activity
     */
    public void setMaintNotifActivitySortNumber( @Nullable final String maintNotifActivitySortNumber )
    {
        rememberChangedField("MaintNotifActivitySortNumber", this.maintNotifActivitySortNumber);
        this.maintNotifActivitySortNumber = maintNotifActivitySortNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifActyTxt</b>
     * </p>
     *
     * @param maintNotifActyTxt
     *            Activity Text
     */
    public void setMaintNotifActyTxt( @Nullable final String maintNotifActyTxt )
    {
        rememberChangedField("MaintNotifActyTxt", this.maintNotifActyTxt);
        this.maintNotifActyTxt = maintNotifActyTxt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifActivityCodeGroup</b>
     * </p>
     *
     * @param maintNotifActivityCodeGroup
     *            Activity Code Group
     */
    public void setMaintNotifActivityCodeGroup( @Nullable final String maintNotifActivityCodeGroup )
    {
        rememberChangedField("MaintNotifActivityCodeGroup", this.maintNotifActivityCodeGroup);
        this.maintNotifActivityCodeGroup = maintNotifActivityCodeGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>NotifActivityCodeGroupText</b>
     * </p>
     *
     * @param notifActivityCodeGroupText
     *            Text for Code Group
     */
    public void setNotifActivityCodeGroupText( @Nullable final String notifActivityCodeGroupText )
    {
        rememberChangedField("NotifActivityCodeGroupText", this.notifActivityCodeGroupText);
        this.notifActivityCodeGroupText = notifActivityCodeGroupText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationActivityCode</b>
     * </p>
     *
     * @param maintNotificationActivityCode
     *            Activity Code
     */
    public void setMaintNotificationActivityCode( @Nullable final String maintNotificationActivityCode )
    {
        rememberChangedField("MaintNotificationActivityCode", this.maintNotificationActivityCode);
        this.maintNotificationActivityCode = maintNotificationActivityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>NotifActivityCodeText</b>
     * </p>
     *
     * @param notifActivityCodeText
     *            Text for Code
     */
    public void setNotifActivityCodeText( @Nullable final String notifActivityCodeText )
    {
        rememberChangedField("NotifActivityCodeText", this.notifActivityCodeText);
        this.notifActivityCodeText = notifActivityCodeText;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedStartDate</b>
     * </p>
     *
     * @param plannedStartDate
     *            Activity Start Date
     */
    public void setPlannedStartDate( @Nullable final LocalDateTime plannedStartDate )
    {
        rememberChangedField("PlannedStartDate", this.plannedStartDate);
        this.plannedStartDate = plannedStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedStartTime</b>
     * </p>
     *
     * @param plannedStartTime
     *            Start Time of Activity
     */
    public void setPlannedStartTime( @Nullable final LocalTime plannedStartTime )
    {
        rememberChangedField("PlannedStartTime", this.plannedStartTime);
        this.plannedStartTime = plannedStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedEndDate</b>
     * </p>
     *
     * @param plannedEndDate
     *            Activity End Date
     */
    public void setPlannedEndDate( @Nullable final LocalDateTime plannedEndDate )
    {
        rememberChangedField("PlannedEndDate", this.plannedEndDate);
        this.plannedEndDate = plannedEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedEndTime</b>
     * </p>
     *
     * @param plannedEndTime
     *            End Time of Activity
     */
    public void setPlannedEndTime( @Nullable final LocalTime plannedEndTime )
    {
        rememberChangedField("PlannedEndTime", this.plannedEndTime);
        this.plannedEndTime = plannedEndTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Delete Data Record
     */
    public void setIsDeleted( @Nullable final Boolean isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifItmActyStrtDateTime</b>
     * </p>
     *
     * @param maintNotifItmActyStrtDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMaintNotifItmActyStrtDateTime( @Nullable final ZonedDateTime maintNotifItmActyStrtDateTime )
    {
        rememberChangedField("MaintNotifItmActyStrtDateTime", this.maintNotifItmActyStrtDateTime);
        this.maintNotifItmActyStrtDateTime = maintNotifItmActyStrtDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifItemActyEndDateTime</b>
     * </p>
     *
     * @param maintNotifItemActyEndDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMaintNotifItemActyEndDateTime( @Nullable final ZonedDateTime maintNotifItemActyEndDateTime )
    {
        rememberChangedField("MaintNotifItemActyEndDateTime", this.maintNotifItemActyEndDateTime);
        this.maintNotifItemActyEndDateTime = maintNotifItemActyEndDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifItemActyCrtnDateTime</b>
     * </p>
     *
     * @param maintNotifItemActyCrtnDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMaintNotifItemActyCrtnDateTime( @Nullable final ZonedDateTime maintNotifItemActyCrtnDateTime )
    {
        rememberChangedField("MaintNotifItemActyCrtnDateTime", this.maintNotifItemActyCrtnDateTime);
        this.maintNotifItemActyCrtnDateTime = maintNotifItemActyCrtnDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifItemActyChgdDateTime</b>
     * </p>
     *
     * @param maintNotifItemActyChgdDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMaintNotifItemActyChgdDateTime( @Nullable final ZonedDateTime maintNotifItemActyChgdDateTime )
    {
        rememberChangedField("MaintNotifItemActyChgdDateTime", this.maintNotifItemActyChgdDateTime);
        this.maintNotifItemActyChgdDateTime = maintNotifItemActyChgdDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintNotificationItemActivity";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintNotificationActivity", getMaintNotificationActivity());
        result.put("MaintenanceNotification", getMaintenanceNotification());
        result.put("MaintenanceNotificationItem", getMaintenanceNotificationItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintNotificationActivity", getMaintNotificationActivity());
        values.put("MaintenanceNotification", getMaintenanceNotification());
        values.put("MaintenanceNotificationItem", getMaintenanceNotificationItem());
        values.put("MaintNotifActivitySortNumber", getMaintNotifActivitySortNumber());
        values.put("MaintNotifActyTxt", getMaintNotifActyTxt());
        values.put("MaintNotifActivityCodeGroup", getMaintNotifActivityCodeGroup());
        values.put("NotifActivityCodeGroupText", getNotifActivityCodeGroupText());
        values.put("MaintNotificationActivityCode", getMaintNotificationActivityCode());
        values.put("NotifActivityCodeText", getNotifActivityCodeText());
        values.put("PlannedStartDate", getPlannedStartDate());
        values.put("PlannedStartTime", getPlannedStartTime());
        values.put("PlannedEndDate", getPlannedEndDate());
        values.put("PlannedEndTime", getPlannedEndTime());
        values.put("IsDeleted", getIsDeleted());
        values.put("MaintNotifItmActyStrtDateTime", getMaintNotifItmActyStrtDateTime());
        values.put("MaintNotifItemActyEndDateTime", getMaintNotifItemActyEndDateTime());
        values.put("MaintNotifItemActyCrtnDateTime", getMaintNotifItemActyCrtnDateTime());
        values.put("MaintNotifItemActyChgdDateTime", getMaintNotifItemActyChgdDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintNotificationActivity") ) {
                final Object value = values.remove("MaintNotificationActivity");
                if( (value == null) || (!value.equals(getMaintNotificationActivity())) ) {
                    setMaintNotificationActivity(((String) value));
                }
            }
            if( values.containsKey("MaintenanceNotification") ) {
                final Object value = values.remove("MaintenanceNotification");
                if( (value == null) || (!value.equals(getMaintenanceNotification())) ) {
                    setMaintenanceNotification(((String) value));
                }
            }
            if( values.containsKey("MaintenanceNotificationItem") ) {
                final Object value = values.remove("MaintenanceNotificationItem");
                if( (value == null) || (!value.equals(getMaintenanceNotificationItem())) ) {
                    setMaintenanceNotificationItem(((String) value));
                }
            }
            if( values.containsKey("MaintNotifActivitySortNumber") ) {
                final Object value = values.remove("MaintNotifActivitySortNumber");
                if( (value == null) || (!value.equals(getMaintNotifActivitySortNumber())) ) {
                    setMaintNotifActivitySortNumber(((String) value));
                }
            }
            if( values.containsKey("MaintNotifActyTxt") ) {
                final Object value = values.remove("MaintNotifActyTxt");
                if( (value == null) || (!value.equals(getMaintNotifActyTxt())) ) {
                    setMaintNotifActyTxt(((String) value));
                }
            }
            if( values.containsKey("MaintNotifActivityCodeGroup") ) {
                final Object value = values.remove("MaintNotifActivityCodeGroup");
                if( (value == null) || (!value.equals(getMaintNotifActivityCodeGroup())) ) {
                    setMaintNotifActivityCodeGroup(((String) value));
                }
            }
            if( values.containsKey("NotifActivityCodeGroupText") ) {
                final Object value = values.remove("NotifActivityCodeGroupText");
                if( (value == null) || (!value.equals(getNotifActivityCodeGroupText())) ) {
                    setNotifActivityCodeGroupText(((String) value));
                }
            }
            if( values.containsKey("MaintNotificationActivityCode") ) {
                final Object value = values.remove("MaintNotificationActivityCode");
                if( (value == null) || (!value.equals(getMaintNotificationActivityCode())) ) {
                    setMaintNotificationActivityCode(((String) value));
                }
            }
            if( values.containsKey("NotifActivityCodeText") ) {
                final Object value = values.remove("NotifActivityCodeText");
                if( (value == null) || (!value.equals(getNotifActivityCodeText())) ) {
                    setNotifActivityCodeText(((String) value));
                }
            }
            if( values.containsKey("PlannedStartDate") ) {
                final Object value = values.remove("PlannedStartDate");
                if( (value == null) || (!value.equals(getPlannedStartDate())) ) {
                    setPlannedStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PlannedStartTime") ) {
                final Object value = values.remove("PlannedStartTime");
                if( (value == null) || (!value.equals(getPlannedStartTime())) ) {
                    setPlannedStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("PlannedEndDate") ) {
                final Object value = values.remove("PlannedEndDate");
                if( (value == null) || (!value.equals(getPlannedEndDate())) ) {
                    setPlannedEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PlannedEndTime") ) {
                final Object value = values.remove("PlannedEndTime");
                if( (value == null) || (!value.equals(getPlannedEndTime())) ) {
                    setPlannedEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("MaintNotifItmActyStrtDateTime") ) {
                final Object value = values.remove("MaintNotifItmActyStrtDateTime");
                if( (value == null) || (!value.equals(getMaintNotifItmActyStrtDateTime())) ) {
                    setMaintNotifItmActyStrtDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("MaintNotifItemActyEndDateTime") ) {
                final Object value = values.remove("MaintNotifItemActyEndDateTime");
                if( (value == null) || (!value.equals(getMaintNotifItemActyEndDateTime())) ) {
                    setMaintNotifItemActyEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("MaintNotifItemActyCrtnDateTime") ) {
                final Object value = values.remove("MaintNotifItemActyCrtnDateTime");
                if( (value == null) || (!value.equals(getMaintNotifItemActyCrtnDateTime())) ) {
                    setMaintNotifItemActyCrtnDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("MaintNotifItemActyChgdDateTime") ) {
                final Object value = values.remove("MaintNotifItemActyChgdDateTime");
                if( (value == null) || (!value.equals(getMaintNotifItemActyChgdDateTime())) ) {
                    setMaintNotifItemActyChgdDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Map ) {
                    if( toItem == null ) {
                        toItem = new MaintenanceNotificationItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toItem.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Notif") ) {
                final Object value = (values).remove("to_Notif");
                if( value instanceof Map ) {
                    if( toNotif == null ) {
                        toNotif = new MaintenanceNotification();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toNotif.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> MaintNotificationItemActivityField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new MaintNotificationItemActivityField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintNotificationItemActivityField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintNotificationItemActivityField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceNotificationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        if( toNotif != null ) {
            (values).put("to_Notif", toNotif);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceNotificationItem</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceNotificationItem</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceNotificationItem fetchItem()
    {
        return fetchFieldAsSingle("to_Item", MaintenanceNotificationItem.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceNotificationItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>MaintNotificationItemActivity</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceNotificationItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceNotificationItem getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>MaintenanceNotificationItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>MaintNotificationItemActivity</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>MaintenanceNotificationItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceNotificationItem> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the associated <b>MaintenanceNotificationItem</b> entity for the loaded navigation property
     * <b>to_Item</b>.
     *
     * @param value
     *            New <b>MaintenanceNotificationItem</b> entity.
     */
    public void setItem( final MaintenanceNotificationItem value )
    {
        toItem = value;
    }

    /**
     * Fetches the <b>MaintenanceNotification</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Notif</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceNotification</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceNotification fetchNotif()
    {
        return fetchFieldAsSingle("to_Notif", MaintenanceNotification.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceNotification</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Notif</b>.
     * <p>
     * If the navigation property <b>to_Notif</b> of a queried <b>MaintNotificationItemActivity</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceNotification</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceNotification getNotifOrFetch()
    {
        if( toNotif == null ) {
            toNotif = fetchNotif();
        }
        return toNotif;
    }

    /**
     * Retrieval of associated <b>MaintenanceNotification</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Notif</b>.
     * <p>
     * If the navigation property for an entity <b>MaintNotificationItemActivity</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Notif</b> is already loaded, the result will contain the
     *         <b>MaintenanceNotification</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceNotification> getNotifIfPresent()
    {
        return Option.of(toNotif);
    }

    /**
     * Overwrites the associated <b>MaintenanceNotification</b> entity for the loaded navigation property
     * <b>to_Notif</b>.
     *
     * @param value
     *            New <b>MaintenanceNotification</b> entity.
     */
    public void setNotif( final MaintenanceNotification value )
    {
        toNotif = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintNotificationItemActivity instances.
     *
     */
    public final static class MaintNotificationItemActivityBuilder
    {

        private MaintenanceNotificationItem toItem;
        private MaintenanceNotification toNotif;

        private MaintNotificationItemActivity.MaintNotificationItemActivityBuilder toItem(
            final MaintenanceNotificationItem value )
        {
            toItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>MaintNotificationItemActivity</b> to single
         * <b>MaintenanceNotificationItem</b>.
         *
         * @param value
         *            The MaintenanceNotificationItem to build this MaintNotificationItemActivity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintNotificationItemActivity.MaintNotificationItemActivityBuilder item(
            final MaintenanceNotificationItem value )
        {
            return toItem(value);
        }

        private MaintNotificationItemActivity.MaintNotificationItemActivityBuilder toNotif(
            final MaintenanceNotification value )
        {
            toNotif = value;
            return this;
        }

        /**
         * Navigation property <b>to_Notif</b> for <b>MaintNotificationItemActivity</b> to single
         * <b>MaintenanceNotification</b>.
         *
         * @param value
         *            The MaintenanceNotification to build this MaintNotificationItemActivity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintNotificationItemActivity.MaintNotificationItemActivityBuilder notif(
            final MaintenanceNotification value )
        {
            return toNotif(value);
        }

    }

}
