/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.selectable.MaintNotificationItemActivitySelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity
 * MaintNotificationItemActivity} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class MaintNotificationItemActivityByKeyFluentHelper
    extends
    FluentHelperByKey<MaintNotificationItemActivityByKeyFluentHelper, MaintNotificationItemActivity, MaintNotificationItemActivitySelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.MaintNotificationItemActivity
     * MaintNotificationItemActivity} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param maintNotificationActivity
     *            Consecutive Number of Activity
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintenanceNotificationItem
     *            Item Number in Item Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintNotificationItemActivity}
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintNotificationItemActivity}
     * @param maintenanceNotification
     *            Notification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     */
    public MaintNotificationItemActivityByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String maintNotificationActivity,
        final String maintenanceNotification,
        final String maintenanceNotificationItem )
    {
        super(servicePath, entityCollection);
        this.key.put("MaintNotificationActivity", maintNotificationActivity);
        this.key.put("MaintenanceNotification", maintenanceNotification);
        this.key.put("MaintenanceNotificationItem", maintenanceNotificationItem);
    }

    @Override
    @Nonnull
    protected Class<MaintNotificationItemActivity> getEntityClass()
    {
        return MaintNotificationItemActivity.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
