/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification;

import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.field.MaintNotificationItemCauseField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.link.MaintNotificationItemCauseOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenancenotification.selectable.MaintNotificationItemCauseSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Notification Item Cause
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintNotificationItemCauseType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintNotificationItemCause extends VdmEntity<MaintNotificationItemCause>
{

    /**
     * Selector for all available fields of MaintNotificationItemCause.
     *
     */
    public final static MaintNotificationItemCauseSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotification</b>
     * </p>
     *
     * @return Notification Number
     */
    @Key
    @SerializedName( "MaintenanceNotification" )
    @JsonProperty( "MaintenanceNotification" )
    @Nullable
    @ODataField( odataName = "MaintenanceNotification" )
    private String maintenanceNotification;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceNotification</b> field to query operations.
     *
     */
    public final static MaintNotificationItemCauseField<String> MAINTENANCE_NOTIFICATION =
        new MaintNotificationItemCauseField<String>("MaintenanceNotification");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotificationItem</b>
     * </p>
     *
     * @return Item Number in Item Record
     */
    @Key
    @SerializedName( "MaintenanceNotificationItem" )
    @JsonProperty( "MaintenanceNotificationItem" )
    @Nullable
    @ODataField( odataName = "MaintenanceNotificationItem" )
    private String maintenanceNotificationItem;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceNotificationItem</b> field to query operations.
     *
     */
    public final static MaintNotificationItemCauseField<String> MAINTENANCE_NOTIFICATION_ITEM =
        new MaintNotificationItemCauseField<String>("MaintenanceNotificationItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotificationCause</b>
     * </p>
     *
     * @return Sequential Number for Cause
     */
    @Key
    @SerializedName( "MaintenanceNotificationCause" )
    @JsonProperty( "MaintenanceNotificationCause" )
    @Nullable
    @ODataField( odataName = "MaintenanceNotificationCause" )
    private String maintenanceNotificationCause;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceNotificationCause</b> field to query operations.
     *
     */
    public final static MaintNotificationItemCauseField<String> MAINTENANCE_NOTIFICATION_CAUSE =
        new MaintNotificationItemCauseField<String>("MaintenanceNotificationCause");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCauseText</b>
     * </p>
     *
     * @return Cause Text
     */
    @SerializedName( "MaintNotifCauseText" )
    @JsonProperty( "MaintNotifCauseText" )
    @Nullable
    @ODataField( odataName = "MaintNotifCauseText" )
    private String maintNotifCauseText;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifCauseText</b> field to query operations.
     *
     */
    public final static MaintNotificationItemCauseField<String> MAINT_NOTIF_CAUSE_TEXT =
        new MaintNotificationItemCauseField<String>("MaintNotifCauseText");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCauseCodeGroup</b>
     * </p>
     *
     * @return Cause Code Group
     */
    @SerializedName( "MaintNotifCauseCodeGroup" )
    @JsonProperty( "MaintNotifCauseCodeGroup" )
    @Nullable
    @ODataField( odataName = "MaintNotifCauseCodeGroup" )
    private String maintNotifCauseCodeGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifCauseCodeGroup</b> field to query operations.
     *
     */
    public final static MaintNotificationItemCauseField<String> MAINT_NOTIF_CAUSE_CODE_GROUP =
        new MaintNotificationItemCauseField<String>("MaintNotifCauseCodeGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCauseCodeGroupName</b>
     * </p>
     *
     * @return Text for Code Group
     */
    @SerializedName( "MaintNotifCauseCodeGroupName" )
    @JsonProperty( "MaintNotifCauseCodeGroupName" )
    @Nullable
    @ODataField( odataName = "MaintNotifCauseCodeGroupName" )
    private String maintNotifCauseCodeGroupName;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifCauseCodeGroupName</b> field to query operations.
     *
     */
    public final static MaintNotificationItemCauseField<String> MAINT_NOTIF_CAUSE_CODE_GROUP_NAME =
        new MaintNotificationItemCauseField<String>("MaintNotifCauseCodeGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationCauseCode</b>
     * </p>
     *
     * @return Cause Code
     */
    @SerializedName( "MaintNotificationCauseCode" )
    @JsonProperty( "MaintNotificationCauseCode" )
    @Nullable
    @ODataField( odataName = "MaintNotificationCauseCode" )
    private String maintNotificationCauseCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotificationCauseCode</b> field to query operations.
     *
     */
    public final static MaintNotificationItemCauseField<String> MAINT_NOTIFICATION_CAUSE_CODE =
        new MaintNotificationItemCauseField<String>("MaintNotificationCauseCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationCauseCodeName</b>
     * </p>
     *
     * @return Text for Code
     */
    @SerializedName( "MaintNotificationCauseCodeName" )
    @JsonProperty( "MaintNotificationCauseCodeName" )
    @Nullable
    @ODataField( odataName = "MaintNotificationCauseCodeName" )
    private String maintNotificationCauseCodeName;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotificationCauseCodeName</b> field to query operations.
     *
     */
    public final static MaintNotificationItemCauseField<String> MAINT_NOTIFICATION_CAUSE_CODE_NAME =
        new MaintNotificationItemCauseField<String>("MaintNotificationCauseCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationRootCause</b>
     * </p>
     *
     * @return Root Cause
     */
    @SerializedName( "MaintNotificationRootCause" )
    @JsonProperty( "MaintNotificationRootCause" )
    @Nullable
    @ODataField( odataName = "MaintNotificationRootCause" )
    private String maintNotificationRootCause;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotificationRootCause</b> field to query operations.
     *
     */
    public final static MaintNotificationItemCauseField<String> MAINT_NOTIFICATION_ROOT_CAUSE =
        new MaintNotificationItemCauseField<String>("MaintNotificationRootCause");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationRootCauseText</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "MaintNotificationRootCauseText" )
    @JsonProperty( "MaintNotificationRootCauseText" )
    @Nullable
    @ODataField( odataName = "MaintNotificationRootCauseText" )
    private String maintNotificationRootCauseText;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotificationRootCauseText</b> field to query operations.
     *
     */
    public final static MaintNotificationItemCauseField<String> MAINT_NOTIFICATION_ROOT_CAUSE_TEXT =
        new MaintNotificationItemCauseField<String>("MaintNotificationRootCauseText");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Delete Data Record
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDeleted" )
    private Boolean isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static MaintNotificationItemCauseField<Boolean> IS_DELETED =
        new MaintNotificationItemCauseField<Boolean>("IsDeleted");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifItmCauseChgdDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MaintNotifItmCauseChgdDateTime" )
    @JsonProperty( "MaintNotifItmCauseChgdDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintNotifItmCauseChgdDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintNotifItmCauseChgdDateTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifItmCauseChgdDateTime</b> field to query operations.
     *
     */
    public final static MaintNotificationItemCauseField<ZonedDateTime> MAINT_NOTIF_ITM_CAUSE_CHGD_DATE_TIME =
        new MaintNotificationItemCauseField<ZonedDateTime>("MaintNotifItmCauseChgdDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifItmCauseCrtnDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "MaintNotifItmCauseCrtnDateTime" )
    @JsonProperty( "MaintNotifItmCauseCrtnDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintNotifItmCauseCrtnDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime maintNotifItmCauseCrtnDateTime;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifItmCauseCrtnDateTime</b> field to query operations.
     *
     */
    public final static MaintNotificationItemCauseField<ZonedDateTime> MAINT_NOTIF_ITM_CAUSE_CRTN_DATE_TIME =
        new MaintNotificationItemCauseField<ZonedDateTime>("MaintNotifItmCauseCrtnDateTime");
    /**
     * Navigation property <b>to_Item</b> for <b>MaintNotificationItemCause</b> to single
     * <b>MaintenanceNotificationItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceNotificationItem toItem;
    /**
     * Navigation property <b>to_Notif</b> for <b>MaintNotificationItemCause</b> to single
     * <b>MaintenanceNotification</b>.
     *
     */
    @SerializedName( "to_Notif" )
    @JsonProperty( "to_Notif" )
    @ODataField( odataName = "to_Notif" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceNotification toNotif;
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static MaintNotificationItemCauseOneToOneLink<MaintenanceNotificationItem> TO_ITEM =
        new MaintNotificationItemCauseOneToOneLink<MaintenanceNotificationItem>("to_Item");
    /**
     * Use with available fluent helpers to apply the <b>to_Notif</b> navigation property to query operations.
     *
     */
    public final static MaintNotificationItemCauseOneToOneLink<MaintenanceNotification> TO_NOTIF =
        new MaintNotificationItemCauseOneToOneLink<MaintenanceNotification>("to_Notif");

    @Nonnull
    @Override
    public Class<MaintNotificationItemCause> getType()
    {
        return MaintNotificationItemCause.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotification</b>
     * </p>
     *
     * @param maintenanceNotification
     *            Notification Number
     */
    public void setMaintenanceNotification( @Nullable final String maintenanceNotification )
    {
        rememberChangedField("MaintenanceNotification", this.maintenanceNotification);
        this.maintenanceNotification = maintenanceNotification;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotificationItem</b>
     * </p>
     *
     * @param maintenanceNotificationItem
     *            Item Number in Item Record
     */
    public void setMaintenanceNotificationItem( @Nullable final String maintenanceNotificationItem )
    {
        rememberChangedField("MaintenanceNotificationItem", this.maintenanceNotificationItem);
        this.maintenanceNotificationItem = maintenanceNotificationItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceNotificationCause</b>
     * </p>
     *
     * @param maintenanceNotificationCause
     *            Sequential Number for Cause
     */
    public void setMaintenanceNotificationCause( @Nullable final String maintenanceNotificationCause )
    {
        rememberChangedField("MaintenanceNotificationCause", this.maintenanceNotificationCause);
        this.maintenanceNotificationCause = maintenanceNotificationCause;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCauseText</b>
     * </p>
     *
     * @param maintNotifCauseText
     *            Cause Text
     */
    public void setMaintNotifCauseText( @Nullable final String maintNotifCauseText )
    {
        rememberChangedField("MaintNotifCauseText", this.maintNotifCauseText);
        this.maintNotifCauseText = maintNotifCauseText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCauseCodeGroup</b>
     * </p>
     *
     * @param maintNotifCauseCodeGroup
     *            Cause Code Group
     */
    public void setMaintNotifCauseCodeGroup( @Nullable final String maintNotifCauseCodeGroup )
    {
        rememberChangedField("MaintNotifCauseCodeGroup", this.maintNotifCauseCodeGroup);
        this.maintNotifCauseCodeGroup = maintNotifCauseCodeGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCauseCodeGroupName</b>
     * </p>
     *
     * @param maintNotifCauseCodeGroupName
     *            Text for Code Group
     */
    public void setMaintNotifCauseCodeGroupName( @Nullable final String maintNotifCauseCodeGroupName )
    {
        rememberChangedField("MaintNotifCauseCodeGroupName", this.maintNotifCauseCodeGroupName);
        this.maintNotifCauseCodeGroupName = maintNotifCauseCodeGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationCauseCode</b>
     * </p>
     *
     * @param maintNotificationCauseCode
     *            Cause Code
     */
    public void setMaintNotificationCauseCode( @Nullable final String maintNotificationCauseCode )
    {
        rememberChangedField("MaintNotificationCauseCode", this.maintNotificationCauseCode);
        this.maintNotificationCauseCode = maintNotificationCauseCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationCauseCodeName</b>
     * </p>
     *
     * @param maintNotificationCauseCodeName
     *            Text for Code
     */
    public void setMaintNotificationCauseCodeName( @Nullable final String maintNotificationCauseCodeName )
    {
        rememberChangedField("MaintNotificationCauseCodeName", this.maintNotificationCauseCodeName);
        this.maintNotificationCauseCodeName = maintNotificationCauseCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationRootCause</b>
     * </p>
     *
     * @param maintNotificationRootCause
     *            Root Cause
     */
    public void setMaintNotificationRootCause( @Nullable final String maintNotificationRootCause )
    {
        rememberChangedField("MaintNotificationRootCause", this.maintNotificationRootCause);
        this.maintNotificationRootCause = maintNotificationRootCause;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotificationRootCauseText</b>
     * </p>
     *
     * @param maintNotificationRootCauseText
     *            Short Text for Fixed Values
     */
    public void setMaintNotificationRootCauseText( @Nullable final String maintNotificationRootCauseText )
    {
        rememberChangedField("MaintNotificationRootCauseText", this.maintNotificationRootCauseText);
        this.maintNotificationRootCauseText = maintNotificationRootCauseText;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Delete Data Record
     */
    public void setIsDeleted( @Nullable final Boolean isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifItmCauseChgdDateTime</b>
     * </p>
     *
     * @param maintNotifItmCauseChgdDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMaintNotifItmCauseChgdDateTime( @Nullable final ZonedDateTime maintNotifItmCauseChgdDateTime )
    {
        rememberChangedField("MaintNotifItmCauseChgdDateTime", this.maintNotifItmCauseChgdDateTime);
        this.maintNotifItmCauseChgdDateTime = maintNotifItmCauseChgdDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifItmCauseCrtnDateTime</b>
     * </p>
     *
     * @param maintNotifItmCauseCrtnDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setMaintNotifItmCauseCrtnDateTime( @Nullable final ZonedDateTime maintNotifItmCauseCrtnDateTime )
    {
        rememberChangedField("MaintNotifItmCauseCrtnDateTime", this.maintNotifItmCauseCrtnDateTime);
        this.maintNotifItmCauseCrtnDateTime = maintNotifItmCauseCrtnDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintNotificationItemCause";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceNotification", getMaintenanceNotification());
        result.put("MaintenanceNotificationItem", getMaintenanceNotificationItem());
        result.put("MaintenanceNotificationCause", getMaintenanceNotificationCause());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceNotification", getMaintenanceNotification());
        values.put("MaintenanceNotificationItem", getMaintenanceNotificationItem());
        values.put("MaintenanceNotificationCause", getMaintenanceNotificationCause());
        values.put("MaintNotifCauseText", getMaintNotifCauseText());
        values.put("MaintNotifCauseCodeGroup", getMaintNotifCauseCodeGroup());
        values.put("MaintNotifCauseCodeGroupName", getMaintNotifCauseCodeGroupName());
        values.put("MaintNotificationCauseCode", getMaintNotificationCauseCode());
        values.put("MaintNotificationCauseCodeName", getMaintNotificationCauseCodeName());
        values.put("MaintNotificationRootCause", getMaintNotificationRootCause());
        values.put("MaintNotificationRootCauseText", getMaintNotificationRootCauseText());
        values.put("IsDeleted", getIsDeleted());
        values.put("MaintNotifItmCauseChgdDateTime", getMaintNotifItmCauseChgdDateTime());
        values.put("MaintNotifItmCauseCrtnDateTime", getMaintNotifItmCauseCrtnDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceNotification") ) {
                final Object value = values.remove("MaintenanceNotification");
                if( (value == null) || (!value.equals(getMaintenanceNotification())) ) {
                    setMaintenanceNotification(((String) value));
                }
            }
            if( values.containsKey("MaintenanceNotificationItem") ) {
                final Object value = values.remove("MaintenanceNotificationItem");
                if( (value == null) || (!value.equals(getMaintenanceNotificationItem())) ) {
                    setMaintenanceNotificationItem(((String) value));
                }
            }
            if( values.containsKey("MaintenanceNotificationCause") ) {
                final Object value = values.remove("MaintenanceNotificationCause");
                if( (value == null) || (!value.equals(getMaintenanceNotificationCause())) ) {
                    setMaintenanceNotificationCause(((String) value));
                }
            }
            if( values.containsKey("MaintNotifCauseText") ) {
                final Object value = values.remove("MaintNotifCauseText");
                if( (value == null) || (!value.equals(getMaintNotifCauseText())) ) {
                    setMaintNotifCauseText(((String) value));
                }
            }
            if( values.containsKey("MaintNotifCauseCodeGroup") ) {
                final Object value = values.remove("MaintNotifCauseCodeGroup");
                if( (value == null) || (!value.equals(getMaintNotifCauseCodeGroup())) ) {
                    setMaintNotifCauseCodeGroup(((String) value));
                }
            }
            if( values.containsKey("MaintNotifCauseCodeGroupName") ) {
                final Object value = values.remove("MaintNotifCauseCodeGroupName");
                if( (value == null) || (!value.equals(getMaintNotifCauseCodeGroupName())) ) {
                    setMaintNotifCauseCodeGroupName(((String) value));
                }
            }
            if( values.containsKey("MaintNotificationCauseCode") ) {
                final Object value = values.remove("MaintNotificationCauseCode");
                if( (value == null) || (!value.equals(getMaintNotificationCauseCode())) ) {
                    setMaintNotificationCauseCode(((String) value));
                }
            }
            if( values.containsKey("MaintNotificationCauseCodeName") ) {
                final Object value = values.remove("MaintNotificationCauseCodeName");
                if( (value == null) || (!value.equals(getMaintNotificationCauseCodeName())) ) {
                    setMaintNotificationCauseCodeName(((String) value));
                }
            }
            if( values.containsKey("MaintNotificationRootCause") ) {
                final Object value = values.remove("MaintNotificationRootCause");
                if( (value == null) || (!value.equals(getMaintNotificationRootCause())) ) {
                    setMaintNotificationRootCause(((String) value));
                }
            }
            if( values.containsKey("MaintNotificationRootCauseText") ) {
                final Object value = values.remove("MaintNotificationRootCauseText");
                if( (value == null) || (!value.equals(getMaintNotificationRootCauseText())) ) {
                    setMaintNotificationRootCauseText(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("MaintNotifItmCauseChgdDateTime") ) {
                final Object value = values.remove("MaintNotifItmCauseChgdDateTime");
                if( (value == null) || (!value.equals(getMaintNotifItmCauseChgdDateTime())) ) {
                    setMaintNotifItmCauseChgdDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("MaintNotifItmCauseCrtnDateTime") ) {
                final Object value = values.remove("MaintNotifItmCauseCrtnDateTime");
                if( (value == null) || (!value.equals(getMaintNotifItmCauseCrtnDateTime())) ) {
                    setMaintNotifItmCauseCrtnDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Map ) {
                    if( toItem == null ) {
                        toItem = new MaintenanceNotificationItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toItem.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Notif") ) {
                final Object value = (values).remove("to_Notif");
                if( value instanceof Map ) {
                    if( toNotif == null ) {
                        toNotif = new MaintenanceNotification();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toNotif.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> MaintNotificationItemCauseField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new MaintNotificationItemCauseField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintNotificationItemCauseField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintNotificationItemCauseField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceNotificationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        if( toNotif != null ) {
            (values).put("to_Notif", toNotif);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceNotificationItem</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceNotificationItem</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceNotificationItem fetchItem()
    {
        return fetchFieldAsSingle("to_Item", MaintenanceNotificationItem.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceNotificationItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>MaintNotificationItemCause</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceNotificationItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceNotificationItem getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>MaintenanceNotificationItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>MaintNotificationItemCause</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>MaintenanceNotificationItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceNotificationItem> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the associated <b>MaintenanceNotificationItem</b> entity for the loaded navigation property
     * <b>to_Item</b>.
     *
     * @param value
     *            New <b>MaintenanceNotificationItem</b> entity.
     */
    public void setItem( final MaintenanceNotificationItem value )
    {
        toItem = value;
    }

    /**
     * Fetches the <b>MaintenanceNotification</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Notif</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceNotification</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceNotification fetchNotif()
    {
        return fetchFieldAsSingle("to_Notif", MaintenanceNotification.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceNotification</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Notif</b>.
     * <p>
     * If the navigation property <b>to_Notif</b> of a queried <b>MaintNotificationItemCause</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceNotification</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceNotification getNotifOrFetch()
    {
        if( toNotif == null ) {
            toNotif = fetchNotif();
        }
        return toNotif;
    }

    /**
     * Retrieval of associated <b>MaintenanceNotification</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Notif</b>.
     * <p>
     * If the navigation property for an entity <b>MaintNotificationItemCause</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Notif</b> is already loaded, the result will contain the
     *         <b>MaintenanceNotification</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceNotification> getNotifIfPresent()
    {
        return Option.of(toNotif);
    }

    /**
     * Overwrites the associated <b>MaintenanceNotification</b> entity for the loaded navigation property
     * <b>to_Notif</b>.
     *
     * @param value
     *            New <b>MaintenanceNotification</b> entity.
     */
    public void setNotif( final MaintenanceNotification value )
    {
        toNotif = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintNotificationItemCause instances.
     *
     */
    public final static class MaintNotificationItemCauseBuilder
    {

        private MaintenanceNotificationItem toItem;
        private MaintenanceNotification toNotif;

        private MaintNotificationItemCause.MaintNotificationItemCauseBuilder toItem(
            final MaintenanceNotificationItem value )
        {
            toItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>MaintNotificationItemCause</b> to single
         * <b>MaintenanceNotificationItem</b>.
         *
         * @param value
         *            The MaintenanceNotificationItem to build this MaintNotificationItemCause with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintNotificationItemCause.MaintNotificationItemCauseBuilder item(
            final MaintenanceNotificationItem value )
        {
            return toItem(value);
        }

        private MaintNotificationItemCause.MaintNotificationItemCauseBuilder toNotif(
            final MaintenanceNotification value )
        {
            toNotif = value;
            return this;
        }

        /**
         * Navigation property <b>to_Notif</b> for <b>MaintNotificationItemCause</b> to single
         * <b>MaintenanceNotification</b>.
         *
         * @param value
         *            The MaintenanceNotification to build this MaintNotificationItemCause with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintNotificationItemCause.MaintNotificationItemCauseBuilder notif( final MaintenanceNotification value )
        {
            return toNotif(value);
        }

    }

}
